/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetUIUtil;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.AutoResizeTableLayout;
import org.eclipse.birt.report.designer.internal.ui.util.DataUtil;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.LinkedDataSetAdapter;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CachedMetaDataHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TreeItem;

public class DataSetBindingSelector
extends BaseDialog {
    public static final String NONE = Messages.getString((String)"BindingPage.None");
    private CheckboxTableViewer columnTableViewer;
    private CheckboxTreeViewer columnTreeViewer;
    private Composite contentPane;
    private Combo dataSetCombo;
    private String dataSetName;
    private DataSetHandle datasetHandle;
    private String[] columns;
    private boolean validateEmptyResults = false;
    private List<DataSetHandle> datasets;
    private Object[] result;
    private static final IChoice[] DATA_TYPE_CHOICES = DEUtil.getMetaDataDictionary().getStructure("ComputedColumn").getMember("dataType").getAllowedChoices().getChoices();

    public DataSetBindingSelector(Shell parentShell, String title) {
        super(parentShell, title);
    }

    public Control createDialogArea(Composite parent) {
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.DataSetBindingSelector_ID");
        Composite area = (Composite)super.createDialogArea(parent);
        Composite contents = new Composite(area, 0);
        contents.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        contents.setLayout((Layout)layout);
        this.createDataSetContents(contents);
        this.contentPane = new Composite(contents, 0);
        this.contentPane.setLayoutData((Object)new GridData(1808));
        this.contentPane.setLayout((Layout)new GridLayout());
        this.columnTableViewer = null;
        this.columnTreeViewer = null;
        Object input = this.populateInput();
        if (input instanceof Map) {
            this.createColumnBindingTreeContents(this.contentPane, input);
        } else {
            this.createColumnBindingTableContents(this.contentPane, input);
        }
        return area;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.enableOKButton();
        return control;
    }

    protected void createColumnBindingTableContents(Composite parent, Object input) {
        this.columnTableViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)67616);
        GridData data = new GridData(1808);
        data.widthHint = 450;
        data.heightHint = 200;
        data.horizontalSpan = 2;
        data.verticalIndent = 5;
        this.columnTableViewer.getTable().setLayoutData((Object)data);
        this.columnTableViewer.getTable().setHeaderVisible(true);
        this.columnTableViewer.getTable().setLinesVisible(true);
        new TableColumn(this.columnTableViewer.getTable(), 0).setText("");
        new TableColumn(this.columnTableViewer.getTable(), 0).setText(Messages.getString((String)"DataSetColumnBindingsFormHandleProvider.Column.Name"));
        new TableColumn(this.columnTableViewer.getTable(), 0).setText(Messages.getString((String)"DataSetColumnBindingsFormHandleProvider.Column.DataType"));
        AutoResizeTableLayout layout = new AutoResizeTableLayout(this.columnTableViewer.getTable());
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(6, true));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(47, true));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(47, true));
        this.columnTableViewer.getTable().setLayout((Layout)layout);
        this.columnTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DataSetBindingSelector.this.enableOKButton();
            }
        });
        DataSetColumnProvider provider = new DataSetColumnProvider();
        this.columnTableViewer.setLabelProvider((IBaseLabelProvider)provider);
        this.columnTableViewer.setContentProvider((IContentProvider)provider);
        Composite buttonContainer = new Composite(parent, 0);
        data = new GridData(768);
        data.horizontalSpan = 2;
        buttonContainer.setLayoutData((Object)data);
        GridLayout gdLayout = new GridLayout();
        gdLayout.numColumns = 2;
        gdLayout.marginHeight = 0;
        gdLayout.marginWidth = 0;
        buttonContainer.setLayout((Layout)gdLayout);
        Button selectAllButton = new Button(buttonContainer, 8);
        selectAllButton.setText(Messages.getString((String)"DataSetBindingSelector.Button.SelectAll"));
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataSetBindingSelector.this.columnTableViewer.setAllChecked(true);
                DataSetBindingSelector.this.enableOKButton();
            }
        });
        Button deselectAllButton = new Button(buttonContainer, 8);
        deselectAllButton.setText(Messages.getString((String)"DataSetBindingSelector.Button.DeselectAll"));
        deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataSetBindingSelector.this.columnTableViewer.setAllChecked(false);
                DataSetBindingSelector.this.enableOKButton();
            }
        });
        this.handleDataSetComboSelectedEvent(input);
        if (this.columns != null) {
            int count = this.columnTableViewer.getTable().getItemCount();
            List<String> columnList = Arrays.asList(this.columns);
            int i = 0;
            while (i < count) {
                ResultSetColumnHandle column = (ResultSetColumnHandle)this.columnTableViewer.getElementAt(i);
                if (columnList.contains(column.getColumnName())) {
                    this.columnTableViewer.setChecked((Object)column, true);
                }
                ++i;
            }
        }
    }

    protected void createColumnBindingTreeContents(Composite parent, Object input) {
        this.columnTreeViewer = new CheckboxTreeViewer(parent, 67616);
        GridData data = new GridData(1808);
        data.widthHint = 450;
        data.heightHint = 200;
        data.horizontalSpan = 2;
        data.verticalIndent = 5;
        this.columnTreeViewer.getTree().setLayoutData((Object)data);
        this.columnTreeViewer.getTree().setHeaderVisible(true);
        this.columnTreeViewer.getTree().setLinesVisible(true);
        TreeViewerColumn tvc1 = new TreeViewerColumn((TreeViewer)this.columnTreeViewer, 0);
        tvc1.getColumn().setText(Messages.getString((String)"DataSetColumnBindingsFormHandleProvider.Column.Name"));
        tvc1.getColumn().setWidth(230);
        tvc1.setLabelProvider((CellLabelProvider)new GroupedColumnNameProvider());
        TreeViewerColumn tvc2 = new TreeViewerColumn((TreeViewer)this.columnTreeViewer, 0);
        tvc2.getColumn().setText(Messages.getString((String)"DataSetColumnBindingsFormHandleProvider.Column.DataType"));
        tvc2.getColumn().setWidth(100);
        tvc2.setLabelProvider((CellLabelProvider)new GroupedColumnTypeProvider());
        this.columnTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DataSetBindingSelector.this.enableOKButton();
            }
        });
        this.columnTreeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                if (element instanceof Map.Entry) {
                    DataSetBindingSelector.this.columnTreeViewer.setGrayed(element, false);
                    DataSetBindingSelector.this.columnTreeViewer.setSubtreeChecked(element, event.getChecked());
                } else {
                    Map input = (Map)DataSetBindingSelector.this.columnTreeViewer.getInput();
                    for (Map.Entry ent : input.entrySet()) {
                        List children = (List)ent.getValue();
                        if (!children.contains(element)) continue;
                        Map.Entry parent = ent;
                        boolean allChecked = event.getChecked();
                        boolean graySet = false;
                        for (Object cc : children) {
                            if (DataSetBindingSelector.this.columnTreeViewer.getChecked(cc) == allChecked) continue;
                            DataSetBindingSelector.this.columnTreeViewer.setGrayed(parent, true);
                            DataSetBindingSelector.this.columnTreeViewer.setChecked(parent, true);
                            graySet = true;
                            break;
                        }
                        if (graySet) break;
                        DataSetBindingSelector.this.columnTreeViewer.setGrayed(parent, false);
                        DataSetBindingSelector.this.columnTreeViewer.setChecked(parent, allChecked);
                        break;
                    }
                }
                DataSetBindingSelector.this.enableOKButton();
            }
        });
        this.columnTreeViewer.setContentProvider((IContentProvider)new GroupedColumnProvider());
        Composite buttonContainer = new Composite(parent, 0);
        data = new GridData(768);
        data.horizontalSpan = 2;
        buttonContainer.setLayoutData((Object)data);
        GridLayout gdLayout = new GridLayout();
        gdLayout.numColumns = 2;
        gdLayout.marginHeight = 0;
        gdLayout.marginWidth = 0;
        buttonContainer.setLayout((Layout)gdLayout);
        Button selectAllButton = new Button(buttonContainer, 8);
        selectAllButton.setText(Messages.getString((String)"DataSetBindingSelector.Button.SelectAll"));
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem[] items;
                TreeItem[] treeItemArray = items = DataSetBindingSelector.this.columnTreeViewer.getTree().getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem ti = treeItemArray[n2];
                    DataSetBindingSelector.this.columnTreeViewer.setGrayed(ti.getData(), false);
                    DataSetBindingSelector.this.columnTreeViewer.setSubtreeChecked(ti.getData(), true);
                    ++n2;
                }
                DataSetBindingSelector.this.enableOKButton();
            }
        });
        Button deselectAllButton = new Button(buttonContainer, 8);
        deselectAllButton.setText(Messages.getString((String)"DataSetBindingSelector.Button.DeselectAll"));
        deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem[] items;
                TreeItem[] treeItemArray = items = DataSetBindingSelector.this.columnTreeViewer.getTree().getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem ti = treeItemArray[n2];
                    DataSetBindingSelector.this.columnTreeViewer.setGrayed(ti.getData(), false);
                    DataSetBindingSelector.this.columnTreeViewer.setSubtreeChecked(ti.getData(), false);
                    ++n2;
                }
                DataSetBindingSelector.this.enableOKButton();
            }
        });
        this.handleDataSetComboSelectedEvent(input);
        if (this.columns != null) {
            TreeItem[] items;
            HashSet<String> columnSet = new HashSet<String>(Arrays.asList(this.columns));
            TreeItem[] treeItemArray = items = this.columnTreeViewer.getTree().getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem ti = treeItemArray[n2];
                TreeItem[] ccs = ti.getItems();
                int count = 0;
                TreeItem[] treeItemArray2 = ccs;
                int n3 = ccs.length;
                int n4 = 0;
                while (n4 < n3) {
                    TreeItem cc = treeItemArray2[n4];
                    ResultSetColumnHandle column = (ResultSetColumnHandle)cc.getData();
                    if (columnSet.contains(column.getColumnName())) {
                        this.columnTreeViewer.setChecked((Object)column, true);
                        ++count;
                    }
                    ++n4;
                }
                if (count == ccs.length) {
                    this.columnTreeViewer.setChecked(ti.getData(), true);
                }
                ++n2;
            }
        }
    }

    protected void createDataSetContents(Composite parent) {
        if (this.dataSetName != null) {
            Label lb = new Label(parent, 0);
            lb.setText(Messages.getString((String)"DataSetBindingSelector.Label.SelectBindingColumns"));
            GridData data = new GridData(768);
            data.horizontalSpan = 2;
            lb.setLayoutData((Object)data);
        } else {
            Label dateSetLabel = new Label(parent, 0);
            dateSetLabel.setText(Messages.getString((String)"DataSetBindingSelector.Combo.DataSet"));
            this.dataSetCombo = new Combo(parent, 2056);
            this.datasets = UIUtil.getVisibleDataSetHandles(SessionHandleAdapter.getInstance().getModule());
            this.dataSetCombo.setItems(this.getDataSetComboList());
            this.dataSetCombo.select(0);
            GridData data = new GridData(768);
            this.dataSetCombo.setLayoutData((Object)data);
            this.dataSetCombo.setVisibleItemCount(30);
            this.dataSetCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Object input = DataSetBindingSelector.this.populateInput();
                    if (input instanceof Map) {
                        if (DataSetBindingSelector.this.columnTreeViewer == null) {
                            DataSetBindingSelector.this.disposeChildren(DataSetBindingSelector.this.contentPane);
                            DataSetBindingSelector.this.columnTableViewer = null;
                            DataSetBindingSelector.this.createColumnBindingTreeContents(DataSetBindingSelector.this.contentPane, input);
                        }
                    } else if (DataSetBindingSelector.this.columnTableViewer == null) {
                        DataSetBindingSelector.this.disposeChildren(DataSetBindingSelector.this.contentPane);
                        DataSetBindingSelector.this.columnTreeViewer = null;
                        DataSetBindingSelector.this.createColumnBindingTableContents(DataSetBindingSelector.this.contentPane, input);
                    }
                    DataSetBindingSelector.this.handleDataSetComboSelectedEvent(input);
                }
            });
        }
    }

    private void disposeChildren(Composite parent) {
        Control[] cc = parent.getChildren();
        if (cc != null) {
            Control[] controlArray = cc;
            int n = cc.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                c.dispose();
                ++n2;
            }
        }
    }

    private String[] getDataSetComboList() {
        String[] comboList = new String[this.datasets.size() + 1];
        comboList[0] = NONE;
        int i = 0;
        while (i < this.datasets.size()) {
            comboList[i + 1] = this.datasets.get(i).getQualifiedName();
            if (SessionHandleAdapter.getInstance().getModule().findDataSet(comboList[i + 1]) != this.datasets.get(i)) {
                int n = i + 1;
                comboList[n] = String.valueOf(comboList[n]) + Messages.getString((String)"BindingGroupDescriptorProvider.Flag.DataModel");
            }
            ++i;
        }
        return comboList;
    }

    private DataSetHandle getSelectedDataSet() {
        if (this.dataSetCombo.getSelectionIndex() > 0) {
            return this.datasets.get(this.dataSetCombo.getSelectionIndex() - 1);
        }
        return null;
    }

    private Object populateInput() {
        Object input = null;
        DataSetHandle handle = null;
        if (this.datasetHandle != null) {
            handle = this.datasetHandle;
            LinkedDataSetAdapter adapter = new LinkedDataSetAdapter();
            for (DataSetHandle dataSetHandle : adapter.getVisibleLinkedDataSetsDataSetHandles(SessionHandleAdapter.getInstance().getReportDesignHandle())) {
                if (!dataSetHandle.getQualifiedName().equals(this.dataSetName)) continue;
                handle = null;
                break;
            }
        } else {
            handle = this.dataSetName != null ? DataUtil.findDataSet(this.dataSetName) : this.getSelectedDataSet();
        }
        if (handle != null) {
            try {
                CachedMetaDataHandle cmdh = DataSetUIUtil.getCachedMetaDataHandle(handle);
                input = cmdh.getResultSet().iterator();
            }
            catch (SemanticException e) {
                ExceptionHandler.handle(e);
            }
        } else {
            input = new LinkedDataSetAdapter().getGroupedResultSetColumns(this.dataSetName);
        }
        return input;
    }

    protected void handleDataSetComboSelectedEvent(Object input) {
        if (input instanceof Iterator) {
            this.columnTableViewer.setInput(input);
        } else if (input instanceof Map) {
            this.columnTreeViewer.setInput(input);
            this.columnTreeViewer.expandAll();
        } else {
            if (this.columnTableViewer != null) {
                this.columnTableViewer.setInput(null);
            }
            if (this.columnTreeViewer != null) {
                this.columnTreeViewer.setInput(null);
            }
        }
    }

    protected void okPressed() {
        this.result = new Object[3];
        if (this.dataSetName != null || this.dataSetCombo.getSelectionIndex() > 0) {
            this.result[0] = this.dataSetName == null ? this.getSelectedDataSet() : this.datasetHandle;
            if (this.columnTableViewer != null) {
                if (this.columnTableViewer.getCheckedElements() != null) {
                    this.result[1] = this.columnTableViewer.getCheckedElements();
                    ArrayList<String> list = new ArrayList<String>();
                    int i = 0;
                    while (i < this.columnTableViewer.getTable().getItemCount()) {
                        ResultSetColumnHandle column = (ResultSetColumnHandle)this.columnTableViewer.getElementAt(i);
                        if (!this.columnTableViewer.getChecked((Object)column)) {
                            list.add(column.getColumnName());
                        }
                        ++i;
                    }
                    this.result[2] = list.toArray();
                } else {
                    this.result[1] = null;
                    ArrayList<String> list = new ArrayList<String>();
                    int i = 0;
                    while (i < this.columnTableViewer.getTable().getItemCount()) {
                        ResultSetColumnHandle column = (ResultSetColumnHandle)this.columnTableViewer.getElementAt(i);
                        if (!this.columnTableViewer.getChecked((Object)column)) {
                            list.add(column.getColumnName());
                        }
                        ++i;
                    }
                    this.result[2] = list.isEmpty() ? null : list.toArray();
                }
            } else if (this.columnTreeViewer.getCheckedElements() != null) {
                Object[] selection = this.columnTreeViewer.getCheckedElements();
                ArrayList<ResultSetColumnHandle> cols = new ArrayList<ResultSetColumnHandle>();
                Object[] objectArray = selection;
                int n = selection.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof ResultSetColumnHandle) {
                        cols.add((ResultSetColumnHandle)obj);
                    }
                    ++n2;
                }
                this.result[1] = cols.toArray();
                ArrayList<String> list = new ArrayList<String>();
                int i = 0;
                while (i < this.columnTreeViewer.getTree().getItemCount()) {
                    TreeItem ti = this.columnTreeViewer.getTree().getItem(i);
                    int j = 0;
                    while (j < ti.getItemCount()) {
                        TreeItem sti = ti.getItem(j);
                        if (!sti.getChecked()) {
                            list.add(((ResultSetColumnHandle)sti.getData()).getColumnName());
                        }
                        ++j;
                    }
                    ++i;
                }
                this.result[2] = list.toArray();
            } else {
                this.result[1] = null;
                ArrayList<String> list = new ArrayList<String>();
                int i = 0;
                while (i < this.columnTreeViewer.getTree().getItemCount()) {
                    TreeItem ti = this.columnTreeViewer.getTree().getItem(i);
                    int j = 0;
                    while (j < ti.getItemCount()) {
                        TreeItem sti = ti.getItem(j);
                        if (!sti.getChecked()) {
                            list.add(((ResultSetColumnHandle)sti.getData()).getColumnName());
                        }
                        ++j;
                    }
                    ++i;
                }
                this.result[2] = list.isEmpty() ? null : list.toArray();
            }
        } else {
            this.result[0] = null;
            this.result[1] = null;
            this.result[2] = null;
        }
        super.okPressed();
    }

    @Override
    public Object getResult() {
        return this.result;
    }

    public void setDataSet(String dataSetName) {
        this.setDataSet(dataSetName, true);
    }

    public void setDataSet(String dataSetName, boolean isDataSet) {
        this.dataSetName = dataSetName;
        if (isDataSet) {
            this.datasetHandle = SessionHandleAdapter.getInstance().getReportDesignHandle().findDataSet(dataSetName);
        } else {
            LinkedDataSetAdapter adapter = new LinkedDataSetAdapter();
            for (DataSetHandle dataSetHandle : adapter.getVisibleLinkedDataSetsDataSetHandles(SessionHandleAdapter.getInstance().getReportDesignHandle())) {
                if (!dataSetHandle.getQualifiedName().equals(dataSetName)) continue;
                this.datasetHandle = dataSetHandle;
                break;
            }
        }
    }

    private static String getDataTypeDisplayName(String dataType) {
        int i = 0;
        while (i < DATA_TYPE_CHOICES.length) {
            IChoice choice = DATA_TYPE_CHOICES[i];
            if (choice.getName().equals(dataType)) {
                return choice.getDisplayName();
            }
            ++i;
        }
        return dataType;
    }

    private void enableOKButton() {
        if (this.getOkButton() != null && !this.getOkButton().isDisposed() && this.validateEmptyResults) {
            if (this.columnTableViewer != null) {
                this.getOkButton().setEnabled(this.columnTableViewer.getCheckedElements().length > 0);
            } else {
                this.getOkButton().setEnabled(this.columnTreeViewer.getCheckedElements().length > 0);
            }
        }
    }

    public void setColumns(String[] columns) {
        this.columns = columns;
    }

    public void setValidateEmptyResults(boolean validateEmptyResults) {
        this.validateEmptyResults = validateEmptyResults;
    }

    public DataSetHandle getDatasetHandle() {
        return this.datasetHandle;
    }

    public void setDatasetHandle(DataSetHandle datasetHandle) {
        if (datasetHandle != null) {
            this.datasetHandle = datasetHandle;
            this.dataSetName = datasetHandle.getQualifiedName();
        }
    }

    private static class DataSetColumnProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IStructuredContentProvider {
        private DataSetColumnProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Iterator) {
                Iterator iter = (Iterator)inputElement;
                ArrayList list = new ArrayList();
                while (iter.hasNext()) {
                    list.add(iter.next());
                }
                return list.toArray();
            }
            return new Object[0];
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            ResultSetColumnHandle column = (ResultSetColumnHandle)element;
            if (columnIndex == 1) {
                return column.getColumnName();
            }
            if (columnIndex == 2) {
                return DataSetBindingSelector.getDataTypeDisplayName(column.getDataType());
            }
            return null;
        }
    }

    private static class GroupedColumnNameProvider
    extends ColumnLabelProvider {
        private GroupedColumnNameProvider() {
        }

        public String getText(Object element) {
            if (element instanceof Map.Entry) {
                return (String)((Map.Entry)element).getKey();
            }
            if (element instanceof ResultSetColumnHandle) {
                ResultSetColumnHandle column = (ResultSetColumnHandle)element;
                return column.getColumnName();
            }
            return "";
        }
    }

    private static class GroupedColumnProvider
    implements ITreeContentProvider {
        private GroupedColumnProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Map) {
                return ((Map)inputElement).entrySet().toArray();
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Map.Entry) {
                return ((List)((Map.Entry)parentElement).getValue()).toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            Object[] cc = this.getChildren(element);
            return cc != null && cc.length > 0;
        }
    }

    private static class GroupedColumnTypeProvider
    extends ColumnLabelProvider {
        private GroupedColumnTypeProvider() {
        }

        public String getText(Object element) {
            if (element instanceof ResultSetColumnHandle) {
                ResultSetColumnHandle column = (ResultSetColumnHandle)element;
                return DataSetBindingSelector.getDataTypeDisplayName(column.getDataType());
            }
            return "";
        }
    }
}

