/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.odp;

import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.emitter.EmitterUtil;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;
import org.eclipse.birt.report.engine.emitter.odp.OdpContext;
import org.eclipse.birt.report.engine.emitter.odp.device.OdpPage;
import org.eclipse.birt.report.engine.emitter.odp.device.OdpPageDevice;
import org.eclipse.birt.report.engine.emitter.odp.util.OdpUtil;
import org.eclipse.birt.report.engine.layout.emitter.IPageDevice;
import org.eclipse.birt.report.engine.layout.emitter.PageDeviceRender;
import org.eclipse.birt.report.engine.nLayout.area.IArea;
import org.eclipse.birt.report.engine.nLayout.area.IImageArea;
import org.eclipse.birt.report.engine.nLayout.area.ITextArea;
import org.eclipse.birt.report.engine.nLayout.area.style.TextStyle;
import org.eclipse.birt.report.engine.odf.writer.MetaWriter;
import org.eclipse.birt.report.model.api.ReportDesignHandle;

public class OdpRender
extends PageDeviceRender {
    private OutputStream bodyOut = null;
    private OutputStream mpOut = null;
    private OdpContext odfContext;
    public static final String REPORT_FILE = "Report.odp";

    public OdpRender(IEmitterServices services, OdpContext context, OutputStream out, OutputStream mpOut) throws EngineException {
        this.initialize(services);
        this.odfContext = context;
        this.bodyOut = out;
        this.mpOut = mpOut;
    }

    public IPageDevice createPageDevice(String title, String author, String subject, String description, IReportContext context, IReportContent report) throws Exception {
        try {
            this.writeMetaProperties(author, title, description, subject);
            return new OdpPageDevice(this.bodyOut, this.mpOut, this.odfContext);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, e.getMessage());
            return null;
        }
    }

    public String getOutputFormat() {
        return "odp";
    }

    public void initialize(IEmitterServices services) throws EngineException {
        this.services = services;
        this.reportRunnable = services.getReportRunnable();
        if (this.reportRunnable != null) {
            this.reportDesign = (ReportDesignHandle)this.reportRunnable.getDesignHandle();
        }
        this.context = services.getReportContext();
        this.bodyOut = EmitterUtil.getOuputStream((IEmitterServices)services, (String)REPORT_FILE);
    }

    public void visitImage(IImageArea imageArea) {
        OdpPage odpPage = (OdpPage)this.pageGraphic;
        odpPage.setLink(OdpUtil.getHyperlink((IArea)imageArea, this.services, this.reportRunnable, this.context));
        super.visitImage(imageArea);
        odpPage.setLink(null);
    }

    public void visitText(ITextArea textArea) {
        OdpPage odpPage = (OdpPage)this.pageGraphic;
        odpPage.setLink(OdpUtil.getHyperlink((IArea)textArea, this.services, this.reportRunnable, this.context));
        super.visitText(textArea);
        odpPage.setLink(null);
    }

    protected void drawTextAt(ITextArea text, int x, int y, int width, int height, TextStyle textStyle) {
        this.pageGraphic.drawText(text.getLogicalOrderText(), x, y, width, height, textStyle);
    }

    protected void writeMetaProperties(String creator, String title, String description, String subject) throws IOException, BirtException {
        MetaWriter writer = new MetaWriter(this.odfContext.getPackage().addEntry("meta.xml", "text/xml").getOutputStream());
        writer.start();
        writer.writeMeta(creator, title, description, subject);
        writer.end();
    }
}

