/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document;

import java.io.IOException;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.emitter.ContentEmitterUtil;
import org.eclipse.birt.report.engine.emitter.DOMBuilderEmitter;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;

public class ReportExecutorWrapper
implements IReportExecutor {
    public static final int EXECUTOR_VERSION_UNKNOWN = -1;
    public static final int EXECUTOR_VERSION_1 = 1;
    public static final int EXECUTOR_VERSION_2 = 2;
    public static final int EXECUTOR_VERSION_3 = 3;
    public static final int EXECUTOR_VERSION_4 = 4;
    protected IReportExecutor executor;

    public IPageContent createPage(long pageNumber, MasterPageDesign pageDesign) throws BirtException {
        IReportItemExecutor executor = this.createPageExecutor(pageNumber, pageDesign);
        IPageContent content = (IPageContent)executor.execute();
        DOMBuilderEmitter emitter = new DOMBuilderEmitter(content);
        while (executor.hasNextChild()) {
            IReportItemExecutor childExecutor = executor.getNextChild();
            IContent childContent = childExecutor.execute();
            if (childContent != null) {
                ContentEmitterUtil.startContent(childContent, emitter);
            }
            this.executeAll(executor, emitter);
            if (childContent != null) {
                ContentEmitterUtil.endContent(childContent, emitter);
            }
            childExecutor.close();
        }
        executor.close();
        return content;
    }

    protected void executeAll(IReportItemExecutor executor, IContentEmitter emitter) throws BirtException {
        while (executor.hasNextChild()) {
            IReportItemExecutor childExecutor = executor.getNextChild();
            IContent childContent = childExecutor.execute();
            if (childContent != null) {
                ContentEmitterUtil.startContent(childContent, emitter);
            }
            this.executeAll(executor, emitter);
            if (childContent != null) {
                ContentEmitterUtil.endContent(childContent, emitter);
            }
            childExecutor.close();
        }
    }

    @Override
    public IReportItemExecutor createPageExecutor(long pageNumber, MasterPageDesign pageDesign) throws BirtException {
        return this.executor.createPageExecutor(pageNumber, pageDesign);
    }

    @Override
    public IReportContent execute() throws BirtException {
        return this.executor.execute();
    }

    @Override
    public void close() throws BirtException {
        this.executor.close();
    }

    @Override
    public IReportItemExecutor getNextChild() throws BirtException {
        return this.executor.getNextChild();
    }

    @Override
    public boolean hasNextChild() throws BirtException {
        return this.executor.hasNextChild();
    }

    public static int getVersion(IReportDocument document) throws IOException {
        String birtVersion = document.getVersion();
        int version = -1;
        if (birtVersion != null) {
            version = "2.0.0".equals(birtVersion) ? 2 : ("2.1.0".equals(birtVersion) ? 3 : 4);
        }
        return version;
    }
}

