/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.emitter;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IBandContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IListGroupContent;
import org.eclipse.birt.report.engine.layout.area.impl.AreaFactory;
import org.eclipse.birt.report.engine.layout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.layout.pdf.emitter.ContainerLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.Layout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.LayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.emitter.RegionLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.RepeatableLayout;

public class ListGroupLayout
extends RepeatableLayout {
    public ListGroupLayout(LayoutEngineContext context, ContainerLayout parent, IContent content) {
        super(context, parent, content);
        this.bandStatus = 3;
    }

    @Override
    protected void repeatHeader() throws BirtException {
        if (this.bandStatus == 3) {
            return;
        }
        IListGroupContent listGroupContent = (IListGroupContent)this.content;
        if (!listGroupContent.isHeaderRepeat()) {
            return;
        }
        IBandContent band = listGroupContent.getHeader();
        if (band == null || band.getChildren().isEmpty()) {
            return;
        }
        ContainerArea headerArea = (ContainerArea)AreaFactory.createLogicContainer(this.content.getReportContent());
        headerArea.setAllocatedWidth(this.parent.getCurrentMaxContentWidth());
        RegionLayout regionLayout = new RegionLayout(this.context, band, headerArea);
        ((Layout)regionLayout).layout();
        if (headerArea.getAllocatedHeight() < this.getCurrentMaxContentHeight()) {
            this.addArea(headerArea);
            ++this.repeatCount;
        }
    }
}

