/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.bpmn2.modeler.core.features.BendpointConnectionRouter;
import org.eclipse.bpmn2.modeler.core.features.ConnectionRoute;
import org.eclipse.bpmn2.modeler.core.features.DetourPoints;
import org.eclipse.bpmn2.modeler.core.features.Direction;
import org.eclipse.bpmn2.modeler.core.features.RouteSolver;
import org.eclipse.bpmn2.modeler.core.utils.AnchorSite;
import org.eclipse.bpmn2.modeler.core.utils.AnchorType;
import org.eclipse.bpmn2.modeler.core.utils.AnchorUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.FixPointAnchor;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;

public class ManhattanConnectionRouter
extends BendpointConnectionRouter {
    static final int margin = 10;
    static boolean testRouteSolver = false;

    public ManhattanConnectionRouter(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    public boolean routingNeeded(Connection connection) {
        if (Graphiti.getPeService().getProperty((PropertyContainer)connection, "ROUTING_NET_CONNECTION") != null) {
            return false;
        }
        if (connection instanceof FreeFormConnection) {
            if (FeatureSupport.getPropertyValue((PropertyContainer)connection, "initial.update") != null) {
                return true;
            }
            if (ManhattanConnectionRouter.forceRouting(connection)) {
                return true;
            }
            this.initialize(connection);
            int length = this.oldPoints.length;
            int i = 0;
            Point p1 = this.oldPoints[i++];
            while (i < length) {
                Point p2;
                if (!this.isHorizontal(p1, p2 = this.oldPoints[i++]) && !this.isVertical(p1, p2)) {
                    return true;
                }
                if (this.getCollision(p1, p2) != null) {
                    return true;
                }
                if (GraphicsUtil.getLength(p1, p2) < 10.0) {
                    return true;
                }
                p1 = p2;
            }
        }
        return false;
    }

    @Override
    public boolean route(Connection connection) {
        boolean changed = false;
        boolean repeat = false;
        int iterations = 0;
        do {
            repeat = false;
            this.initialize(connection);
            Hashtable<AnchorSite, List<FixPointAnchor>> sourceAnchorsBefore = AnchorUtil.countAnchors((AnchorContainer)this.source);
            Hashtable<AnchorSite, List<FixPointAnchor>> targetAnchorsBefore = AnchorUtil.countAnchors((AnchorContainer)this.target);
            if (connection instanceof FreeFormConnection) {
                Map<Anchor, Point> initialSourceAnchorLocations = AnchorUtil.saveAnchorLocations((AnchorContainer)this.source);
                Map<Anchor, Point> initialTargetAnchorLocations = AnchorUtil.saveAnchorLocations((AnchorContainer)this.target);
                AnchorUtil.adjustAnchors((AnchorContainer)this.source);
                AnchorUtil.adjustAnchors((AnchorContainer)this.target);
                this.oldPoints[0] = GraphicsUtil.createPoint(this.ffc.getStart());
                this.oldPoints[this.oldPoints.length - 1] = GraphicsUtil.createPoint(this.ffc.getEnd());
                ConnectionRoute route = this.calculateRoute();
                if (route != null) {
                    changed = this.isRouteChanged(route);
                    this.applyRoute(route);
                }
                initialSourceAnchorLocations.remove(this.ffc.getStart());
                initialTargetAnchorLocations.remove(this.ffc.getEnd());
                AnchorUtil.restoreAnchorLocations((AnchorContainer)this.source, initialSourceAnchorLocations);
                AnchorUtil.restoreAnchorLocations((AnchorContainer)this.target, initialTargetAnchorLocations);
                this.dispose();
            }
            Hashtable<AnchorSite, List<FixPointAnchor>> sourceAnchorsAfter = AnchorUtil.countAnchors((AnchorContainer)this.source);
            Hashtable<AnchorSite, List<FixPointAnchor>> targetAnchorsAfter = AnchorUtil.countAnchors((AnchorContainer)this.target);
            AnchorSite[] anchorSiteArray = AnchorSite.values();
            int n = anchorSiteArray.length;
            int n2 = 0;
            while (n2 < n) {
                AnchorSite site = anchorSiteArray[n2];
                List<FixPointAnchor> sb = sourceAnchorsBefore.get((Object)site);
                List<FixPointAnchor> sa = sourceAnchorsAfter.get((Object)site);
                if (sa != null && sb != null && sa.size() != sb.size()) {
                    repeat = true;
                }
                if (!repeat) {
                    List<FixPointAnchor> tb = targetAnchorsBefore.get((Object)site);
                    List<FixPointAnchor> ta = targetAnchorsAfter.get((Object)site);
                    if (ta != null && tb != null && ta.size() != tb.size()) {
                        repeat = true;
                    }
                }
                ++n2;
            }
        } while (repeat && ++iterations < 3);
        return changed;
    }

    @Override
    protected ConnectionRoute calculateRoute() {
        RouteSolver solver;
        boolean b;
        boolean initialUpdate;
        if (this.isSelfConnection()) {
            return super.calculateRoute();
        }
        GraphicsUtil.dump("\n===========================================\nRouting ", (Connection)this.ffc);
        boolean bl = initialUpdate = FeatureSupport.getPropertyValue((PropertyContainer)this.ffc, "initial.update") != null;
        if (initialUpdate) {
            peService.removeProperty((PropertyContainer)this.ffc, "initial.update");
        }
        Point start = null;
        Point end = null;
        if (testRouteSolver && (b = (solver = new RouteSolver(this.fp, this.allShapes)).solve(this.source, this.target))) {
            return null;
        }
        ArrayList<ConnectionRoute> allRoutes = new ArrayList<ConnectionRoute>();
        AnchorSite sourceSite = AnchorSite.getSite(this.sourceAnchor);
        AnchorSite targetSite = AnchorSite.getSite(this.targetAnchor);
        AnchorSite initialSourceSite = sourceSite;
        AnchorSite initialTargetSite = targetSite;
        Point initialSourceLocation = this.createPoint((Anchor)this.sourceAnchor);
        Point initialTargetLocation = this.createPoint((Anchor)this.targetAnchor);
        int length = this.oldPoints.length;
        if (this.movedBendpoint == null && length > 2) {
            int d;
            int dx = 0;
            int dy = 0;
            boolean canFix = true;
            Point p = this.oldPoints[1];
            if (sourceSite == AnchorSite.LEFT) {
                d = initialSourceLocation.getX() - p.getX();
                if (d < 10) {
                    dx = d - 10;
                }
            } else if (sourceSite == AnchorSite.RIGHT) {
                d = p.getX() - initialSourceLocation.getX();
                if (d < 10) {
                    dx = 10 - d;
                }
            } else if (sourceSite == AnchorSite.TOP) {
                d = initialSourceLocation.getY() - p.getY();
                if (d < 10) {
                    dy = d - 10;
                }
            } else if (sourceSite == AnchorSite.BOTTOM && (d = p.getY() - initialSourceLocation.getY()) < 10) {
                dy = 10 - d;
            }
            p = this.oldPoints[length - 2];
            if (targetSite == AnchorSite.LEFT) {
                d = initialTargetLocation.getX() - p.getX();
                if (d < 10) {
                    if (dx != 0) {
                        canFix = false;
                    } else {
                        dx = d - 10;
                    }
                }
            } else if (targetSite == AnchorSite.RIGHT) {
                d = p.getX() - initialTargetLocation.getX();
                if (d < 10) {
                    if (dx != 0) {
                        canFix = false;
                    } else {
                        dx = 10 - d;
                    }
                }
            } else if (targetSite == AnchorSite.TOP) {
                d = initialTargetLocation.getY() - p.getY();
                if (d < 10) {
                    if (dy != 0) {
                        canFix = false;
                    } else {
                        dy = d - 10;
                    }
                }
            } else if (targetSite == AnchorSite.BOTTOM && (d = p.getY() - initialTargetLocation.getY()) < 10) {
                if (dy != 0) {
                    canFix = false;
                } else {
                    dy = 10 - d;
                }
            }
            if (canFix) {
                Point p2;
                Point p1;
                Direction[] directions = new Direction[length - 1];
                ConnectionRoute route = new ConnectionRoute(this, 0, this.source, this.target);
                route.setSourceAnchor(this.sourceAnchor);
                route.setTargetAnchor(this.targetAnchor);
                Point[] pointArray = this.oldPoints;
                int n = this.oldPoints.length;
                int n2 = 0;
                while (n2 < n) {
                    Point point = pointArray[n2];
                    route.getPoints().add(point);
                    ++n2;
                }
                if (dx != 0 || dy != 0) {
                    int i = 1;
                    while (i < length - 1) {
                        p1 = route.get(i);
                        p1.setX(p1.getX() + dx);
                        p1.setY(p1.getY() + dy);
                        ++i;
                    }
                }
                p1 = route.get(0);
                int i = 1;
                while (i < length) {
                    p2 = route.get(i);
                    directions[i - 1] = Direction.get(p1, p2);
                    p1 = p2;
                    ++i;
                }
                directions[0] = Direction.get(initialSourceSite);
                directions[length - 2] = Direction.get(initialTargetSite);
                int loop = 0;
                while (loop < 2) {
                    ContainerShape shape;
                    int i2;
                    p1 = route.get(0);
                    p2 = route.get(1);
                    Point p3 = route.get(length - 2);
                    Point p4 = route.get(length - 1);
                    if (!Direction.get(p1, p2, true).parallel(directions[0])) {
                        i2 = 0;
                        p1 = route.get(i2++);
                        while (i2 < length - 1) {
                            Direction dir = directions[i2 - 1];
                            if (!Direction.get(p1, p2 = route.get(i2++), true).parallel(dir)) {
                                if (dir.isHorizontal()) {
                                    p2.setY(p1.getY());
                                } else {
                                    p2.setX(p1.getX());
                                }
                            }
                            if ((shape = this.getCollision(p1, p2)) != null) {
                                route.addCollision((Shape)shape, p1, p2);
                            }
                            p1 = p2;
                        }
                    } else if (!Direction.get(p3, p4, true).parallel(directions[length - 2])) {
                        i2 = length;
                        p1 = route.get(--i2);
                        while (i2 > 0) {
                            Direction dir = directions[i2 - 1];
                            if (Direction.get(p1, p2 = route.get(--i2), true) != dir) {
                                if (dir.isHorizontal()) {
                                    p2.setY(p1.getY());
                                } else {
                                    p2.setX(p1.getX());
                                }
                            }
                            if ((shape = this.getCollision(p1, p2)) != null) {
                                route.addCollision((Shape)shape, p1, p2);
                            }
                            p1 = p2;
                        }
                    } else {
                        route.addCollision((Shape)this.getCollision(p1, p2), p1, p2);
                        if (route.getCollisions().size() == 0) {
                            allRoutes.add(route);
                            break;
                        }
                    }
                    ++loop;
                }
            }
        }
        int i = 0;
        while (i < 16) {
            int rank = 1;
            if (!this.shouldCalculate(sourceSite, targetSite)) {
                ++rank;
            }
            AnchorUtil.moveAnchor(this.sourceAnchor, initialSourceLocation);
            AnchorUtil.moveAnchor(this.targetAnchor, initialTargetLocation);
            AnchorSite.setSite(this.sourceAnchor, sourceSite);
            AnchorUtil.adjustAnchors((AnchorContainer)this.source);
            AnchorSite.setSite(this.targetAnchor, targetSite);
            AnchorUtil.adjustAnchors((AnchorContainer)this.target);
            ConnectionRoute route = new ConnectionRoute(this, allRoutes.size() + 1, this.source, this.target);
            start = this.createPoint((Anchor)this.sourceAnchor);
            end = this.createPoint((Anchor)this.targetAnchor);
            if (initialUpdate || this.movedBendpoint != null || sourceSite != initialSourceSite || targetSite != initialTargetSite) {
                if (AnchorType.getType((Anchor)this.targetAnchor) == AnchorType.POOL) {
                    if (this.movedBendpoint != null) {
                        AnchorUtil.moveAnchor(this.targetAnchor, this.movedBendpoint);
                    } else {
                        AnchorUtil.moveAnchor(this.targetAnchor, this.sourceAnchor);
                    }
                    AnchorUtil.adjustAnchors((AnchorContainer)this.source);
                    end = this.createPoint((Anchor)this.targetAnchor);
                    if (targetSite != initialTargetSite) {
                        ++rank;
                    }
                }
                if (AnchorType.getType((Anchor)this.sourceAnchor) == AnchorType.POOL) {
                    if (this.movedBendpoint != null) {
                        AnchorUtil.moveAnchor(this.sourceAnchor, this.movedBendpoint);
                    } else {
                        AnchorUtil.moveAnchor(this.sourceAnchor, this.targetAnchor);
                    }
                    AnchorUtil.adjustAnchors((AnchorContainer)this.target);
                    start = this.createPoint((Anchor)this.sourceAnchor);
                    if (sourceSite != initialSourceSite) {
                        ++rank;
                    }
                }
            }
            route.setRank(rank);
            route.setSourceAnchor(this.sourceAnchor);
            route.setTargetAnchor(this.targetAnchor);
            this.calculateRoute(route, sourceSite, start, targetSite, end);
            allRoutes.add(route);
            if (i % 4 == 0) {
                sourceSite = this.getNextAnchorSite(sourceSite);
            } else {
                targetSite = this.getNextAnchorSite(targetSite);
            }
            ++i;
        }
        ConnectionRoute route = null;
        if (allRoutes.size() == 1) {
            route = (ConnectionRoute)allRoutes.get(0);
            this.optimize(route);
            GraphicsUtil.dump("Only one valid route: " + route.toString());
        } else if (allRoutes.size() > 1) {
            GraphicsUtil.dump("Optimizing Routes:\n------------------");
            for (ConnectionRoute r : allRoutes) {
                this.optimize(r);
            }
            GraphicsUtil.dump("Calculating Crossings:\n------------------");
            for (ConnectionRoute r : allRoutes) {
                if (r.getPoints().size() > 1) {
                    Point p1 = r.get(0);
                    int i3 = 1;
                    while (i3 < r.getPoints().size()) {
                        Point p2 = r.get(i3);
                        List<Connection> crossings = this.findCrossings(this.connection, p1, p2);
                        for (Connection c : crossings) {
                            if (c == this.connection) continue;
                            r.addCrossing(c, p1, p2);
                        }
                        ContainerShape shape = this.getCollision(p1, p2);
                        if (shape != null) {
                            r.addCollision((Shape)shape, p1, p2);
                        }
                        p1 = p2;
                        ++i3;
                    }
                }
                GraphicsUtil.dump("    " + r.toString());
            }
            GraphicsUtil.dump("Sorting Routes:\n------------------");
            Collections.sort(allRoutes);
            this.drawConnectionRoutes(allRoutes);
            route = (ConnectionRoute)allRoutes.get(0);
        }
        return route;
    }

    ConnectionRoute calculateRoute(ConnectionRoute route, AnchorSite sourceSite, Point start, AnchorSite targetSite, Point end) {
        if (this.movedBendpoint != null) {
            List<Point> departure = this.calculateDeparture(sourceSite, start, this.movedBendpoint);
            List<Point> approach = this.calculateApproach(targetSite, this.movedBendpoint, end);
            route.getPoints().addAll(departure);
            if (this.calculateEnroute(route, departure.get(departure.size() - 1), this.movedBendpoint)) {
                route.add(this.movedBendpoint);
                if (this.calculateEnroute(route, this.movedBendpoint, approach.get(0))) {
                    route.getPoints().addAll(approach);
                } else {
                    route.add(end);
                }
            } else {
                route.add(end);
            }
        } else {
            List<Point> departure = this.calculateDeparture(sourceSite, start, end);
            List<Point> approach = this.calculateApproach(targetSite, start, end);
            route.getPoints().addAll(departure);
            start = departure.get(departure.size() - 1);
            end = approach.get(0);
            this.calculateEnroute(route, start, end);
            route.getPoints().addAll(approach);
        }
        return route;
    }

    List<Point> calculateDeparture(AnchorSite sourceSite, Point start, Point end) {
        ArrayList<Point> points = new ArrayList<Point>();
        Point p = this.createPoint(start);
        Point m = this.createPoint(end);
        switch (sourceSite) {
            case TOP: 
            case BOTTOM: {
                ContainerShape shape;
                m.setX(start.getX());
                while ((shape = this.getCollision(start, m = this.getVertMidpoint(start, m, 0.5))) != null && Math.abs(m.getY() - start.getY()) > 10) {
                }
                if (shape != null) {
                    if (sourceSite == AnchorSite.BOTTOM) {
                        m.setY(start.getY() + 10);
                    } else {
                        m.setY(start.getY() - 10);
                    }
                }
                p.setY(m.getY());
                break;
            }
            case LEFT: 
            case RIGHT: {
                ContainerShape shape;
                m.setY(start.getY());
                while ((shape = this.getCollision(start, m = this.getHorzMidpoint(start, m, 0.5))) != null && Math.abs(m.getX() - start.getX()) > 10) {
                }
                if (shape != null) {
                    if (sourceSite == AnchorSite.RIGHT) {
                        m.setX(start.getX() + 10);
                    } else {
                        m.setX(start.getX() - 10);
                    }
                }
                p.setX(m.getX());
                break;
            }
            default: {
                return points;
            }
        }
        points.add(start);
        points.add(p);
        return points;
    }

    List<Point> calculateApproach(AnchorSite targetSite, Point start, Point end) {
        ArrayList<Point> points = new ArrayList<Point>();
        Point p = this.createPoint(end);
        Point m = this.createPoint(start);
        switch (targetSite) {
            case TOP: 
            case BOTTOM: {
                ContainerShape shape;
                m.setX(end.getX());
                while ((shape = this.getCollision(m = this.getVertMidpoint(m, end, 0.5), end)) != null && Math.abs(m.getY() - end.getY()) > 10) {
                }
                if (shape != null) {
                    if (targetSite == AnchorSite.BOTTOM) {
                        m.setY(end.getY() + 10);
                    } else {
                        m.setY(end.getY() - 10);
                    }
                }
                p.setY(m.getY());
                break;
            }
            case LEFT: 
            case RIGHT: {
                ContainerShape shape;
                m.setY(end.getY());
                while ((shape = this.getCollision(m = this.getHorzMidpoint(m, end, 0.5), end)) != null && Math.abs(m.getX() - end.getX()) > 10) {
                }
                if (shape != null) {
                    if (targetSite == AnchorSite.RIGHT) {
                        m.setX(end.getX() + 10);
                    } else {
                        m.setX(end.getX() - 10);
                    }
                }
                p.setX(m.getX());
                break;
            }
            default: {
                points.add(p);
                return points;
            }
        }
        points.add(p);
        points.add(end);
        return points;
    }

    boolean calculateEnroute(ConnectionRoute route, Point start, Point end) {
        if (GraphicsUtil.pointsEqual(start, end)) {
            return false;
        }
        if (!GraphicsUtil.isSlanted(start, end) && this.getCollision(start, end) == null) {
            return true;
        }
        Point nextPoint = this.createPoint(end);
        Point p0 = route.get(route.size() - 2);
        Point p1 = route.get(route.size() - 1);
        Direction oldDirection = Direction.get(p0, p1);
        Direction newDirection = Direction.get(oldDirection, start, end);
        switch (newDirection) {
            case UP: {
                nextPoint = this.createPoint(start.getX(), end.getY());
                if (this.calculateDetour(route, newDirection, start, nextPoint, end)) break;
                route.add(nextPoint);
                break;
            }
            case DOWN: {
                nextPoint = this.createPoint(start.getX(), end.getY());
                if (this.calculateDetour(route, newDirection, start, nextPoint, end)) break;
                route.add(nextPoint);
                break;
            }
            case LEFT: {
                nextPoint = this.createPoint(end.getX(), start.getY());
                if (this.calculateDetour(route, newDirection, start, nextPoint, end)) break;
                route.add(nextPoint);
                break;
            }
            case RIGHT: {
                nextPoint = this.createPoint(end.getX(), start.getY());
                if (this.calculateDetour(route, newDirection, start, nextPoint, end)) break;
                route.add(nextPoint);
            }
        }
        if (route.isValid() && !this.calculateEnroute(route, nextPoint = route.get(route.size() - 1), end)) {
            return false;
        }
        return route.isValid();
    }

    boolean calculateDetour(ConnectionRoute route, Direction direction, Point start, Point nextPoint, Point end) {
        ContainerShape shape = this.getCollision(start, nextPoint);
        if (shape != null) {
            DetourPoints detour = this.getDetourPoints(shape);
            switch (direction) {
                case UP: {
                    int d0 = Math.abs(nextPoint.getX() - detour.bottomLeft.getX());
                    int d1 = Math.abs(nextPoint.getX() - detour.bottomRight.getX());
                    if (d0 < d1) {
                        nextPoint.setY(detour.bottomLeft.getY());
                        route.add(nextPoint);
                        route.add(detour.bottomLeft);
                        break;
                    }
                    nextPoint.setY(detour.bottomRight.getY());
                    route.add(nextPoint);
                    route.add(detour.bottomRight);
                    break;
                }
                case DOWN: {
                    int d0 = Math.abs(nextPoint.getX() - detour.topLeft.getX());
                    int d1 = Math.abs(nextPoint.getX() - detour.topRight.getX());
                    if (d0 < d1) {
                        nextPoint.setY(detour.topLeft.getY());
                        route.add(nextPoint);
                        route.add(detour.topLeft);
                        break;
                    }
                    nextPoint.setY(detour.topRight.getY());
                    route.add(nextPoint);
                    route.add(detour.topRight);
                    break;
                }
                case LEFT: {
                    int d0 = Math.abs(nextPoint.getY() - detour.topRight.getY());
                    int d1 = Math.abs(nextPoint.getY() - detour.bottomRight.getY());
                    if (d0 < d1) {
                        nextPoint.setX(detour.topRight.getX());
                        route.add(nextPoint);
                        route.add(detour.topRight);
                        break;
                    }
                    nextPoint.setX(detour.bottomRight.getX());
                    route.add(nextPoint);
                    route.add(detour.bottomRight);
                    break;
                }
                case RIGHT: {
                    int d0 = Math.abs(nextPoint.getY() - detour.topLeft.getY());
                    int d1 = Math.abs(nextPoint.getY() - detour.bottomLeft.getY());
                    if (d0 < d1) {
                        nextPoint.setX(detour.topLeft.getX());
                        route.add(nextPoint);
                        route.add(detour.topLeft);
                        break;
                    }
                    nextPoint.setX(detour.bottomLeft.getX());
                    route.add(nextPoint);
                    route.add(detour.bottomLeft);
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        return shape != null;
    }

    Point getVertMidpoint(Point start, Point end, double fract) {
        Point m = this.createPoint(start);
        int d = (int)(fract * (double)(end.getY() - start.getY()));
        m.setY(start.getY() + d);
        return m;
    }

    Point getHorzMidpoint(Point start, Point end, double fract) {
        Point m = this.createPoint(start);
        int d = (int)(fract * (double)(end.getX() - start.getX()));
        m.setX(start.getX() + d);
        return m;
    }

    Point createPoint(int x, int y) {
        return GraphicsUtil.createPoint(x, y);
    }

    Point createPoint(Point p) {
        return GraphicsUtil.createPoint(p);
    }

    Point createPoint(Anchor a) {
        return GraphicsUtil.createPoint(a);
    }

    boolean isHorizontal(Point p1, Point p2) {
        return GraphicsUtil.isHorizontal(p1, p2);
    }

    boolean isVertical(Point p1, Point p2) {
        return GraphicsUtil.isVertical(p1, p2);
    }

    DetourPoints getDetourPoints(ContainerShape shape) {
        DetourPoints detour = new DetourPoints(shape, 10);
        if (this.allShapes == null) {
            this.findAllShapes();
        }
        int i = 0;
        while (i < this.allShapes.size()) {
            DetourPoints d;
            ContainerShape s = (ContainerShape)this.allShapes.get(i);
            if (shape != s && shape != this.source && shape != this.target && detour.intersects(d = new DetourPoints(s, 10)) && !detour.contains(d)) {
                detour.merge(d);
                i = -1;
            }
            ++i;
        }
        return detour;
    }

    boolean adjustPoint(AnchorSite site, Point p1, Point p2) {
        return this.adjustPoint(Direction.get(site), p1, p2);
    }

    boolean adjustPoint(Point p1, Point p2, AnchorSite site) {
        return this.adjustPoint(Direction.reverse(Direction.get(site)), p1, p2);
    }

    boolean adjustPoint(Direction direction, Point p1, Point p2) {
        switch (Direction.get(p1, p2)) {
            case UP: {
                if (p1.getY() - p2.getY() >= 10) break;
                p1.setY(p2.getY() - 10);
                return true;
            }
            case DOWN: {
                if (p2.getY() - p1.getY() >= 10) break;
                p1.setY(p2.getY() - 10);
                return true;
            }
            case LEFT: {
                if (p1.getX() - p2.getX() >= 10) break;
                p1.setX(p2.getX() - 10);
                return true;
            }
            case RIGHT: {
                if (p2.getX() - p1.getX() >= 10) break;
                p1.setX(p2.getX() + 10);
                return true;
            }
        }
        return false;
    }

    void optimize(ConnectionRoute route) {
        Point p2;
        if (route.getId() == 0) {
            return;
        }
        route.addSpecial(this.movedBendpoint);
        Point p1 = route.get(0);
        int i = 1;
        while (i < route.size()) {
            p2 = route.get(i);
            if (Math.abs(p1.getX() - p2.getX()) <= 1) {
                p2.setX(p1.getX());
            }
            if (Math.abs(p1.getY() - p2.getY()) <= 1) {
                p2.setY(p1.getY());
            }
            if (GraphicsUtil.isSlanted(p1, p2)) {
                route.setRank(5);
            }
            p1 = p2;
            ++i;
        }
        route.optimize();
        int size = route.size();
        if (size > 1) {
            GraphicsUtil.LineSegment[] sourceEdges = GraphicsUtil.getEdges(this.source);
            p1 = route.get(0);
            if (this.isVertical(p1, p2 = route.get(1))) {
                if (p1.getX() == sourceEdges[AnchorSite.LEFT.ordinal()].getStart().getX() || p1.getX() == sourceEdges[AnchorSite.RIGHT.ordinal()].getStart().getX()) {
                    route.setRank(4);
                }
            } else if (this.isHorizontal(p1, p2) && (p1.getY() == sourceEdges[AnchorSite.TOP.ordinal()].getStart().getY() || p1.getY() == sourceEdges[AnchorSite.BOTTOM.ordinal()].getStart().getY())) {
                route.setRank(4);
            }
            if (size > 2) {
                GraphicsUtil.LineSegment[] targetEdges = GraphicsUtil.getEdges(this.target);
                p1 = route.get(size - 2);
                if (this.isVertical(p1, p2 = route.get(size - 1))) {
                    if (p1.getX() == targetEdges[AnchorSite.LEFT.ordinal()].getStart().getX() || p1.getX() == targetEdges[AnchorSite.RIGHT.ordinal()].getStart().getX()) {
                        route.setRank(4);
                    }
                } else if (this.isHorizontal(p1, p2) && (p1.getY() == targetEdges[AnchorSite.TOP.ordinal()].getStart().getY() || p1.getY() == targetEdges[AnchorSite.BOTTOM.ordinal()].getStart().getY())) {
                    route.setRank(4);
                }
            }
        }
    }
}

