/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.configuration.internal;

import com.google.common.base.Objects;
import com.gradleware.tooling.toolingclient.GradleDistribution;
import java.io.File;
import java.io.IOException;

final class DefaultBuildConfigurationProperties {
    private final File rootProjectDirectory;
    private final GradleDistribution gradleDistribution;
    private final File gradleUserHome;
    private final boolean overrideWorkspaceSettings;
    private final boolean buildScansEnabled;
    private final boolean offlineMode;

    public DefaultBuildConfigurationProperties(File rootProjectDirectory, GradleDistribution gradleDistribution, File gradleUserHome, boolean overrideWorkspaceSettings, boolean buildScansEnabled, boolean offlineMode) {
        this.rootProjectDirectory = DefaultBuildConfigurationProperties.canonicalize(rootProjectDirectory);
        this.gradleDistribution = gradleDistribution;
        this.gradleUserHome = gradleUserHome;
        this.overrideWorkspaceSettings = overrideWorkspaceSettings;
        this.buildScansEnabled = buildScansEnabled;
        this.offlineMode = offlineMode;
    }

    private static File canonicalize(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public File getRootProjectDirectory() {
        return this.rootProjectDirectory;
    }

    public GradleDistribution getGradleDistribution() {
        return this.gradleDistribution;
    }

    public File getGradleUserHome() {
        return this.gradleUserHome;
    }

    public boolean isOverrideWorkspaceSettings() {
        return this.overrideWorkspaceSettings;
    }

    public boolean isBuildScansEnabled() {
        return this.buildScansEnabled;
    }

    public boolean isOfflineMode() {
        return this.offlineMode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DefaultBuildConfigurationProperties) {
            DefaultBuildConfigurationProperties other = (DefaultBuildConfigurationProperties)obj;
            return Objects.equal((Object)this.rootProjectDirectory, (Object)other.rootProjectDirectory) && Objects.equal((Object)this.gradleDistribution, (Object)other.gradleDistribution) && Objects.equal((Object)this.gradleUserHome, (Object)other.gradleUserHome) && Objects.equal((Object)this.overrideWorkspaceSettings, (Object)other.overrideWorkspaceSettings) && Objects.equal((Object)this.buildScansEnabled, (Object)other.buildScansEnabled) && Objects.equal((Object)this.offlineMode, (Object)other.offlineMode);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.rootProjectDirectory, this.gradleDistribution, this.gradleUserHome, this.overrideWorkspaceSettings, this.buildScansEnabled, this.offlineMode});
    }
}

