/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.util.widget;

import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.i18n.CoreMessages;
import org.eclipse.buildship.ui.util.widget.GradleDistributionGroup;
import org.eclipse.buildship.ui.util.widget.GradleUserHomeGroup;
import org.eclipse.buildship.ui.util.widget.HoverText;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;

public final class GradleProjectSettingsComposite
extends Composite {
    private final String overrideCheckboxLabel;
    private final String configureParentPrefsLinkLabel;
    private Button overrideSettingsCheckbox;
    private Link parentPreferenceLink;
    private GradleDistributionGroup gradleDistributionGroup;
    private GradleUserHomeGroup gradleUserHomeGroup;
    private Button offlineModeCheckbox;
    private Button buildScansCheckbox;

    private GradleProjectSettingsComposite(Composite parent, boolean hasOverrideCheckbox, String overrideCheckboxLabel, String configureParentPrefsLinkLabel) {
        super(parent, 0);
        this.overrideCheckboxLabel = overrideCheckboxLabel;
        this.configureParentPrefsLinkLabel = configureParentPrefsLinkLabel;
        GridLayoutFactory.swtDefaults().numColumns(2).margins(0, 0).applyTo((Composite)this);
        if (hasOverrideCheckbox) {
            this.createOverrideWorkspaceCheckbox(this);
            this.configureParentPreferenceLink(this);
            this.createHorizontalLine(this);
        }
        this.createGradleDistributionGroup(this);
        this.createGradleUserHomeGroup(this);
        this.createOfflineModeCheckbox(this);
        this.createBuildScansCheckbox(this);
        this.addListeners();
        Dialog.applyDialogFont((Control)this);
    }

    private void createOverrideWorkspaceCheckbox(Composite parent) {
        this.overrideSettingsCheckbox = new Button(parent, 32);
        this.overrideSettingsCheckbox.setText(this.overrideCheckboxLabel);
        GridDataFactory.swtDefaults().applyTo((Control)parent);
    }

    private void configureParentPreferenceLink(Composite parent) {
        this.parentPreferenceLink = new Link(parent, 0);
        this.parentPreferenceLink.setFont(parent.getFont());
        this.parentPreferenceLink.setText("<A>" + this.configureParentPrefsLinkLabel + "...</A>");
        GridDataFactory.swtDefaults().align(0x1000008, 0x1000000).grab(false, false).applyTo((Control)this.parentPreferenceLink);
    }

    private void createHorizontalLine(Composite parent) {
        Label line = new Label(parent, 258);
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).applyTo((Control)line);
    }

    private void createGradleDistributionGroup(Composite parent) {
        this.gradleDistributionGroup = new GradleDistributionGroup(CorePlugin.publishedGradleVersions(), parent);
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)this.gradleDistributionGroup);
    }

    private void createGradleUserHomeGroup(Composite parent) {
        this.gradleUserHomeGroup = new GradleUserHomeGroup(parent);
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)this.gradleUserHomeGroup);
    }

    private void createOfflineModeCheckbox(Composite parent) {
        this.offlineModeCheckbox = new Button(parent, 32);
        this.offlineModeCheckbox.setText("Offline Mode");
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)this.offlineModeCheckbox);
    }

    private void createBuildScansCheckbox(Composite parent) {
        this.buildScansCheckbox = new Button(parent, 32);
        this.buildScansCheckbox.setText("Build Scans");
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)this.buildScansCheckbox);
        HoverText.createAndAttach((Control)this.buildScansCheckbox, CoreMessages.Preference_Label_BuildScansHover);
    }

    private void addListeners() {
        if (this.overrideSettingsCheckbox != null) {
            this.overrideSettingsCheckbox.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    GradleProjectSettingsComposite.this.updateEnablement();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    GradleProjectSettingsComposite.this.updateEnablement();
                }
            });
        }
    }

    public void updateEnablement() {
        if (this.overrideSettingsCheckbox != null) {
            boolean enabled = this.overrideSettingsCheckbox.getSelection();
            this.gradleDistributionGroup.setEnabled(enabled);
            this.gradleUserHomeGroup.setEnabled(enabled);
            this.offlineModeCheckbox.setEnabled(enabled);
            this.buildScansCheckbox.setEnabled(enabled);
        }
    }

    protected void checkSubclass() {
    }

    public Button getOverrideBuildSettingsCheckbox() {
        return this.overrideSettingsCheckbox;
    }

    public Link getParentPreferenceLink() {
        return this.parentPreferenceLink;
    }

    public GradleDistributionGroup getGradleDistributionGroup() {
        return this.gradleDistributionGroup;
    }

    public GradleUserHomeGroup getGradleUserHomeGroup() {
        return this.gradleUserHomeGroup;
    }

    public Button getOfflineModeCheckbox() {
        return this.offlineModeCheckbox;
    }

    public Button getBuildScansCheckbox() {
        return this.buildScansCheckbox;
    }

    public static GradleProjectSettingsComposite withOverrideCheckbox(Composite parent, String overrideCheckboxLabel, String configureParentPrefsLinkLabel) {
        return new GradleProjectSettingsComposite(parent, true, overrideCheckboxLabel, configureParentPrefsLinkLabel);
    }

    public static GradleProjectSettingsComposite withoutOverrideCheckbox(Composite parent) {
        return new GradleProjectSettingsComposite(parent, false, null, null);
    }
}

