/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.memory.floatingpoint;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.eclipse.cdt.debug.ui.memory.floatingpoint.FPMemoryByte;
import org.eclipse.cdt.debug.ui.memory.floatingpoint.FPRenderingMessages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class FPutilities {
    private static final int BYTE_MASK = 255;
    public static final float floatNegMax = -3.4028235E38f;
    public static final float floatNegMin = -1.1754944E-38f;
    public static final float floatPosMax = 1.1754943E38f;
    public static final float floatPosMin = 3.4028235E-38f;
    public static final double doubleNegMax = -1.7976931348623157E308;
    public static final double doubleNegMin = -2.2250738585072014E-308;
    public static final double doublePosMax = Double.MAX_VALUE;
    public static final double doublePosMin = Double.MIN_NORMAL;

    public static byte[] rawFloatBitsToByteArray(int floatBits) {
        int byteCount = 4;
        byte[] result = new byte[byteCount];
        int index = 0;
        while (index < byteCount) {
            int offset = (result.length - 1 - index) * 8;
            result[index] = (byte)(floatBits >>> offset & 0xFF);
            ++index;
        }
        return result;
    }

    public static byte[] rawDoubleBitsToByteArray(long doubleBits) {
        int byteCount = 8;
        byte[] result = new byte[byteCount];
        int index = 0;
        while (index < byteCount) {
            int offset = (result.length - 1 - index) * 8;
            result[index] = (byte)(doubleBits >>> offset & 0xFFL);
            ++index;
        }
        return result;
    }

    public static byte[] reverseByteOrder(byte[] byteArray) {
        if (byteArray.length == 0) {
            return new byte[0];
        }
        byte tempByte = 0;
        byte[] reversedByteArray = new byte[byteArray.length];
        System.arraycopy(byteArray, 0, reversedByteArray, 0, byteArray.length);
        int start = 0;
        int end = reversedByteArray.length - 1;
        while (start < end) {
            tempByte = reversedByteArray[start];
            reversedByteArray[start] = reversedByteArray[end];
            reversedByteArray[end] = tempByte;
            ++start;
            --end;
        }
        return reversedByteArray;
    }

    public static String byteArrayToSciNotation(FPDataType dt, boolean isLittleEndian, FPMemoryByte[] memByteArray, int maxDisplayDigits) throws ArithmeticException {
        int displayedDigits = 8;
        if (memByteArray.length != FPDataType.FLOAT.getByteLength() && memByteArray.length != FPDataType.DOUBLE.getByteLength()) {
            throw new ArithmeticException("Conversion of the floating point number cannot be performed; invalid data type or byte array length.");
        }
        DecimalFormat df = new DecimalFormat("0.0E0");
        df.setPositivePrefix(" ");
        DecimalFormatSymbols dfSymbols = new DecimalFormatSymbols();
        dfSymbols.setNaN(" " + FPRenderingMessages.getString("FPRendering.NAN"));
        dfSymbols.setInfinity(FPRenderingMessages.getString("FPRendering.INFINITY"));
        df.setDecimalFormatSymbols(dfSymbols);
        df.setMinimumIntegerDigits(1);
        df.setMaximumIntegerDigits(1);
        if (dt == FPDataType.FLOAT) {
            displayedDigits = Math.min(maxDisplayDigits, FPDataType.FLOAT.getInternalPrecision());
        }
        if (dt == FPDataType.DOUBLE) {
            displayedDigits = Math.min(maxDisplayDigits, FPDataType.DOUBLE.getInternalPrecision());
        }
        df.setMinimumFractionDigits(displayedDigits - 1);
        df.setMaximumFractionDigits(displayedDigits - 1);
        ByteOrder byteOrder = isLittleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        return df.format(dt == FPDataType.FLOAT ? (double)ByteBuffer.wrap(FPutilities.memoryBytesToByteArray(memByteArray)).order(byteOrder).getFloat() : ByteBuffer.wrap(FPutilities.memoryBytesToByteArray(memByteArray)).order(byteOrder).getDouble());
    }

    public static byte[] floatingStringToByteArray(FPDataType dt, String valueString, int dataTypeBitCount) throws NumberFormatException {
        if ((valueString = valueString.trim().replaceAll(" ", "")).length() != 0) {
            if (dt == FPDataType.FLOAT || FPDataType.FLOAT.getBitsize() == dataTypeBitCount) {
                float floatValue = new Float(valueString).floatValue();
                floatValue = FPutilities.floatLimitCheck(floatValue);
                return FPutilities.rawFloatBitsToByteArray(Float.floatToRawIntBits(floatValue));
            }
            if (dt == FPDataType.DOUBLE || FPDataType.DOUBLE.getBitsize() == dataTypeBitCount) {
                double doubleValue = new Double(valueString);
                doubleValue = FPutilities.doubleLimitCheck(doubleValue);
                return FPutilities.rawDoubleBitsToByteArray(Double.doubleToRawLongBits(doubleValue));
            }
        }
        return new byte[0];
    }

    public static byte[] memoryBytesToByteArray(FPMemoryByte[] memoryByteArray) {
        byte[] byteArray = new byte[memoryByteArray.length];
        int index = 0;
        while (index < memoryByteArray.length) {
            byteArray[index] = memoryByteArray[index].getValue();
            ++index;
        }
        return byteArray;
    }

    public static FPMemoryByte[] byteArrayToMemoryBytes(Endian endian, byte[] byteArray) {
        FPMemoryByte[] memoryBytes = new FPMemoryByte[byteArray.length];
        int index = 0;
        while (index < byteArray.length) {
            memoryBytes[index] = new FPMemoryByte();
            memoryBytes[index].setBigEndian(endian == Endian.BIG);
            memoryBytes[index].setValue(byteArray[index]);
            ++index;
        }
        return memoryBytes;
    }

    public static boolean validEditCharacter(char character) {
        return character >= '0' && character <= '9' || character == '+' || character == '-' || character == 'e' || character == 'E' || character == '.' || character == ' ';
    }

    public static boolean isValidFormat(String string) {
        boolean digit = false;
        char[] charArray = string.toCharArray();
        String scientificNotationPattern = "^[-+]??(\\d++[.]\\d*?|[.]?\\d+?|\\d+(?=[eE]))([eE][-+]??\\d++)?$";
        if (!Pattern.matches(scientificNotationPattern, string)) {
            return false;
        }
        int index = 0;
        while (index < string.length()) {
            if (charArray[index] >= '0' && charArray[index] <= '9') {
                digit = true;
            }
            if (!FPutilities.validEditCharacter(charArray[index])) {
                return false;
            }
            if (FPutilities.countMatches(string.toLowerCase(), ".") > 1 || FPutilities.countMatches(string.toLowerCase(), "e") > 1) {
                return false;
            }
            if ((charArray[index] == '+' || charArray[index] == '-') && index != 0 && charArray[index - 1] != 'e' && charArray[index - 1] != 'E') {
                return false;
            }
            int eIndex = string.toLowerCase().indexOf(101);
            if (charArray[index] == '.' && eIndex != -1 && eIndex < index) {
                return false;
            }
            ++index;
        }
        return digit;
    }

    public static String fillString(int length, char character) {
        if (length < 1) {
            return "";
        }
        char[] charArray = new char[length];
        Arrays.fill(charArray, character);
        return new String(charArray);
    }

    public static int countMatches(String string, String subString) {
        if (string.length() == 0 || subString.length() == 0) {
            return 0;
        }
        int count = 0;
        int index = 0;
        while ((index = string.indexOf(subString, index)) != -1) {
            ++count;
            index += subString.length();
        }
        return count;
    }

    public static void stackTrace(int depth) {
        StackTraceElement[] seArray;
        int offset = 3;
        if (depth == 0) {
            depth = 4;
        }
        if ((seArray = Thread.currentThread().getStackTrace()).length > offset) {
            System.out.println("Displaying " + depth + " of " + seArray.length + " stack trace elements");
            int index = offset;
            while (index < Math.min(depth + offset, seArray.length + offset)) {
                System.out.println("   " + seArray[index].getClassName() + "." + seArray[index].getMethodName() + ": line " + seArray[index].getLineNumber());
                ++index;
            }
        } else {
            System.out.println("No stack frames to display");
        }
    }

    public static void popupMessage(final String title, final String errorText, final Status status) {
        UIJob job = new UIJob("Floating Point Renderer"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)title, (String)errorText, (IStatus)status);
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public static float floatLimitCheck(float floatValue) {
        if (floatValue != 0.0f && floatValue != Float.NEGATIVE_INFINITY && floatValue != Float.POSITIVE_INFINITY) {
            if (floatValue < 0.0f) {
                if (Float.compare(floatValue, -3.4028235E38f) < 0 || Float.compare(floatValue, -1.1754944E-38f) > 0) {
                    return Float.NEGATIVE_INFINITY;
                }
            } else if (Float.compare(floatValue, 3.4028235E-38f) < 0 || Float.compare(floatValue, 1.1754943E38f) > 0) {
                return Float.POSITIVE_INFINITY;
            }
        }
        return floatValue;
    }

    public static double doubleLimitCheck(double doubleValue) {
        if (doubleValue != 0.0 && doubleValue != Double.NEGATIVE_INFINITY && doubleValue != Double.POSITIVE_INFINITY) {
            if (doubleValue < 0.0) {
                if (Double.compare(doubleValue, -1.7976931348623157E308) < 0 || Double.compare(doubleValue, -2.2250738585072014E-308) > 0) {
                    return Double.NEGATIVE_INFINITY;
                }
            } else if (Double.compare(doubleValue, Double.MIN_NORMAL) < 0 || Double.compare(doubleValue, Double.MAX_VALUE) > 0) {
                return Double.POSITIVE_INFINITY;
            }
        }
        return doubleValue;
    }

    public static String bi2HexStr(BigInteger bi, int lastDigits) {
        int PAD_LENGTH = 12;
        String base16 = bi.toString(16);
        base16 = String.valueOf(FPutilities.fillString(12 - base16.length(), '0')) + base16;
        return "0x" + base16.substring(12 - lastDigits).toUpperCase();
    }

    public static String bi2DecStr(BigInteger bi, int lastDigits) {
        int PAD_LENGTH = 12;
        String base10 = bi.toString();
        base10 = String.valueOf(FPutilities.fillString(12 - base10.length(), '0')) + base10;
        return base10.substring(12 - lastDigits);
    }

    public static enum Endian {
        LITTLE(10),
        BIG(20);

        private int value;

        private Endian(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum FPDataType {
        FLOAT(10, 32, 7, 8),
        DOUBLE(20, 64, 15, 8),
        FLOAT_80(30, 80, 19, 16),
        FLOAT_96(40, 96, 0, 0),
        FLOAT_128(50, 128, 33, 16),
        FLOAT_256(60, 256, 0, 0),
        FLOAT_512(70, 512, 0, 0);

        private int value;
        private int bitsize;
        private int decimalPrecision;
        private int displayedPrecision;

        private FPDataType(int value, int bitSize, int precisionDigits, int defaultDisplayPrecision) {
            this.value = value;
            this.bitsize = bitSize;
            this.decimalPrecision = precisionDigits;
            this.displayedPrecision = defaultDisplayPrecision;
        }

        public int getValue() {
            return this.value;
        }

        public int getBitsize() {
            return this.bitsize;
        }

        public int getDecimalPrecision() {
            return this.decimalPrecision;
        }

        public int getDisplayedPrecision() {
            return this.displayedPrecision;
        }

        public int getInternalPrecision() {
            return this.decimalPrecision;
        }

        public int getByteLength() {
            return this.bitsize / 8;
        }
    }

    public static enum Justification {
        LEFT,
        RIGHT,
        CENTER;

    }
}

