/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.service;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.ImmediateDataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ReflectionSequence;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IBreakpoints;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommand;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.launching.LaunchUtils;
import org.eclipse.cdt.dsf.gdb.service.GDBRunControl_7_0;
import org.eclipse.cdt.dsf.gdb.service.IGDBBackend;
import org.eclipse.cdt.dsf.gdb.service.IGDBProcesses;
import org.eclipse.cdt.dsf.gdb.service.IReverseRunControl;
import org.eclipse.cdt.dsf.gdb.service.SessionType;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.mi.service.IMIContainerDMContext;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.MIInferiorProcess;
import org.eclipse.cdt.dsf.mi.service.command.output.MIBreakInsertInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIBreakpoint;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.cdt.utils.pty.PersistentPTY;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class StartOrRestartProcessSequence_7_0
extends ReflectionSequence {
    private IGDBControl fCommandControl;
    private CommandFactory fCommandFactory;
    private IGDBProcesses fProcService;
    private IReverseRunControl fReverseService;
    private IGDBBackend fBackend;
    private DsfServicesTracker fTracker;
    private IRunControl.IContainerDMContext fContainerDmc;
    private MIBreakpoint fUserBreakpoint;
    private boolean fUserBreakpointIsOnMain;
    private MIBreakpoint fBreakPointForReverse;
    private boolean fReverseEnabled;
    private final Map<String, Object> fAttributes;
    private final boolean fRestart;
    private PTY fPty;
    private final DataRequestMonitor<IRunControl.IContainerDMContext> fDataRequestMonitor;

    protected IRunControl.IContainerDMContext getContainerContext() {
        return this.fContainerDmc;
    }

    protected MIBreakpoint getUserBreakpoint() {
        return this.fUserBreakpoint;
    }

    protected MIBreakpoint getBreakPointForReverse() {
        return this.fBreakPointForReverse;
    }

    protected boolean getUserBreakpointIsOnMain() {
        return this.fUserBreakpointIsOnMain;
    }

    protected boolean getReverseEnabled() {
        return this.fReverseEnabled;
    }

    public StartOrRestartProcessSequence_7_0(DsfExecutor executor, IRunControl.IContainerDMContext containerDmc, Map<String, Object> attributes, boolean restart, DataRequestMonitor<IRunControl.IContainerDMContext> rm) {
        super(executor, rm);
        assert (executor != null);
        assert (containerDmc != null);
        if (attributes == null) {
            attributes = new HashMap<String, Object>();
        }
        this.fContainerDmc = containerDmc;
        this.fAttributes = attributes;
        this.fRestart = restart;
        this.fDataRequestMonitor = rm;
    }

    protected String[] getExecutionOrder(String group) {
        if ("GROUP_TOP_LEVEL".equals(group)) {
            return new String[]{"stepInitializeBaseSequence", "stepInsertStopOnMainBreakpoint", "stepSetBreakpointForReverse", "stepInitializeInputOutput", "stepCreateConsole", "stepRunProgram", "stepSetReverseOff", "stepEnableReverse", "stepContinue", "stepCleanupBaseSequence"};
        }
        return null;
    }

    @ReflectionSequence.Execute
    public void stepInitializeBaseSequence(RequestMonitor rm) {
        this.fTracker = new DsfServicesTracker(GdbPlugin.getBundleContext(), this.fContainerDmc.getSessionId());
        this.fCommandControl = (IGDBControl)this.fTracker.getService(IGDBControl.class);
        this.fCommandFactory = ((IMICommandControl)this.fTracker.getService(IMICommandControl.class)).getCommandFactory();
        this.fProcService = (IGDBProcesses)this.fTracker.getService(IGDBProcesses.class);
        this.fBackend = (IGDBBackend)this.fTracker.getService(IGDBBackend.class);
        if (this.fCommandControl == null || this.fCommandFactory == null || this.fProcService == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Cannot obtain service", null));
            rm.done();
            return;
        }
        this.fReverseService = (IReverseRunControl)this.fTracker.getService(IReverseRunControl.class);
        if (this.fReverseService != null) {
            this.fReverseEnabled = (Boolean)CDebugUtils.getAttribute(this.fAttributes, (String)"org.eclipse.cdt.dsf.gdb.REVERSE", (Object)false);
        }
        rm.done();
    }

    @ReflectionSequence.RollBack(value="stepInitializeBaseSequence")
    public void rollBackInitializeBaseSequence(RequestMonitor rm) {
        if (this.fTracker != null) {
            this.fTracker.dispose();
        }
        this.fTracker = null;
        rm.done();
    }

    @ReflectionSequence.Execute
    public void stepInsertStopOnMainBreakpoint(final RequestMonitor rm) {
        boolean userRequestedStop = (Boolean)CDebugUtils.getAttribute(this.fAttributes, (String)"org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", (Object)LaunchUtils.getStopAtMainDefault());
        if (userRequestedStop) {
            String userStopSymbol = (String)CDebugUtils.getAttribute(this.fAttributes, (String)"org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN_SYMBOL", (Object)LaunchUtils.getStopAtMainSymbolDefault());
            IBreakpoints.IBreakpointsTargetDMContext bpTargetDmc = (IBreakpoints.IBreakpointsTargetDMContext)DMContexts.getAncestorOfType((IDMContext)this.getContainerContext(), IBreakpoints.IBreakpointsTargetDMContext.class);
            this.fCommandControl.queueCommand(this.fCommandFactory.createMIBreakInsert(bpTargetDmc, true, false, null, 0, userStopSymbol, "0"), (DataRequestMonitor)new ImmediateDataRequestMonitor<MIBreakInsertInfo>(rm){

                public void handleSuccess() {
                    MIBreakpoint[] breakpoints;
                    if (this.getData() != null && (breakpoints = ((MIBreakInsertInfo)this.getData()).getMIBreakpoints()).length > 0) {
                        StartOrRestartProcessSequence_7_0.this.fUserBreakpoint = breakpoints[0];
                    }
                    rm.done();
                }
            });
        } else {
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepSetBreakpointForReverse(final RequestMonitor rm) {
        if (this.fReverseEnabled) {
            IBreakpoints.IBreakpointsTargetDMContext bpTargetDmc = (IBreakpoints.IBreakpointsTargetDMContext)DMContexts.getAncestorOfType((IDMContext)this.getContainerContext(), IBreakpoints.IBreakpointsTargetDMContext.class);
            this.fCommandControl.queueCommand(this.fCommandFactory.createMIBreakInsert(bpTargetDmc, true, false, null, 0, "main", "0"), (DataRequestMonitor)new ImmediateDataRequestMonitor<MIBreakInsertInfo>(rm){

                public void handleSuccess() {
                    MIBreakpoint[] breakpoints;
                    if (this.getData() != null && (breakpoints = ((MIBreakInsertInfo)this.getData()).getMIBreakpoints()).length > 0) {
                        StartOrRestartProcessSequence_7_0.this.fBreakPointForReverse = breakpoints[0];
                        if (StartOrRestartProcessSequence_7_0.this.fUserBreakpoint != null) {
                            StartOrRestartProcessSequence_7_0.this.fUserBreakpointIsOnMain = StartOrRestartProcessSequence_7_0.this.fBreakPointForReverse.getAddress().equals(StartOrRestartProcessSequence_7_0.this.fUserBreakpoint.getAddress());
                        }
                    }
                    rm.done();
                }
            });
        } else {
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepInitializeInputOutput(final RequestMonitor rm) {
        if (this.fBackend.getSessionType() == SessionType.REMOTE) {
            this.fPty = null;
            rm.done();
        } else {
            if (this.fRestart) {
                assert (this.fPty instanceof PersistentPTY || this.fPty == null);
                rm.done();
                return;
            }
            try {
                this.fPty = new PersistentPTY();
                this.fPty.validateSlaveName();
                this.fCommandControl.queueCommand(this.fCommandFactory.createMIInferiorTTYSet((IMIContainerDMContext)this.getContainerContext(), this.fPty.getSlaveName()), (DataRequestMonitor)new ImmediateDataRequestMonitor<MIInfo>(rm){

                    protected void handleFailure() {
                        StartOrRestartProcessSequence_7_0.this.fPty = null;
                        rm.done();
                    }
                });
            }
            catch (IOException e) {
                this.fPty = null;
                rm.done();
            }
        }
    }

    @Deprecated
    protected MIInferiorProcess createInferiorProcess(IRunControl.IContainerDMContext container, OutputStream outputStream) {
        return new MIInferiorProcess(container, outputStream);
    }

    @Deprecated
    protected MIInferiorProcess createInferiorProcess(IRunControl.IContainerDMContext container, PTY pty) {
        return new MIInferiorProcess(container, pty);
    }

    @ReflectionSequence.Execute
    public void stepCreateConsole(final RequestMonitor rm) {
        if (this.fBackend.getSessionType() == SessionType.REMOTE) {
            rm.done();
            return;
        }
        if (this.fRestart) {
            rm.done();
            return;
        }
        IGDBBackend backend = (IGDBBackend)this.fTracker.getService(IGDBBackend.class);
        String defaultPathName = backend.getProgramPath().lastSegment();
        if (defaultPathName == null) {
            defaultPathName = "";
        }
        String progPathName = (String)CDebugUtils.getAttribute(this.fAttributes, (String)"org.eclipse.cdt.launch.PROGRAM_NAME", (Object)defaultPathName);
        String pathLabel = new Path(progPathName).lastSegment();
        this.fProcService.addInferiorToLaunch(this.fContainerDmc, pathLabel, this.fPty, (RequestMonitor)new ImmediateRequestMonitor(){

            protected void handleCompleted() {
                rm.done();
            }
        });
    }

    @ReflectionSequence.Execute
    public void stepRunProgram(final RequestMonitor rm) {
        ICommand<MIInfo> command = this.useContinueCommand() ? this.fCommandFactory.createMIExecContinue((IRunControl.IExecutionDMContext)this.fContainerDmc) : this.fCommandFactory.createMIExecRun((IRunControl.IExecutionDMContext)this.fContainerDmc);
        this.fCommandControl.queueCommand(command, (DataRequestMonitor)new ImmediateDataRequestMonitor<MIInfo>(rm){

            protected void handleSuccess() {
                if (StartOrRestartProcessSequence_7_0.this.fContainerDmc instanceof IMIContainerDMContext) {
                    StartOrRestartProcessSequence_7_0.this.fContainerDmc = StartOrRestartProcessSequence_7_0.this.fProcService.createContainerContextFromGroupId(StartOrRestartProcessSequence_7_0.this.fCommandControl.getContext(), ((IMIContainerDMContext)StartOrRestartProcessSequence_7_0.this.fContainerDmc).getGroupId());
                    StartOrRestartProcessSequence_7_0.this.fDataRequestMonitor.setData((Object)StartOrRestartProcessSequence_7_0.this.fContainerDmc);
                } else if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"Container context was not an IMIContainerDMContext");
                }
                rm.done();
            }
        });
    }

    @ReflectionSequence.Execute
    public void stepSetReverseOff(RequestMonitor rm) {
        GDBRunControl_7_0 reverseService;
        if (this.fRestart && (reverseService = (GDBRunControl_7_0)this.fTracker.getService(GDBRunControl_7_0.class)) != null) {
            reverseService.setReverseModeEnabled(false);
        }
        rm.done();
    }

    @ReflectionSequence.Execute
    public void stepEnableReverse(RequestMonitor rm) {
        if (this.fReverseEnabled) {
            this.fReverseService.enableReverseMode(this.fCommandControl.getContext(), true, rm);
        } else {
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepContinue(RequestMonitor rm) {
        if (this.fReverseEnabled && !this.fUserBreakpointIsOnMain) {
            this.fCommandControl.queueCommand(this.fCommandFactory.createMIExecContinue((IRunControl.IExecutionDMContext)this.fContainerDmc), (DataRequestMonitor)new ImmediateDataRequestMonitor(rm));
        } else {
            rm.done();
        }
    }

    @ReflectionSequence.Execute
    public void stepCleanupBaseSequence(RequestMonitor rm) {
        this.fTracker.dispose();
        this.fTracker = null;
        rm.done();
    }

    protected boolean useContinueCommand() {
        IGDBBackend backend = (IGDBBackend)this.fTracker.getService(IGDBBackend.class);
        if (backend == null) {
            return false;
        }
        return backend.getSessionType() == SessionType.REMOTE && !backend.getIsAttachSession();
    }
}

