/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;
import org.eclipse.cdt.internal.core.model.ASTStringUtil;
import org.eclipse.cdt.internal.core.model.ext.ICElementHandle;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.internal.ui.text.ICReconcilingListener;
import org.eclipse.cdt.internal.ui.viewsupport.IndexUI;
import org.eclipse.cdt.ui.CDTUITools;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;

public class OverrideIndicatorManager
implements ICReconcilingListener {
    public static final String ANNOTATION_TYPE = "org.eclipse.cdt.ui.overrideIndicator";
    private final HashMap<ICPPClassType, ICPPMethod[]> methodsCache = new HashMap();
    public static final int ANNOTATION_IMPLEMENTS = 0;
    public static final int ANNOTATION_OVERRIDES = 1;
    public static final int ANNOTATION_SHADOWS = 2;
    private final IAnnotationModel fAnnotationModel;
    private Annotation[] fOverrideAnnotations;
    private final Object fAnnotationModelLockObject;
    private int annotationKind;
    private String annotationMessage;

    public OverrideIndicatorManager(IAnnotationModel annotationModel, IASTTranslationUnit ast) {
        this.fAnnotationModel = annotationModel;
        this.fAnnotationModelLockObject = this.getLockObject(this.fAnnotationModel);
        this.updateAnnotations(ast, (IProgressMonitor)new NullProgressMonitor());
    }

    private Object getLockObject(IAnnotationModel annotationModel) {
        Object lock;
        if (annotationModel instanceof ISynchronizable && (lock = ((ISynchronizable)annotationModel).getLockObject()) != null) {
            return lock;
        }
        return annotationModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateAnnotations(IASTTranslationUnit ast, IProgressMonitor progressMonitor) {
        if (ast == null || progressMonitor.isCanceled()) {
            return;
        }
        IIndex index = ast.getIndex();
        HashMap annotationMap = new HashMap(50);
        try {
            class MethodFinder
            extends ASTVisitor {
                private final /* synthetic */ IIndex val$index;
                private final /* synthetic */ Map val$annotationMap;

                MethodFinder(IIndex iIndex, Map map) {
                    this.val$index = iIndex;
                    this.val$annotationMap = map;
                    this.shouldVisitDeclarators = true;
                }

                public int visit(IASTDeclarator declarator) {
                    IBinding binding;
                    if (!(declarator instanceof ICPPASTFunctionDeclarator)) {
                        return 3;
                    }
                    IASTDeclarator decl = ASTQueries.findInnermostDeclarator((IASTDeclarator)declarator);
                    IASTName name = decl.getName();
                    if (name != null && (binding = name.resolveBinding()) instanceof ICPPMethod) {
                        ICPPMethod method = (ICPPMethod)binding;
                        try {
                            ICPPMethod overriddenMethod = OverrideIndicatorManager.this.testForOverride(method, (IASTNode)declarator);
                            if (overriddenMethod != null) {
                                try {
                                    ICElementHandle[] allDefinitions;
                                    ICElementHandle baseDeclaration = IndexUI.findAnyDeclaration(this.val$index, null, (IBinding)overriddenMethod);
                                    if (baseDeclaration == null && (allDefinitions = IndexUI.findAllDefinitions(this.val$index, (IBinding)overriddenMethod)).length > 0) {
                                        baseDeclaration = allDefinitions[0];
                                    }
                                    OverrideIndicator indicator = new OverrideIndicator(OverrideIndicatorManager.this.annotationKind, OverrideIndicatorManager.this.annotationMessage, baseDeclaration);
                                    IASTFileLocation fileLocation = declarator.getFileLocation();
                                    Position position = new Position(fileLocation.getNodeOffset(), fileLocation.getNodeLength());
                                    this.val$annotationMap.put(indicator, position);
                                }
                                catch (CoreException coreException) {}
                            }
                        }
                        catch (DOMException dOMException) {
                            // empty catch block
                        }
                    }
                    return 3;
                }
            }
            ast.accept((ASTVisitor)new MethodFinder(index, annotationMap));
        }
        finally {
            this.methodsCache.clear();
        }
        if (progressMonitor.isCanceled()) {
            return;
        }
        Object object = this.fAnnotationModelLockObject;
        synchronized (object) {
            if (this.fAnnotationModel instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)this.fAnnotationModel).replaceAnnotations(this.fOverrideAnnotations, annotationMap);
            } else {
                this.removeAnnotations();
                for (Map.Entry entry : annotationMap.entrySet()) {
                    this.fAnnotationModel.addAnnotation((Annotation)entry.getKey(), (Position)entry.getValue());
                }
            }
            this.fOverrideAnnotations = annotationMap.keySet().toArray(new Annotation[annotationMap.keySet().size()]);
        }
    }

    private ICPPMethod testForOverride(ICPPMethod method, IASTNode point) throws DOMException {
        if (method.isDestructor() || method.isPureVirtual()) {
            return null;
        }
        ICPPBase[] bases = ClassTypeHelper.getBases((ICPPClassType)method.getClassOwner(), (IASTNode)point);
        if (bases.length == 0) {
            return null;
        }
        ICPPClassType owningClass = method.getClassOwner();
        ICPPMethod overriddenMethod = this.getOverriddenMethodInBaseClass(owningClass, method, point);
        if (overriddenMethod != null) {
            StringBuilder sb = new StringBuilder();
            if (this.annotationKind == 0) {
                sb.append(CEditorMessages.OverrideIndicatorManager_implements);
            } else if (this.annotationKind == 1) {
                sb.append(CEditorMessages.OverrideIndicatorManager_overrides);
            } else if (this.annotationKind == 2) {
                sb.append(CEditorMessages.OverrideIndicatorManager_shadows);
            }
            sb.append(' ');
            sb.append(ASTStringUtil.join((String[])overriddenMethod.getQualifiedName(), (CharSequence)"::"));
            if (bases.length > 1) {
                boolean foundInDirectlyDerivedBaseClass = false;
                ICPPClassType matchedMethodOwner = overriddenMethod.getClassOwner();
                ICPPBase[] iCPPBaseArray = bases;
                int n = bases.length;
                int n2 = 0;
                while (n2 < n) {
                    ICPPBase base = iCPPBaseArray[n2];
                    if (base.getBaseClass() == matchedMethodOwner) {
                        foundInDirectlyDerivedBaseClass = true;
                        break;
                    }
                    ++n2;
                }
                if (!foundInDirectlyDerivedBaseClass) {
                    ICPPClassType indirectingClass = null;
                    ICPPBase[] iCPPBaseArray2 = bases;
                    int n3 = bases.length;
                    n = 0;
                    while (n < n3) {
                        ICPPBase base = iCPPBaseArray2[n];
                        IBinding baseClass = base.getBaseClass();
                        if (baseClass instanceof ICPPClassType && this.getOverriddenMethodInBaseClass(indirectingClass = (ICPPClassType)baseClass, method, point) != null) break;
                        ++n;
                    }
                    if (indirectingClass != null) {
                        sb.append(' ');
                        sb.append(CEditorMessages.OverrideIndicatorManager_via);
                        sb.append(' ');
                        sb.append(ASTStringUtil.join((String[])indirectingClass.getQualifiedName(), (CharSequence)"::"));
                    }
                }
            }
            this.annotationMessage = sb.toString();
            return overriddenMethod;
        }
        return null;
    }

    private ICPPMethod getOverriddenMethodInBaseClass(ICPPClassType aClass, ICPPMethod testedMethod, IASTNode point) throws DOMException {
        int n;
        int n2;
        ICPPClassType[] iCPPClassTypeArray;
        ICPPMethod[] allInheritedMethods;
        String testedMethodName = testedMethod.getName();
        if (this.methodsCache.containsKey(aClass)) {
            allInheritedMethods = this.methodsCache.get(aClass);
        } else {
            ICPPClassType[] bases;
            ICPPMethod[] inheritedMethods = null;
            iCPPClassTypeArray = bases = ClassTypeHelper.getAllBases((ICPPClassType)aClass, (IASTNode)point);
            n2 = bases.length;
            n = 0;
            while (n < n2) {
                ICPPClassType base = iCPPClassTypeArray[n];
                inheritedMethods = (ICPPMethod[])ArrayUtil.addAll(ICPPMethod.class, inheritedMethods, (Object[])ClassTypeHelper.getDeclaredMethods((ICPPClassType)base, (IASTNode)point));
                ++n;
            }
            allInheritedMethods = (ICPPMethod[])ArrayUtil.trim(ICPPMethod.class, inheritedMethods);
            this.methodsCache.put(aClass, allInheritedMethods);
        }
        boolean foundOverridden = false;
        ICPPClassType result = null;
        iCPPClassTypeArray = allInheritedMethods;
        n2 = allInheritedMethods.length;
        n = 0;
        while (n < n2) {
            ICPPClassType method = iCPPClassTypeArray[n];
            if (method.getName().equals(testedMethodName)) {
                if (method.isVirtual()) {
                    if (ClassTypeHelper.isOverrider((ICPPMethod)testedMethod, (ICPPMethod)method)) {
                        if (method.isPureVirtual()) {
                            this.annotationKind = 0;
                            result = method;
                        } else {
                            this.annotationKind = 1;
                            result = method;
                        }
                        foundOverridden = true;
                    } else if (!foundOverridden) {
                        this.annotationKind = 2;
                        result = method;
                    }
                } else if (!foundOverridden) {
                    this.annotationKind = 2;
                    result = method;
                }
            }
            ++n;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAnnotations() {
        if (this.fOverrideAnnotations == null) {
            return;
        }
        Object object = this.fAnnotationModelLockObject;
        synchronized (object) {
            if (this.fAnnotationModel instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)this.fAnnotationModel).replaceAnnotations(this.fOverrideAnnotations, null);
            } else {
                int i = 0;
                int length = this.fOverrideAnnotations.length;
                while (i < length) {
                    this.fAnnotationModel.removeAnnotation(this.fOverrideAnnotations[i]);
                    ++i;
                }
            }
            this.fOverrideAnnotations = null;
        }
    }

    @Override
    public void aboutToBeReconciled() {
    }

    @Override
    public void reconciled(IASTTranslationUnit ast, boolean force, IProgressMonitor progressMonitor) {
        this.updateAnnotations(ast, progressMonitor);
    }

    public class OverrideIndicator
    extends Annotation {
        public static final String ANNOTATION_TYPE_ID = "org.eclipse.cdt.ui.overrideIndicator";
        private final int type;
        private final ICElementHandle elementHandle;

        public OverrideIndicator(int resultType, String message, ICElementHandle elementHandle) {
            super("org.eclipse.cdt.ui.overrideIndicator", false, message);
            this.type = resultType;
            this.elementHandle = elementHandle;
        }

        public int getIndicationType() {
            return this.type;
        }

        public void open() {
            try {
                CDTUITools.openInEditor((ICElement)this.elementHandle, true, true);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }
}

