/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui.dialogs;

import java.util.Arrays;
import java.util.List;
import org.eclipse.egf.core.ui.dialogs.AbstractSelectionDialog;
import org.eclipse.egf.core.ui.internal.SWTFactory;
import org.eclipse.egf.core.ui.l10n.CoreUIMessages;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public abstract class AbstractCheckboxSelectionDialog
extends AbstractSelectionDialog {
    private boolean fShowSelectButtons = false;

    public AbstractCheckboxSelectionDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected CheckboxTableViewer getCheckBoxTableViewer() {
        return (CheckboxTableViewer)this.fViewer;
    }

    protected void initializeControls() {
        List selectedElements = this.getInitialElementSelections();
        if (selectedElements != null && !selectedElements.isEmpty()) {
            this.fViewer.setInput(this.getViewerInput());
            this.getCheckBoxTableViewer().setCheckedElements(selectedElements.toArray());
            this.getCheckBoxTableViewer().setSelection((ISelection)StructuredSelection.EMPTY);
        }
        if (this.getButtonBar() != null) {
            super.initializeControls();
        }
    }

    protected StructuredViewer createViewer(Composite parent) {
        Table table = new Table(parent, 2084);
        table.setLayoutData((Object)new GridData(1808));
        return new CheckboxTableViewer(table);
    }

    protected void addViewerListeners(StructuredViewer viewer) {
        this.getCheckBoxTableViewer().addCheckStateListener((ICheckStateListener)new DefaultCheckboxListener());
    }

    protected boolean isValid() {
        return this.getCheckBoxTableViewer().getCheckedElements().length > 0;
    }

    protected void addCustomFooterControls(Composite parent) {
        if (this.fShowSelectButtons) {
            Composite comp = SWTFactory.createComposite(parent, 2, 1, 768);
            GridData gd = (GridData)comp.getLayoutData();
            gd.horizontalAlignment = 0x1000008;
            Button button = SWTFactory.createPushButton(comp, CoreUIMessages.AbstractCheckboxSelectionDialog_Select, null);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractCheckboxSelectionDialog.this.getCheckBoxTableViewer().setAllChecked(true);
                    if (AbstractCheckboxSelectionDialog.this.getButtonBar() != null) {
                        AbstractCheckboxSelectionDialog.this.getButton(0).setEnabled(AbstractCheckboxSelectionDialog.this.isValid());
                    }
                }
            });
            button = SWTFactory.createPushButton(comp, CoreUIMessages.AbstractCheckboxSelectionDialog_Deselect, null);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractCheckboxSelectionDialog.this.getCheckBoxTableViewer().setAllChecked(false);
                    if (AbstractCheckboxSelectionDialog.this.getButtonBar() != null) {
                        AbstractCheckboxSelectionDialog.this.getButton(0).setEnabled(AbstractCheckboxSelectionDialog.this.isValid());
                    }
                }
            });
        }
    }

    protected void setShowSelectAllButtons(boolean setting) {
        this.fShowSelectButtons = setting;
    }

    protected void okPressed() {
        Object[] elements = this.getCheckBoxTableViewer().getCheckedElements();
        this.setResult(Arrays.asList(elements));
        super.okPressed();
    }

    public Object[] getResult() {
        if (this.getCheckBoxTableViewer().getControl().isDisposed()) {
            return super.getResult();
        }
        return this.getCheckBoxTableViewer().getCheckedElements();
    }

    private class DefaultCheckboxListener
    implements ICheckStateListener {
        private DefaultCheckboxListener() {
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            if (AbstractCheckboxSelectionDialog.this.getButtonBar() != null) {
                AbstractCheckboxSelectionDialog.this.getButton(0).setEnabled(AbstractCheckboxSelectionDialog.this.isValid());
            }
        }
    }
}

