/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.ide.ui.sirius.internal;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.filters.AbstractDifferenceFilter;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.viewpoint.ViewpointPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SiriusTechnicalElementsFilter
extends AbstractDifferenceFilter {
    private static final Predicate<? super EObject> PREDICATE_WHEN_SELECTED = new Predicate<EObject>(){

        public boolean apply(EObject input) {
            if (input instanceof TreeNode) {
                EObject data = ((TreeNode)input).getData();
                Set affectedElements = Sets.newLinkedHashSet();
                if (data instanceof Diff) {
                    affectedElements = SiriusTechnicalElementsFilter.affectedEObjects((Diff)data);
                }
                return Iterables.any((Iterable)affectedElements, (Predicate)new Predicate<EObject>(){

                    public boolean apply(EObject element) {
                        EClass eClass = element.eClass();
                        return eClass != null && (eClass.getEPackage() == ViewpointPackage.eINSTANCE || eClass.getEPackage() == DiagramPackage.eINSTANCE);
                    }
                });
            }
            return false;
        }
    };

    public Predicate<? super EObject> getPredicateWhenSelected() {
        return PREDICATE_WHEN_SELECTED;
    }

    private static Set<EObject> affectedEObjects(Diff diff) {
        Match match = diff.getMatch();
        if (match != null) {
            return SiriusTechnicalElementsFilter.matchedEObjects(match);
        }
        return Sets.newLinkedHashSet();
    }

    private static Set<EObject> matchedEObjects(Match match) {
        LinkedHashSet affectedEObjects = Sets.newLinkedHashSet();
        if (match.getLeft() != null) {
            affectedEObjects.add(match.getLeft());
        }
        if (match.getRight() != null) {
            affectedEObjects.add(match.getRight());
        }
        if (match.getOrigin() != null) {
            affectedEObjects.add(match.getOrigin());
        }
        return affectedEObjects;
    }
}

