/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.handlers;

import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import org.eclipse.gef.mvc.fx.handlers.AbstractHandler;
import org.eclipse.gef.mvc.fx.handlers.IOnHoverHandler;
import org.eclipse.gef.mvc.fx.models.HoverModel;
import org.eclipse.gef.mvc.fx.parts.IContentPart;
import org.eclipse.gef.mvc.fx.parts.IHandlePart;
import org.eclipse.gef.mvc.fx.parts.IRootPart;

public class HoverOnHoverHandler
extends AbstractHandler
implements IOnHoverHandler {
    protected HoverModel getHoverModel() {
        return (HoverModel)((Object)this.getHost().getViewer().getAdapter(HoverModel.class));
    }

    @Override
    public void hover(MouseEvent e) {
        if (!this.isHover(e)) {
            return;
        }
        this.getHoverModel().setHover(this.getHost());
    }

    @Override
    public void hoverIntent(Node hoverIntent) {
        HoverModel hoverModel = this.getHoverModel();
        if (!this.isRegistered((EventTarget)hoverIntent) && this.getHost() instanceof IRootPart) {
            hoverModel.setHoverIntent(null);
        } else if (this.isRegisteredForHost((EventTarget)hoverIntent)) {
            if (this.getHost() instanceof IHandlePart) {
                if (!this.getHost().getAnchoragesUnmodifiable().containsKey(hoverModel.getHoverIntent())) {
                    hoverModel.setHoverIntent(null);
                }
            } else if (this.getHost() instanceof IContentPart) {
                hoverModel.setHoverIntent((IContentPart)this.getHost());
            } else if (this.getHost() instanceof IRootPart) {
                hoverModel.setHoverIntent(null);
            }
        }
    }

    protected boolean isHover(MouseEvent event) {
        return !this.isRegistered(event.getTarget()) || this.isRegisteredForHost(event.getTarget());
    }
}

