/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.batch;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.compiler.lookup.ModuleBinding;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;

public abstract class ClasspathLocation
implements FileSystem.Classpath,
SuffixConstants {
    public static final int SOURCE = 1;
    public static final int BINARY = 2;
    String path;
    char[] normalizedPath;
    public AccessRuleSet accessRuleSet;
    IModule module;
    protected boolean isAutoModule;
    public String destinationPath;

    protected ClasspathLocation(AccessRuleSet accessRuleSet, String destinationPath) {
        this.accessRuleSet = accessRuleSet;
        this.destinationPath = destinationPath;
    }

    protected AccessRestriction fetchAccessRestriction(String qualifiedBinaryFileName) {
        if (this.accessRuleSet == null) {
            return null;
        }
        char[] qualifiedTypeName = qualifiedBinaryFileName.substring(0, qualifiedBinaryFileName.length() - SUFFIX_CLASS.length).toCharArray();
        if (File.separatorChar == '\\') {
            CharOperation.replace(qualifiedTypeName, File.separatorChar, '/');
        }
        return this.accessRuleSet.getViolatedRestriction(qualifiedTypeName);
    }

    public int getMode() {
        return 3;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.getMode();
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClasspathLocation other = (ClasspathLocation)obj;
        String localPath = this.getPath();
        String otherPath = other.getPath();
        if (localPath == null ? otherPath != null : !localPath.equals(otherPath)) {
            return false;
        }
        return this.getMode() == other.getMode();
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getDestinationPath() {
        return this.destinationPath;
    }

    @Override
    public void acceptModule(IModule mod) {
        this.module = mod;
        this.isAutoModule = mod.isAutomatic();
    }

    @Override
    public boolean isAutomaticModule() {
        return this.isAutoModule;
    }

    @Override
    public Collection<String> getModuleNames(Collection<String> limitModules) {
        if (this.module != null) {
            return Collections.singletonList(String.valueOf(this.module.name()));
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isPackage(String qualifiedPackageName, String moduleName) {
        return this.getModulesDeclaringPackage(qualifiedPackageName, moduleName) != null;
    }

    protected char[][] singletonModuleNameIf(boolean condition) {
        if (!condition) {
            return null;
        }
        if (this.module != null) {
            return new char[][]{this.module.name()};
        }
        return new char[][]{ModuleBinding.UNNAMED};
    }
}

