/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java.hover;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IOrdinaryClassFile;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.javadoc.JavaDocLocations;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.actions.OpenBrowserUtil;
import org.eclipse.jdt.internal.ui.actions.SimpleSelectionProvider;
import org.eclipse.jdt.internal.ui.infoviews.JavadocView;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.jdt.internal.ui.text.java.hover.AbstractJavaEditorTextHover;
import org.eclipse.jdt.internal.ui.text.java.hover.JavaHoverMessages;
import org.eclipse.jdt.internal.ui.text.java.hover.JavadocBrowserInformationControlInput;
import org.eclipse.jdt.internal.ui.text.javadoc.JavadocContentAccess2;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementLabelComposer;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementLinks;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jdt.ui.actions.OpenAttachedJavadocAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.internal.text.html.BrowserInformationControl;
import org.eclipse.jface.internal.text.html.BrowserInformationControlInput;
import org.eclipse.jface.internal.text.html.BrowserInput;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.internal.text.html.HTMLTextPresenter;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension4;
import org.eclipse.jface.text.IInputChangedListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.osgi.framework.Bundle;

public class JavadocHover
extends AbstractJavaEditorTextHover {
    public static final String CONSTANT_VALUE_SEPARATOR = " : ";
    private static final long LABEL_FLAGS = JavaElementLabels.ALL_FULLY_QUALIFIED | 0x40L | 0x10000000000000L | 1L | 2L | 0x10L | 0x8000L | 4L | 0x200000L | 0x1000000000000L;
    private static final long LOCAL_VARIABLE_FLAGS = LABEL_FLAGS & 0xFFFFFFFFFFFEFFFFL | 0x20000L;
    private static final long TYPE_PARAMETER_FLAGS = LABEL_FLAGS | 0x400000L;
    private static final long PACKAGE_FLAGS = LABEL_FLAGS & (JavaElementLabels.ALL_FULLY_QUALIFIED ^ 0xFFFFFFFFFFFFFFFFL);
    private static String fgStyleSheet;
    private IInformationControlCreator fHoverControlCreator;
    private IInformationControlCreator fPresenterControlCreator;

    @Override
    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.fPresenterControlCreator == null) {
            this.fPresenterControlCreator = new PresenterControlCreator(this.getSite());
        }
        return this.fPresenterControlCreator;
    }

    private IWorkbenchSite getSite() {
        IWorkbenchPage page;
        IEditorPart editor = this.getEditor();
        if (editor == null && (page = JavaPlugin.getActivePage()) != null) {
            editor = page.getActiveEditor();
        }
        if (editor != null) {
            return editor.getSite();
        }
        return null;
    }

    @Override
    public IInformationControlCreator getHoverControlCreator() {
        if (this.fHoverControlCreator == null) {
            this.fHoverControlCreator = new HoverControlCreator(this.getInformationPresenterControlCreator());
        }
        return this.fHoverControlCreator;
    }

    public static IEditorPart openDeclaration(IJavaElement element) throws PartInitException, JavaModelException {
        Object[] nonJavaResources;
        if (!(element instanceof IPackageFragment)) {
            return JavaUI.openInEditor(element);
        }
        IPackageFragment packageFragment = (IPackageFragment)element;
        IPackageFragmentRoot root = (IPackageFragmentRoot)packageFragment.getAncestor(3);
        Object typeRoot = root.getKind() == 2 ? packageFragment.getClassFile("package-info.class") : packageFragment.getCompilationUnit("package-info.java");
        if (typeRoot.exists()) {
            return JavaUI.openInEditor((IJavaElement)typeRoot);
        }
        Object[] objectArray = nonJavaResources = packageFragment.getNonJavaResources();
        int n = nonJavaResources.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file;
            Object nonJavaResource = objectArray[n2];
            if (nonJavaResource instanceof IFile && (file = (IFile)nonJavaResource).exists() && "package.html".equals(file.getName())) {
                return EditorUtility.openInEditor((Object)file, true);
            }
            ++n2;
        }
        PackageExplorerPart view = (PackageExplorerPart)JavaPlugin.getActivePage().showView("org.eclipse.jdt.ui.PackageExplorer");
        view.tryToReveal(packageFragment);
        return null;
    }

    private static void addLinkListener(final BrowserInformationControl control) {
        control.addLocationListener(JavaElementLinks.createLocationListener(new JavaElementLinks.ILinkHandler(){

            @Override
            public void handleJavadocViewLink(IJavaElement linkTarget) {
                control.notifyDelayedInputChange(null);
                control.setVisible(false);
                control.dispose();
                try {
                    JavadocView view = (JavadocView)JavaPlugin.getActivePage().showView("org.eclipse.jdt.ui.JavadocView");
                    view.setInput(linkTarget);
                }
                catch (PartInitException e) {
                    JavaPlugin.log(e);
                }
            }

            @Override
            public void handleInlineJavadocLink(IJavaElement linkTarget) {
                JavadocBrowserInformationControlInput hoverInfo = JavadocHover.getHoverInfo(new IJavaElement[]{linkTarget}, null, null, (JavadocBrowserInformationControlInput)control.getInput());
                if (control.hasDelayedInputChangeListener()) {
                    control.notifyDelayedInputChange((Object)hoverInfo);
                } else {
                    control.setInput((Object)hoverInfo);
                }
            }

            @Override
            public void handleDeclarationLink(IJavaElement linkTarget) {
                control.notifyDelayedInputChange(null);
                control.dispose();
                try {
                    JavadocHover.openDeclaration(linkTarget);
                }
                catch (PartInitException e) {
                    JavaPlugin.log(e);
                }
                catch (JavaModelException e) {
                    JavaPlugin.log(e);
                }
            }

            @Override
            public boolean handleExternalLink(URL url, Display display) {
                control.notifyDelayedInputChange(null);
                control.dispose();
                OpenBrowserUtil.open(url, display);
                return true;
            }

            @Override
            public void handleTextSet() {
            }
        }));
    }

    @Deprecated
    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        JavadocBrowserInformationControlInput info = (JavadocBrowserInformationControlInput)((Object)this.getHoverInfo2(textViewer, hoverRegion));
        return info != null ? info.getHtml() : null;
    }

    @Override
    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        return this.internalGetHoverInfo(textViewer, hoverRegion);
    }

    private JavadocBrowserInformationControlInput internalGetHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        IJavaElement[] elements = this.getJavaElementsAt(textViewer, hoverRegion);
        if (elements == null || elements.length == 0) {
            return null;
        }
        return JavadocHover.getHoverInfo(elements, this.getEditorInputJavaElement(), hoverRegion, null);
    }

    private static IJavaElement[] filterDuplicatePackages(IJavaElement[] elements) {
        if (elements.length <= 1 || !(elements[0] instanceof IPackageFragment)) {
            return elements;
        }
        int i = 0;
        while (i < elements.length) {
            try {
                IPackageFragment packageFragment;
                if (elements[i] instanceof IPackageFragment && JavadocContentAccess2.getHTMLContent(packageFragment = (IPackageFragment)elements[i]) != null) {
                    return new IJavaElement[]{packageFragment};
                }
            }
            catch (CoreException coreException) {}
            ++i;
        }
        return new IJavaElement[]{elements[0]};
    }

    public static JavadocBrowserInformationControlInput getHoverInfo(IJavaElement[] elements, ITypeRoot editorInputElement, IRegion hoverRegion, JavadocBrowserInformationControlInput previousInput) {
        StringBuffer buffer = new StringBuffer();
        boolean hasContents = false;
        String base = null;
        IJavaElement element = null;
        int leadingImageWidth = 0;
        if ((elements = JavadocHover.filterDuplicatePackages(elements)).length > 1) {
            int i = 0;
            while (i < elements.length) {
                HTMLPrinter.startBulletList((StringBuffer)buffer);
                IJavaElement curr = elements[i];
                if (curr instanceof IMember || curr.getElementType() == 14) {
                    String link;
                    String label = JavaElementLabels.getElementLabel(curr, JavadocHover.getHeaderFlags(curr));
                    try {
                        String uri = JavaElementLinks.createURI("eclipse-javadoc", curr);
                        link = JavaElementLinks.createLink(uri, label);
                    }
                    catch (URISyntaxException e) {
                        JavaPlugin.log(e);
                        link = label;
                    }
                    HTMLPrinter.addBullet((StringBuffer)buffer, (String)link);
                    hasContents = true;
                }
                HTMLPrinter.endBulletList((StringBuffer)buffer);
                ++i;
            }
        } else {
            element = elements[0];
            if (element instanceof IPackageFragment || element instanceof IMember || element instanceof ILocalVariable || element instanceof ITypeParameter) {
                HTMLPrinter.addSmallHeader((StringBuffer)buffer, (String)JavadocHover.getInfoText(element, editorInputElement, hoverRegion, true));
                buffer.append("<br>");
                JavadocHover.addAnnotations(buffer, element, editorInputElement, hoverRegion);
                StringReader reader = null;
                try {
                    boolean isBinary;
                    String content = JavadocContentAccess2.getHTMLContent(element, true);
                    IPackageFragmentRoot root = (IPackageFragmentRoot)element.getAncestor(3);
                    boolean bl = isBinary = root.exists() && root.getKind() == 2;
                    if (content != null) {
                        base = JavadocContentAccess2.extractBaseURL(content);
                        if (base == null) {
                            base = JavaDocLocations.getBaseURL(element, isBinary);
                        }
                        reader = new StringReader(content);
                    } else {
                        String explanationForMissingJavadoc = JavaDocLocations.getExplanationForMissingJavadoc(element, root);
                        if (explanationForMissingJavadoc != null) {
                            reader = new StringReader(explanationForMissingJavadoc);
                        }
                    }
                }
                catch (CoreException ex) {
                    reader = new StringReader(JavaDocLocations.handleFailedJavadocFetch(ex));
                }
                if (reader != null) {
                    HTMLPrinter.addParagraph((StringBuffer)buffer, (Reader)reader);
                }
                hasContents = true;
            }
            leadingImageWidth = 20;
        }
        if (!hasContents) {
            return null;
        }
        if (buffer.length() > 0) {
            ColorRegistry registry = JFaceResources.getColorRegistry();
            RGB fgRGB = registry.getRGB("org.eclipse.jdt.ui.Javadoc.foregroundColor");
            RGB bgRGB = registry.getRGB("org.eclipse.jdt.ui.Javadoc.backgroundColor");
            HTMLPrinter.insertPageProlog((StringBuffer)buffer, (int)0, (RGB)fgRGB, (RGB)bgRGB, (String)JavadocHover.getStyleSheet());
            if (base != null) {
                int endHeadIdx = buffer.indexOf("</head>");
                buffer.insert(endHeadIdx, "\n<base href='" + base + "'>\n");
            }
            HTMLPrinter.addPageEpilog((StringBuffer)buffer);
            return new JavadocBrowserInformationControlInput(previousInput, element, buffer.toString(), leadingImageWidth);
        }
        return null;
    }

    private static String getInfoText(IJavaElement element, ITypeRoot editorInputElement, IRegion hoverRegion, boolean allowImage) {
        String constantValue;
        long flags = JavadocHover.getHeaderFlags(element);
        boolean haveSource = editorInputElement instanceof ICompilationUnit;
        ASTNode node = haveSource ? JavadocHover.getHoveredASTNode(editorInputElement, hoverRegion) : null;
        IBinding binding = JavadocHover.getHoverBinding(element, node);
        StringBuffer label = binding != null ? new StringBuffer(JavaElementLinks.getBindingLabel(binding, element, flags, haveSource)) : new StringBuffer(JavaElementLinks.getElementLabel(element, flags));
        if (element.getElementType() == 8 && (constantValue = JavadocHover.getConstantValue((IField)element, editorInputElement, hoverRegion)) != null) {
            constantValue = HTMLPrinter.convertToHTMLContentWithWhitespace((String)constantValue);
            label.append(CONSTANT_VALUE_SEPARATOR);
            label.append(constantValue);
        }
        if (element.getElementType() == 9) {
            String defaultValue;
            try {
                defaultValue = JavadocHover.getAnnotationMemberDefaultValue((IMethod)element, editorInputElement, hoverRegion);
            }
            catch (JavaModelException javaModelException) {
                defaultValue = null;
            }
            if (defaultValue != null) {
                defaultValue = HTMLPrinter.convertToHTMLContentWithWhitespace((String)defaultValue);
                label.append(CONSTANT_VALUE_SEPARATOR);
                label.append(defaultValue);
            }
        }
        return JavadocHover.getImageAndLabel(element, allowImage, label.toString());
    }

    public static String getAnnotationMemberDefaultValue(IMethod method, ITypeRoot editorInputElement, IRegion hoverRegion) throws JavaModelException {
        IMemberValuePair memberValuePair = method.getDefaultValue();
        if (memberValuePair == null) {
            return null;
        }
        Object defaultValue = memberValuePair.getValue();
        boolean isEmptyArray = defaultValue instanceof Object[] && ((Object[])defaultValue).length == 0;
        int valueKind = memberValuePair.getValueKind();
        if (valueKind == 14 && !isEmptyArray) {
            IBinding binding = JavadocHover.getHoveredNodeBinding((IJavaElement)method, editorInputElement, hoverRegion);
            if (binding instanceof IMethodBinding) {
                Object value = ((IMethodBinding)binding).getDefaultValue();
                StringBuffer buf = new StringBuffer();
                try {
                    JavadocHover.addValue(buf, value, false);
                }
                catch (URISyntaxException uRISyntaxException) {}
                return buf.toString();
            }
        } else if (defaultValue != null) {
            IAnnotation parentAnnotation = (IAnnotation)method.getAncestor(16);
            StringBuffer buf = new StringBuffer();
            new JavaElementLabelComposer(buf).appendAnnotationValue(parentAnnotation, defaultValue, valueKind, LABEL_FLAGS);
            return buf.toString();
        }
        return null;
    }

    private static IBinding getHoveredNodeBinding(IJavaElement element, ITypeRoot editorInputElement, IRegion hoverRegion) {
        IBinding binding;
        if (editorInputElement == null || hoverRegion == null) {
            return null;
        }
        ASTNode node = JavadocHover.getHoveredASTNode(editorInputElement, hoverRegion);
        if (node == null) {
            ASTParser p = ASTParser.newParser((int)9);
            p.setProject(element.getJavaProject());
            p.setBindingsRecovery(true);
            try {
                binding = p.createBindings(new IJavaElement[]{element}, null)[0];
            }
            catch (OperationCanceledException operationCanceledException) {
                return null;
            }
        } else {
            binding = JavadocHover.resolveBinding(node);
        }
        return binding;
    }

    public static IBinding getHoverBinding(IJavaElement element, ASTNode node) {
        if (element.getJavaProject().getOption("org.eclipse.jdt.core.compiler.annotation.nullanalysis", true).equals("enabled")) {
            if (node == null) {
                if (element instanceof ISourceReference) {
                    ASTParser p = ASTParser.newParser((int)9);
                    p.setProject(element.getJavaProject());
                    p.setBindingsRecovery(true);
                    try {
                        return p.createBindings(new IJavaElement[]{element}, null)[0];
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        return null;
                    }
                }
            } else {
                return JavadocHover.resolveBinding(node);
            }
        }
        return null;
    }

    private static String getImageURL(IJavaElement element) {
        String imageName = null;
        URL imageUrl = JavaPlugin.getDefault().getImagesOnFSRegistry().getImageURL(element);
        if (imageUrl != null) {
            imageName = imageUrl.toExternalForm();
        }
        return imageName;
    }

    public static long getHeaderFlags(IJavaElement element) {
        switch (element.getElementType()) {
            case 14: {
                return LOCAL_VARIABLE_FLAGS;
            }
            case 15: {
                return TYPE_PARAMETER_FLAGS;
            }
            case 4: 
            case 11: {
                return PACKAGE_FLAGS;
            }
        }
        return LABEL_FLAGS;
    }

    public static boolean isStaticFinal(IField field) {
        try {
            return JdtFlags.isFinal((IMember)field) && JdtFlags.isStatic((IMember)field);
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            return false;
        }
    }

    private static String getConstantValue(IField field, ITypeRoot editorInputElement, IRegion hoverRegion) {
        Object constantValue;
        if (!JavadocHover.isStaticFinal(field)) {
            return null;
        }
        if (editorInputElement == null || hoverRegion == null) {
            constantValue = JavadocView.computeFieldConstantFromTypeAST(field, null);
        } else {
            ASTNode node = JavadocHover.getHoveredASTNode(editorInputElement, hoverRegion);
            if (node == null) {
                return null;
            }
            constantValue = JavadocHover.getVariableBindingConstValue(node, field);
        }
        if (constantValue == null) {
            return null;
        }
        if (constantValue instanceof String) {
            return ASTNodes.getEscapedStringLiteral((String)((String)constantValue));
        }
        return JavadocHover.getHexConstantValue(constantValue);
    }

    private static ASTNode getHoveredASTNode(ITypeRoot editorInputElement, IRegion hoverRegion) {
        if (editorInputElement == null) {
            return null;
        }
        CompilationUnit unit = SharedASTProvider.getAST(editorInputElement, SharedASTProvider.WAIT_ACTIVE_ONLY, null);
        if (unit == null) {
            return null;
        }
        return NodeFinder.perform((ASTNode)unit, (int)hoverRegion.getOffset(), (int)hoverRegion.getLength());
    }

    private static String formatWithHexValue(Object constantValue, String hexValue) {
        return Messages.format(JavaHoverMessages.JavadocHover_constantValue_hexValue, new String[]{constantValue.toString(), hexValue});
    }

    private static String getStyleSheet() {
        String css;
        if (fgStyleSheet == null) {
            fgStyleSheet = JavadocHover.loadStyleSheet("/JavadocHoverStyleSheet.css");
        }
        if ((css = fgStyleSheet) != null) {
            FontData fontData = JFaceResources.getFontRegistry().getFontData("org.eclipse.jdt.ui.javadocfont")[0];
            css = HTMLPrinter.convertTopLevelFont((String)css, (FontData)fontData);
        }
        return css;
    }

    /*
     * Loose catch block
     */
    public static String loadStyleSheet(String styleSheetName) {
        Bundle bundle = Platform.getBundle((String)JavaPlugin.getPluginId());
        URL styleSheetURL = bundle.getEntry(styleSheetName);
        if (styleSheetURL == null) {
            return null;
        }
        BufferedReader reader = null;
        reader = new BufferedReader(new InputStreamReader(styleSheetURL.openStream()));
        StringBuffer buffer = new StringBuffer(1500);
        String line = reader.readLine();
        while (line != null) {
            buffer.append(line);
            buffer.append('\n');
            line = reader.readLine();
        }
        FontData fontData = JFaceResources.getFontRegistry().getFontData("org.eclipse.jdt.ui.javadocfont")[0];
        String string = HTMLPrinter.convertTopLevelFont((String)buffer.toString(), (FontData)fontData);
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException iOException) {}
        return string;
        catch (IOException ex) {
            try {
                JavaPlugin.log(ex);
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
            return "";
        }
    }

    public static String getImageAndLabel(IJavaElement element, boolean allowImage, String label) {
        String imageSrcPath;
        StringBuffer buf = new StringBuffer();
        int imageWidth = 16;
        int imageHeight = 16;
        int labelLeft = 20;
        int labelTop = 2;
        buf.append("<div style='word-wrap: break-word; position: relative; ");
        String string = imageSrcPath = allowImage ? JavadocHover.getImageURL(element) : null;
        if (imageSrcPath != null) {
            buf.append("margin-left: ").append(labelLeft).append("px; ");
            buf.append("padding-top: ").append(labelTop).append("px; ");
        }
        buf.append("'>");
        if (imageSrcPath != null) {
            if (element != null) {
                try {
                    String uri = JavaElementLinks.createURI("eclipse-open", element);
                    buf.append("<a href='").append(uri).append("'>");
                }
                catch (URISyntaxException uRISyntaxException) {
                    element = null;
                }
            }
            StringBuffer imageStyle = new StringBuffer("border:none; position: absolute; ");
            imageStyle.append("width: ").append(imageWidth).append("px; ");
            imageStyle.append("height: ").append(imageHeight).append("px; ");
            imageStyle.append("left: ").append(-labelLeft - 1).append("px; ");
            buf.append("<!--[if lte IE 6]><![if gte IE 5.5]>\n");
            String tooltip = element == null ? "" : "alt='" + JavaHoverMessages.JavadocHover_openDeclaration + "' ";
            buf.append("<span ").append(tooltip).append("style=\"").append(imageStyle).append("filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='").append(imageSrcPath).append("')\"></span>\n");
            buf.append("<![endif]><![endif]-->\n");
            buf.append("<!--[if !IE]>-->\n");
            buf.append("<img ").append(tooltip).append("style='").append(imageStyle).append("' src='").append(imageSrcPath).append("'/>\n");
            buf.append("<!--<![endif]-->\n");
            buf.append("<!--[if gte IE 7]>\n");
            buf.append("<img ").append(tooltip).append("style='").append(imageStyle).append("' src='").append(imageSrcPath).append("'/>\n");
            buf.append("<![endif]-->\n");
            if (element != null) {
                buf.append("</a>");
            }
        }
        buf.append(label);
        buf.append("</div>");
        return buf.toString();
    }

    public static void addAnnotations(StringBuffer buf, IJavaElement element, ITypeRoot editorInputElement, IRegion hoverRegion) {
        try {
            if (element instanceof IAnnotatable) {
                String annotationString = JavadocHover.getAnnotations(element, editorInputElement, hoverRegion);
                if (annotationString != null) {
                    buf.append("<div style='margin-bottom: 5px;'>");
                    buf.append(annotationString);
                    buf.append("</div>");
                }
            } else if (element instanceof IPackageFragment) {
                IPackageFragment pack = (IPackageFragment)element;
                ICompilationUnit cu = pack.getCompilationUnit("package-info.java");
                if (cu.exists()) {
                    IPackageDeclaration[] packDecls = cu.getPackageDeclarations();
                    if (packDecls.length > 0) {
                        JavadocHover.addAnnotations(buf, (IJavaElement)packDecls[0], null, null);
                    }
                } else {
                    IOrdinaryClassFile classFile = pack.getOrdinaryClassFile("package-info.class");
                    if (classFile.exists()) {
                        JavadocHover.addAnnotations(buf, (IJavaElement)classFile.getType(), null, null);
                    }
                }
            }
        }
        catch (JavaModelException javaModelException) {
            buf.append("<br>");
        }
        catch (URISyntaxException uRISyntaxException) {
            buf.append("<br>");
        }
    }

    private static String getAnnotations(IJavaElement element, ITypeRoot editorInputElement, IRegion hoverRegion) throws URISyntaxException, JavaModelException {
        IBinding binding;
        if (!(element instanceof IPackageFragment)) {
            if (!(element instanceof IAnnotatable)) {
                return null;
            }
            if (((IAnnotatable)element).getAnnotations().length == 0) {
                return null;
            }
        }
        if ((binding = JavadocHover.getHoveredNodeBinding(element, editorInputElement, hoverRegion)) == null) {
            return null;
        }
        IAnnotationBinding[] annotations = binding.getAnnotations();
        if (annotations.length == 0) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < annotations.length) {
            JavadocHover.addAnnotation(buf, annotations[i], true);
            buf.append("<br>");
            ++i;
        }
        return buf.toString();
    }

    private static IBinding resolveBinding(ASTNode node) {
        if (node instanceof SimpleName) {
            SimpleName simpleName = (SimpleName)node;
            ASTNode normalized = ASTNodes.getNormalizedNode((ASTNode)simpleName);
            if (normalized.getLocationInParent() == ClassInstanceCreation.TYPE_PROPERTY) {
                ClassInstanceCreation cic = (ClassInstanceCreation)normalized.getParent();
                IMethodBinding constructorBinding = cic.resolveConstructorBinding();
                if (constructorBinding == null) {
                    return null;
                }
                ITypeBinding declaringClass = constructorBinding.getDeclaringClass();
                if (!declaringClass.isAnonymous()) {
                    return constructorBinding;
                }
                ITypeBinding superTypeDeclaration = declaringClass.getSuperclass().getTypeDeclaration();
                return JavadocHover.resolveSuperclassConstructor(superTypeDeclaration, constructorBinding);
            }
            return simpleName.resolveBinding();
        }
        if (node instanceof SuperConstructorInvocation) {
            return ((SuperConstructorInvocation)node).resolveConstructorBinding();
        }
        if (node instanceof ConstructorInvocation) {
            return ((ConstructorInvocation)node).resolveConstructorBinding();
        }
        if (node instanceof LambdaExpression) {
            return ((LambdaExpression)node).resolveMethodBinding();
        }
        return null;
    }

    private static IBinding resolveSuperclassConstructor(ITypeBinding superClassDeclaration, IMethodBinding constructor) {
        IMethodBinding[] methods = superClassDeclaration.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            IMethodBinding method = methods[i];
            if (method.isConstructor() && constructor.isSubsignature(method)) {
                return method;
            }
            ++i;
        }
        return null;
    }

    private static void addAnnotation(StringBuffer buf, IAnnotationBinding annotation, boolean addLinks) throws URISyntaxException {
        IJavaElement javaElement = annotation.getAnnotationType().getJavaElement();
        buf.append('@');
        if (javaElement == null || !addLinks) {
            buf.append(annotation.getName());
        } else {
            String uri = JavaElementLinks.createURI("eclipse-javadoc", javaElement);
            JavadocHover.addLink(buf, uri, annotation.getName());
        }
        IMemberValuePairBinding[] mvPairs = annotation.getDeclaredMemberValuePairs();
        if (mvPairs.length > 0) {
            buf.append('(');
            int j = 0;
            while (j < mvPairs.length) {
                if (j > 0) {
                    buf.append(JavaElementLabels.COMMA_STRING);
                }
                IMemberValuePairBinding mvPair = mvPairs[j];
                if (addLinks) {
                    String memberURI = JavaElementLinks.createURI("eclipse-javadoc", mvPair.getMethodBinding().getJavaElement());
                    JavadocHover.addLink(buf, memberURI, mvPair.getName());
                } else {
                    buf.append(mvPair.getName());
                }
                buf.append('=');
                JavadocHover.addValue(buf, mvPair.getValue(), addLinks);
                ++j;
            }
            buf.append(')');
        }
    }

    private static void addValue(StringBuffer buf, Object value, boolean addLinks) throws URISyntaxException {
        if (value instanceof ITypeBinding) {
            ITypeBinding typeBinding = (ITypeBinding)value;
            IJavaElement type = typeBinding.getJavaElement();
            if (type == null || !addLinks) {
                buf.append(typeBinding.getName());
            } else {
                String uri = JavaElementLinks.createURI("eclipse-javadoc", type);
                String name = type.getElementName();
                JavadocHover.addLink(buf, uri, name);
            }
            buf.append(".class");
        } else if (value instanceof IVariableBinding) {
            IVariableBinding variableBinding = (IVariableBinding)value;
            IJavaElement variable = variableBinding.getJavaElement();
            if (variable == null || !addLinks) {
                buf.append(variableBinding.getName());
            } else {
                String uri = JavaElementLinks.createURI("eclipse-javadoc", variable);
                String name = variable.getElementName();
                JavadocHover.addLink(buf, uri, name);
            }
        } else if (value instanceof IAnnotationBinding) {
            IAnnotationBinding annotationBinding = (IAnnotationBinding)value;
            JavadocHover.addAnnotation(buf, annotationBinding, addLinks);
        } else if (value instanceof String) {
            buf.append(ASTNodes.getEscapedStringLiteral((String)((String)value)));
        } else if (value instanceof Character) {
            buf.append(ASTNodes.getEscapedCharacterLiteral((char)((Character)value).charValue()));
        } else if (value instanceof Object[]) {
            Object[] values = (Object[])value;
            buf.append('{');
            int i = 0;
            while (i < values.length) {
                if (i > 0) {
                    buf.append(JavaElementLabels.COMMA_STRING);
                }
                JavadocHover.addValue(buf, values[i], addLinks);
                ++i;
            }
            buf.append('}');
        } else {
            buf.append(String.valueOf(value));
        }
    }

    private static StringBuffer addLink(StringBuffer buf, String uri, String label) {
        return buf.append(JavaElementLinks.createLink(uri, label));
    }

    public static String getHexConstantValue(Object constantValue) {
        if (constantValue instanceof Character) {
            String constantResult = String.valueOf('\'') + constantValue.toString() + '\'';
            char charValue = ((Character)constantValue).charValue();
            String hexString = Integer.toHexString(charValue);
            StringBuffer hexResult = new StringBuffer("\\u");
            int i = hexString.length();
            while (i < 4) {
                hexResult.append('0');
                ++i;
            }
            hexResult.append(hexString);
            return JavadocHover.formatWithHexValue(constantResult, hexResult.toString());
        }
        if (constantValue instanceof Byte) {
            int byteValue = ((Byte)constantValue).intValue() & 0xFF;
            return JavadocHover.formatWithHexValue(constantValue, "0x" + Integer.toHexString(byteValue));
        }
        if (constantValue instanceof Short) {
            int shortValue = (Short)constantValue & 0xFFFF;
            return JavadocHover.formatWithHexValue(constantValue, "0x" + Integer.toHexString(shortValue));
        }
        if (constantValue instanceof Integer) {
            int intValue = (Integer)constantValue;
            return JavadocHover.formatWithHexValue(constantValue, "0x" + Integer.toHexString(intValue));
        }
        if (constantValue instanceof Long) {
            long longValue = (Long)constantValue;
            return JavadocHover.formatWithHexValue(constantValue, "0x" + Long.toHexString(longValue));
        }
        return constantValue.toString();
    }

    public static Object getVariableBindingConstValue(ASTNode node, IField field) {
        IVariableBinding variableBinding;
        IBinding binding;
        if (node != null && node.getNodeType() == 42 && (binding = ((SimpleName)node).resolveBinding()) != null && binding.getKind() == 3 && field.equals((variableBinding = (IVariableBinding)binding).getJavaElement())) {
            return variableBinding.getConstantValue();
        }
        return null;
    }

    private static final class BackAction
    extends Action {
        private final BrowserInformationControl fInfoControl;

        public BackAction(BrowserInformationControl infoControl) {
            this.fInfoControl = infoControl;
            this.setText(JavaHoverMessages.JavadocHover_back);
            ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
            this.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_BACK"));
            this.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_BACK_DISABLED"));
            this.update();
        }

        public void run() {
            BrowserInformationControlInput previous = (BrowserInformationControlInput)this.fInfoControl.getInput().getPrevious();
            if (previous != null) {
                this.fInfoControl.setInput((Object)previous);
            }
        }

        public void update() {
            BrowserInformationControlInput current = this.fInfoControl.getInput();
            if (current != null && current.getPrevious() != null) {
                BrowserInput previous = current.getPrevious();
                this.setToolTipText(Messages.format(JavaHoverMessages.JavadocHover_back_toElement_toolTip, BasicElementLabels.getJavaElementName((String)previous.getInputName())));
                this.setEnabled(true);
            } else {
                this.setToolTipText(JavaHoverMessages.JavadocHover_back);
                this.setEnabled(false);
            }
        }
    }

    public static class FallbackInformationPresenter
    extends HTMLTextPresenter {
        public FallbackInformationPresenter() {
            super(false);
        }

        public String updatePresentation(Drawable drawable, String hoverInfo, TextPresentation presentation, int maxWidth, int maxHeight) {
            String warningInfo = JavaHoverMessages.JavadocHover_fallback_warning;
            String warning = super.updatePresentation(drawable, warningInfo, presentation, maxWidth, maxHeight);
            presentation.clear();
            String content = super.updatePresentation(drawable, hoverInfo, presentation, maxWidth, maxHeight);
            return String.valueOf(content) + "\n\n" + warning;
        }
    }

    private static final class ForwardAction
    extends Action {
        private final BrowserInformationControl fInfoControl;

        public ForwardAction(BrowserInformationControl infoControl) {
            this.fInfoControl = infoControl;
            this.setText(JavaHoverMessages.JavadocHover_forward);
            ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
            this.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_FORWARD"));
            this.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_FORWARD_DISABLED"));
            this.update();
        }

        public void run() {
            BrowserInformationControlInput next = (BrowserInformationControlInput)this.fInfoControl.getInput().getNext();
            if (next != null) {
                this.fInfoControl.setInput((Object)next);
            }
        }

        public void update() {
            BrowserInformationControlInput current = this.fInfoControl.getInput();
            if (current != null && current.getNext() != null) {
                this.setToolTipText(Messages.format(JavaHoverMessages.JavadocHover_forward_toElement_toolTip, BasicElementLabels.getJavaElementName((String)current.getNext().getInputName())));
                this.setEnabled(true);
            } else {
                this.setToolTipText(JavaHoverMessages.JavadocHover_forward_toolTip);
                this.setEnabled(false);
            }
        }
    }

    public static final class HoverControlCreator
    extends AbstractReusableInformationControlCreator
    implements IPropertyChangeListener {
        private final IInformationControlCreator fInformationPresenterControlCreator;
        private final boolean fAdditionalInfoAffordance;
        private BrowserInformationControl iControl;

        public HoverControlCreator(IInformationControlCreator informationPresenterControlCreator) {
            this(informationPresenterControlCreator, false);
        }

        public HoverControlCreator(IInformationControlCreator informationPresenterControlCreator, boolean additionalInfoAffordance) {
            this.fInformationPresenterControlCreator = informationPresenterControlCreator;
            this.fAdditionalInfoAffordance = additionalInfoAffordance;
        }

        public IInformationControl doCreateInformationControl(Shell parent) {
            String tooltipAffordanceString;
            String string = tooltipAffordanceString = this.fAdditionalInfoAffordance ? JavaPlugin.getAdditionalInfoAffordanceString() : EditorsUI.getTooltipAffordanceString();
            if (BrowserInformationControl.isAvailable((Composite)parent)) {
                String font = "org.eclipse.jdt.ui.javadocfont";
                this.iControl = new BrowserInformationControl(parent, font, tooltipAffordanceString){

                    public IInformationControlCreator getInformationPresenterControlCreator() {
                        return fInformationPresenterControlCreator;
                    }
                };
                JFaceResources.getColorRegistry().addListener((IPropertyChangeListener)this);
                this.setHoverColors();
                JavadocHover.addLinkListener(this.iControl);
                return this.iControl;
            }
            return new DefaultInformationControl(parent, tooltipAffordanceString){

                public IInformationControlCreator getInformationPresenterControlCreator() {
                    return new IInformationControlCreator(){

                        public IInformationControl createInformationControl(Shell parentShell) {
                            return new DefaultInformationControl(parentShell, null, (DefaultInformationControl.IInformationPresenter)new FallbackInformationPresenter());
                        }
                    };
                }
            };
        }

        public void propertyChange(PropertyChangeEvent event) {
            String property = event.getProperty();
            if (this.iControl != null && (property.equals("org.eclipse.jdt.ui.Javadoc.foregroundColor") || property.equals("org.eclipse.jdt.ui.Javadoc.backgroundColor"))) {
                this.setHoverColors();
            }
        }

        private void setHoverColors() {
            ColorRegistry registry = JFaceResources.getColorRegistry();
            Color fgRGB = registry.get("org.eclipse.jdt.ui.Javadoc.foregroundColor");
            Color bgRGB = registry.get("org.eclipse.jdt.ui.Javadoc.backgroundColor");
            this.iControl.setForegroundColor(fgRGB);
            this.iControl.setBackgroundColor(bgRGB);
        }

        public void widgetDisposed(DisposeEvent e) {
            super.widgetDisposed(e);
            JFaceResources.getColorRegistry().removeListener((IPropertyChangeListener)this);
        }

        public boolean canReuse(IInformationControl control) {
            if (!super.canReuse(control)) {
                return false;
            }
            if (control instanceof IInformationControlExtension4) {
                String tooltipAffordanceString = this.fAdditionalInfoAffordance ? JavaPlugin.getAdditionalInfoAffordanceString() : EditorsUI.getTooltipAffordanceString();
                ((IInformationControlExtension4)control).setStatusText(tooltipAffordanceString);
            }
            return true;
        }
    }

    private static final class OpenDeclarationAction
    extends Action {
        private final BrowserInformationControl fInfoControl;

        public OpenDeclarationAction(BrowserInformationControl infoControl) {
            this.fInfoControl = infoControl;
            this.setText(JavaHoverMessages.JavadocHover_openDeclaration);
            JavaPluginImages.setLocalImageDescriptors((IAction)this, "goto_input.png");
        }

        public void run() {
            JavadocBrowserInformationControlInput infoInput = (JavadocBrowserInformationControlInput)this.fInfoControl.getInput();
            this.fInfoControl.notifyDelayedInputChange(null);
            this.fInfoControl.dispose();
            try {
                JavadocHover.openDeclaration(infoInput.getElement());
            }
            catch (PartInitException e) {
                JavaPlugin.log(e);
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        }
    }

    public static final class PresenterControlCreator
    extends AbstractReusableInformationControlCreator {
        private final IWorkbenchSite fSite;

        public PresenterControlCreator(IWorkbenchSite site) {
            this.fSite = site;
        }

        public IInformationControl doCreateInformationControl(Shell parent) {
            if (BrowserInformationControl.isAvailable((Composite)parent)) {
                ToolBarManager tbm = new ToolBarManager(0x800000);
                String font = "org.eclipse.jdt.ui.javadocfont";
                BrowserInformationControl iControl = new BrowserInformationControl(parent, font, tbm);
                final BackAction backAction = new BackAction(iControl);
                backAction.setEnabled(false);
                tbm.add((IAction)backAction);
                final ForwardAction forwardAction = new ForwardAction(iControl);
                tbm.add((IAction)forwardAction);
                forwardAction.setEnabled(false);
                final ShowInJavadocViewAction showInJavadocViewAction = new ShowInJavadocViewAction(iControl);
                tbm.add((IAction)showInJavadocViewAction);
                final OpenDeclarationAction openDeclarationAction = new OpenDeclarationAction(iControl);
                tbm.add((IAction)openDeclarationAction);
                final SimpleSelectionProvider selectionProvider = new SimpleSelectionProvider();
                if (this.fSite != null) {
                    OpenAttachedJavadocAction openAttachedJavadocAction = new OpenAttachedJavadocAction(this.fSite);
                    openAttachedJavadocAction.setSpecialSelectionProvider(selectionProvider);
                    openAttachedJavadocAction.setImageDescriptor(JavaPluginImages.DESC_ELCL_OPEN_BROWSER);
                    openAttachedJavadocAction.setDisabledImageDescriptor(JavaPluginImages.DESC_DLCL_OPEN_BROWSER);
                    selectionProvider.addSelectionChangedListener(openAttachedJavadocAction);
                    selectionProvider.setSelection((ISelection)new StructuredSelection());
                    tbm.add((IAction)openAttachedJavadocAction);
                }
                IInputChangedListener inputChangeListener = new IInputChangedListener(){

                    public void inputChanged(Object newInput) {
                        backAction.update();
                        forwardAction.update();
                        if (newInput == null) {
                            selectionProvider.setSelection((ISelection)new StructuredSelection());
                        } else if (newInput instanceof BrowserInformationControlInput) {
                            BrowserInformationControlInput input = (BrowserInformationControlInput)newInput;
                            Object inputElement = input.getInputElement();
                            selectionProvider.setSelection((ISelection)new StructuredSelection(inputElement));
                            boolean isJavaElementInput = inputElement instanceof IJavaElement;
                            showInJavadocViewAction.setEnabled(isJavaElementInput);
                            openDeclarationAction.setEnabled(isJavaElementInput);
                        }
                    }
                };
                iControl.addInputChangeListener(inputChangeListener);
                tbm.update(true);
                JavadocHover.addLinkListener(iControl);
                return iControl;
            }
            return new DefaultInformationControl(parent, true);
        }
    }

    private static final class ShowInJavadocViewAction
    extends Action {
        private final BrowserInformationControl fInfoControl;

        public ShowInJavadocViewAction(BrowserInformationControl infoControl) {
            this.fInfoControl = infoControl;
            this.setText(JavaHoverMessages.JavadocHover_showInJavadoc);
            this.setImageDescriptor(JavaPluginImages.DESC_OBJS_JAVADOCTAG);
        }

        public void run() {
            JavadocBrowserInformationControlInput infoInput = (JavadocBrowserInformationControlInput)this.fInfoControl.getInput();
            this.fInfoControl.notifyDelayedInputChange(null);
            this.fInfoControl.dispose();
            try {
                JavadocView view = (JavadocView)JavaPlugin.getActivePage().showView("org.eclipse.jdt.ui.JavadocView");
                view.setInput((BrowserInput)infoInput);
            }
            catch (PartInitException e) {
                JavaPlugin.log(e);
            }
        }
    }
}

