/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.CheckoutConflictException;
import org.eclipse.jgit.api.errors.RefAlreadyExistsException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.spi.RestOfArgumentsHandler;

@Command(common=true, usage="usage_checkout")
class Checkout
extends TextBuiltin {
    @Option(name="-b", usage="usage_createBranchAndCheckout")
    private boolean createBranch = false;
    @Option(name="--force", aliases={"-f"}, usage="usage_forceCheckout")
    private boolean force = false;
    @Option(name="--orphan", usage="usage_orphan")
    private boolean orphan = false;
    @Argument(required=false, index=0, metaVar="metaVar_name", usage="usage_checkout")
    private String name;
    @Option(name="--", metaVar="metaVar_paths", multiValued=true, handler=RestOfArgumentsHandler.class)
    private List<String> paths = new ArrayList<String>();

    Checkout() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void run() throws Exception {
        ObjectId head;
        if (this.createBranch && (head = this.db.resolve("HEAD")) == null) {
            throw Checkout.die(CLIText.get().onBranchToBeBorn);
        }
        Throwable throwable = null;
        try (Git git = new Git(this.db);){
            Ref ref;
            block33: {
                block34: {
                    String oldBranch;
                    block31: {
                        block32: {
                            CheckoutCommand command = git.checkout();
                            if (this.paths.size() > 0) {
                                command.setStartPoint(this.name);
                                if (this.paths.size() == 1 && this.paths.get(0).equals(".")) {
                                    command.setAllPaths(true);
                                } else {
                                    command.addPaths(this.paths);
                                }
                            } else {
                                command.setCreateBranch(this.createBranch);
                                command.setName(this.name);
                                command.setForce(this.force);
                                command.setOrphan(this.orphan);
                            }
                            oldBranch = this.db.getBranch();
                            ref = command.call();
                            if (ref != null) break block31;
                            if (git == null) return;
                            if (throwable == null) break block32;
                            try {
                                git.close();
                                return;
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                                return;
                            }
                        }
                        git.close();
                        return;
                    }
                    if (!Repository.shortenRefName((String)ref.getName()).equals(oldBranch)) break block33;
                    this.outw.println(MessageFormat.format(CLIText.get().alreadyOnBranch, this.name));
                    if (git == null) return;
                    if (throwable == null) break block34;
                    try {
                        git.close();
                        return;
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                        return;
                    }
                }
                git.close();
                return;
            }
            try {
                if (this.createBranch || this.orphan) {
                    this.outw.println(MessageFormat.format(CLIText.get().switchedToNewBranch, this.name));
                    return;
                }
                this.outw.println(MessageFormat.format(CLIText.get().switchedToBranch, Repository.shortenRefName((String)ref.getName())));
                return;
            }
            catch (RefNotFoundException e) {
                this.outw.println(MessageFormat.format(CLIText.get().pathspecDidNotMatch, this.name));
                return;
            }
            catch (RefAlreadyExistsException e) {
                throw Checkout.die(MessageFormat.format(CLIText.get().branchAlreadyExists, this.name));
            }
            catch (CheckoutConflictException e) {
                this.outw.println(CLIText.get().checkoutConflict);
                Iterator iterator = e.getConflictingPaths().iterator();
                while (iterator.hasNext()) {
                    String path = (String)iterator.next();
                    this.outw.println(MessageFormat.format(CLIText.get().checkoutConflictPathLine, path));
                }
                return;
            }
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        catch (Throwable throwable5) {
            throw throwable5;
        }
    }
}

