/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.eclipse.jgit.pgm.opt.CmdLineParser;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.Option;

@Command(usage="usage_RevParse")
class RevParse
extends TextBuiltin {
    @Option(name="--all", usage="usage_RevParseAll")
    boolean all;
    @Option(name="--verify", usage="usage_RevParseVerify")
    boolean verify;
    @Argument(index=0, metaVar="metaVar_commitish")
    private final List<ObjectId> commits = new ArrayList<ObjectId>();

    RevParse() {
    }

    @Override
    protected void run() throws Exception {
        if (this.all) {
            Map allRefs = this.db.getRefDatabase().getRefs("");
            for (Ref r : allRefs.values()) {
                ObjectId objectId = r.getObjectId();
                if (objectId == null) {
                    throw new NullPointerException();
                }
                this.outw.println(objectId.name());
            }
        } else {
            if (this.verify && this.commits.size() > 1) {
                CmdLineParser clp = new CmdLineParser(this);
                throw new CmdLineException((org.kohsuke.args4j.CmdLineParser)clp, CLIText.get().needSingleRevision);
            }
            for (ObjectId o : this.commits) {
                this.outw.println(o.name());
            }
        }
    }
}

