/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.iterable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.common.utility.closure.Closure;
import org.eclipse.jpt.common.utility.closure.InterruptibleClosure;
import org.eclipse.jpt.common.utility.exception.ExceptionHandler;
import org.eclipse.jpt.common.utility.internal.closure.DisabledClosure;
import org.eclipse.jpt.common.utility.internal.collection.HashBag;
import org.eclipse.jpt.common.utility.internal.collection.ListTools;
import org.eclipse.jpt.common.utility.internal.iterable.ArrayIterable;
import org.eclipse.jpt.common.utility.internal.iterable.ArrayListIterable;
import org.eclipse.jpt.common.utility.internal.iterable.ChainIterable;
import org.eclipse.jpt.common.utility.internal.iterable.CompositeIterable;
import org.eclipse.jpt.common.utility.internal.iterable.CompositeListIterable;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyListIterable;
import org.eclipse.jpt.common.utility.internal.iterable.FilteringIterable;
import org.eclipse.jpt.common.utility.internal.iterable.GraphIterable;
import org.eclipse.jpt.common.utility.internal.iterable.LateralIterableWrapper;
import org.eclipse.jpt.common.utility.internal.iterable.LateralListIterableWrapper;
import org.eclipse.jpt.common.utility.internal.iterable.ListListIterable;
import org.eclipse.jpt.common.utility.internal.iterable.LiveCloneIterable;
import org.eclipse.jpt.common.utility.internal.iterable.LiveCloneListIterable;
import org.eclipse.jpt.common.utility.internal.iterable.PeekableIterable;
import org.eclipse.jpt.common.utility.internal.iterable.QueueIterable;
import org.eclipse.jpt.common.utility.internal.iterable.ReadOnlyCompositeListIterable;
import org.eclipse.jpt.common.utility.internal.iterable.ReadOnlyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.ReadOnlyListIterable;
import org.eclipse.jpt.common.utility.internal.iterable.SimultaneousIterable;
import org.eclipse.jpt.common.utility.internal.iterable.SimultaneousListIterable;
import org.eclipse.jpt.common.utility.internal.iterable.SingleElementIterable;
import org.eclipse.jpt.common.utility.internal.iterable.SingleElementListIterable;
import org.eclipse.jpt.common.utility.internal.iterable.SnapshotCloneIterable;
import org.eclipse.jpt.common.utility.internal.iterable.SnapshotCloneListIterable;
import org.eclipse.jpt.common.utility.internal.iterable.StackIterable;
import org.eclipse.jpt.common.utility.internal.iterable.SubIterableWrapper;
import org.eclipse.jpt.common.utility.internal.iterable.SubListIterableWrapper;
import org.eclipse.jpt.common.utility.internal.iterable.SuperIterableWrapper;
import org.eclipse.jpt.common.utility.internal.iterable.SuperListIterableWrapper;
import org.eclipse.jpt.common.utility.internal.iterable.TransformationIterable;
import org.eclipse.jpt.common.utility.internal.iterable.TransformationListIterable;
import org.eclipse.jpt.common.utility.internal.iterable.TreeIterable;
import org.eclipse.jpt.common.utility.internal.iterator.CloneListIterator;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateTools;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.queue.Queue;
import org.eclipse.jpt.common.utility.stack.Stack;
import org.eclipse.jpt.common.utility.transformer.Transformer;

public final class IterableTools {
    public static final Transformer ITERATOR_TRANSFORMER = new IteratorTransformer();
    public static final Transformer READ_ONLY_LIST_ITERATOR_TRANSFORMER = new ReadOnlyListIteratorTransformer();

    public static <E> HashBag<E> bag(Iterable<? extends E> iterable) {
        return IteratorTools.bag(iterable.iterator());
    }

    public static <E> HashBag<E> bag(Iterable<? extends E> iterable, int iterableSize) {
        return IteratorTools.bag(iterable.iterator(), iterableSize);
    }

    public static <E> HashBag<E> hashBag(Iterable<? extends E> iterable) {
        return IteratorTools.hashBag(iterable.iterator());
    }

    public static <E> HashBag<E> hashBag(Iterable<? extends E> iterable, int iterableSize) {
        return IteratorTools.hashBag(iterable.iterator(), iterableSize);
    }

    public static boolean isOrContainsNull(Iterable<?> iterable) {
        return iterable == null || IterableTools.contains(iterable, null);
    }

    public static boolean containsNull(Iterable<?> iterable) {
        return IteratorTools.containsNull(iterable.iterator());
    }

    public static boolean contains(Iterable<?> iterable, Object value) {
        return IteratorTools.contains(iterable.iterator(), value);
    }

    public static int count(Iterable<?> iterable, Object value) {
        return IteratorTools.count(iterable.iterator(), value);
    }

    public static <E> int countFalse(Iterable<? extends E> iterable, Predicate<? super E> predicate) {
        return IteratorTools.countFalse(iterable.iterator(), predicate);
    }

    public static <E> int countTrue(Iterable<? extends E> iterable, Predicate<? super E> predicate) {
        return IteratorTools.countTrue(iterable.iterator(), predicate);
    }

    public static boolean containsAll(Iterable<?> iterable, Collection<?> collection) {
        return IteratorTools.containsAll(iterable.iterator(), collection);
    }

    public static boolean containsAll(Iterable<?> iterable, int iterableSize, Collection<?> collection) {
        return IteratorTools.containsAll(iterable.iterator(), iterableSize, collection);
    }

    public static boolean containsAll(Iterable<?> iterable1, Iterable<?> iterable2) {
        return IteratorTools.containsAll(iterable1.iterator(), iterable2);
    }

    public static boolean containsAll(Iterable<?> iterable1, int iterable1Size, Iterable<?> iterable2) {
        return IteratorTools.containsAll(iterable1.iterator(), iterable1Size, iterable2);
    }

    public static boolean containsAll(Iterable<?> iterable, Iterator<?> iterator) {
        return IteratorTools.containsAll(iterable.iterator(), iterator);
    }

    public static boolean containsAll(Iterable<?> iterable, int iterableSize, Iterator<?> iterator) {
        return IteratorTools.containsAll(iterable.iterator(), iterableSize, iterator);
    }

    public static boolean containsAll(Iterable<?> iterable, Object ... array) {
        return IteratorTools.containsAll(iterable.iterator(), array);
    }

    public static boolean containsAll(Iterable<?> iterable, int iterableSize, Object ... array) {
        return IteratorTools.containsAll(iterable.iterator(), iterableSize, array);
    }

    public static boolean elementsAreDifferent(Iterable<?> iterable1, Iterable<?> iterable2) {
        return IteratorTools.elementsAreDifferent(iterable1.iterator(), iterable2.iterator());
    }

    public static boolean elementsAreEqual(Iterable<?> iterable1, Iterable<?> iterable2) {
        return IteratorTools.elementsAreEqual(iterable1.iterator(), iterable2.iterator());
    }

    public static boolean elementsAreIdentical(Iterable<?> iterable1, Iterable<?> iterable2) {
        return IteratorTools.elementsAreIdentical(iterable1.iterator(), iterable2.iterator());
    }

    public static boolean elementsAreNotIdentical(Iterable<?> iterable1, Iterable<?> iterable2) {
        return IteratorTools.elementsAreNotIdentical(iterable1.iterator(), iterable2.iterator());
    }

    public static <E> void execute(Iterable<? extends E> iterable, Closure<E> closure) {
        IteratorTools.execute(iterable.iterator(), closure);
    }

    public static <E> void execute(Iterable<? extends E> iterable, Closure<E> closure, ExceptionHandler exceptionHandler) {
        IteratorTools.execute(iterable.iterator(), closure, exceptionHandler);
    }

    public static <E> void execute(Iterable<? extends E> iterable, InterruptibleClosure<E> closure) throws InterruptedException {
        IteratorTools.execute(iterable.iterator(), closure);
    }

    public static <E> void execute(Iterable<? extends E> iterable, InterruptibleClosure<E> closure, ExceptionHandler exceptionHandler) throws InterruptedException {
        IteratorTools.execute(iterable.iterator(), closure, exceptionHandler);
    }

    public static <E> E first(Iterable<E> iterable) {
        return IteratorTools.first(iterable.iterator());
    }

    public static <E> E get(Iterable<? extends E> iterable, int index) {
        return IteratorTools.get(iterable.iterator(), index);
    }

    public static int hashCode(Iterable<?> iterable) {
        return iterable == null ? 0 : IteratorTools.hashCode(iterable.iterator());
    }

    public static int indexOf(Iterable<?> iterable, Object value) {
        return IteratorTools.indexOf(iterable.iterator(), value);
    }

    public static int indexOf(Iterable<?> iterable, Object value, int startIndex) {
        return IteratorTools.indexOf(iterable.iterator(), value, startIndex);
    }

    public static boolean isEmpty(Iterable<?> iterable) {
        return IteratorTools.isEmpty(iterable.iterator());
    }

    public static boolean isNotEmpty(Iterable<?> iterable) {
        return IteratorTools.isNotEmpty(iterable.iterator());
    }

    public static <E> E last(Iterable<E> iterable) {
        return IteratorTools.last(iterable.iterator());
    }

    public static int lastIndexOf(Iterable<?> iterable, Object value) {
        return IteratorTools.lastIndexOf(iterable.iterator(), value);
    }

    public static int lastIndexOf(Iterable<?> iterable, Object value, int startIndex) {
        return IteratorTools.lastIndexOf(iterable.iterator(), value, startIndex);
    }

    public static <E> ArrayList<E> list(Iterable<? extends E> iterable) {
        return IteratorTools.list(iterable.iterator());
    }

    public static <E> ArrayList<E> list(Iterable<? extends E> iterable, int iterableSize) {
        return IteratorTools.list(iterable.iterator(), iterableSize);
    }

    public static int size(Iterable<?> iterable) {
        return IteratorTools.size(iterable.iterator());
    }

    public static <E extends Comparable<? super E>> Iterable<E> sort(Iterable<? extends E> iterable) {
        return IterableTools.sort(iterable, null);
    }

    public static <E extends Comparable<? super E>> Iterable<E> sort(Iterable<? extends E> iterable, int iterableSize) {
        return IterableTools.sort(iterable, null, iterableSize);
    }

    public static <E> Iterable<E> sort(Iterable<? extends E> iterable, Comparator<? super E> comparator) {
        Iterator<E> iterator = iterable.iterator();
        if (iterator.hasNext()) {
            return ListTools.sort(ListTools.arrayList(iterator), comparator);
        }
        return IterableTools.emptyIterable();
    }

    public static <E> Iterable<E> sort(Iterable<? extends E> iterable, Comparator<? super E> comparator, int iterableSize) {
        Iterator<E> iterator = iterable.iterator();
        if (iterator.hasNext()) {
            return ListTools.sort(ListTools.arrayList(iterator, iterableSize), comparator);
        }
        return IterableTools.emptyIterable();
    }

    public static Object[] toArray(Iterable<?> iterable) {
        return IteratorTools.toArray(iterable.iterator());
    }

    public static Object[] toArray(Iterable<?> iterable, int iterableSize) {
        return IteratorTools.toArray(iterable.iterator(), iterableSize);
    }

    public static <E> E[] toArray(Iterable<? extends E> iterable, E[] array) {
        return IteratorTools.toArray(iterable.iterator(), array);
    }

    public static <E> E[] toArray(Iterable<? extends E> iterable, int iterableSize, E[] array) {
        return IteratorTools.toArray(iterable.iterator(), iterableSize, array);
    }

    @SafeVarargs
    public static <E, I extends Iterable<? extends E>> Iterable<List<E>> align(I ... iterables) {
        int len = iterables.length;
        if (len == 0) {
            return IterableTools.emptyIterable();
        }
        return IterableTools.align(IterableTools.iterable(iterables), len);
    }

    public static <E, I extends Iterable<? extends E>> Iterable<List<E>> align(Iterable<I> iterables) {
        return IterableTools.align(iterables, -1);
    }

    public static <E, I extends Iterable<? extends E>> Iterable<List<E>> align(Iterable<I> iterables, int iterablesSize) {
        return new SimultaneousIterable(iterables, iterablesSize);
    }

    @SafeVarargs
    public static <E, I extends ListIterable<E>> ListIterable<List<E>> alignList(I ... iterables) {
        int len = iterables.length;
        if (len == 0) {
            return IterableTools.emptyListIterable();
        }
        return IterableTools.alignList(IterableTools.iterable(iterables), len);
    }

    public static <E, I extends ListIterable<E>> ListIterable<List<E>> alignList(Iterable<I> iterables) {
        return IterableTools.alignList(iterables, -1);
    }

    public static <E, I extends ListIterable<E>> ListIterable<List<E>> alignList(Iterable<I> iterables, int iterablesSize) {
        return new SimultaneousListIterable(iterables, iterablesSize);
    }

    public static <E1, E2> Iterable<E2> cast(Iterable<E1> iterable) {
        return new LateralIterableWrapper(iterable);
    }

    public static <E1, E2> ListIterable<E2> cast(ListIterable<E1> iterable) {
        return new LateralListIterableWrapper(iterable);
    }

    public static <E1, E2 extends E1> Iterable<E2> downCast(Iterable<E1> iterable) {
        return new SubIterableWrapper(iterable);
    }

    public static <E1, E2 extends E1> ListIterable<E2> downCast(ListIterable<E1> iterable) {
        return new SubListIterableWrapper(iterable);
    }

    public static <E> Iterable<E> upCast(Iterable<? extends E> iterable) {
        return new SuperIterableWrapper<E>(iterable);
    }

    public static <E> ListIterable<E> upCast(ListIterable<? extends E> iterable) {
        return new SuperListIterableWrapper<E>(iterable);
    }

    public static <E> Iterable<E> chainIterable(E first, Transformer<? super E, ? extends E> transformer) {
        if (first == null) {
            return IterableTools.emptyIterable();
        }
        return new ChainIterable<E>(first, transformer);
    }

    public static <E> Iterable<E> cloneLive(Collection<? extends E> collection) {
        return IterableTools.cloneLive(collection, DisabledClosure.instance());
    }

    public static <E> Iterable<E> cloneLive(Collection<? extends E> collection, Closure<? super E> removeClosure) {
        return new LiveCloneIterable<E>(collection, removeClosure);
    }

    public static <E> ListIterable<E> cloneLive(List<? extends E> list) {
        return IterableTools.cloneLive(list, CloneListIterator.Adapter.ReadOnly.instance());
    }

    public static <E> ListIterable<E> cloneLive(List<? extends E> list, CloneListIterator.Adapter<E> adapter) {
        return new LiveCloneListIterable<E>(list, adapter);
    }

    public static <E> Iterable<E> cloneSnapshot(Collection<? extends E> collection) {
        return IterableTools.cloneSnapshot(collection, DisabledClosure.instance());
    }

    public static <E> Iterable<E> cloneSnapshot(Collection<? extends E> collection, Closure<? super E> removeClosure) {
        if (collection.isEmpty()) {
            return IterableTools.emptyIterable();
        }
        return new SnapshotCloneIterable<E>(collection, removeClosure);
    }

    public static <E> ListIterable<E> cloneSnapshot(List<? extends E> list) {
        return IterableTools.cloneSnapshot(list, CloneListIterator.Adapter.ReadOnly.instance());
    }

    public static <E> ListIterable<E> cloneSnapshot(List<? extends E> list, CloneListIterator.Adapter<E> adapter) {
        if (list.isEmpty()) {
            return IterableTools.emptyListIterable();
        }
        return new SnapshotCloneListIterable<E>(list, adapter);
    }

    public static <E> Iterable<E> add(Iterable<? extends E> iterable, E object) {
        return IterableTools.concatenate_(iterable, IterableTools.singletonIterable(object));
    }

    public static <E> Iterable<E> insert(E object, Iterable<? extends E> iterable) {
        return IterableTools.concatenate_(IterableTools.singletonIterable(object), iterable);
    }

    public static <E> Iterable<E> concatenate(Iterable<? extends E> ... iterables) {
        int len = iterables.length;
        if (len == 0) {
            return IterableTools.emptyIterable();
        }
        if (len == 1) {
            return iterables[0];
        }
        return IterableTools.concatenate_(iterables);
    }

    @SafeVarargs
    private static <E> Iterable<E> concatenate_(Iterable<? extends E> ... iterables) {
        return IterableTools.concatenate(Arrays.asList(iterables));
    }

    public static <E> Iterable<E> concatenate(Iterable<? extends Iterable<? extends E>> iterables) {
        return new CompositeIterable(iterables);
    }

    public static <P, E> Iterable<E> children(Iterable<? extends P> parents, Transformer<? super P, ? extends Iterable<? extends E>> childrenTransformer) {
        return IterableTools.concatenate(IterableTools.transform(parents, childrenTransformer));
    }

    public static <E> ListIterable<E> add(ListIterable<E> iterable, E object) {
        return IterableTools.concatenate_(iterable, IterableTools.singletonListIterable(object));
    }

    public static <E> ListIterable<E> insert(E object, ListIterable<E> iterable) {
        return IterableTools.concatenate_(IterableTools.singletonListIterable(object), iterable);
    }

    @SafeVarargs
    public static <E> ListIterable<E> concatenate(ListIterable<E> ... iterables) {
        int len = iterables.length;
        if (len == 0) {
            return IterableTools.emptyListIterable();
        }
        if (len == 1) {
            return iterables[0];
        }
        return IterableTools.concatenate_(iterables);
    }

    @SafeVarargs
    private static <E> ListIterable<E> concatenate_(ListIterable<E> ... iterables) {
        return IterableTools.concatenate(IterableTools.listIterable(iterables));
    }

    public static <E> ListIterable<E> concatenate(ListIterable<? extends ListIterable<E>> iterables) {
        return new CompositeListIterable(iterables);
    }

    public static <P, E> ListIterable<E> children(ListIterable<? extends P> parents, Transformer<? super P, ? extends ListIterable<E>> childrenTransformer) {
        return IterableTools.concatenate(IterableTools.transform(parents, childrenTransformer));
    }

    public static <E> ListIterable<E> addReadOnly(ListIterable<? extends E> iterable, E object) {
        return IterableTools.concatenateReadOnly_(iterable, IterableTools.singletonListIterable(object));
    }

    public static <E> ListIterable<E> insertReadOnly(E object, ListIterable<? extends E> iterable) {
        return IterableTools.concatenateReadOnly_(IterableTools.singletonListIterable(object), iterable);
    }

    public static <E> ListIterable<E> concatenateReadOnly(ListIterable<? extends E> ... iterables) {
        int len = iterables.length;
        if (len == 0) {
            return IterableTools.emptyListIterable();
        }
        if (len == 1) {
            return iterables[0];
        }
        return IterableTools.concatenateReadOnly_(iterables);
    }

    @SafeVarargs
    private static <E> ListIterable<E> concatenateReadOnly_(ListIterable<? extends E> ... iterables) {
        return IterableTools.concatenateReadOnly(IterableTools.listIterable(iterables));
    }

    public static <E> ListIterable<E> concatenateReadOnly(ListIterable<? extends ListIterable<? extends E>> iterables) {
        return new ReadOnlyCompositeListIterable(iterables);
    }

    public static <P, E> ListIterable<E> readOnlyChildren(ListIterable<? extends P> parents, Transformer<? super P, ? extends ListIterable<? extends E>> childrenTransformer) {
        return IterableTools.concatenateReadOnly(IterableTools.transform(parents, childrenTransformer));
    }

    public static <E> Iterable<E> emptyIterable() {
        return EmptyIterable.instance();
    }

    public static <E> ListIterable<E> emptyListIterable() {
        return EmptyListIterable.instance();
    }

    public static <E> Iterable<E> filter(Iterable<? extends E> iterable, Predicate<? super E> predicate) {
        return new FilteringIterable<E>(iterable, predicate);
    }

    public static <E> Iterable<E> removeNulls(Iterable<? extends E> iterable) {
        return IterableTools.filter(iterable, PredicateTools.isNotNull());
    }

    public static <E> Iterable<E> graphIterable(E root, Transformer<? super E, ? extends Iterable<? extends E>> transformer) {
        return IterableTools.graphIterable(IterableTools.singletonIterable(root), transformer);
    }

    public static <E> Iterable<E> graphIterable(E[] roots, Transformer<? super E, ? extends Iterable<? extends E>> transformer) {
        if (roots.length == 0) {
            return IterableTools.emptyIterable();
        }
        return IterableTools.graphIterable(Arrays.asList(roots), transformer);
    }

    public static <E> Iterable<E> graphIterable(Iterable<? extends E> roots, Transformer<? super E, ? extends Iterable<? extends E>> transformer) {
        return new GraphIterable<E>(roots, transformer);
    }

    @SafeVarargs
    public static <E> Iterable<E> iterable(E ... array) {
        return IterableTools.iterable(array, 0);
    }

    public static <E> Iterable<E> iterable(E[] array, int start) {
        return IterableTools.iterable(array, start, array.length);
    }

    public static <E> Iterable<E> iterable(E[] array, int start, int end) {
        if (start == end) {
            return IterableTools.emptyIterable();
        }
        return new ArrayIterable<E>(array, start, end);
    }

    public static <E> Iterable<E> iterable(Queue<? extends E> queue) {
        return new QueueIterable<E>(queue);
    }

    public static <E> Iterable<E> iterable(Stack<? extends E> stack) {
        return new StackIterable<E>(stack);
    }

    @SafeVarargs
    public static <E> ListIterable<E> listIterable(E ... array) {
        return IterableTools.listIterable(array, 0);
    }

    public static <E> ListIterable<E> listIterable(E[] array, int start) {
        return IterableTools.listIterable(array, start, array.length);
    }

    public static <E> ListIterable<E> listIterable(E[] array, int start, int end) {
        if (start == end) {
            return IterableTools.emptyListIterable();
        }
        return new ArrayListIterable<E>(array, start, end);
    }

    public static <E> ListIterable<E> listIterable(List<E> list) {
        return new ListListIterable<E>(list);
    }

    public static <E> PeekableIterable<E> peekable(Iterable<? extends E> iterable) {
        return new PeekableIterable<E>(iterable);
    }

    public static <E> Iterable<E> readOnly(Iterable<? extends E> iterable) {
        return new ReadOnlyIterable<E>(iterable);
    }

    public static <E> ListIterable<E> readOnly(ListIterable<? extends E> iterable) {
        return new ReadOnlyListIterable<E>(iterable);
    }

    public static <E> Iterable<E> singletonIterable(E value) {
        return new SingleElementIterable<E>(value);
    }

    public static <E> ListIterable<E> singletonListIterable(E value) {
        return new SingleElementListIterable<E>(value);
    }

    public static <E1, E2> Iterable<E2> transform(Iterable<? extends E1> iterable, Transformer<? super E1, ? extends E2> transformer) {
        return new TransformationIterable<E1, E2>(iterable, transformer);
    }

    public static <E1, E2, T extends E1> ListIterable<E2> transform(ListIterable<T> iterable, Transformer<? super E1, ? extends E2> transformer) {
        return new TransformationListIterable<E1, E2>(iterable, transformer);
    }

    public static <E> Iterable<E> treeIterable(E root, Transformer<? super E, ? extends Iterable<? extends E>> transformer) {
        return IterableTools.treeIterable(IterableTools.singletonIterable(root), transformer);
    }

    public static <E> Iterable<E> treeIterable(E[] roots, Transformer<? super E, ? extends Iterable<? extends E>> transformer) {
        if (roots.length == 0) {
            return IterableTools.emptyIterable();
        }
        return IterableTools.treeIterable(IterableTools.iterable(roots), transformer);
    }

    public static <E> Iterable<E> treeIterable(Iterable<? extends E> roots, Transformer<? super E, ? extends Iterable<? extends E>> transformer) {
        return new TreeIterable<E>(roots, transformer);
    }

    public static <E> Transformer<Iterable<? extends E>, Iterator<E>> iteratorTransformer() {
        return ITERATOR_TRANSFORMER;
    }

    public static <E> Transformer<ListIterable<E>, ListIterator<E>> listIteratorTransformer() {
        return ListIterable.TRANSFORMER;
    }

    public static <E> Transformer<ListIterable<? extends E>, ListIterator<? extends E>> readOnlyListIteratorTransformer() {
        return READ_ONLY_LIST_ITERATOR_TRANSFORMER;
    }

    private IterableTools() {
        throw new UnsupportedOperationException();
    }

    public static class IteratorTransformer<E>
    implements Transformer<Iterable<? extends E>, Iterator<E>> {
        @Override
        public Iterator<E> transform(Iterable<? extends E> iterable) {
            return iterable.iterator();
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    public static class ReadOnlyListIteratorTransformer<E>
    implements Transformer<ListIterable<? extends E>, ListIterator<? extends E>> {
        @Override
        public ListIterator<? extends E> transform(ListIterable<? extends E> iterable) {
            return IteratorTools.readOnly(iterable.iterator());
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }
}

