/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.jpql.spi;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.jpql.spi.IJpaType;
import org.eclipse.jpt.jpa.core.jpql.spi.JavaType;
import org.eclipse.jpt.jpa.core.jpql.spi.JpaType;
import org.eclipse.jpt.jpa.core.jpql.spi.JpaTypeDeclaration;
import org.eclipse.jpt.jpa.core.jpql.spi.SimpleType;
import org.eclipse.persistence.jpa.jpql.tools.TypeHelper;
import org.eclipse.persistence.jpa.jpql.tools.spi.ITypeDeclaration;
import org.eclipse.persistence.jpa.jpql.tools.spi.ITypeRepository;

public class JpaTypeRepository
implements ITypeRepository {
    private final IJavaProject javaProject;
    private Map<String, Class<?>> primitives;
    private TypeHelper typeHelper;
    private final Map<String, IJpaType> types;
    private IJpaType unresolvableType;

    public JpaTypeRepository(IJavaProject javaProject) {
        this.javaProject = javaProject;
        this.types = new HashMap<String, IJpaType>();
    }

    protected String buildInnerTypeName(String typeName, int index) {
        StringBuilder sb = new StringBuilder();
        sb.append(typeName.substring(0, index));
        sb.append("$");
        sb.append(typeName.substring(index + 1, typeName.length()));
        return sb.toString();
    }

    protected Map<String, Class<?>> buildPrimitives() {
        HashMap primitives = new HashMap();
        primitives.put(Byte.TYPE.getName(), Byte.TYPE);
        primitives.put(Short.TYPE.getName(), Short.TYPE);
        primitives.put(Character.TYPE.getName(), Character.TYPE);
        primitives.put(Integer.TYPE.getName(), Integer.TYPE);
        primitives.put(Long.TYPE.getName(), Long.TYPE);
        primitives.put(Float.TYPE.getName(), Float.TYPE);
        primitives.put(Double.TYPE.getName(), Double.TYPE);
        primitives.put(Boolean.TYPE.getName(), Boolean.TYPE);
        return primitives;
    }

    protected IJpaType buildType(Class<?> javaType) {
        JavaType jpaType = new JavaType(this, javaType);
        this.types.put(jpaType.getName(), jpaType);
        return jpaType;
    }

    protected IJpaType buildType(IType type) {
        JpaType jpaType = new JpaType(this, type);
        this.types.put(jpaType.getName(), jpaType);
        return jpaType;
    }

    protected IJpaType buildType(String typeName) {
        SimpleType jpaType = new SimpleType(this, typeName);
        this.types.put(typeName, jpaType);
        return jpaType;
    }

    protected String convertToJavaArrayType(String typeName) {
        int index = typeName.indexOf("[]");
        int dimensionality = typeName.length() - index >> 1;
        StringBuilder sb = new StringBuilder();
        while (dimensionality-- > 0) {
            sb.append("[");
        }
        String type = typeName.substring(0, index);
        Class<?> primitive = this.primitives.get(type);
        if (primitive != null) {
            if (primitive == Byte.TYPE) {
                sb.append("B");
            } else if (primitive == Character.TYPE) {
                sb.append("C");
            } else if (primitive == Short.TYPE) {
                sb.append("S");
            } else if (primitive == Integer.TYPE) {
                sb.append("I");
            } else if (primitive == Long.TYPE) {
                sb.append("L");
            } else if (primitive == Float.TYPE) {
                sb.append("F");
            } else if (primitive == Double.TYPE) {
                sb.append("D");
            } else if (primitive == Boolean.TYPE) {
                sb.append("Z");
            }
        } else {
            sb.append(type);
            sb.append(";");
        }
        return sb.toString();
    }

    protected Class<?> findPrimitive(String typeName) {
        if (this.primitives == null) {
            this.primitives = this.buildPrimitives();
        }
        return this.primitives.get(typeName);
    }

    protected IType findType(String typeName) {
        try {
            return this.javaProject.findType(typeName);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public IJpaType getEnumType(String enumTypeName) {
        if (StringTools.isBlank((String)enumTypeName)) {
            return null;
        }
        int lastDotIndex = enumTypeName.lastIndexOf(".");
        if (lastDotIndex == -1) {
            return null;
        }
        String typeName = enumTypeName.substring(0, lastDotIndex);
        IType type = this.findType(typeName);
        IJpaType jpaType = type != null ? this.buildType(type) : this.loadInnerType(typeName);
        return jpaType != null && jpaType.isEnum() ? jpaType : null;
    }

    protected IJavaProject getJavaProject() {
        return this.javaProject;
    }

    public IJpaType getType(Class<?> javaClass) {
        IJpaType type = this.types.get(javaClass.getName());
        if (type == null) {
            type = this.buildType(javaClass);
        }
        return type;
    }

    protected IType getType(IResource resource) {
        try {
            return (IType)this.javaProject.findElement((IPath)resource);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public IJpaType getType(String typeName) {
        if (StringTools.isBlank((String)typeName) || "UNRESOLVABLE_TYPE" == typeName) {
            return this.unresolvableType();
        }
        if (typeName.endsWith("[]")) {
            return this.loadArrayType(typeName);
        }
        if (typeName.charAt(0) == '[') {
            return this.loadJavaArrayType(typeName);
        }
        return this.loadTypeImp(typeName);
    }

    public TypeHelper getTypeHelper() {
        if (this.typeHelper == null) {
            this.typeHelper = new TypeHelper((ITypeRepository)this);
        }
        return this.typeHelper;
    }

    protected IJpaType loadArrayType(String typeName) {
        IJpaType type = this.types.get(typeName);
        if (type == null) {
            try {
                String javaTypeName = this.convertToJavaArrayType(typeName);
                type = this.buildType(Class.forName(javaTypeName));
            }
            catch (Exception exception) {
                int index = typeName.indexOf("[]");
                int dimensionality = typeName.length() - index >> 1;
                type = this.getType(typeName.substring(0, index));
                type.setTypeDeclaration(new JpaTypeDeclaration(type, new ITypeDeclaration[0], dimensionality));
            }
            this.types.put(typeName, type);
        }
        return type;
    }

    protected IJpaType loadInnerType(String typeName) {
        IType type;
        do {
            int index;
            if ((index = typeName.lastIndexOf(".")) == -1) {
                return null;
            }
            IJpaType cachedType = this.types.get(typeName = this.buildInnerTypeName(typeName, index));
            if (cachedType == null) continue;
            return cachedType;
        } while ((type = this.findType(typeName)) == null);
        return this.buildType(type);
    }

    protected IJpaType loadJavaArrayType(String typeName) {
        IJpaType type = this.types.get(typeName);
        if (type == null) {
            try {
                type = this.buildType(Class.forName(typeName));
            }
            catch (Exception exception) {
                int index = typeName.lastIndexOf("[");
                int dimensionality = index >> 1;
                type = this.getType(typeName.substring(index, typeName.endsWith(";") ? typeName.length() - 1 : typeName.length()));
                type.setTypeDeclaration(new JpaTypeDeclaration(type, new ITypeDeclaration[0], dimensionality));
            }
            this.types.put(typeName, type);
        }
        return type;
    }

    protected IJpaType loadTypeImp(String typeName) {
        IJpaType type = this.types.get(typeName);
        if (type != null) {
            return type;
        }
        Class<?> primitive = this.findPrimitive(typeName);
        if (primitive != null) {
            return this.buildType(primitive);
        }
        IType iType = this.findType(typeName);
        if (iType != null) {
            return this.buildType(iType);
        }
        type = this.loadInnerType(typeName);
        if (type == null) {
            type = this.buildType(typeName);
        }
        return type;
    }

    protected IJpaType unresolvableType() {
        if (this.unresolvableType == null) {
            this.unresolvableType = new SimpleType(this, "UNRESOLVABLE_TYPE");
        }
        return this.unresolvableType;
    }
}

