/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.tools.internal.xml.businessmodell;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.eclipse.jubula.tools.internal.xml.businessmodell.InvalidParam;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Param;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Action {
    private static Logger log = LoggerFactory.getLogger(Action.class);
    private List<Param> m_params = new ArrayList<Param>();
    private String m_name;
    private String m_method;
    private String m_descriptionKey;
    private String m_postExecutionCommand;
    private boolean m_deprecated = false;
    private boolean m_clientAction = false;
    private boolean m_apiAction = false;
    private String m_since;

    public List<Param> getParams() {
        return this.m_params;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public int getParamsSize() {
        return this.m_params != null ? this.m_params.size() : 0;
    }

    public String toString() {
        if (this.getParamsSize() == 0) {
            return new ToStringBuilder((Object)this).append("Name", (Object)this.m_name).append("Method", (Object)this.m_method).toString();
        }
        return new ToStringBuilder((Object)this).append("Name", (Object)this.m_name).append("Method", (Object)this.m_method).append("Params", this.m_params.toArray()).toString();
    }

    public boolean equals(Object object) {
        if (object instanceof Action) {
            Action theOther = (Action)object;
            return new EqualsBuilder().append((Object)this.m_name, (Object)theOther.m_name).append((Object)this.m_method, (Object)theOther.m_method).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.m_name).append((Object)this.m_method).toHashCode();
    }

    public Param findParam(String name) {
        Validate.notNull((Object)name);
        List<Param> list = this.getParams();
        for (Param param : list) {
            if (!name.equals(param.getName())) continue;
            return param;
        }
        String message = "Param " + name + " does not exist";
        log.error(message);
        return new InvalidParam();
    }

    public String[] getParamNames() {
        int count = 0;
        String[] names = new String[this.getParamsSize()];
        List<Param> params = this.getParams();
        if (params != null) {
            for (Param param : params) {
                names[count] = param.getName();
                ++count;
            }
            return names;
        }
        return null;
    }

    public String getMethod() {
        return this.m_method;
    }

    public void setMethod(String method) {
        this.m_method = method;
    }

    public boolean isDeprecated() {
        return this.m_deprecated;
    }

    public void setDeprecated(boolean deprecated) {
        this.m_deprecated = deprecated;
    }

    public String getPostExecutionCommand() {
        return this.m_postExecutionCommand;
    }

    public void setPostExecutionCommand(String postExecutionCommand) {
        this.m_postExecutionCommand = postExecutionCommand;
    }

    public boolean isClientAction() {
        return this.m_clientAction;
    }

    public void setClientAction(boolean clientAction) {
        this.m_clientAction = clientAction;
    }

    public boolean isApiAction() {
        return this.m_apiAction;
    }

    public void setApiAction(boolean apiAction) {
        this.m_apiAction = apiAction;
    }

    public boolean isITEInvolved() {
        return this.isClientAction() || !StringUtils.isEmpty((String)this.getPostExecutionCommand());
    }

    public String getDescriptionKey() {
        return this.m_descriptionKey;
    }

    public void setDescriptionKey(String descriptionKey) {
        this.m_descriptionKey = descriptionKey;
    }

    public String getSince() {
        return this.m_since;
    }

    public void setSince(String since) {
        this.m_since = since;
    }
}

