/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.parts.processes.policies;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.jwt.meta.commands.processes.CreateActivityEdgeCommand;
import org.eclipse.jwt.meta.commands.processes.ReconnectActivityEdgeCommand;
import org.eclipse.jwt.meta.model.processes.ActivityEdge;
import org.eclipse.jwt.meta.model.processes.ActivityNode;
import org.eclipse.jwt.meta.model.processes.Scope;
import org.eclipse.jwt.we.commands.gefEmfAdapter.EmfToGefCommandAdapter;

public class ActivityNodeGraphicalNodeEditPolicy
extends GraphicalNodeEditPolicy {
    private int maximumInEdges = Integer.MAX_VALUE;
    private int maximumOutEdges = Integer.MAX_VALUE;

    public ActivityNodeGraphicalNodeEditPolicy() {
    }

    public ActivityNodeGraphicalNodeEditPolicy(int maximumInEdges, int maximumOutEdges) {
        this.maximumOutEdges = maximumOutEdges;
        this.maximumInEdges = maximumInEdges;
    }

    public int getMaximumInActivityEdges() {
        return this.maximumInEdges;
    }

    public void setMaximumInActivityEdges(int maximumInNodes) {
        this.maximumInEdges = maximumInNodes;
    }

    public int getMaximumOutActivityEdges() {
        return this.maximumOutEdges;
    }

    public void setMaximumOutActivityEdges(int maximumOutNodes) {
        this.maximumOutEdges = maximumOutNodes;
    }

    protected org.eclipse.gef.commands.Command getConnectionCreateCommand(CreateConnectionRequest request) {
        Object source = this.getHost().getModel();
        Object parent = this.getHost().getParent().getModel();
        Object type = request.getNewObjectType();
        EditingDomain editingDomain = (EditingDomain)this.getHost().getAdapter(EditingDomain.class);
        if (source instanceof ActivityNode && parent instanceof Scope && type != null && type instanceof Class && ActivityEdge.class.isAssignableFrom((Class)type) && editingDomain != null) {
            CreateActivityEdgeCommand connectCommand = new CreateActivityEdgeCommand(editingDomain);
            connectCommand.setSource((ActivityNode)source);
            connectCommand.setMaximumOutEdges(this.maximumOutEdges);
            EmfToGefCommandAdapter connectCommandEMF = null;
            if (connectCommand.checkMaxInOutConnections()) {
                connectCommandEMF = new EmfToGefCommandAdapter((Command)connectCommand);
            }
            request.setStartCommand(connectCommandEMF);
            return connectCommandEMF;
        }
        return null;
    }

    protected org.eclipse.gef.commands.Command getConnectionCompleteCommand(CreateConnectionRequest request) {
        org.eclipse.gef.commands.Command command = request.getStartCommand();
        Object target = this.getHost().getModel();
        if (command instanceof EmfToGefCommandAdapter && ((EmfToGefCommandAdapter)command).getEmfCommand() instanceof CreateActivityEdgeCommand && target instanceof ActivityNode) {
            CreateActivityEdgeCommand connectCommand = (CreateActivityEdgeCommand)((EmfToGefCommandAdapter)command).getEmfCommand();
            connectCommand.setTarget((ActivityNode)target);
            connectCommand.setMaximumInEdges(this.maximumInEdges);
            return command;
        }
        return null;
    }

    protected org.eclipse.gef.commands.Command getReconnectSourceCommand(ReconnectRequest request) {
        Object edge = request.getConnectionEditPart().getModel();
        Object newSource = this.getHost().getModel();
        Object parent = this.getHost().getParent().getModel();
        EditingDomain editingDomain = (EditingDomain)this.getHost().getAdapter(EditingDomain.class);
        if (edge instanceof ActivityEdge && newSource instanceof ActivityNode && parent instanceof Scope && editingDomain != null) {
            ReconnectActivityEdgeCommand command = new ReconnectActivityEdgeCommand(editingDomain, (ActivityEdge)edge);
            command.setNewSource((ActivityNode)newSource);
            command.setMaximumOutEdges(this.maximumOutEdges);
            return new EmfToGefCommandAdapter((Command)command);
        }
        return null;
    }

    protected org.eclipse.gef.commands.Command getReconnectTargetCommand(ReconnectRequest request) {
        Object edge = request.getConnectionEditPart().getModel();
        Object newTarget = this.getHost().getModel();
        Object parent = this.getHost().getParent().getModel();
        EditingDomain editingDomain = (EditingDomain)this.getHost().getAdapter(EditingDomain.class);
        if (edge instanceof ActivityEdge && newTarget instanceof ActivityNode && parent instanceof Scope && editingDomain != null) {
            ReconnectActivityEdgeCommand command = new ReconnectActivityEdgeCommand(editingDomain, (ActivityEdge)edge);
            command.setNewTarget((ActivityNode)newTarget);
            command.setMaximumInEdges(this.maximumInEdges);
            return new EmfToGefCommandAdapter((Command)command);
        }
        return null;
    }
}

