/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.framework.core;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.libra.framework.core.FrameworkInstanceDelegate;
import org.eclipse.libra.framework.core.Messages;
import org.eclipse.libra.framework.core.ProgressUtil;
import org.eclipse.libra.framework.core.TargetDefinitionUtil;
import org.eclipse.libra.framework.core.Trace;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetHandle;
import org.eclipse.pde.core.target.ITargetPlatformService;

public class FrameworkInstanceConfiguration {
    public static final String ADD_BUNDLE = "ADD_BUNDLE";
    public static final String REMOVE_BUNDLE = "REMOVE_BUNDLE";
    protected IFolder configPath;
    protected ITargetDefinition targetDefinition;
    protected FrameworkInstanceDelegate runtimeInstance;
    private transient List<PropertyChangeListener> propertyListeners;

    public FrameworkInstanceConfiguration(IFolder path, FrameworkInstanceDelegate runtimeInstance) {
        this.configPath = path;
        this.runtimeInstance = runtimeInstance;
    }

    public ITargetDefinition getTargetDefinition() {
        try {
            this.loadTarget();
        }
        catch (CoreException coreException) {}
        return this.targetDefinition;
    }

    public void setTargetDefinition(ITargetDefinition targetDefinition) {
        this.targetDefinition = targetDefinition;
    }

    protected IFolder getFolder() {
        return this.configPath;
    }

    public void load(IFolder folder, IProgressMonitor monitor) throws CoreException {
        this.targetDefinition = this.loadTarget();
        if (this.targetDefinition == null) {
            this.createDefaultTarget();
        } else {
            this.loadTarget();
        }
    }

    private ITargetDefinition loadTarget() throws CoreException {
        this.targetDefinition = null;
        ITargetPlatformService service = TargetDefinitionUtil.getTargetPlatformService();
        ITargetHandle[] targets = service.getTargets((IProgressMonitor)new NullProgressMonitor());
        String name = this.runtimeInstance.getServer().getName();
        ITargetHandle[] iTargetHandleArray = targets;
        int n = targets.length;
        int n2 = 0;
        while (n2 < n) {
            ITargetHandle handle = iTargetHandleArray[n2];
            if (name.equals(handle.getTargetDefinition().getName())) {
                this.targetDefinition = handle.getTargetDefinition();
            }
            ++n2;
        }
        return this.targetDefinition;
    }

    private void createDefaultTarget() throws CoreException {
        this.targetDefinition = this.runtimeInstance.createDefaultTarget();
    }

    protected void firePropertyChangeEvent(String propertyName, Object oldValue, Object newValue) {
        if (this.propertyListeners == null) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        try {
            for (PropertyChangeListener listener : this.propertyListeners) {
                try {
                    listener.propertyChange(event);
                }
                catch (Exception e) {
                    Trace.trace((byte)2, "Error firing property change event", e);
                }
            }
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Error in property event", e);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyListeners == null) {
            this.propertyListeners = new ArrayList<PropertyChangeListener>();
        }
        this.propertyListeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyListeners != null) {
            this.propertyListeners.remove(listener);
        }
    }

    public void importFromPath(IPath path, boolean isTestEnv, IProgressMonitor monitor) throws CoreException {
        this.load(path, monitor);
    }

    public void load(IPath path, IProgressMonitor monitor) throws CoreException {
        try {
            monitor = ProgressUtil.getMonitorFor(monitor);
            monitor.beginTask(Messages.loadingTask, 7);
            monitor.worked(1);
            monitor.worked(1);
            if (monitor.isCanceled()) {
                return;
            }
            monitor.done();
        }
        catch (Exception e) {
            Trace.trace((byte)1, "Could not load Felix configuration from " + path.toOSString() + ": " + e.getMessage());
            throw new CoreException((IStatus)new Status(4, "org.eclipse.libra.framework.core", 0, NLS.bind((String)Messages.errorCouldNotLoadConfiguration, (Object)path.toOSString()), (Throwable)e));
        }
    }

    protected void save(IPath path, boolean forceDirty, IProgressMonitor monitor) throws CoreException {
    }

    public void save(IPath path, IProgressMonitor monitor) throws CoreException {
        this.save(path, true, monitor);
    }

    public void save(IFolder folder, IProgressMonitor monitor) throws CoreException {
    }

    public String toString() {
        return "FrameworkInstanceConfiguration[" + this.getFolder() + "]";
    }
}

