/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;

public class IDEFileSystemStructureProvider
implements IImportStructureProvider {
    private Set<String> visitedDirs;

    public List getChildren(Object element) {
        File folder = (File)element;
        String[] children = folder.list();
        int childrenLength = children == null ? 0 : children.length;
        ArrayList<File> result = new ArrayList<File>(childrenLength);
        int i = 0;
        while (i < childrenLength) {
            File file = new File(folder, children[i]);
            if (!this.isRecursiveLink(file)) {
                result.add(file);
            }
            ++i;
        }
        return result;
    }

    private void initVisitedDirs() {
        if (this.visitedDirs == null) {
            this.visitedDirs = new HashSet<String>();
        }
    }

    private boolean isRecursiveLink(File childFile) {
        if (childFile.isDirectory()) {
            try {
                String canonicalPath = childFile.getCanonicalPath();
                this.initVisitedDirs();
                return !this.visitedDirs.add(canonicalPath);
            }
            catch (IOException e) {
                Activator.log(e);
            }
        }
        return false;
    }

    public InputStream getContents(Object element) {
        try {
            return new FileInputStream((File)element);
        }
        catch (FileNotFoundException e) {
            Activator.log(e);
            return null;
        }
    }

    public String getFullPath(Object element) {
        return ((File)element).getPath();
    }

    public String getLabel(Object element) {
        File file = (File)element;
        String name = file.getName();
        if (name.length() == 0) {
            return file.getPath();
        }
        return name;
    }

    public boolean isFolder(Object element) {
        return ((File)element).isDirectory();
    }

    public void clearVisitedDirs() {
        if (this.visitedDirs != null) {
            this.visitedDirs.clear();
        }
    }
}

