/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.oprofile.core.opxml;

import java.util.HashMap;
import java.util.Stack;
import org.eclipse.linuxtools.internal.oprofile.core.opxml.XMLProcessor;
import org.eclipse.linuxtools.internal.oprofile.core.opxml.checkevent.CheckEventsProcessor;
import org.eclipse.linuxtools.internal.oprofile.core.opxml.info.OpInfoProcessor;
import org.eclipse.linuxtools.internal.oprofile.core.opxml.modeldata.ModelDataProcessor;
import org.eclipse.linuxtools.internal.oprofile.core.opxml.sessions.SessionsProcessor;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class OprofileSAXHandler
extends DefaultHandler {
    private static OprofileSAXHandler instance = null;
    private static HashMap<String, Class<?>> processors = new HashMap();
    private XMLProcessor processor = null;
    private Object callData;
    private Stack<XMLProcessor> processorStack = new Stack();
    private StringBuffer charactersBuffer;
    private static final ProcessorItem[] handlerList = new ProcessorItem[]{new ProcessorItem("info", OpInfoProcessor.class), new ProcessorItem("check-events", CheckEventsProcessor.class), new ProcessorItem("model-data", ModelDataProcessor.class), new ProcessorItem("sessions", SessionsProcessor.class)};

    public static OprofileSAXHandler getInstance(Object callData) {
        if (instance == null) {
            instance = new OprofileSAXHandler();
            int i = 0;
            while (i < handlerList.length) {
                processors.put(OprofileSAXHandler.handlerList[i].tagName, OprofileSAXHandler.handlerList[i].handlerClass);
                ++i;
            }
        }
        instance.setCallData(callData);
        return instance;
    }

    private void setCallData(Object callData) {
        this.callData = callData;
    }

    private static XMLProcessor getProcessor(String type) {
        XMLProcessor processor = null;
        Class<?> handlerClass = processors.get(type);
        if (handlerClass != null) {
            try {
                processor = (XMLProcessor)handlerClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                // empty catch block
            }
        }
        return processor;
    }

    @Override
    public void startDocument() {
        this.processor = null;
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void startElement(String uri, String lName, String qName, Attributes attrs) {
        if (this.processor == null) {
            this.processor = OprofileSAXHandler.getProcessor(qName);
            this.processor.reset(this.callData);
        }
        this.processor.startElement(qName, attrs, this.callData);
        this.charactersBuffer = new StringBuffer();
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        this.processor.characters(this.charactersBuffer.toString(), this.callData);
        this.processor.endElement(qName, this.callData);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        String str = new String(ch, start, length).trim();
        if (str.length() > 0 && this.processor != null) {
            this.charactersBuffer.append(str);
        }
    }

    public void push(XMLProcessor proc) {
        this.processorStack.add(this.processor);
        this.processor = proc;
        this.processor.reset(this.callData);
    }

    public void pop(String tag) {
        this.processor = this.processorStack.pop();
        this.processor.endElement(tag, this.callData);
    }

    private static class ProcessorItem {
        public String tagName;
        public Class<?> handlerClass;

        public ProcessorItem(String name, Class<?> cls) {
            this.tagName = name;
            this.handlerClass = cls;
        }
    }
}

