/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.outline;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;

public class SymbolsModel {
    private static final SymbolInformation ROOT = new SymbolInformation();
    private static final Object[] EMPTY = new Object[0];
    private Map<SymbolInformation, List<SymbolInformation>> childrenMap = new HashMap<SymbolInformation, List<SymbolInformation>>();

    /*
     * Unable to fully structure code
     */
    public boolean update(List<? extends SymbolInformation> response) {
        block2: {
            this.childrenMap.clear();
            if (response == null || response.isEmpty()) break block2;
            Collections.sort(response, new Comparator<SymbolInformation>(){

                @Override
                public int compare(SymbolInformation o1, SymbolInformation o2) {
                    Range r1 = o1.getLocation().getRange();
                    Range r2 = o2.getLocation().getRange();
                    if (r1.getStart().getLine() == r2.getStart().getLine()) {
                        return Integer.compare(r1.getStart().getCharacter(), r2.getStart().getCharacter());
                    }
                    return Integer.compare(r1.getStart().getLine(), r2.getStart().getLine());
                }
            });
            parentStack = new Stack<SymbolInformation>();
            parentStack.push(SymbolsModel.ROOT);
            previousSymbol = null;
            i = 0;
            while (i < response.size()) {
                block4: {
                    block3: {
                        symbol = response.get(i);
                        if (!this.isIncluded(previousSymbol, symbol)) break block3;
                        parentStack.push(previousSymbol);
                        this.addChild((SymbolInformation)parentStack.peek(), symbol);
                        break block4;
                    }
                    if (!this.isIncluded((SymbolInformation)parentStack.peek(), symbol)) ** GOTO lbl22
                    this.addChild((SymbolInformation)parentStack.peek(), symbol);
                    break block4;
lbl-1000:
                    // 1 sources

                    {
                        parentStack.pop();
lbl22:
                        // 2 sources

                        ** while (!this.isIncluded((SymbolInformation)((SymbolInformation)parentStack.peek()), (SymbolInformation)symbol))
                    }
lbl23:
                    // 1 sources

                    this.addChild((SymbolInformation)parentStack.peek(), symbol);
                    parentStack.push(symbol);
                }
                previousSymbol = symbol;
                ++i;
            }
        }
        return true;
    }

    private boolean isIncluded(SymbolInformation parent, SymbolInformation symbol) {
        if (parent == null || symbol == null) {
            return false;
        }
        if (parent == ROOT) {
            return true;
        }
        return this.isIncluded(parent.getLocation(), symbol.getLocation());
    }

    private boolean isIncluded(Location reference, Location included) {
        return reference.getUri().equals(included.getUri()) && this.isAfter(reference.getRange().getStart(), included.getRange().getStart()) && this.isAfter(included.getRange().getEnd(), reference.getRange().getEnd());
    }

    private boolean isAfter(Position reference, Position included) {
        return included.getLine() > reference.getLine() || included.getLine() == reference.getLine() && included.getLine() > reference.getLine();
    }

    private void addChild(SymbolInformation parent, SymbolInformation child) {
        List<SymbolInformation> children = this.childrenMap.get(parent);
        if (children == null) {
            children = new ArrayList<SymbolInformation>();
            this.childrenMap.put(parent, children);
        }
        children.add(child);
    }

    public Object[] getElements() {
        return this.getChildren(ROOT);
    }

    public Object[] getChildren(Object parentElement) {
        List<SymbolInformation> children;
        if (parentElement != null && parentElement instanceof SymbolInformation && (children = this.childrenMap.get(parentElement)) != null) {
            return children.toArray();
        }
        return EMPTY;
    }

    public Object getParent(Object element) {
        Optional<SymbolInformation> result = this.childrenMap.keySet().stream().filter(parent -> {
            List<SymbolInformation> children = this.childrenMap.get(parent);
            return children == null ? false : children.contains(element);
        }).findFirst();
        return result.isPresent() ? result.get() : null;
    }
}

