/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.composites;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.m2e.editor.composites.ListEditorContentProvider;
import org.eclipse.m2e.editor.internal.Messages;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ListEditorComposite<T>
extends Composite {
    TableViewer viewer;
    protected Map<String, Button> buttons = new HashMap<String, Button>(5);
    private static final String ADD = "ADD";
    private static final String CREATE = "CREATE";
    private static final String REMOVE = "REMOVE";
    boolean readOnly = false;
    protected FormToolkit toolkit;
    private TableViewerColumn column;

    public ListEditorComposite(Composite parent, int style, boolean includeSearch) {
        super(parent, style);
        this.toolkit = new FormToolkit(parent.getDisplay());
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 1;
        gridLayout.marginHeight = 1;
        gridLayout.verticalSpacing = 1;
        this.setLayout((Layout)gridLayout);
        final Table table = this.toolkit.createTable((Composite)this, 0x800002);
        table.setData("name", (Object)"list-editor-composite-table");
        this.viewer = new TableViewer(table);
        this.column = new TableViewerColumn(this.viewer, 16384);
        table.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                ListEditorComposite.this.column.getColumn().setWidth(table.getClientArea().width);
            }
        });
        this.createButtons(includeSearch);
        int vSpan = this.buttons.size();
        GridData viewerData = new GridData(4, 4, true, true, 1, vSpan);
        viewerData.widthHint = 100;
        viewerData.heightHint = includeSearch ? 125 : 50;
        viewerData.minimumHeight = includeSearch ? 125 : 50;
        table.setLayoutData((Object)viewerData);
        this.viewer.setData("FormWidgetFactory.drawBorder", (Object)Boolean.TRUE);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ListEditorComposite.this.viewerSelectionChanged();
            }
        });
        this.toolkit.paintBordersFor((Composite)this);
    }

    public ListEditorComposite(Composite parent, int style) {
        this(parent, style, false);
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this.viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
    }

    public void setCellLabelProvider(CellLabelProvider cell) {
        this.column.setLabelProvider(cell);
    }

    public void setContentProvider(ListEditorContentProvider<T> contentProvider) {
        this.viewer.setContentProvider(contentProvider);
    }

    public void setInput(List<T> input) {
        this.viewer.setInput(input);
        this.viewer.setSelection((ISelection)new StructuredSelection());
    }

    public Object getInput() {
        return this.viewer.getInput();
    }

    public void setOpenListener(IOpenListener listener) {
        this.viewer.addOpenListener(listener);
    }

    public void addSelectionListener(ISelectionChangedListener listener) {
        this.viewer.addSelectionChangedListener(listener);
    }

    public void setAddButtonListener(SelectionListener listener) {
        if (this.getAddButton() != null) {
            this.getAddButton().addSelectionListener(listener);
            this.getAddButton().setEnabled(true);
        }
    }

    protected Button getCreateButton() {
        return this.buttons.get(CREATE);
    }

    protected Button getRemoveButton() {
        return this.buttons.get(REMOVE);
    }

    protected Button getAddButton() {
        return this.buttons.get(ADD);
    }

    public void setCreateButtonListener(SelectionListener listener) {
        this.getCreateButton().addSelectionListener(listener);
        this.getCreateButton().setEnabled(true);
    }

    public void setRemoveButtonListener(SelectionListener listener) {
        this.getRemoveButton().addSelectionListener(listener);
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    public int getSelectionIndex() {
        return this.viewer.getTable().getSelectionIndex();
    }

    public void setSelectionIndex(int n) {
        this.viewer.getTable().setSelection(n);
    }

    public List<T> getSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        return selection == null ? Collections.emptyList() : selection.toList();
    }

    public void setSelection(List<T> selection) {
        this.viewer.setSelection((ISelection)new StructuredSelection(selection), true);
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        for (Map.Entry<String, Button> entry : this.buttons.entrySet()) {
            if (entry.getKey().equals(REMOVE)) {
                this.updateRemoveButton();
                continue;
            }
            entry.getValue().setEnabled(!readOnly);
        }
    }

    protected void viewerSelectionChanged() {
        this.updateRemoveButton();
    }

    protected void updateRemoveButton() {
        this.getRemoveButton().setEnabled(!this.readOnly && !this.viewer.getSelection().isEmpty());
    }

    public void refresh() {
        if (!this.viewer.getTable().isDisposed()) {
            this.viewer.refresh(true);
            this.column.getColumn().setWidth(this.viewer.getTable().getClientArea().width);
        }
    }

    public void setCellModifier(ICellModifier cellModifier) {
        ColumnViewerEditorActivationStrategy activationSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)this.viewer){
            Object prevSelection;

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ListEditorComposite.this.viewer.getSelection();
                if (selection.size() != 1) {
                    return false;
                }
                Object selElement = selection.getFirstElement();
                this.prevSelection = selElement;
                if (this.prevSelection != this.prevSelection) {
                    return false;
                }
                return super.isEditorActivationEvent(event);
            }
        };
        TableViewerEditor.create((TableViewer)this.viewer, (ColumnViewerEditorActivationStrategy)activationSupport, (int)1);
        this.viewer.setColumnProperties(new String[]{"?"});
        TextCellEditor editor = new TextCellEditor((Composite)this.viewer.getTable());
        this.viewer.setCellEditors(new CellEditor[]{editor});
        this.viewer.setCellModifier(cellModifier);
    }

    public void setDoubleClickListener(IDoubleClickListener listener) {
        this.viewer.addDoubleClickListener(listener);
    }

    protected void createButtons(boolean includeSearch) {
        if (includeSearch) {
            this.createAddButton();
        }
        this.createCreateButton();
        this.createRemoveButton();
    }

    protected void addButton(String key, Button button) {
        this.buttons.put(key, button);
    }

    protected void createAddButton() {
        this.addButton(ADD, this.createButton(Messages.ListEditorComposite_btnAdd));
    }

    protected void createCreateButton() {
        this.addButton(CREATE, this.createButton(Messages.ListEditorComposite_btnCreate));
    }

    protected void createRemoveButton() {
        this.addButton(REMOVE, this.createButton(Messages.ListEditorComposite_btnRemove));
    }

    protected Button createButton(String text) {
        Button button = this.toolkit.createButton((Composite)this, text, 0x800000);
        GridData gd = new GridData(4, 128, false, false);
        gd.verticalIndent = 0;
        button.setLayoutData((Object)gd);
        button.setEnabled(false);
        return button;
    }
}

