/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.internal.snapshot.inspections;

import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.NumberFormat;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.Format;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.ContextProvider;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IContextObjectSet;
import org.eclipse.mat.query.IIconProvider;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.IResultTable;
import org.eclipse.mat.query.IResultTree;
import org.eclipse.mat.query.IStructuredResult;
import org.eclipse.mat.query.ResultMetaData;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.query.annotations.Menu;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.OQL;
import org.eclipse.mat.snapshot.query.Icons;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Icon(value="/META-INF/icons/compare.gif")
@HelpUrl(value="/org.eclipse.mat.ui.help/tasks/comparingdata.html")
@Menu(value={@Menu.Entry(options="-setop ALL")})
public class CompareTablesQuery
implements IQuery {
    @Argument
    public IStructuredResult[] tables;
    @Argument
    public IQueryContext queryContext;
    @Argument(isMandatory=false)
    public ISnapshot[] snapshots;
    @Argument(isMandatory=false)
    public Mode mode = Mode.ABSOLUTE;
    @Argument(isMandatory=false)
    public Operation setOp = Operation.NONE;
    @Argument(isMandatory=false)
    public int keyColumn = 1;
    private boolean[] sameSnapshot;

    public IResult execute(IProgressListener listener) throws Exception {
        if (this.tables == null) {
            return null;
        }
        IStructuredResult base = this.tables[0];
        Column[] baseColumns = base.getColumns();
        Column key = baseColumns[this.keyColumn - 1];
        this.sameSnapshot = new boolean[this.tables.length];
        ISnapshot sn = (ISnapshot)this.queryContext.get(ISnapshot.class, null);
        int i = 0;
        while (i < this.tables.length) {
            this.sameSnapshot[i] = this.snapshots[i] == null || sn.equals(this.snapshots[i]);
            ++i;
        }
        ArrayList<ComparedColumn> attributes = new ArrayList<ComparedColumn>();
        int i2 = 0;
        while (i2 < baseColumns.length) {
            if (i2 != this.keyColumn - 1) {
                int[] indexes = new int[this.tables.length];
                int j = 0;
                while (j < indexes.length) {
                    indexes[j] = this.getColumnIndex(baseColumns[i2].getLabel(), this.tables[j]);
                    ++j;
                }
                attributes.add(new ComparedColumn(baseColumns[i2], indexes, true));
            }
            ++i2;
        }
        return new TableComparisonResult(this.mergeKeys(), key, attributes, this.mode, this.setOp);
    }

    private int getColumnIndex(String name, IStructuredResult table) {
        Column[] columns = table.getColumns();
        int i = 0;
        while (i < columns.length) {
            if (columns[i].getLabel().equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private List<ComparedRow> mergeKeys() {
        HashMap<Object, Object[]> map = new HashMap<Object, Object[]>();
        int i = 0;
        while (i < this.tables.length) {
            IStructuredResult table = this.tables[i];
            int size = table instanceof IResultTable ? ((IResultTable)table).getRowCount() : (table instanceof IResultTree ? ((IResultTree)table).getElements().size() : 0);
            int j = 0;
            while (j < size) {
                Object row = table instanceof IResultTable ? ((IResultTable)table).getRow(j) : (table instanceof IResultTree ? ((IResultTree)table).getElements().get(j) : null);
                Object key = table.getColumnValue(row, this.keyColumn - 1);
                Object[] rows = (Object[])map.get(key);
                if (rows == null) {
                    rows = new Object[this.tables.length];
                    map.put(key, rows);
                }
                rows[i] = row;
                ++j;
            }
            ++i;
        }
        ArrayList<ComparedRow> result = new ArrayList<ComparedRow>(map.size());
        for (Map.Entry entry : map.entrySet()) {
            result.add(new ComparedRow(entry.getKey(), (Object[])entry.getValue()));
        }
        return result;
    }

    public class ComparedColumn {
        Column description;
        int[] columnIndexes;
        boolean displayed;

        public ComparedColumn(Column description, int[] columnIndexes, boolean displayed) {
            this.displayed = displayed;
            this.description = description;
            this.columnIndexes = columnIndexes;
        }

        public Column getDescription() {
            return this.description;
        }

        public void setDescription(Column description) {
            this.description = description;
        }

        public int[] getColumnIndexes() {
            return this.columnIndexes;
        }

        public void setColumnIndexes(int[] columnIndexes) {
            this.columnIndexes = columnIndexes;
        }

        public boolean isDisplayed() {
            return this.displayed;
        }

        public void setDisplayed(boolean displayed) {
            this.displayed = displayed;
        }
    }

    class ComparedRow {
        Object key;
        Object[] rows;

        public ComparedRow(Object key, Object[] rows) {
            this.key = key;
            this.rows = rows;
        }

        public Object getKey() {
            return this.key;
        }

        public void setKey(Object key) {
            this.key = key;
        }

        public Object[] getRows() {
            return this.rows;
        }

        public void setRows(Object[] rows) {
            this.rows = rows;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        ABSOLUTE("ABSOLUTE"),
        DIFF_TO_FIRST("DIFF_TO_FIRST"),
        DIFF_TO_PREVIOUS("DIFF_TO_PREVIOUS"),
        DIFF_RATIO_TO_FIRST("DIFF_RATIO_TO_FIRST"),
        DIFF_RATIO_TO_PREVIOUS("DIFF_RATIO_TO_PREVIOUS");

        String label;

        private Mode(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operation {
        NONE,
        ALL,
        INTERSECTION,
        UNION,
        SYMMETRIC_DIFFERENCE,
        DIFFERENCE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TableComparisonResult
    implements IResultTable,
    IIconProvider {
        private Column key;
        private List<ComparedRow> rows;
        private List<ComparedColumn> comparedColumns;
        private List<ComparedColumn> displayedColumns;
        private Column[] columns;
        private Mode mode;
        private Operation setOp;

        public TableComparisonResult(List<ComparedRow> rows, Column key, List<ComparedColumn> comparedColumns, Mode mode, Operation setOp) {
            this.key = key;
            this.mode = mode;
            this.rows = rows;
            this.comparedColumns = comparedColumns;
            this.updateColumns();
            this.setMode(mode);
            this.setOp = setOp;
        }

        public Object getRow(int rowId) {
            return this.rows.get(rowId);
        }

        public int getRowCount() {
            return this.rows.size();
        }

        public List<ComparedColumn> getComparedColumns() {
            return this.comparedColumns;
        }

        public void setComparedColumns(List<ComparedColumn> comparedColumns) {
            this.comparedColumns = comparedColumns;
        }

        public Object getColumnValue(Object row, int columnIndex) {
            ComparedRow cr = (ComparedRow)row;
            if (columnIndex == 0) {
                return cr.getKey();
            }
            int subCols = this.mode == Mode.DIFF_RATIO_TO_FIRST || this.mode == Mode.DIFF_RATIO_TO_PREVIOUS ? CompareTablesQuery.this.tables.length + CompareTablesQuery.this.tables.length - 1 : CompareTablesQuery.this.tables.length;
            int comparedColumnIdx = (columnIndex - 1) / subCols;
            int tableIdx = (columnIndex - 1) % subCols;
            if (tableIdx == 0) {
                return this.getAbsoluteValue(cr, comparedColumnIdx, tableIdx);
            }
            switch (this.mode) {
                case ABSOLUTE: {
                    return this.getAbsoluteValue(cr, comparedColumnIdx, tableIdx);
                }
                case DIFF_TO_FIRST: {
                    return this.getDiffToFirst(cr, comparedColumnIdx, tableIdx, false);
                }
                case DIFF_TO_PREVIOUS: {
                    return this.getDiffToPrevious(cr, comparedColumnIdx, tableIdx, false);
                }
                case DIFF_RATIO_TO_FIRST: {
                    return this.getDiffToFirst(cr, comparedColumnIdx, (tableIdx + 1) / 2, tableIdx % 2 == 0);
                }
                case DIFF_RATIO_TO_PREVIOUS: {
                    return this.getDiffToPrevious(cr, comparedColumnIdx, (tableIdx + 1) / 2, tableIdx % 2 == 0);
                }
            }
            return null;
        }

        public Column[] getColumns() {
            return this.columns;
        }

        public IContextObject getContext(Object row) {
            IContextObject ret = null;
            int i = 0;
            while (i < CompareTablesQuery.this.tables.length && ret == null) {
                ret = this.getContextFromTable(i, row);
                ++i;
            }
            return ret;
        }

        public ResultMetaData getResultMetaData() {
            ResultMetaData.Builder bb = new ResultMetaData.Builder();
            int previous = -1;
            int i = 0;
            while (i < CompareTablesQuery.this.tables.length) {
                if (CompareTablesQuery.this.sameSnapshot[i]) {
                    if (this.setOp != Operation.NONE && previous >= 0) {
                        int op = 0;
                        while (op < 5) {
                            if (!(this.setOp == Operation.INTERSECTION && op != 0 || this.setOp == Operation.UNION && op != 1 || this.setOp == Operation.SYMMETRIC_DIFFERENCE && op != 2 || this.setOp == Operation.DIFFERENCE && op != 3)) {
                                String title1;
                                final int op1 = op;
                                final LinkedList<Integer> toDo = new LinkedList<Integer>();
                                if (this.mode == Mode.ABSOLUTE) {
                                    toDo.add(previous);
                                    if (op == 4) {
                                        int k = previous + 1;
                                        while (k <= i) {
                                            toDo.addFirst(k);
                                            ++k;
                                        }
                                    } else {
                                        int k = previous + 1;
                                        while (k <= i) {
                                            toDo.add(k);
                                            ++k;
                                        }
                                    }
                                } else if (op == 4) {
                                    toDo.add(i);
                                    toDo.add(previous);
                                } else {
                                    toDo.add(previous);
                                    toDo.add(i);
                                }
                                if (toDo.size() == 2) {
                                    switch (op) {
                                        case 0: {
                                            title1 = MessageUtil.format((String)Messages.CompareTablesQuery_IntersectionOf2, (Object[])new Object[]{(Integer)toDo.get(0) + 1, (Integer)toDo.get(1) + 1});
                                            break;
                                        }
                                        case 1: {
                                            title1 = MessageUtil.format((String)Messages.CompareTablesQuery_UnionOf2, (Object[])new Object[]{(Integer)toDo.get(0) + 1, (Integer)toDo.get(1) + 1});
                                            break;
                                        }
                                        case 2: {
                                            title1 = MessageUtil.format((String)Messages.CompareTablesQuery_SymmetricDifferenceOf2, (Object[])new Object[]{(Integer)toDo.get(0) + 1, (Integer)toDo.get(1) + 1});
                                            break;
                                        }
                                        default: {
                                            title1 = MessageUtil.format((String)Messages.CompareTablesQuery_DifferenceOf2, (Object[])new Object[]{(Integer)toDo.get(0) + 1, (Integer)toDo.get(1) + 1});
                                            break;
                                        }
                                    }
                                } else {
                                    String soFar;
                                    switch (op) {
                                        case 0: {
                                            soFar = MessageUtil.format((String)Messages.CompareTablesQuery_IntersectionFirst, (Object[])new Object[]{(Integer)toDo.get(0) + 1, (Integer)toDo.get(1) + 1});
                                            break;
                                        }
                                        case 1: {
                                            soFar = MessageUtil.format((String)Messages.CompareTablesQuery_UnionFirst, (Object[])new Object[]{(Integer)toDo.get(0) + 1, (Integer)toDo.get(1) + 1});
                                            break;
                                        }
                                        case 2: {
                                            soFar = MessageUtil.format((String)Messages.CompareTablesQuery_SymmetricDifferenceFirst, (Object[])new Object[]{(Integer)toDo.get(0) + 1, (Integer)toDo.get(1) + 1});
                                            break;
                                        }
                                        default: {
                                            soFar = MessageUtil.format((String)Messages.CompareTablesQuery_DifferenceFirst, (Object[])new Object[]{(Integer)toDo.get(0) + 1, (Integer)toDo.get(1) + 1});
                                        }
                                    }
                                    int t = 2;
                                    while (t < toDo.size() - 1) {
                                        switch (op) {
                                            case 0: {
                                                soFar = MessageUtil.format((String)Messages.CompareTablesQuery_IntersectionMiddle, (Object[])new Object[]{soFar, (Integer)toDo.get(t) + 1});
                                                break;
                                            }
                                            case 1: {
                                                soFar = MessageUtil.format((String)Messages.CompareTablesQuery_UnionMiddle, (Object[])new Object[]{soFar, (Integer)toDo.get(t) + 1});
                                                break;
                                            }
                                            case 2: {
                                                soFar = MessageUtil.format((String)Messages.CompareTablesQuery_SymmetricDifferenceMiddle, (Object[])new Object[]{soFar, (Integer)toDo.get(t) + 1});
                                                break;
                                            }
                                            default: {
                                                soFar = MessageUtil.format((String)Messages.CompareTablesQuery_DifferenceMiddle, (Object[])new Object[]{soFar, (Integer)toDo.get(t) + 1});
                                            }
                                        }
                                        ++t;
                                    }
                                    t = toDo.size() - 1;
                                    switch (op) {
                                        case 0: {
                                            title1 = MessageUtil.format((String)Messages.CompareTablesQuery_IntersectionLast, (Object[])new Object[]{soFar, (Integer)toDo.get(t) + 1});
                                            break;
                                        }
                                        case 1: {
                                            title1 = MessageUtil.format((String)Messages.CompareTablesQuery_UnionLast, (Object[])new Object[]{soFar, (Integer)toDo.get(t) + 1});
                                            break;
                                        }
                                        case 2: {
                                            title1 = MessageUtil.format((String)Messages.CompareTablesQuery_SymmetricDifferenceLast, (Object[])new Object[]{soFar, (Integer)toDo.get(t) + 1});
                                            break;
                                        }
                                        default: {
                                            title1 = MessageUtil.format((String)Messages.CompareTablesQuery_DifferenceLast, (Object[])new Object[]{soFar, (Integer)toDo.get(t) + 1});
                                        }
                                    }
                                }
                                ContextProvider prov2 = new ContextProvider(title1){

                                    public URL getIcon() {
                                        switch (op1) {
                                            case 0: {
                                                return Icons.getURL("set_intersection.gif");
                                            }
                                            case 1: {
                                                return Icons.getURL("set_union.gif");
                                            }
                                            case 2: {
                                                return Icons.getURL("set_symmetric_difference.gif");
                                            }
                                            case 3: {
                                                return Icons.getURL("set_differenceA.gif");
                                            }
                                            case 4: {
                                                return Icons.getURL("set_differenceB.gif");
                                            }
                                        }
                                        return null;
                                    }

                                    public IContextObject getContext(final Object row) {
                                        int nullContexts = 0;
                                        int i = 0;
                                        while (i < toDo.size()) {
                                            if (TableComparisonResult.this.getContextFromTable(i, row) != null) break;
                                            ++nullContexts;
                                            ++i;
                                        }
                                        if (nullContexts == toDo.size()) {
                                            return null;
                                        }
                                        final IContextObject cb = TableComparisonResult.this.getContextFromTable(nullContexts, row);
                                        return new IContextObjectSet(){

                                            public int getObjectId() {
                                                return cb.getObjectId();
                                            }

                                            public String getOQL() {
                                                LinkedList toDo2 = new LinkedList(toDo);
                                                switch (op1) {
                                                    case 0: {
                                                        String resultOQL0 = null;
                                                        Iterator iterator = toDo2.iterator();
                                                        while (iterator.hasNext()) {
                                                            int j = (Integer)iterator.next();
                                                            IContextObject cb32 = TableComparisonResult.this.getContextFromTable(j, row);
                                                            if (cb32 == null) continue;
                                                            String oql = this.getOQLfromContext(cb32);
                                                            if (oql != null) {
                                                                if (resultOQL0 == null) {
                                                                    resultOQL0 = oql;
                                                                    continue;
                                                                }
                                                                resultOQL0 = this.OQLintersection(resultOQL0, oql);
                                                                continue;
                                                            }
                                                            return null;
                                                        }
                                                        return resultOQL0;
                                                    }
                                                    case 1: {
                                                        StringBuilder resultOQL = new StringBuilder();
                                                        Iterator cb32 = toDo2.iterator();
                                                        while (cb32.hasNext()) {
                                                            int j = (Integer)cb32.next();
                                                            IContextObject cb2 = TableComparisonResult.this.getContextFromTable(j, row);
                                                            if (cb2 == null) continue;
                                                            String oql = this.getOQLfromContext(cb2);
                                                            if (oql != null) {
                                                                OQL.union(resultOQL, oql);
                                                                continue;
                                                            }
                                                            return null;
                                                        }
                                                        resultOQL.insert(0, "SELECT DISTINCT OBJECTS @objectId FROM OBJECTS (");
                                                        resultOQL.append(")");
                                                        return resultOQL.toString();
                                                    }
                                                    case 2: {
                                                        String resultOQL2 = null;
                                                        Iterator cb2 = toDo2.iterator();
                                                        while (cb2.hasNext()) {
                                                            int j = (Integer)cb2.next();
                                                            IContextObject cb4 = TableComparisonResult.this.getContextFromTable(j, row);
                                                            if (cb4 == null) continue;
                                                            String oql = this.getOQLfromContext(cb4);
                                                            if (oql != null) {
                                                                if (resultOQL2 == null) {
                                                                    resultOQL2 = oql;
                                                                    continue;
                                                                }
                                                                StringBuilder sb = new StringBuilder();
                                                                sb.append(this.OQLexcept(resultOQL2, oql));
                                                                OQL.union(sb, this.OQLexcept(oql, resultOQL2));
                                                                resultOQL2 = sb.toString();
                                                                continue;
                                                            }
                                                            return null;
                                                        }
                                                        return resultOQL2;
                                                    }
                                                    case 3: 
                                                    case 4: {
                                                        String resultOQL3 = null;
                                                        Iterator iterator = toDo2.iterator();
                                                        while (iterator.hasNext()) {
                                                            int j = (Integer)iterator.next();
                                                            IContextObject cb5 = TableComparisonResult.this.getContextFromTable(j, row);
                                                            if (cb5 == null) continue;
                                                            String oql = this.getOQLfromContext(cb5);
                                                            if (oql != null) {
                                                                if (resultOQL3 == null) {
                                                                    resultOQL3 = oql;
                                                                    continue;
                                                                }
                                                                resultOQL3 = this.OQLexcept(resultOQL3, oql);
                                                                continue;
                                                            }
                                                            return null;
                                                        }
                                                        return resultOQL3;
                                                    }
                                                }
                                                return null;
                                            }

                                            private String OQLexcept(String oql1, String oql2) {
                                                oql1 = "SELECT * FROM OBJECTS (" + oql1 + ")" + " WHERE @objectId not in (" + oql2 + ")";
                                                return oql1;
                                            }

                                            private String OQLintersection(String oql1, String oql2) {
                                                oql1 = "SELECT * FROM OBJECTS (" + oql1 + ")" + " WHERE @objectId in (" + oql2 + ")";
                                                return oql1;
                                            }

                                            public int[] getObjectIds() {
                                                ArrayInt bb;
                                                LinkedList toDo2 = new LinkedList(toDo);
                                                int j = (Integer)toDo2.remove();
                                                IContextObject cb2 = TableComparisonResult.this.getContextFromTable(j, row);
                                                int[] b = this.getObjectIdsFromContext(cb2);
                                                if (b == null) {
                                                    bb = new ArrayInt();
                                                } else {
                                                    bb = new ArrayInt(b);
                                                    bb.sort();
                                                }
                                                while (!toDo2.isEmpty()) {
                                                    ArrayInt aa;
                                                    j = (Integer)toDo2.remove();
                                                    IContextObject ca = TableComparisonResult.this.getContextFromTable(j, row);
                                                    int[] a = this.getObjectIdsFromContext(ca);
                                                    if (a == null) {
                                                        aa = new ArrayInt();
                                                    } else {
                                                        aa = new ArrayInt(a);
                                                        aa.sort();
                                                    }
                                                    switch (op1) {
                                                        case 0: {
                                                            bb = this.intersectionArray(aa, bb);
                                                            break;
                                                        }
                                                        case 1: {
                                                            bb = this.unionArray(aa, bb);
                                                            break;
                                                        }
                                                        case 2: {
                                                            bb = this.symdiffArray(aa, bb);
                                                            break;
                                                        }
                                                        case 3: 
                                                        case 4: {
                                                            bb = this.diffArray(aa, bb);
                                                        }
                                                    }
                                                }
                                                int[] res = bb.toArray();
                                                return res;
                                            }

                                            /*
                                             * Unable to fully structure code
                                             */
                                            private ArrayInt unionArray(ArrayInt aa, ArrayInt bb) {
                                                if (aa.size() == 0) {
                                                    return bb;
                                                }
                                                if (bb.size() == 0) {
                                                    return aa;
                                                }
                                                cc = new ArrayInt();
                                                j = 0;
                                                i = 0;
                                                ** GOTO lbl17
                                                {
                                                    cc.add(aa.get(j));
                                                    ++j;
                                                    do {
                                                        if (j < aa.size() && aa.get(j) < bb.get(i)) continue block0;
                                                        cc.add(bb.get(i));
                                                        if (j < aa.size() && aa.get(j) == bb.get(i)) {
                                                            ++j;
                                                        }
                                                        ++i;
lbl17:
                                                        // 2 sources

                                                    } while (i < bb.size());
                                                }
                                                return cc;
                                            }

                                            /*
                                             * Unable to fully structure code
                                             */
                                            private ArrayInt diffArray(ArrayInt aa, ArrayInt bb) {
                                                if (bb.size() == 0) {
                                                    return bb;
                                                }
                                                if (aa.size() == 0) {
                                                    return bb;
                                                }
                                                cc = new ArrayInt();
                                                j = 0;
                                                i = 0;
                                                ** GOTO lbl17
                                                {
                                                    ++j;
                                                    do {
                                                        if (j < aa.size() && aa.get(j) < bb.get(i)) continue block0;
                                                        if (j < aa.size() && aa.get(j) == bb.get(i)) {
                                                            ++j;
                                                        } else {
                                                            cc.add(bb.get(i));
                                                        }
                                                        ++i;
lbl17:
                                                        // 2 sources

                                                    } while (i < bb.size());
                                                }
                                                return cc;
                                            }

                                            /*
                                             * Unable to fully structure code
                                             */
                                            private ArrayInt intersectionArray(ArrayInt aa, ArrayInt bb) {
                                                if (aa.size() == 0) {
                                                    return aa;
                                                }
                                                if (bb.size() == 0) {
                                                    return bb;
                                                }
                                                cc = new ArrayInt();
                                                j = 0;
                                                i = 0;
                                                ** GOTO lbl16
                                                {
                                                    ++j;
                                                    do {
                                                        if (j < aa.size() && aa.get(j) < bb.get(i)) continue block0;
                                                        if (j < aa.size() && aa.get(j) == bb.get(i)) {
                                                            cc.add(bb.get(i));
                                                            ++j;
                                                        }
                                                        ++i;
lbl16:
                                                        // 2 sources

                                                    } while (i < bb.size());
                                                }
                                                return cc;
                                            }

                                            /*
                                             * Unable to fully structure code
                                             */
                                            private ArrayInt symdiffArray(ArrayInt aa, ArrayInt bb) {
                                                if (aa.size() == 0) {
                                                    return bb;
                                                }
                                                if (bb.size() == 0) {
                                                    return aa;
                                                }
                                                cc = new ArrayInt();
                                                j = 0;
                                                i = 0;
                                                ** GOTO lbl18
                                                {
                                                    cc.add(aa.get(j));
                                                    ++j;
                                                    do {
                                                        if (j < aa.size() && aa.get(j) < bb.get(i)) continue block0;
                                                        if (j < aa.size() && aa.get(j) == bb.get(i)) {
                                                            ++j;
                                                        } else {
                                                            cc.add(bb.get(i));
                                                        }
                                                        ++i;
lbl18:
                                                        // 2 sources

                                                    } while (i < bb.size());
                                                }
                                                return cc;
                                            }

                                            private int[] getObjectIdsFromContext(IContextObject b) {
                                                int id;
                                                Object bobjs = b instanceof IContextObjectSet ? ((IContextObjectSet)b).getObjectIds() : (Object)(b != null ? (Object)((id = b.getObjectId()) >= 0 ? new int[]{id} : null) : null);
                                                return bobjs;
                                            }

                                            private String getOQLfromContext(IContextObject b) {
                                                int id;
                                                String oql = b instanceof IContextObjectSet ? ((IContextObjectSet)b).getOQL() : (b != null ? ((id = b.getObjectId()) >= 0 ? OQL.forObjectId(id) : null) : null);
                                                return oql;
                                            }
                                        };
                                    }
                                };
                                bb.addContext(prov2);
                            }
                            ++op;
                        }
                    }
                    if (this.setOp == Operation.NONE || this.setOp == Operation.ALL) {
                        final int i2 = i;
                        String title = MessageUtil.format((String)Messages.CompareTablesQuery_Table, (Object[])new Object[]{i + 1});
                        ContextProvider prov = new ContextProvider(title){

                            public IContextObject getContext(Object row) {
                                return TableComparisonResult.this.getContextFromTable(i2, row);
                            }
                        };
                        bb.addContext(prov);
                    }
                    if (this.mode == Mode.DIFF_TO_PREVIOUS || this.mode == Mode.DIFF_RATIO_TO_PREVIOUS || previous == -1) {
                        previous = i;
                    }
                }
                ++i;
            }
            return bb.build();
        }

        private Object getAbsoluteValue(ComparedRow cr, int comparedColumnIdx, int tableIdx) {
            Object tableRow = cr.getRows()[tableIdx];
            if (tableRow == null) {
                return null;
            }
            int tableColumnIdx = this.displayedColumns.get(comparedColumnIdx).getColumnIndexes()[tableIdx];
            if (tableColumnIdx == -1) {
                return null;
            }
            return CompareTablesQuery.this.tables[tableIdx].getColumnValue(tableRow, tableColumnIdx);
        }

        private Object percentDivide(Number d1, Number d2) {
            if (d1.doubleValue() == 0.0 && d2.doubleValue() == 0.0 && (d2 instanceof Integer || d2 instanceof Long || d2 instanceof Byte || d2 instanceof Short)) {
                return 0.0;
            }
            return d1.doubleValue() / d2.doubleValue();
        }

        private Object getDiffToFirst(ComparedRow cr, int comparedColumnIdx, int tableIdx, boolean ratio) {
            Object tableRow = cr.getRows()[tableIdx];
            if (tableRow == null) {
                return null;
            }
            int tableColumnIdx = this.displayedColumns.get(comparedColumnIdx).getColumnIndexes()[tableIdx];
            if (tableColumnIdx == -1) {
                return null;
            }
            Object value = CompareTablesQuery.this.tables[tableIdx].getColumnValue(tableRow, tableColumnIdx);
            Object firstTableValue = this.getAbsoluteValue(cr, comparedColumnIdx, 0);
            if (value == null && firstTableValue == null) {
                return null;
            }
            if (value == null && firstTableValue instanceof Number) {
                return null;
            }
            if (value instanceof Number && firstTableValue == null) {
                return ratio ? null : value;
            }
            if (value instanceof Number && firstTableValue instanceof Number) {
                Object ret = this.computeDiff((Number)firstTableValue, (Number)value);
                if (ratio && ret instanceof Number) {
                    return this.percentDivide((Number)ret, (Number)firstTableValue);
                }
                return ret;
            }
            return null;
        }

        private Object getDiffToPrevious(ComparedRow cr, int comparedColumnIdx, int tableIdx, boolean ratio) {
            Object tableRow = cr.getRows()[tableIdx];
            if (tableRow == null) {
                return null;
            }
            int tableColumnIdx = this.displayedColumns.get(comparedColumnIdx).getColumnIndexes()[tableIdx];
            if (tableColumnIdx == -1) {
                return null;
            }
            Object value = CompareTablesQuery.this.tables[tableIdx].getColumnValue(tableRow, tableColumnIdx);
            Object previousTableValue = this.getAbsoluteValue(cr, comparedColumnIdx, tableIdx - 1);
            if (value == null && previousTableValue == null) {
                return null;
            }
            if (value == null && previousTableValue instanceof Number) {
                return null;
            }
            if (value instanceof Number && previousTableValue == null) {
                return ratio ? null : value;
            }
            if (value instanceof Number && previousTableValue instanceof Number) {
                Object ret = this.computeDiff((Number)previousTableValue, (Number)value);
                if (ratio && ret instanceof Number) {
                    return this.percentDivide((Number)ret, (Number)previousTableValue);
                }
                return ret;
            }
            return null;
        }

        private Object computeDiff(Number o1, Number o2) {
            if (o1 instanceof Long && o2 instanceof Long) {
                return o2.longValue() - o1.longValue();
            }
            if (o1 instanceof Integer && o2 instanceof Integer) {
                return o2.intValue() - o1.intValue();
            }
            if (o1 instanceof Short && o2 instanceof Short) {
                return o2.shortValue() - o1.shortValue();
            }
            if (o1 instanceof Byte && o2 instanceof Byte) {
                return o2.byteValue() - o1.byteValue();
            }
            if (o1 instanceof Float && o2 instanceof Float) {
                return Float.valueOf(o2.floatValue() - o1.floatValue());
            }
            if (o1 instanceof Double && o2 instanceof Double) {
                return o2.doubleValue() - o1.doubleValue();
            }
            return null;
        }

        public URL getIcon(Object row) {
            URL ret = null;
            ComparedRow cr = (ComparedRow)row;
            boolean foundIcon = false;
            int i = 0;
            while (i < CompareTablesQuery.this.tables.length) {
                block6: {
                    Object r = cr.getRows()[i];
                    if (r != null) {
                        URL tableIcon;
                        URL uRL = tableIcon = CompareTablesQuery.this.tables[i] instanceof IIconProvider ? ((IIconProvider)CompareTablesQuery.this.tables[i]).getIcon(r) : null;
                        if (foundIcon) {
                            try {
                                if (ret == null ? tableIcon != null : tableIcon == null || !ret.toURI().equals(tableIcon.toURI())) {
                                    ret = Icons.getURL("compare.gif");
                                }
                                break block6;
                            }
                            catch (URISyntaxException uRISyntaxException) {
                                ret = Icons.getURL("compare.gif");
                            }
                            break;
                        }
                        ret = tableIcon;
                        foundIcon = true;
                    }
                }
                ++i;
            }
            return ret;
        }

        public Mode getMode() {
            return this.mode;
        }

        public void setMode(Mode mode) {
            this.mode = mode;
            this.updateColumns();
        }

        private void setFormatter() {
            int i = 1;
            DecimalFormat formatter = new DecimalFormat("+#,##0;-#,##0");
            NumberFormat formatterPercent = NumberFormat.getPercentInstance();
            if (formatterPercent instanceof DecimalFormat) {
                ((DecimalFormat)formatterPercent).setPositivePrefix("+");
            }
            for (ComparedColumn comparedColumn : this.displayedColumns) {
                Column c = comparedColumn.description;
                int j = 0;
                while (j < comparedColumn.getColumnIndexes().length) {
                    if (this.mode != Mode.ABSOLUTE && j > 0) {
                        if (!this.columns[i].getCalculateTotals() && c.getCalculateTotals()) {
                            this.columns[i] = new Column(this.columns[i].getLabel(), this.columns[i].getType(), this.columns[i].getAlign(), this.columns[i].getSortDirection(), this.columns[i].getFormatter(), this.columns[i].getComparator());
                        }
                        if (c.getFormatter() instanceof DecimalFormat) {
                            DecimalFormat fm = (DecimalFormat)c.getFormatter().clone();
                            fm.setPositivePrefix("+");
                            this.columns[i].formatting((Format)fm);
                        } else {
                            this.columns[i].formatting((Format)formatter);
                        }
                    } else {
                        if (!this.columns[i].getCalculateTotals() && c.getCalculateTotals()) {
                            this.columns[i] = new Column(this.columns[i].getLabel(), this.columns[i].getType(), this.columns[i].getAlign(), this.columns[i].getSortDirection(), this.columns[i].getFormatter(), this.columns[i].getComparator());
                        }
                        this.columns[i].formatting(c.getFormatter());
                    }
                    ++i;
                    if ((this.mode == Mode.DIFF_RATIO_TO_FIRST || this.mode == Mode.DIFF_RATIO_TO_PREVIOUS) && j > 0) {
                        this.columns[i].formatting((Format)formatterPercent);
                        this.columns[i].noTotals();
                        ++i;
                    }
                    ++j;
                }
            }
        }

        public void updateColumns() {
            ArrayList<Column> result = new ArrayList<Column>();
            result.add(new Column(this.key.getLabel(), this.key.getType(), this.key.getAlign(), null, this.key.getFormatter(), null));
            this.displayedColumns = new ArrayList<ComparedColumn>();
            for (ComparedColumn comparedColumn : this.comparedColumns) {
                Column c = comparedColumn.description;
                if (!comparedColumn.isDisplayed()) continue;
                this.displayedColumns.add(comparedColumn);
                int j = 0;
                while (j < comparedColumn.getColumnIndexes().length) {
                    int prev = this.mode == Mode.DIFF_TO_PREVIOUS || this.mode == Mode.DIFF_RATIO_TO_PREVIOUS ? j - 1 : 0;
                    String label = j == 0 || this.mode == Mode.ABSOLUTE ? MessageUtil.format((String)Messages.CompareTablesQuery_ColumnAbsolute, (Object[])new Object[]{c.getLabel(), j}) : MessageUtil.format((String)Messages.CompareTablesQuery_ColumnDifference, (Object[])new Object[]{c.getLabel(), j, prev});
                    result.add(new Column(label, c.getType(), c.getAlign(), c.getSortDirection(), c.getFormatter(), null));
                    if (j > 0 && (this.mode == Mode.DIFF_RATIO_TO_FIRST || this.mode == Mode.DIFF_RATIO_TO_PREVIOUS)) {
                        label = MessageUtil.format((String)Messages.CompareTablesQuery_ColumnPercentDifference, (Object[])new Object[]{c.getLabel(), j, prev});
                        result.add(new Column(label, c.getType(), c.getAlign(), c.getSortDirection(), c.getFormatter(), null));
                    }
                    ++j;
                }
            }
            this.columns = result.toArray(new Column[result.size()]);
            this.setFormatter();
        }

        IContextObject getContextFromTable(int i, Object row) {
            if (!CompareTablesQuery.this.sameSnapshot[i]) {
                return null;
            }
            ComparedRow cr = (ComparedRow)row;
            IContextObject ret = null;
            Object r = cr.getRows()[i];
            if (r != null) {
                ret = CompareTablesQuery.this.tables[i].getContext(r);
            }
            return ret;
        }
    }
}

