/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.snapshot.panes.oql.contentAssist;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.snapshot.panes.oql.contentAssist.ContentAssistElement;
import org.eclipse.mat.ui.snapshot.panes.oql.contentAssist.SuggestionProvider;
import org.eclipse.mat.ui.util.ErrorHelper;
import org.eclipse.mat.util.PatternUtil;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassesSuggestionProvider
implements SuggestionProvider {
    boolean ready = false;
    private TreeSet<ContentAssistElement> orderedList;

    public ClassesSuggestionProvider(ISnapshot snapshot) {
        InitializerJob asyncJob = new InitializerJob(snapshot);
        asyncJob.schedule();
    }

    @Override
    public List<ContentAssistElement> getSuggestions(String context) {
        LinkedList<ContentAssistElement> tempList = new LinkedList<ContentAssistElement>();
        boolean foundFirst = false;
        if (this.ready) {
            for (ContentAssistElement cp : this.orderedList) {
                String cName = cp.getClassName();
                if (cName.startsWith(context)) {
                    foundFirst = true;
                    tempList.add(cp);
                    continue;
                }
                if (foundFirst) break;
            }
            if (context.startsWith("\"")) {
                String context2 = context.substring(1);
                if (context2.endsWith("\"")) {
                    context2 = context2.substring(0, context2.length() - 1);
                } else if (context2.endsWith("[")) {
                    context2 = String.valueOf(context2) + "].*";
                } else if (!context2.endsWith(".*")) {
                    context2 = String.valueOf(context2) + ".*";
                }
                context2 = PatternUtil.smartFix((String)context2, (boolean)false);
                try {
                    Pattern p = Pattern.compile(context2);
                    foundFirst = false;
                    for (ContentAssistElement cp : this.orderedList) {
                        String cName = cp.getClassName();
                        if (!p.matcher(cName).matches()) continue;
                        if (!foundFirst) {
                            tempList.add(new ContentAssistElement("\"" + context2 + "\"", null));
                            foundFirst = true;
                        }
                        tempList.add(cp);
                    }
                }
                catch (PatternSyntaxException patternSyntaxException) {}
            }
        }
        return tempList;
    }

    private void initList(ISnapshot snapshot) throws SnapshotException {
        if (snapshot == null) {
            throw new IllegalArgumentException("Cannot extract class list from a null snapshot.");
        }
        Collection classes = snapshot.getClasses();
        this.orderedList = new TreeSet();
        Image im = MemoryAnalyserPlugin.getImage("$nl$/icons/heapobjects/class.gif");
        for (IClass c : classes) {
            ContentAssistElement ce = new ContentAssistElement(c.getName(), im);
            this.orderedList.add(ce);
        }
        this.ready = true;
    }

    private class InitializerJob
    extends Job {
        ISnapshot snapshot;

        public InitializerJob(ISnapshot snapshot) {
            super("Init content assistant");
            this.snapshot = snapshot;
        }

        protected IStatus run(IProgressMonitor arg0) {
            try {
                ClassesSuggestionProvider.this.initList(this.snapshot);
                return Status.OK_STATUS;
            }
            catch (SnapshotException e) {
                ErrorHelper.logThrowable(e);
                return Status.CANCEL_STATUS;
            }
        }
    }
}

