/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.data;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.nebula.widgets.nattable.data.IColumnPropertyAccessor;

public class ReflectiveColumnPropertyAccessor<R>
implements IColumnPropertyAccessor<R> {
    private static final Log LOG = LogFactory.getLog(ReflectiveColumnPropertyAccessor.class);
    private final List<String> propertyNames;
    private Map<Class<?>, Map<String, PropertyDescriptor>> propertyDescriptorMap = new HashMap();

    public ReflectiveColumnPropertyAccessor(String ... propertyNames) {
        this.propertyNames = Arrays.asList(propertyNames);
    }

    public ReflectiveColumnPropertyAccessor(List<String> propertyNames) {
        this.propertyNames = propertyNames;
    }

    @Override
    public int getColumnCount() {
        return this.propertyNames.size();
    }

    @Override
    public Object getDataValue(R rowObj, int columnIndex) {
        try {
            PropertyDescriptor propertyDesc = this.getPropertyDescriptor(rowObj, columnIndex);
            Method readMethod = propertyDesc.getReadMethod();
            return readMethod.invoke(rowObj, new Object[0]);
        }
        catch (Exception e) {
            LOG.warn((Object)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setDataValue(R rowObj, int columnIndex, Object newValue) {
        try {
            PropertyDescriptor propertyDesc = this.getPropertyDescriptor(rowObj, columnIndex);
            Method writeMethod = propertyDesc.getWriteMethod();
            if (writeMethod == null) {
                throw new RuntimeException("Setter method not found in backing bean for value at column index: " + columnIndex);
            }
            writeMethod.invoke(rowObj, newValue);
        }
        catch (IllegalArgumentException ex) {
            LOG.error((Object)"Data type being set does not match the data type of the setter method in the backing bean", (Throwable)ex);
        }
        catch (Exception e) {
            LOG.error((Object)e);
            throw new RuntimeException("Error while setting data value");
        }
    }

    @Override
    public String getColumnProperty(int columnIndex) {
        return this.propertyNames.get(columnIndex);
    }

    @Override
    public int getColumnIndex(String propertyName) {
        return this.propertyNames.indexOf(propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertyDescriptor getPropertyDescriptor(R rowObj, int columnIndex) throws IntrospectionException {
        R r = rowObj;
        synchronized (r) {
            if (!this.propertyDescriptorMap.containsKey(rowObj.getClass())) {
                PropertyDescriptor[] propertyDescriptors = Introspector.getBeanInfo(rowObj.getClass()).getPropertyDescriptors();
                HashMap<String, PropertyDescriptor> propertiesByAttribute = new HashMap<String, PropertyDescriptor>();
                PropertyDescriptor[] propertyDescriptorArray = propertyDescriptors;
                int n = propertyDescriptors.length;
                int n2 = 0;
                while (n2 < n) {
                    PropertyDescriptor propertyDescriptor = propertyDescriptorArray[n2];
                    propertiesByAttribute.put(propertyDescriptor.getName(), propertyDescriptor);
                    ++n2;
                }
                this.propertyDescriptorMap.put(rowObj.getClass(), propertiesByAttribute);
            }
        }
        String propertyName = this.propertyNames.get(columnIndex);
        return this.propertyDescriptorMap.get(rowObj.getClass()).get(propertyName);
    }
}

