/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.filterrow;

import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.editor.ComboBoxCellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.ICellEditor;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.ImagePainter;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.nebula.widgets.nattable.util.ObjectUtils;
import org.eclipse.swt.graphics.Image;

public class FilterIconPainter
extends ImagePainter {
    private Image filterImage;
    private Image removeFilterImage;
    private Image comboImage;

    public FilterIconPainter() {
        this(null, null, null);
    }

    public FilterIconPainter(Image filterImage) {
        this(filterImage, null, null);
    }

    public FilterIconPainter(Image filterImage, Image removeFilterImage, Image comboImage) {
        if (filterImage != null) {
            this.filterImage = filterImage;
        }
        this.removeFilterImage = removeFilterImage != null ? removeFilterImage : GUIHelper.getImage("remove_filter");
        this.comboImage = comboImage != null ? comboImage : GUIHelper.getImage("down_2");
    }

    @Override
    protected Image getImage(ILayerCell cell, IConfigRegistry configRegistry) {
        if (ObjectUtils.isNotNull(cell.getDataValue())) {
            return this.removeFilterImage;
        }
        if (this.filterImage != null) {
            return this.filterImage;
        }
        ICellEditor cellEditor = configRegistry.getConfigAttribute(EditConfigAttributes.CELL_EDITOR, cell.getDisplayMode(), cell.getConfigLabels().getLabels());
        if (ObjectUtils.isNotNull(cellEditor) && cellEditor instanceof ComboBoxCellEditor) {
            return this.comboImage;
        }
        return null;
    }
}

