/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.util.table;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.net4j.internal.util.table.AbstractRange;
import org.eclipse.net4j.internal.util.table.Cell;
import org.eclipse.net4j.internal.util.table.Range;
import org.eclipse.net4j.internal.util.table.Table;
import org.eclipse.net4j.util.Predicates;
import org.eclipse.net4j.util.collection.AbstractIterator;
import org.eclipse.net4j.util.collection.ComposedIterator;
import org.eclipse.net4j.util.collection.PredicateIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ComposedRange
extends AbstractRange {
    final Table table;
    final List<Range> inclusions = new ArrayList<Range>();
    final List<Range> exclusions = new ArrayList<Range>();

    public ComposedRange(ComposedRange source) {
        this.table = source.table;
        this.inclusions.addAll(source.inclusions);
        this.exclusions.addAll(source.exclusions);
    }

    public ComposedRange(Table table, Range ... ranges) {
        this.table = table;
        this.addRanges(ranges);
    }

    @Override
    public Range addRanges(Range ... ranges) {
        ComposedRange.addRanges(this.inclusions, ranges);
        return this;
    }

    @Override
    public Range subtractRanges(Range ... ranges) {
        ComposedRange.addRanges(this.exclusions, ranges);
        return this;
    }

    @Override
    public Table table() {
        return this.table;
    }

    @Override
    public Iterator<Cell> iterator() {
        if (this.inclusions.isEmpty()) {
            return AbstractIterator.empty();
        }
        Iterator iterator = ComposedIterator.fromIterables(this.inclusions);
        if (!this.exclusions.isEmpty()) {
            HashSet<Cell> excludedCells = new HashSet<Cell>();
            for (Range range : this.exclusions) {
                for (Cell cell : range) {
                    excludedCells.add(cell);
                }
            }
            iterator = new PredicateIterator(Predicates.excluded(excludedCells), iterator);
        }
        return new PredicateIterator<Cell>(Predicates.unique(), iterator);
    }

    private static void addRanges(List<Range> list, Range ... ranges) {
        int i = 0;
        while (i < ranges.length) {
            Range range = ranges[i];
            list.add(range);
            ++i;
        }
    }
}

