/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.impactanalyzer.instanceScope.traceback;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.Stack;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.ecore.CallExp;
import org.eclipse.ocl.ecore.IteratorExp;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.ecore.opposites.OppositeEndFinder;
import org.eclipse.ocl.examples.impactanalyzer.PartialEvaluator;
import org.eclipse.ocl.examples.impactanalyzer.PartialEvaluatorFactory;
import org.eclipse.ocl.examples.impactanalyzer.ValueNotFoundException;
import org.eclipse.ocl.examples.impactanalyzer.deltaPropagation.PartialEvaluatorImpl;
import org.eclipse.ocl.examples.impactanalyzer.impl.OperationBodyToCallMapper;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.traceback.AbstractTracebackStep;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.traceback.TracebackCache;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.traceback.TracebackStepCache;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.unusedEvaluation.UnusedEvaluationRequestFactory;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.unusedEvaluation.UnusedEvaluationRequestSet;
import org.eclipse.ocl.examples.impactanalyzer.util.AnnotatedEObject;
import org.eclipse.ocl.examples.impactanalyzer.util.OCLFactory;
import org.eclipse.ocl.examples.impactanalyzer.util.OperationCallExpKeyedSet;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.util.OCLStandardLibraryUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IteratorTracebackStep
extends AbstractTracebackStep<IteratorExp> {
    private final Strategy strategy;
    private final AbstractTracebackStep.TracebackStepAndScopeChange step;
    private final boolean checkPredicate;
    private final boolean acceptIfPredicateTrue;
    private final OppositeEndFinder oppositeEndFinder;
    private final PartialEvaluatorFactory partialEvaluatorFactory;

    public IteratorTracebackStep(IteratorExp sourceExpression, EClass context, OperationBodyToCallMapper operationBodyToCallMapper, Stack<String> tupleLiteralNamesToLookFor, TracebackStepCache tracebackStepCache, UnusedEvaluationRequestFactory unusedEvaluationRequestFactory, OCLFactory oclFactory) {
        super(sourceExpression, tupleLiteralNamesToLookFor, tracebackStepCache.getOppositeEndFinder(), operationBodyToCallMapper, unusedEvaluationRequestFactory, oclFactory);
        this.partialEvaluatorFactory = tracebackStepCache.getInstanceScopeAnalysis().getPartialEvaluatorFactory();
        String name = sourceExpression.getName();
        int opCode = OCLStandardLibraryUtil.getOperationCode((String)name);
        if (opCode == 209 || opCode == 210 || opCode == 211 || opCode == 205) {
            this.strategy = Strategy.PASSTHROUGH;
            this.step = this.createTracebackStepAndScopeChange((OCLExpression)sourceExpression, (OCLExpression)sourceExpression.getSource(), context, operationBodyToCallMapper, tupleLiteralNamesToLookFor, tracebackStepCache);
            if (opCode == 209 || opCode == 210 || opCode == 205) {
                Variable varDecl = (Variable)sourceExpression.getIterator().get(0);
                this.requiredType = this.getInnermostTypeConsideringTupleLiteralsLookedFor(tupleLiteralNamesToLookFor, (EClassifier)varDecl.getType());
                this.acceptIfPredicateTrue = opCode == 209 || opCode == 205;
                this.checkPredicate = true;
                this.oppositeEndFinder = tracebackStepCache.getOppositeEndFinder();
            } else {
                this.requiredType = null;
                this.checkPredicate = false;
                this.acceptIfPredicateTrue = false;
                this.oppositeEndFinder = null;
            }
        } else if (opCode == 206 || opCode == 207 || opCode == 208) {
            this.strategy = Strategy.MAP;
            this.requiredType = null;
            this.checkPredicate = false;
            this.acceptIfPredicateTrue = false;
            this.step = this.createTracebackStepAndScopeChange((OCLExpression)sourceExpression, (OCLExpression)sourceExpression.getBody(), context, operationBodyToCallMapper, tupleLiteralNamesToLookFor, tracebackStepCache);
            this.oppositeEndFinder = null;
        } else {
            this.strategy = Strategy.EMPTY;
            this.requiredType = null;
            this.checkPredicate = false;
            this.acceptIfPredicateTrue = false;
            this.step = null;
            this.oppositeEndFinder = null;
        }
    }

    @Override
    protected OperationCallExpKeyedSet performSubsequentTraceback(AnnotatedEObject source, UnusedEvaluationRequestSet pendingUnusedEvalRequests, TracebackCache tracebackCache, Notification changeEvent) {
        switch (this.strategy) {
            case EMPTY: {
                return tracebackCache.getOperationCallExpKeyedSetFactory().emptySet();
            }
            case MAP: {
                return this.step.traceback(this.annotateEObject(source), pendingUnusedEvalRequests, tracebackCache, changeEvent);
            }
            case PASSTHROUGH: {
                boolean passedPredicate;
                boolean bl = passedPredicate = !this.checkPredicate || this.evaluatePredicate(source.getAnnotatedObject(), changeEvent);
                if (passedPredicate) {
                    return this.step.traceback(this.annotateEObject(source), pendingUnusedEvalRequests, tracebackCache, changeEvent);
                }
                return tracebackCache.getOperationCallExpKeyedSetFactory().emptySet();
            }
        }
        throw new RuntimeException("Internal error: unknown traceback strategy " + (Object)((Object)this.strategy));
    }

    private boolean evaluatePredicate(EObject sourceObject, Notification atPre) {
        Set<EObject> sourceCollection = Collections.singleton(sourceObject);
        boolean resultPre = this.acceptIfPredicateTrue;
        if (atPre != null) {
            PartialEvaluatorImpl evalPre = new PartialEvaluatorImpl(atPre, this.oppositeEndFinder, this.oclFactory);
            try {
                Object result = evalPre.evaluate(null, (CallExp)this.getExpression(), sourceCollection);
                resultPre = this.isSourceInResult(sourceObject, result);
            }
            catch (ValueNotFoundException vnfe) {
                resultPre = this.acceptIfPredicateTrue;
            }
            catch (ClassCastException cce) {
                throw new RuntimeException("The result of the iterator expression's body is not of type Boolean.");
            }
        }
        boolean resultPost = this.acceptIfPredicateTrue;
        if (atPre == null || resultPre != this.acceptIfPredicateTrue) {
            PartialEvaluator evalPost = this.partialEvaluatorFactory.createPartialEvaluator(this.oppositeEndFinder, this.oclFactory);
            try {
                Object result = evalPost.evaluate(null, (CallExp)this.getExpression(), sourceCollection);
                resultPost = this.isSourceInResult(sourceObject, result);
            }
            catch (ValueNotFoundException vnfe) {
                resultPost = this.acceptIfPredicateTrue;
            }
            catch (ClassCastException cce) {
                throw new RuntimeException("The result of the iterator expression's body is not of type Boolean.");
            }
        }
        return atPre != null && resultPre == this.acceptIfPredicateTrue || resultPost == this.acceptIfPredicateTrue;
    }

    private boolean isSourceInResult(EObject sourceObject, Object result) {
        boolean resultPost = result instanceof Collection ? (((Collection)result).isEmpty() ? false : ((Collection)result).contains(sourceObject)) : result == sourceObject;
        return resultPost;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Strategy {
        EMPTY,
        MAP,
        PASSTHROUGH;

    }
}

