/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.predicates.impl;

import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.oomph.predicates.CommentPredicate;
import org.eclipse.oomph.predicates.PredicatesPackage;
import org.eclipse.oomph.predicates.impl.PredicateImpl;

public class CommentPredicateImpl
extends PredicateImpl
implements CommentPredicate {
    protected static final String PATTERN_EDEFAULT = null;
    protected String pattern = PATTERN_EDEFAULT;
    private Pattern compiledPattern;

    protected CommentPredicateImpl() {
    }

    protected EClass eStaticClass() {
        return PredicatesPackage.Literals.COMMENT_PREDICATE;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPatternGen(String newPattern) {
        String oldPattern = this.pattern;
        this.pattern = newPattern;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldPattern, (Object)this.pattern));
        }
    }

    public void setPattern(String newPattern) {
        this.setPatternGen(newPattern);
        this.compiledPattern = null;
    }

    private Pattern getCompiledPattern() {
        if (this.compiledPattern == null) {
            this.compiledPattern = this.getPattern(this.getPattern());
        }
        return this.compiledPattern;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.getPattern();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.setPattern((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.setPattern(PATTERN_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return PATTERN_EDEFAULT == null ? this.pattern != null : !PATTERN_EDEFAULT.equals(this.pattern);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (pattern: ");
        result.append(this.pattern);
        result.append(')');
        return result.toString();
    }

    public boolean matches(IResource resource) {
        if (resource != null) {
            try {
                IProject project = resource.getProject();
                IProjectDescription description = project.getDescription();
                if (description != null) {
                    String comment = description.getComment();
                    return comment != null && this.getCompiledPattern().matcher(comment).matches();
                }
            }
            catch (CoreException coreException) {}
        }
        return false;
    }
}

