/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.architecture.preferences;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.papyrus.infra.architecture.ArchitectureDomainManager;
import org.eclipse.papyrus.infra.architecture.ArchitectureDomainMerger;
import org.eclipse.papyrus.infra.architecture.ArchitectureDomainPreferences;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedADElement;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureContext;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureDomain;
import org.eclipse.papyrus.infra.ui.architecture.preferences.ArchitectureModelSelectDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;

public class ArchitectureContextPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String PAGE_ID = ArchitectureContextPreferencePage.class.getName();
    private static final StyledString.Styler BOLD_FONT_STYLER = new StyledString.Styler(){

        public void applyStyles(TextStyle textStyle) {
            Font boldFont;
            FontDescriptor boldDescriptor = FontDescriptor.createFrom((FontData)new FontData()).setStyle(3);
            textStyle.font = boldFont = boldDescriptor.createFont((Device)Display.getCurrent());
        }
    };
    private CheckboxTreeViewer fContextsViewer;
    private ListViewer fDescription;
    private ComposedAdapterFactory fComposedAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private Button fOtherButton;
    private Button fDefaultButton;
    ArchitectureDomainMerger fMerger = ArchitectureDomainManager.getInstance().getMerger().clone();
    ArchitectureDomainPreferences fPreferences = ArchitectureDomainManager.getInstance().getPreferences().clone();

    public Control createContents(Composite parent) {
        Composite container = ArchitectureContextPreferencePage.createComposite(parent, 1, 1, 1808, 0, 0);
        this.createArchitectureContextsGroup(container);
        Dialog.applyDialogFont((Control)container);
        return container;
    }

    private void createArchitectureContextsGroup(Composite container) {
        Composite comp = ArchitectureContextPreferencePage.createComposite(container, 1, 1, 1808, 0, 0);
        ((GridData)comp.getLayoutData()).widthHint = 350;
        ArchitectureContextPreferencePage.createWrapLabel(comp, "Select the architecture contexts that can be applied to Papyrus models:", 2);
        ArchitectureContextPreferencePage.createVerticalSpacer(comp, 1);
        Composite tableComposite = ArchitectureContextPreferencePage.createComposite(comp, 2, 1, 1808, 0, 0);
        ArchitectureContextPreferencePage.createLabel(tableComposite, "Architecture Contexts:", 2);
        this.fContextsViewer = new ContainerCheckedTreeViewer(tableComposite, 2050);
        GridData gd = new GridData(1808);
        gd.heightHint = 250;
        this.fContextsViewer.getControl().setLayoutData((Object)gd);
        AdapterFactoryLabelProvider.StyledLabelProvider labelProvider = new AdapterFactoryLabelProvider.StyledLabelProvider((AdapterFactory)this.fComposedAdapterFactory, (Viewer)this.fContextsViewer){

            public StyledString getStyledText(Object object) {
                MergedArchitectureContext context;
                MergedADElement element = (MergedADElement)object;
                if (element instanceof MergedArchitectureContext && (context = (MergedArchitectureContext)element).getId() != null && context.getId().equals(ArchitectureContextPreferencePage.this.fPreferences.getDefaultContextId())) {
                    return new StyledString(element.getName(), BOLD_FONT_STYLER);
                }
                return new StyledString(element.getName());
            }

            public Image getImage(Object object) {
                MergedADElement element = (MergedADElement)object;
                return super.getImage(element.getImageObject());
            }
        };
        this.fContextsViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public boolean hasChildren(Object element) {
                if (element instanceof MergedArchitectureDomain) {
                    return !((MergedArchitectureDomain)element).getContexts().isEmpty();
                }
                return false;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getElements(Object inputElement) {
                Collection domains = ((ArchitectureDomainMerger)inputElement).getDomains();
                return domains.toArray();
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof MergedArchitectureDomain) {
                    Collection contexts = ((MergedArchitectureDomain)parentElement).getContexts();
                    return contexts.toArray();
                }
                return null;
            }
        });
        this.fContextsViewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)labelProvider));
        this.fContextsViewer.setComparator(new ViewerComparator((DelegatingStyledCellLabelProvider.IStyledLabelProvider)labelProvider){
            private final /* synthetic */ DelegatingStyledCellLabelProvider.IStyledLabelProvider val$labelProvider;
            {
                this.val$labelProvider = iStyledLabelProvider;
            }

            public int compare(Viewer viewer, Object e1, Object e2) {
                String name1 = this.val$labelProvider.getStyledText(e1).getString();
                String name2 = this.val$labelProvider.getStyledText(e2).getString();
                return this.getComparator().compare(name1, name2);
            }
        });
        this.fContextsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ArchitectureContextPreferencePage.this.updateButtons();
                ArchitectureContextPreferencePage.this.updateDetails();
            }
        });
        this.fContextsViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return false;
            }

            public boolean isChecked(Object element) {
                if (element instanceof MergedArchitectureContext) {
                    return !ArchitectureContextPreferencePage.this.fPreferences.getExcludedContextIds().contains(((MergedArchitectureContext)element).getId());
                }
                return ArchitectureContextPreferencePage.this.fContextsViewer.getChecked(element);
            }
        });
        this.fContextsViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Collection<Object> contexts = null;
                contexts = event.getElement() instanceof MergedArchitectureContext ? Collections.singletonList((MergedArchitectureContext)event.getElement()) : ((MergedArchitectureDomain)event.getElement()).getContexts();
                for (MergedArchitectureContext mergedArchitectureContext : contexts) {
                    if (!event.getChecked()) {
                        ArchitectureContextPreferencePage.this.fPreferences.getExcludedContextIds().add(mergedArchitectureContext.getId());
                        continue;
                    }
                    ArchitectureContextPreferencePage.this.fPreferences.getExcludedContextIds().remove(mergedArchitectureContext.getId());
                }
            }
        });
        this.fContextsViewer.setInput((Object)this.fMerger);
        this.fContextsViewer.expandAll();
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.fContextsViewer, (int)2);
        Composite buttonComposite = ArchitectureContextPreferencePage.createComposite(tableComposite, 1, 1, 1042, 0, 0);
        ArchitectureContextPreferencePage.createVerticalSpacer(buttonComposite, 1);
        this.fOtherButton = ArchitectureContextPreferencePage.createPushButton(buttonComposite, "Other Architecture Models...", null, 8);
        this.fOtherButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArchitectureContextPreferencePage.this.handleOther();
            }
        });
        this.fDefaultButton = ArchitectureContextPreferencePage.createPushButton(buttonComposite, "Make Default", null, 8);
        this.fDefaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArchitectureContextPreferencePage.this.handleDefault();
            }
        });
        this.updateButtons();
        Composite descriptionComposite = ArchitectureContextPreferencePage.createComposite(comp, 1, 1, 768, 0, 0);
        ArchitectureContextPreferencePage.createLabel(descriptionComposite, "Description:", 1);
        this.fDescription = new ListViewer(descriptionComposite);
        gd = new GridData(768);
        gd.heightHint = 50;
        this.fDescription.getControl().setLayoutData((Object)gd);
        this.fDescription.setContentProvider((IContentProvider)new IStructuredContentProvider(){
            private Object input;

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                this.input = newInput;
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return new Object[]{this.input};
            }
        });
        this.fDescription.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((MergedADElement)element).getDescription();
            }
        });
    }

    private void handleOther() {
        ArchitectureModelSelectDialog dialog = new ArchitectureModelSelectDialog(this.getShell(), "File Selection", this.fPreferences.getAddedModelURIs().toArray(new String[0]));
        dialog.open();
        List<URI> files = dialog.getURIs();
        this.fPreferences.getAddedModelURIs().clear();
        for (URI file : files) {
            this.fPreferences.getAddedModelURIs().add(file.toString());
        }
        this.fMerger.setPreferenceModels(files);
        this.fContextsViewer.refresh();
        this.fContextsViewer.expandAll();
    }

    protected void handleDefault() {
        IStructuredSelection selection = (IStructuredSelection)this.fContextsViewer.getSelection();
        MergedArchitectureContext selected = (MergedArchitectureContext)selection.getFirstElement();
        this.fPreferences.setDefaultContextId(selected.getId());
        this.fContextsViewer.refresh();
    }

    protected void updateButtons() {
        MergedADElement selected;
        IStructuredSelection selection = (IStructuredSelection)this.fContextsViewer.getSelection();
        if (selection.size() == 1 && (selected = (MergedADElement)selection.getFirstElement()) instanceof MergedArchitectureContext) {
            this.fDefaultButton.setEnabled(true);
            return;
        }
        this.fDefaultButton.setEnabled(false);
        this.fDefaultButton.setSelection(false);
    }

    protected void updateDetails() {
        IStructuredSelection selection = (IStructuredSelection)this.fContextsViewer.getSelection();
        if (selection.size() == 1) {
            MergedADElement selected = (MergedADElement)selection.getFirstElement();
            this.fDescription.setInput((Object)selected);
        } else {
            this.fDescription.setInput(null);
        }
    }

    public void init(IWorkbench workbench) {
    }

    public void performDefaults() {
        this.fPreferences.reset();
        this.fContextsViewer.refresh();
    }

    public boolean performOk() {
        this.fPreferences.write();
        return true;
    }

    private static Composite createComposite(Composite parent, int columns, int hspan, int fill, int marginwidth, int marginheight) {
        Composite g = new Composite(parent, 0);
        GridLayout layout = new GridLayout(columns, false);
        layout.marginWidth = marginwidth;
        layout.marginHeight = marginheight;
        g.setLayout((Layout)layout);
        g.setFont(parent.getFont());
        GridData gd = new GridData(fill);
        gd.horizontalSpan = hspan;
        g.setLayoutData((Object)gd);
        return g;
    }

    private static Label createLabel(Composite parent, String text, int hspan) {
        Label l = new Label(parent, 0);
        l.setFont(parent.getFont());
        l.setText(text);
        GridData gd = new GridData(768);
        gd.horizontalSpan = hspan;
        gd.grabExcessHorizontalSpace = false;
        l.setLayoutData((Object)gd);
        return l;
    }

    private static Label createWrapLabel(Composite parent, String text, int hspan) {
        Label l = new Label(parent, 64);
        l.setFont(parent.getFont());
        l.setText(text);
        GridData gd = new GridData(768);
        gd.horizontalSpan = hspan;
        l.setLayoutData((Object)gd);
        return l;
    }

    private static void createVerticalSpacer(Composite parent, int numlines) {
        Label lbl = new Label(parent, 0);
        GridData gd = new GridData(768);
        Layout layout = parent.getLayout();
        if (layout instanceof GridLayout) {
            gd.horizontalSpan = ((GridLayout)parent.getLayout()).numColumns;
        }
        gd.heightHint = numlines;
        lbl.setLayoutData((Object)gd);
    }

    private static Button createPushButton(Composite parent, String label, Image image, int style) {
        Button button = new Button(parent, style);
        button.setFont(parent.getFont());
        if (image != null) {
            button.setImage(image);
        }
        if (label != null) {
            button.setText(label);
        }
        GridData gd = new GridData();
        button.setLayoutData((Object)gd);
        ArchitectureContextPreferencePage.setButtonDimensionHint(button);
        return button;
    }

    private static void setButtonDimensionHint(Button button) {
        Assert.isNotNull((Object)button);
        Object gd = button.getLayoutData();
        if (gd instanceof GridData) {
            ((GridData)gd).widthHint = ArchitectureContextPreferencePage.getButtonWidthHint(button);
            ((GridData)gd).horizontalAlignment = 4;
        }
    }

    private static int getButtonWidthHint(Button button) {
        button.setFont(JFaceResources.getDialogFont());
        PixelConverter converter = new PixelConverter((Control)button);
        int widthHint = converter.convertHorizontalDLUsToPixels(61);
        return Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }
}

