/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.ui.dialogs;

import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.ui.dialogs.ComboInputDialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class ComboDialogWithMessage
extends ComboInputDialog {
    private CLabel warningMessageText;
    private String warningMessage;
    private static final String ICON_WARNING = "/icons/warning.gif";

    protected ComboDialogWithMessage(Shell parentShell, String title, String message, String initialValue, String[] elementsList, String warningMessage) {
        super(parentShell, title, message, initialValue, elementsList);
        this.warningMessage = warningMessage;
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        if (this.getElementList() == null || this.getElementList().length == 1 && this.getElementList()[0].equals("")) {
            this.warningMessageText = new CLabel(composite, 72);
            this.warningMessageText.setLayoutData((Object)new GridData(768));
            this.warningMessageText.setBackground(this.warningMessageText.getDisplay().getSystemColor(22));
            this.setWarningMessage(this.warningMessage);
        }
        ComboDialogWithMessage.applyDialogFont((Control)composite);
        return composite;
    }

    public void setWarningMessage(String warningMessage) {
        this.warningMessage = warningMessage;
        if (this.warningMessageText != null && !this.warningMessageText.isDisposed()) {
            Image errorImage = Activator.getPluginIconImage("org.eclipse.papyrus.uml.diagram.common", ICON_WARNING);
            this.warningMessageText.setImage(warningMessage == null ? null : errorImage);
            this.warningMessageText.setText(warningMessage == null ? "" : warningMessage);
            this.warningMessageText.getParent().update();
            Button button = this.getButton(0);
            if (button != null) {
                button.setEnabled(warningMessage == null);
            }
        }
    }

    protected int getInputTextStyle() {
        return 2052;
    }
}

