/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.edit.policies;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ConstrainedToolbarLayoutEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.NonResizableEditPolicyEx;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.FigureUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.edit.commands.RefreshCommandForDo;
import org.eclipse.papyrus.uml.diagram.timing.custom.edit.commands.RefreshCommandForUndo;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.ViewUtils;

public class GenericListCompartmentLayoutEditPolicy
extends ConstrainedToolbarLayoutEditPolicy {
    private static final int LAYOUT_FEEDBACK_HEIGHT = 4;
    private static final int MARGIN_BEFORE_FIRST = 4;
    private static final int MARGIN_AFTER_LAST = 4;
    protected IFigure layoutFeedbackFigure = null;

    protected GraphicalEditPart getEditPartToRefresh() {
        return (GraphicalEditPart)this.getHost();
    }

    protected int getLayoutFeedbackHeight() {
        return 4;
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        EditPolicy result = child.getEditPolicy((Object)"PrimaryDrag Policy");
        if (result == null) {
            result = new NonResizableEditPolicyEx();
        }
        return result;
    }

    protected Command getMoveChildrenCommand(Request request) {
        if (request instanceof ChangeBoundsRequest) {
            ChangeBoundsRequest changeBoundsRequest = (ChangeBoundsRequest)request;
            InsertionPoint insertionPoint = this.computeClosestInsertionPoint(changeBoundsRequest.getLocation().y);
            if (insertionPoint == null) {
                return UnexecutableCommand.INSTANCE;
            }
            GraphicalEditPart hostEditPart = (GraphicalEditPart)this.getHost();
            View compartmentView = (View)hostEditPart.getModel();
            List editParts = changeBoundsRequest.getEditParts();
            for (EditPart editPart : editParts) {
                if (!(editPart instanceof GraphicalEditPart)) continue;
                GraphicalEditPart graphicalEditPart = (GraphicalEditPart)editPart;
                View view = (View)graphicalEditPart.getModel();
                GraphicalEditPart editPartToRefresh = this.getEditPartToRefresh();
                CompoundCommand compoundCommand = new CompoundCommand();
                compoundCommand.add((Command)new RefreshCommandForUndo(editPartToRefresh));
                compoundCommand.add((Command)new ICommandProxy(ViewUtils.getMoveViewCommand(compartmentView, view, insertionPoint.getIndex())));
                compoundCommand.add((Command)new RefreshCommandForDo(editPartToRefresh));
                return compoundCommand;
            }
        }
        return null;
    }

    protected void showLayoutTargetFeedback(Request request) {
        if (request instanceof ChangeBoundsRequest) {
            this.eraseLayoutTargetFeedback();
            ChangeBoundsRequest changeBoundsRequest = (ChangeBoundsRequest)request;
            InsertionPoint insertionPoint = this.computeClosestInsertionPoint(changeBoundsRequest.getLocation().y);
            if (insertionPoint == null) {
                return;
            }
            Rectangle containerBounds = new Rectangle(this.getHostFigure().getBounds());
            this.getHostFigure().translateToAbsolute((Translatable)containerBounds);
            int layoutFeedbackHeight = this.getLayoutFeedbackHeight();
            Rectangle feedbackBounds = new Rectangle(containerBounds.x, insertionPoint.getLocation() - layoutFeedbackHeight / 2, containerBounds.width, layoutFeedbackHeight);
            Point origin = FigureUtils.getLayeredPaneOrigin((IFigure)this.getHostFigure());
            feedbackBounds.translate(origin);
            double scale = FigureUtils.getScale((IFigure)this.getHostFigure());
            feedbackBounds.width = (int)((double)feedbackBounds.width * scale);
            feedbackBounds.height = (int)((double)feedbackBounds.height * scale);
            this.layoutFeedbackFigure = this.createLayoutTargetFeedbackFigure(feedbackBounds);
        }
    }

    protected InsertionPoint computeClosestInsertionPoint(int offset) {
        List children = this.getHost().getChildren();
        if (children.isEmpty()) {
            return null;
        }
        List<InsertionPoint> insertionPoints = this.computeInsertionPoints(children);
        TreeMap<Integer, InsertionPoint> distanceMap = new TreeMap<Integer, InsertionPoint>();
        for (InsertionPoint insertionPoint : insertionPoints) {
            int distance = Math.abs(offset - insertionPoint.getLocation());
            distanceMap.put(distance, insertionPoint);
        }
        return (InsertionPoint)distanceMap.values().iterator().next();
    }

    protected int getMarginBeforeFirst() {
        return 4;
    }

    protected int getMarginAfterLast() {
        return 4;
    }

    protected List<InsertionPoint> computeInsertionPoints(List<GraphicalEditPart> children) {
        int size = children.size();
        ArrayList<InsertionPoint> insertionPoints = new ArrayList<InsertionPoint>();
        Rectangle previousBounds = null;
        int i = 0;
        while (i < size) {
            GraphicalEditPart childEditPart = children.get(i);
            Rectangle bounds = new Rectangle(childEditPart.getFigure().getBounds());
            this.getHostFigure().translateToAbsolute((Translatable)bounds);
            if (previousBounds != null) {
                insertionPoints.add(new InsertionPoint(i, (previousBounds.y + previousBounds.height + bounds.y) / 2));
            } else {
                insertionPoints.add(new InsertionPoint(i, bounds.y - this.getMarginBeforeFirst()));
            }
            if (i == size - 1) {
                insertionPoints.add(new InsertionPoint(i + 1, bounds.y + bounds.height + this.getMarginAfterLast()));
            }
            previousBounds = bounds;
            ++i;
        }
        return insertionPoints;
    }

    protected IFigure createLayoutTargetFeedbackFigure(Rectangle bounds) {
        RectangleFigure r = new RectangleFigure();
        r.setForegroundColor(ColorConstants.darkBlue);
        r.setBackgroundColor(ColorConstants.lightBlue);
        r.setBounds(bounds);
        r.validate();
        this.addFeedback((IFigure)r);
        return r;
    }

    protected void eraseLayoutTargetFeedback(Request request) {
        this.eraseLayoutTargetFeedback();
    }

    protected void eraseLayoutTargetFeedback() {
        if (this.layoutFeedbackFigure != null) {
            this.removeFeedback(this.layoutFeedbackFigure);
            this.layoutFeedbackFigure = null;
        }
    }

    protected Command getCreateCommand(CreateRequest request) {
        return null;
    }

    protected class InsertionPoint {
        int index;
        int location;

        public InsertionPoint(int index, int location) {
            this.index = index;
            this.location = location;
        }

        public int getIndex() {
            return this.index;
        }

        public int getLocation() {
            return this.location;
        }
    }
}

