/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.match.ASTMatcher;
import org.eclipse.php.core.ast.nodes.AST;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.ChildPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.Expression;
import org.eclipse.php.core.ast.nodes.SimplePropertyDescriptor;
import org.eclipse.php.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.core.ast.visitor.Visitor;

public class ConditionalExpression
extends Expression {
    public static final int OP_TERNARY = 0;
    public static final int OP_COALESCE = 1;
    private Expression condition;
    private Expression ifTrue;
    private Expression ifFalse;
    private int operatorType;
    public static final ChildPropertyDescriptor CONDITION_PROPERTY = new ChildPropertyDescriptor(ConditionalExpression.class, "condition", Expression.class, true, true);
    public static final ChildPropertyDescriptor IF_TRUE_PROPERTY = new ChildPropertyDescriptor(ConditionalExpression.class, "ifTrue", Expression.class, false, true);
    public static final ChildPropertyDescriptor IF_FALSE_PROPERTY = new ChildPropertyDescriptor(ConditionalExpression.class, "ifFalse", Expression.class, true, true);
    public static final SimplePropertyDescriptor OPERATOR_TYPE_PROPERTY = new SimplePropertyDescriptor(ConditionalExpression.class, "operatorType", Integer.class, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<StructuralPropertyDescriptor> list = new ArrayList<StructuralPropertyDescriptor>(3);
        list.add(CONDITION_PROPERTY);
        list.add(IF_TRUE_PROPERTY);
        list.add(IF_FALSE_PROPERTY);
        list.add(OPERATOR_TYPE_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(list);
    }

    public ConditionalExpression(AST ast) {
        super(ast);
    }

    public ConditionalExpression(int start, int end, AST ast, Expression condition, Expression ifTrue, Expression ifFalse) {
        super(start, end, ast);
        if (condition == null || ast.apiLevel().isLessThan(PHPVersion.PHP5_3) && ifTrue == null || ifFalse == null) {
            throw new IllegalArgumentException();
        }
        this.setCondition(condition);
        this.setIfTrue(ifTrue);
        this.setIfFalse(ifFalse);
        this.operatorType = 0;
    }

    public ConditionalExpression(int start, int end, AST ast, Expression expression, Expression ifNull) {
        super(start, end, ast);
        if (expression == null || ast.apiLevel().isLessThan(PHPVersion.PHP7_0) || ifNull == null) {
            throw new IllegalArgumentException();
        }
        this.setCondition(expression);
        this.setIfTrue(ifNull);
        this.setIfFalse(null);
        this.operatorType = 1;
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        this.condition.accept(visitor);
        if (this.ifTrue != null) {
            this.ifTrue.accept(visitor);
        }
        if (this.ifFalse != null) {
            this.ifFalse.accept(visitor);
        }
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.condition.traverseTopDown(visitor);
        if (this.ifTrue != null) {
            this.ifTrue.traverseTopDown(visitor);
        }
        if (this.ifFalse != null) {
            this.ifFalse.traverseTopDown(visitor);
        }
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        this.condition.traverseBottomUp(visitor);
        if (this.ifTrue != null) {
            this.ifTrue.traverseBottomUp(visitor);
        }
        if (this.ifFalse != null) {
            this.ifFalse.traverseBottomUp(visitor);
        }
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<ConditionalExpression");
        this.appendInterval(buffer);
        buffer.append(" operatorType='" + this.operatorType + "'");
        buffer.append(">\n");
        buffer.append("\t").append(tab).append("<Condition>\n");
        this.condition.toString(buffer, "\t\t" + tab);
        buffer.append("\n").append("\t").append(tab).append("</Condition>\n");
        if (this.operatorType == 0) {
            if (this.ifTrue != null) {
                buffer.append("\t").append(tab).append("<IfTrue>\n");
                this.ifTrue.toString(buffer, "\t\t" + tab);
                buffer.append("\n").append("\t").append(tab).append("</IfTrue>\n");
            }
            if (this.ifFalse != null) {
                buffer.append("\t").append(tab).append("<IfFalse>\n");
                this.ifFalse.toString(buffer, "\t\t" + tab);
                buffer.append("\n").append("\t").append(tab).append("</IfFalse>\n");
            }
        } else if (this.operatorType == 1) {
            buffer.append("\t").append(tab).append("<IfNull>\n");
            this.ifTrue.toString(buffer, "\t\t" + tab);
            buffer.append("\n").append("\t").append(tab).append("</IfNull>\n");
        }
        buffer.append(tab).append("</ConditionalExpression>");
    }

    @Override
    public int getType() {
        return 17;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public void setCondition(Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException();
        }
        Expression oldChild = this.condition;
        this.preReplaceChild(oldChild, expression, CONDITION_PROPERTY);
        this.condition = expression;
        this.postReplaceChild(oldChild, expression, CONDITION_PROPERTY);
    }

    public Expression getIfTrue() {
        return this.ifTrue;
    }

    public void setIfTrue(Expression expression) {
        if (this.ast.apiLevel().isLessThan(PHPVersion.PHP5_3) && expression == null) {
            throw new IllegalArgumentException();
        }
        Expression oldChild = this.ifTrue;
        this.preReplaceChild(oldChild, expression, IF_TRUE_PROPERTY);
        this.ifTrue = expression;
        this.postReplaceChild(oldChild, expression, IF_TRUE_PROPERTY);
    }

    public Expression getIfFalse() {
        if (this.getOperatorType() == 1) {
            return this.condition;
        }
        return this.ifFalse;
    }

    public void setIfFalse(Expression expression) {
        if (expression == null && this.ast.apiLevel().isLessThan(PHPVersion.PHP7_0)) {
            throw new IllegalArgumentException();
        }
        Expression oldChild = this.ifFalse;
        this.preReplaceChild(oldChild, expression, IF_FALSE_PROPERTY);
        this.ifFalse = expression;
        this.postReplaceChild(oldChild, expression, IF_FALSE_PROPERTY);
    }

    public void setOperatorType(int operatorType) {
        this.preValueChange(OPERATOR_TYPE_PROPERTY);
        this.operatorType = operatorType;
        this.postValueChange(OPERATOR_TYPE_PROPERTY);
    }

    public int getOperatorType() {
        return this.operatorType;
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == CONDITION_PROPERTY) {
            if (get) {
                return this.getCondition();
            }
            this.setCondition((Expression)child);
            return null;
        }
        if (property == IF_TRUE_PROPERTY) {
            if (get) {
                return this.getIfTrue();
            }
            this.setIfTrue((Expression)child);
            return null;
        }
        if (property == IF_FALSE_PROPERTY) {
            if (get) {
                return this.getIfFalse();
            }
            this.setIfFalse((Expression)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    final int internalGetSetIntProperty(SimplePropertyDescriptor property, boolean get, int value) {
        if (property == OPERATOR_TYPE_PROPERTY) {
            if (get) {
                return this.getOperatorType();
            }
            this.setOperatorType(value);
            return 0;
        }
        return super.internalGetSetIntProperty(property, get, value);
    }

    @Override
    ASTNode clone0(AST target) {
        Expression condition = ASTNode.copySubtree(target, this.getCondition());
        Expression ifTrue = ASTNode.copySubtree(target, this.getIfTrue());
        Expression ifFalse = ASTNode.copySubtree(target, this.getIfTrue());
        if (this.operatorType == 0) {
            return new ConditionalExpression(this.getStart(), this.getEnd(), target, condition, ifTrue, ifFalse);
        }
        return new ConditionalExpression(this.getStart(), this.getEnd(), target, condition, ifTrue);
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }
}

