/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.codeassist.ICompletionReporter;
import org.eclipse.php.core.codeassist.IElementFilter;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.codeassist.contexts.AbstractCompletionContext;
import org.eclipse.php.internal.core.codeassist.contexts.GlobalMethodStatementContext;
import org.eclipse.php.internal.core.codeassist.strategies.GlobalElementStrategy;
import org.eclipse.php.internal.core.language.PHPVariables;
import org.eclipse.php.internal.core.typeinference.FakeField;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;

public class LocalMethodVariablesStrategy
extends GlobalElementStrategy {
    private static final String THIS = "$this";

    public LocalMethodVariablesStrategy(ICompletionContext context, IElementFilter elementFilter) {
        super(context, elementFilter);
    }

    public LocalMethodVariablesStrategy(ICompletionContext context) {
        super(context);
    }

    @Override
    public void apply(ICompletionReporter reporter) throws BadLocationException, ModelException {
        ICompletionContext context = this.getContext();
        if (!(context instanceof GlobalMethodStatementContext)) {
            return;
        }
        GlobalMethodStatementContext concreteContext = (GlobalMethodStatementContext)context;
        CompletionRequestor requestor = concreteContext.getCompletionRequestor();
        String prefix = concreteContext.getPrefix();
        String suffix = this.getSuffix(concreteContext);
        ISourceRange replaceRange = null;
        replaceRange = suffix.equals("") ? this.getReplacementRange(concreteContext) : this.getReplacementRangeWithBraces(concreteContext);
        replaceRange = this.getReplacementRange(context);
        IMethod enclosingMethod = concreteContext.getEnclosingMethod();
        if (!PHPFlags.isStatic((int)enclosingMethod.getFlags())) {
            IMethod method;
            IType declaringType = enclosingMethod.getDeclaringType();
            if (declaringType != null) {
                if (THIS.startsWith(prefix)) {
                    reporter.reportField((IField)new FakeField((ModelElement)declaringType, THIS, 0, 0), suffix, replaceRange, false, 100);
                }
            } else if (enclosingMethod.getParent() instanceof IField && concreteContext.getPHPVersion().isGreaterThan(PHPVersion.PHP5_3) && (method = (IMethod)enclosingMethod.getParent().getAncestor(9)) != null && (declaringType = method.getDeclaringType()) != null && THIS.startsWith(prefix)) {
                reporter.reportField((IField)new FakeField((ModelElement)declaringType, THIS, 0, 0), suffix, replaceRange, false, 100);
            }
        }
        IModelElement[] iModelElementArray = PHPModelUtils.getMethodFields(enclosingMethod, prefix, requestor.isContextInformationMode(), null);
        int n = iModelElementArray.length;
        int method = 0;
        while (method < n) {
            IModelElement element = iModelElementArray[method];
            reporter.reportField((IField)element, "", replaceRange, false, 100);
            ++method;
        }
        PHPVersion phpVersion = concreteContext.getPHPVersion();
        String[] stringArray = PHPVariables.getVariables(phpVersion, PHPVariables.SUPER_GLOBAL);
        int n2 = stringArray.length;
        n = 0;
        while (n < n2) {
            String variable = stringArray[n];
            if (variable.startsWith(prefix) && (!requestor.isContextInformationMode() || variable.length() == prefix.length())) {
                reporter.reportField((IField)new FakeField((ModelElement)concreteContext.getSourceModule(), variable, 0, 0), "", replaceRange, false, -100);
            }
            ++n;
        }
    }

    public String getSuffix(AbstractCompletionContext abstractContext) {
        String nextWord = null;
        try {
            nextWord = abstractContext.getNextWord();
        }
        catch (BadLocationException e) {
            PHPCorePlugin.log(e);
        }
        return "->".equals(nextWord) ? "" : "->";
    }
}

