/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.communication;

import com.ibm.icu.text.MessageFormat;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.php.debug.daemon.communication.ICommunicationDaemon;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.PHPDebugUtil;
import org.eclipse.php.internal.debug.core.daemon.AbstractDebuggerCommunicationDaemon;
import org.eclipse.php.internal.debug.core.debugger.AbstractDebuggerConfiguration;
import org.eclipse.php.internal.debug.core.debugger.DebuggerSettingsManager;
import org.eclipse.php.internal.debug.core.debugger.IDebuggerSettings;
import org.eclipse.php.internal.debug.core.debugger.IDebuggerSettingsListener;
import org.eclipse.php.internal.debug.core.launching.PHPProcess;
import org.eclipse.php.internal.debug.core.launching.XDebugLaunch;
import org.eclipse.php.internal.debug.core.pathmapper.PathMapper;
import org.eclipse.php.internal.debug.core.pathmapper.PathMapperRegistry;
import org.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.core.sourcelookup.PHPSourceLookupDirector;
import org.eclipse.php.internal.debug.core.xdebug.IDELayerFactory;
import org.eclipse.php.internal.debug.core.xdebug.XDebugPreferenceMgr;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpBreakpointFacade;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpLogger;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpMultiSessionTarget;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpTarget;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.session.DBGpSession;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.session.DBGpSessionHandler;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.core.manager.ServersManager;
import org.eclipse.php.ui.util.LinkMessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.BackingStoreException;

public class XDebugCommunicationDaemon
implements ICommunicationDaemon {
    public static final String XDEBUG_DEBUGGER_ID = "org.eclipse.php.debug.core.xdebugDebugger";
    private List<AbstractDebuggerCommunicationDaemon> daemons = new ArrayList<AbstractDebuggerCommunicationDaemon>();
    private IEclipsePreferences.IPreferenceChangeListener defaultPortListener = null;
    private IDebuggerSettingsListener debuggerSettingsListener = null;

    public void init() {
        this.registerListeners();
        this.reset();
    }

    public boolean isListening(int port) {
        for (ICommunicationDaemon iCommunicationDaemon : this.daemons) {
            if (!iCommunicationDaemon.isListening(port)) continue;
            return true;
        }
        return false;
    }

    public void startListen() {
        for (ICommunicationDaemon iCommunicationDaemon : this.daemons) {
            iCommunicationDaemon.startListen();
        }
    }

    public void stopListen() {
        this.unregisterListeners();
        for (ICommunicationDaemon iCommunicationDaemon : this.daemons) {
            iCommunicationDaemon.stopListen();
        }
    }

    public boolean resetSocket() {
        boolean allReset = true;
        for (ICommunicationDaemon iCommunicationDaemon : this.daemons) {
            if (iCommunicationDaemon.resetSocket()) continue;
            allReset = false;
        }
        return allReset;
    }

    public void handleMultipleBindingError() {
    }

    public boolean isEnabled() {
        return true;
    }

    public String getDebuggerID() {
        return XDEBUG_DEBUGGER_ID;
    }

    public boolean isDebuggerDaemon() {
        return true;
    }

    public boolean isInitialized() {
        for (ICommunicationDaemon iCommunicationDaemon : this.daemons) {
            if (iCommunicationDaemon.isInitialized()) continue;
            return false;
        }
        return true;
    }

    private void registerListeners() {
        if (this.defaultPortListener == null) {
            this.defaultPortListener = new DefaultPortListener();
            InstanceScope.INSTANCE.getNode("org.eclipse.php.debug.core").addPreferenceChangeListener(this.defaultPortListener);
        }
        if (this.debuggerSettingsListener == null) {
            this.debuggerSettingsListener = new DebuggerSettingsListener();
            DebuggerSettingsManager.INSTANCE.addSettingsListener(this.debuggerSettingsListener);
        }
    }

    private void unregisterListeners() {
        if (this.defaultPortListener != null) {
            InstanceScope.INSTANCE.getNode("org.eclipse.php.debug.core").addPreferenceChangeListener(this.defaultPortListener);
        }
        if (this.debuggerSettingsListener != null) {
            DebuggerSettingsManager.INSTANCE.addSettingsListener(this.debuggerSettingsListener);
        }
    }

    private synchronized void reset() {
        Set<Integer> ports = PHPDebugUtil.getDebugPorts(this.getDebuggerID());
        ArrayList<AbstractDebuggerCommunicationDaemon> daemonsToSet = new ArrayList<AbstractDebuggerCommunicationDaemon>();
        for (AbstractDebuggerCommunicationDaemon daemon : this.daemons) {
            boolean isRedundant = true;
            Iterator<Object> iterator = ports.iterator();
            while (iterator.hasNext()) {
                int port = iterator.next();
                if (daemon.getReceiverPort() != port) continue;
                daemonsToSet.add(daemon);
                isRedundant = false;
                break;
            }
            if (!isRedundant) continue;
            daemon.stopListen();
        }
        Iterator<Object> iterator = ports.iterator();
        while (iterator.hasNext()) {
            int port = (Integer)iterator.next();
            boolean isRunning = false;
            for (AbstractDebuggerCommunicationDaemon daemon : this.daemons) {
                if (daemon.getReceiverPort() != port) continue;
                isRunning = true;
                break;
            }
            if (isRunning) continue;
            CommunicationDaemon newDaemon = new CommunicationDaemon(port);
            daemonsToSet.add(newDaemon);
        }
        this.daemons = daemonsToSet;
    }

    private class CommunicationDaemon
    extends AbstractDebuggerCommunicationDaemon {
        private int port;

        public CommunicationDaemon(int port) {
            this.port = port;
            this.init();
        }

        @Override
        public int getReceiverPort() {
            return this.port;
        }

        public boolean isDebuggerDaemon() {
            return true;
        }

        @Override
        public String getDebuggerID() {
            return XDebugCommunicationDaemon.XDEBUG_DEBUGGER_ID;
        }

        @Override
        protected void startConnection(Socket socket) {
            if (DBGpLogger.debugSession()) {
                DBGpLogger.debug("Connection established: " + socket.toString());
            }
            try {
                DBGpSession session = new DBGpSession(socket);
                if (session.isActive() && !DBGpSessionHandler.getInstance().fireSessionAdded(session)) {
                    new RequestVerifier().verify(session);
                    XDebugPreferenceMgr.AcceptRemoteSession aSess = XDebugPreferenceMgr.getAcceptRemoteSession();
                    if (aSess != XDebugPreferenceMgr.AcceptRemoteSession.off) {
                        if (aSess == XDebugPreferenceMgr.AcceptRemoteSession.localhost && !session.getRemoteAddress().isLoopbackAddress()) {
                            session.endSession();
                        } else if (aSess == XDebugPreferenceMgr.AcceptRemoteSession.prompt) {
                            PromptUser prompt = new PromptUser(session);
                            Display.getDefault().syncExec((Runnable)prompt);
                            if (prompt.isResult()) {
                                this.createLaunch(session);
                            } else {
                                session.endSession();
                            }
                        } else {
                            this.createLaunch(session);
                        }
                    } else {
                        session.endSession();
                    }
                }
            }
            catch (Exception e) {
                DBGpLogger.logException("Unexpected Exception: Listener thread still listening", this, e);
            }
        }

        private void createLaunch(DBGpSession session) throws CoreException {
            boolean stopAtFirstLine = PHPProjectPreferences.getStopAtFirstLine(null);
            DBGpTarget target = null;
            PathMapper mapper = null;
            PHPSourceLookupDirector srcLocator = new PHPSourceLookupDirector();
            srcLocator.setSourcePathComputer(DebugPlugin.getDefault().getLaunchManager().getSourcePathComputer("org.eclipse.php.debug.core.sourcePathComputer.php"));
            ILaunchConfigurationType type = null;
            ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
            type = session.getSessionId() == null ? lm.getLaunchConfigurationType("org.eclipse.php.debug.core.remotePHPLaunchConfigurationType") : lm.getLaunchConfigurationType("org.eclipse.php.debug.core.launching.PHPExeLaunchConfigurationType");
            ILaunchConfigurationWorkingCopy launchConfig = type.newInstance(null, PHPDebugCoreMessages.XDebugMessage_remoteSessionTitle);
            srcLocator.initializeDefaults((ILaunchConfiguration)launchConfig);
            srcLocator.initializeParticipants();
            XDebugLaunch remoteLaunch = new XDebugLaunch((ILaunchConfiguration)launchConfig, "debug", (ISourceLocator)srcLocator);
            DebugPlugin.getDefault().getLaunchManager().addLaunch((ILaunch)remoteLaunch);
            boolean multiSession = XDebugPreferenceMgr.useMultiSession();
            if (session.getSessionId() == null && !multiSession) {
                target = new DBGpTarget((ILaunch)remoteLaunch, null, null, session.getIdeKey(), null, stopAtFirstLine);
                PHPProcess process = new PHPProcess((ILaunch)remoteLaunch, PHPDebugCoreMessages.XDebugWebLaunchConfigurationDelegate_PHP_process);
                process.setAttribute(IProcess.ATTR_PROCESS_TYPE, "org.eclipse.php.debug.core.launching.PHPProcess");
                target.setProcess(process);
                process.setDebugTarget(target);
                remoteLaunch.addProcess(process);
                Server server = null;
                Server[] servers = ServersManager.getServers();
                int i = 0;
                while (i < servers.length) {
                    if (servers[i].getPort() == session.getRemotePort() && servers[i].getHost().equalsIgnoreCase(session.getRemoteHostname())) {
                        server = servers[i];
                        break;
                    }
                    ++i;
                }
                if (server != null) {
                    mapper = PathMapperRegistry.getByServer(server);
                }
                if (mapper == null) {
                    mapper = new PathMapper();
                }
                DBGpSessionHandler.getInstance().addSessionListener(target);
            } else {
                target = new DBGpTarget((ILaunch)remoteLaunch, null, session.getIdeKey(), session.getSessionId(), stopAtFirstLine);
                mapper = new PathMapper();
            }
            target.setPathMapper(mapper);
            target.setSession(session);
            session.setDebugTarget(target);
            if (multiSession && session.getSessionId() == null) {
                DBGpMultiSessionTarget multiSessionTarget = new DBGpMultiSessionTarget((ILaunch)remoteLaunch, null, null, session.getIdeKey(), stopAtFirstLine);
                DBGpSessionHandler.getInstance().addSessionListener(multiSessionTarget);
                remoteLaunch.addDebugTarget(multiSessionTarget);
                multiSessionTarget.sessionReceived((DBGpBreakpointFacade)((Object)IDELayerFactory.getIDELayer()), XDebugPreferenceMgr.createSessionPreferences(), target, mapper);
            } else {
                remoteLaunch.addDebugTarget(target);
                target.sessionReceived((DBGpBreakpointFacade)((Object)IDELayerFactory.getIDELayer()), XDebugPreferenceMgr.createSessionPreferences());
            }
        }

        private class PromptUser
        implements Runnable {
            private DBGpSession session;
            private boolean result;

            public boolean isResult() {
                return this.result;
            }

            public PromptUser(DBGpSession session) {
                this.session = session;
            }

            @Override
            public void run() {
                String insert = String.valueOf(this.session.getRemoteAddress().getCanonicalHostName()) + "/" + this.session.getRemoteAddress().getHostAddress();
                String message = MessageFormat.format((String)PHPDebugCoreMessages.XDebugMessage_remoteSessionPrompt, (Object[])new Object[]{insert});
                this.result = MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)PHPDebugCoreMessages.XDebugMessage_remoteSessionTitle, (String)message);
            }
        }

        private class RequestVerifier {
            private DBGpSession session;

            private RequestVerifier() {
            }

            public void verify(DBGpSession session) {
                if (!XDebugPreferenceMgr.getWarnNoLocalhostSession()) {
                    return;
                }
                this.session = session;
                String message = null;
                int messageType = 0;
                XDebugPreferenceMgr.AcceptRemoteSession acceptSession = XDebugPreferenceMgr.getAcceptRemoteSession();
                if (!(acceptSession != XDebugPreferenceMgr.AcceptRemoteSession.localhost && acceptSession != XDebugPreferenceMgr.AcceptRemoteSession.off || this.session.getRemoteAddress().isLoopbackAddress())) {
                    message = PHPDebugCoreMessages.XDebugCommunicationDaemon_Remote_debug_session_does_not_refer_to_localhost;
                    messageType = 4;
                } else if (acceptSession == XDebugPreferenceMgr.AcceptRemoteSession.off && this.session.getRemoteAddress().isLoopbackAddress()) {
                    messageType = 2;
                    message = PHPDebugCoreMessages.XDebugCommunicationDaemon_Remote_debug_session_for_localhost;
                } else {
                    return;
                }
                this.openMessage(message, messageType);
            }

            private void openMessage(final String message, final int messageType) {
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                        LinkMessageDialog dialog = new LinkMessageDialog(shell, PHPDebugCoreMessages.XDebugCommunicationDaemon_XDebug_remote_session_title, null, message, messageType, new String[]{IDialogConstants.OK_LABEL}, 0){

                            protected void linkActivated() {
                                AbstractDebuggerConfiguration configuration = PHPDebuggersRegistry.getDebuggerConfiguration(XDebugCommunicationDaemon.XDEBUG_DEBUGGER_ID);
                                configuration.openConfigurationDialog(this.getShell());
                            }

                            protected Control createDialogArea(Composite composite) {
                                Control control = super.createDialogArea(composite);
                                final Button button = new Button(composite, 32);
                                GridData gridData = new GridData(4, 4, true, true, 2, 1);
                                button.setLayoutData((Object)gridData);
                                button.setText(PHPDebugCoreMessages.XDebugCommunicationDaemon_Dont_show_this_message_again);
                                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                    public void widgetSelected(SelectionEvent e) {
                                        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.php.debug.core");
                                        preferences.putBoolean("org.eclipse.php.debug.core.no_localhost_remote_session", !button.getSelection());
                                        try {
                                            preferences.flush();
                                        }
                                        catch (BackingStoreException backingStoreException) {
                                            // empty catch block
                                        }
                                    }
                                });
                                return control;
                            }
                        };
                        if (shell != null) {
                            shell.forceActive();
                            shell.setActive();
                        }
                        dialog.open();
                    }
                });
            }
        }
    }

    private class DebuggerSettingsListener
    implements IDebuggerSettingsListener {
        private DebuggerSettingsListener() {
        }

        @Override
        public void settingsAdded(IDebuggerSettings settings) {
            if (XDebugCommunicationDaemon.this.getDebuggerID().equals(settings.getDebuggerId())) {
                XDebugCommunicationDaemon.this.reset();
            }
        }

        @Override
        public void settingsRemoved(IDebuggerSettings settings) {
            if (XDebugCommunicationDaemon.this.getDebuggerID().equals(settings.getDebuggerId())) {
                XDebugCommunicationDaemon.this.reset();
            }
        }

        @Override
        public void settingsChanged(PropertyChangeEvent[] events) {
            PropertyChangeEvent[] propertyChangeEventArray = events;
            int n = events.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyChangeEvent event = propertyChangeEventArray[n2];
                IDebuggerSettings settings = (IDebuggerSettings)event.getSource();
                if (XDebugCommunicationDaemon.this.getDebuggerID().equals(settings.getDebuggerId()) && event.getProperty().equals("clientPort")) {
                    XDebugCommunicationDaemon.this.reset();
                }
                ++n2;
            }
        }
    }

    private class DefaultPortListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        private DefaultPortListener() {
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if (event.getKey().equals("org.eclipse.php.debug.core.xdebug_port")) {
                XDebugCommunicationDaemon.this.reset();
            }
        }
    }
}

