/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.lml.core.model;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.ptp.internal.rm.lml.core.JAXBUtil;
import org.eclipse.ptp.internal.rm.lml.core.model.LMLCheck;
import org.eclipse.ptp.internal.rm.lml.core.model.LguiItem;
import org.eclipse.ptp.rm.lml.core.elements.AbslayoutType;
import org.eclipse.ptp.rm.lml.core.elements.ChartlayoutType;
import org.eclipse.ptp.rm.lml.core.elements.ColumnlayoutType;
import org.eclipse.ptp.rm.lml.core.elements.ComponentType;
import org.eclipse.ptp.rm.lml.core.elements.ComponentlayoutType;
import org.eclipse.ptp.rm.lml.core.elements.GobjectType;
import org.eclipse.ptp.rm.lml.core.elements.InfoboxlayoutType;
import org.eclipse.ptp.rm.lml.core.elements.LayoutRoot;
import org.eclipse.ptp.rm.lml.core.elements.LguiType;
import org.eclipse.ptp.rm.lml.core.elements.Nodedisplay;
import org.eclipse.ptp.rm.lml.core.elements.Nodedisplayelement;
import org.eclipse.ptp.rm.lml.core.elements.NodedisplaylayoutType;
import org.eclipse.ptp.rm.lml.core.elements.ObjectFactory;
import org.eclipse.ptp.rm.lml.core.elements.SchemeElement;
import org.eclipse.ptp.rm.lml.core.elements.SchemeElement1;
import org.eclipse.ptp.rm.lml.core.elements.SchemeElement2;
import org.eclipse.ptp.rm.lml.core.elements.SchemeElement3;
import org.eclipse.ptp.rm.lml.core.elements.SchemeElement4;
import org.eclipse.ptp.rm.lml.core.elements.SchemeElement5;
import org.eclipse.ptp.rm.lml.core.elements.SchemeElement6;
import org.eclipse.ptp.rm.lml.core.elements.SchemeElement7;
import org.eclipse.ptp.rm.lml.core.elements.SchemeElement8;
import org.eclipse.ptp.rm.lml.core.elements.SchemeElement9;
import org.eclipse.ptp.rm.lml.core.elements.TableType;
import org.eclipse.ptp.rm.lml.core.elements.TablelayoutType;
import org.eclipse.ptp.rm.lml.core.elements.UsagebarlayoutType;
import org.eclipse.ptp.rm.lml.core.events.ILguiUpdatedEvent;
import org.eclipse.ptp.rm.lml.core.listeners.ILguiListener;
import org.eclipse.ptp.rm.lml.core.model.ILguiItem;
import org.eclipse.ptp.rm.lml.core.model.LguiHandler;

public class LayoutAccess
extends LguiHandler {
    private static ObjectFactory objectFactory = new ObjectFactory();
    private static final String LAYOUT_ENDING = "_layout";
    private static String DEAFULT_ABS = "abs_default";
    private static JAXBUtil jaxbUtil = JAXBUtil.getInstance();

    public static LguiType mergeLayouts(LguiType data, LguiType layout) {
        if (data == null || layout == null) {
            return data;
        }
        LguiItem lguiData = new LguiItem(data);
        for (Object object : jaxbUtil.getObjects(layout)) {
            if (!(object instanceof ComponentlayoutType)) continue;
            jaxbUtil.replaceComponentLayout(data, lguiData, (ComponentlayoutType)object);
        }
        JAXBUtil.replaceGlobalLayout(layout, data);
        return data;
    }

    public LayoutAccess(ILguiItem lguiItem, LguiType lgui) {
        super(lguiItem, lgui);
        this.lguiItem.addListener(new ILguiListener(){

            @Override
            public void handleEvent(ILguiUpdatedEvent e) {
                LayoutAccess.this.update(e.getLgui());
            }
        });
    }

    public AbslayoutType generateDefaultAbsoluteLayout(int width, int height) {
        int rows;
        ArrayList<GobjectType> activeObjects = new ArrayList<GobjectType>();
        block0: for (GobjectType gobject : this.lguiItem.getOverviewAccess().getGraphicalObjects()) {
            List<ComponentlayoutType> layouts = this.getComponentLayoutByGid(gobject.getId());
            if (layouts.size() == 0) {
                activeObjects.add(gobject);
            }
            for (ComponentlayoutType componentLayout : layouts) {
                if (!componentLayout.isActive()) continue;
                activeObjects.add(gobject);
                continue block0;
            }
        }
        AbslayoutType result = objectFactory.createAbslayoutType();
        result.setId(DEAFULT_ABS);
        int columns = (int)Math.round(Math.sqrt(activeObjects.size()));
        if (columns == 0) {
            columns = 1;
        }
        if ((rows = (int)Math.ceil((double)activeObjects.size() / (double)columns)) == 0) {
            rows = 1;
        }
        int index = 0;
        int rectWidth = width / columns;
        int rectHeight = height / rows;
        for (GobjectType gobject : activeObjects) {
            ComponentType component = objectFactory.createComponentType();
            component.setGid(gobject.getId());
            component.setW(BigInteger.valueOf(rectWidth));
            component.setH(BigInteger.valueOf(rectHeight));
            component.setX(BigInteger.valueOf(index % columns * rectWidth));
            component.setY(BigInteger.valueOf(index / columns * rectHeight));
            result.getComp().add(component);
            ++index;
        }
        return result;
    }

    public LayoutRoot generateRequestFromModel() {
        LayoutRoot result = objectFactory.createLayoutRoot();
        jaxbUtil.addLayoutTagsToRequest(result, this.lgui);
        jaxbUtil.addNodedisplaySchemeHints(result, this.lgui);
        jaxbUtil.addTableContenttypeHints(result, this.lgui);
        return result;
    }

    public ChartlayoutType getChartLayout(String chartId) {
        for (ChartlayoutType chartLayout : this.getChartLayouts()) {
            if (!chartLayout.getGid().equals(chartId)) continue;
            return chartLayout;
        }
        return objectFactory.createChartlayoutType();
    }

    public List<ChartlayoutType> getChartLayouts() {
        LinkedList<ChartlayoutType> chartLayouts = new LinkedList<ChartlayoutType>();
        for (ComponentlayoutType layout : this.getComponentLayouts()) {
            if (!(layout instanceof ChartlayoutType)) continue;
            chartLayouts.add((ChartlayoutType)layout);
        }
        return chartLayouts;
    }

    public List<ComponentlayoutType> getComponentLayoutByGid(String gid) {
        ArrayList<ComponentlayoutType> result = new ArrayList<ComponentlayoutType>();
        for (ComponentlayoutType layout : this.getComponentLayouts()) {
            if (layout.getGid() == null || !layout.getGid().equals(gid)) continue;
            result.add(layout);
        }
        return result;
    }

    public List<ComponentlayoutType> getComponentLayouts() {
        LinkedList<ComponentlayoutType> layouts = new LinkedList<ComponentlayoutType>();
        for (Object object : jaxbUtil.getObjects(this.lgui)) {
            if (!(object instanceof ComponentlayoutType)) continue;
            layouts.add((ComponentlayoutType)object);
        }
        return layouts;
    }

    public TablelayoutType getDefaultTableLayoutFromTable(String gid) {
        TablelayoutType tableLayout = this.getTableLayout(gid);
        if (tableLayout == null) {
            tableLayout = new TablelayoutType();
            tableLayout.setGid(gid);
            this.getTableLayouts().add(tableLayout);
        }
        if (tableLayout.getColumn().size() <= 0) {
            tableLayout.setId(String.valueOf(gid) + LAYOUT_ENDING);
            TableType table = this.lguiItem.getTableHandler().getTable(gid);
            if (table != null) {
                int i = 0;
                while (i < table.getColumn().size()) {
                    ColumnlayoutType column = new ColumnlayoutType();
                    column.setCid(BigInteger.valueOf(i + 1));
                    column.setPos(BigInteger.valueOf(i));
                    column.setWidth(1.0);
                    column.setActive(true);
                    column.setKey(table.getColumn().get(i).getName());
                    tableLayout.getColumn().add(column);
                    ++i;
                }
            }
        }
        return tableLayout;
    }

    public Map<String, String> getInactiveComponents() {
        HashMap<String, String> inactiveMap = new HashMap<String, String>();
        for (ComponentlayoutType object : this.getComponentLayouts()) {
            if (object.isActive()) continue;
            if (object instanceof TablelayoutType) {
                TableType table = this.lguiItem.getTableHandler().getTable(object.getGid());
                if (table == null) continue;
                inactiveMap.put(table.getTitle(), object.getGid());
                continue;
            }
            if (!(object instanceof NodedisplaylayoutType)) continue;
            inactiveMap.put(this.lguiItem.getNodedisplayAccess().getNodedisplayById(object.getGid()).getTitle(), object.getGid());
        }
        return inactiveMap;
    }

    public InfoboxlayoutType getInfoboxLayout(String infoId) {
        for (InfoboxlayoutType infoboxLayout : this.getInfoboxLayout()) {
            if (!infoboxLayout.getGid().equals(infoId)) continue;
            return infoboxLayout;
        }
        return objectFactory.createInfoboxlayoutType();
    }

    public ColumnlayoutType[] getLayoutColumsToCids(BigInteger[] cids, String gid) {
        ColumnlayoutType[] columns = new ColumnlayoutType[cids.length];
        int i = 0;
        while (i < cids.length) {
            for (ColumnlayoutType column : this.getTableLayout(gid).getColumn()) {
                if (!column.getCid().equals(cids[i])) continue;
                columns[i] = column;
                break;
            }
            ++i;
        }
        return columns;
    }

    public NodedisplaylayoutType getLayoutForNodedisplay(String gid) {
        List<ComponentlayoutType> layouts = this.getComponentLayoutByGid(gid);
        if (layouts != null && layouts.size() > 0) {
            return (NodedisplaylayoutType)layouts.get(0);
        }
        ObjectFactory objfc = new ObjectFactory();
        NodedisplaylayoutType layout = objfc.createNodedisplaylayoutType();
        layout.setId("nodedisplay");
        layout.setGid(gid);
        layout.setEl0(objfc.createNodedisplayelement0());
        jaxbUtil.replaceComponentLayout(this.lgui, this.lguiItem, layout);
        return layout;
    }

    public LguiType getLayoutFromModel() {
        LguiType result = objectFactory.createLguiType();
        HashSet<String> components = new HashSet<String>();
        jaxbUtil.getLayoutComponents(result, this.lgui, components);
        LinkedList<GobjectType> gobjectList = new LinkedList<GobjectType>();
        for (Object object : jaxbUtil.getObjects(this.lgui)) {
            if (!(object instanceof GobjectType) || !components.contains(((GobjectType)object).getId())) continue;
            gobjectList.add((GobjectType)object);
        }
        for (GobjectType gobject : gobjectList) {
            result.getObjectsAndRelationsAndInformation().add(JAXBUtil.minimizeGobjectType(gobject, objectFactory));
        }
        result.setLayout(true);
        return result;
    }

    public List<NodedisplaylayoutType> getNodedisplayLayouts() {
        LinkedList<NodedisplaylayoutType> nodedisplayLayouts = new LinkedList<NodedisplaylayoutType>();
        for (ComponentlayoutType layout : this.getComponentLayouts()) {
            if (!(layout instanceof NodedisplaylayoutType)) continue;
            nodedisplayLayouts.add((NodedisplaylayoutType)layout);
        }
        return nodedisplayLayouts;
    }

    public TablelayoutType getTableLayout(String tablelayoutId) {
        for (TablelayoutType layout : this.getTableLayouts()) {
            if (!layout.getGid().equals(tablelayoutId)) continue;
            return layout;
        }
        return objectFactory.createTablelayoutType();
    }

    public List<TablelayoutType> getTableLayouts() {
        LinkedList<TablelayoutType> tableLayouts = new LinkedList<TablelayoutType>();
        for (ComponentlayoutType layout : this.getComponentLayouts()) {
            if (!(layout instanceof TablelayoutType)) continue;
            tableLayouts.add((TablelayoutType)layout);
        }
        return tableLayouts;
    }

    public InfoboxlayoutType getTextboxLayout(String textId) {
        return this.getInfoboxLayout(textId);
    }

    public UsagebarlayoutType getUsagebarLayout(String usagebarId) {
        for (UsagebarlayoutType usagebarLayout : this.getUsagebarLayouts()) {
            if (!usagebarLayout.getGid().equals(usagebarId)) continue;
            return usagebarLayout;
        }
        return objectFactory.createUsagebarlayoutType();
    }

    public List<UsagebarlayoutType> getUsagebarLayouts() {
        LinkedList<UsagebarlayoutType> usagebarLayouts = new LinkedList<UsagebarlayoutType>();
        for (ComponentlayoutType layout : this.getComponentLayouts()) {
            if (!(layout instanceof UsagebarlayoutType)) continue;
            usagebarLayouts.add((UsagebarlayoutType)layout);
        }
        return usagebarLayouts;
    }

    public String setComponentActive(String gid, boolean active) {
        String type = null;
        ComponentlayoutType component = this.getComponent(gid);
        if (component != null) {
            if (component instanceof TablelayoutType) {
                type = "table";
            } else if (component instanceof NodedisplaylayoutType) {
                type = "nodedisplay";
            }
            component.setActive(active);
        }
        return type;
    }

    public void setMaxLevelOnLevel(NodedisplaylayoutType layout, int layoutLevel, int maxLevel) {
        if (layout.getEl0() == null) {
            layout.setEl0(objectFactory.createNodedisplayelement0());
        }
        if (layoutLevel == 0) {
            layout.getEl0().setMaxlevel(BigInteger.valueOf(maxLevel));
            return;
        }
        Nodedisplay nodedisplay = this.lguiItem.getNodedisplayAccess().getNodedisplayById(layout.getGid());
        this.setMaxLevelOnLevel(layout.getEl0(), nodedisplay.getScheme(), layoutLevel, maxLevel);
    }

    private Nodedisplayelement createNodedisplayelementFromSchemeElement(SchemeElement scheme) {
        Nodedisplayelement result = null;
        if (scheme instanceof SchemeElement1) {
            result = objectFactory.createNodedisplayelement1();
        } else if (scheme instanceof SchemeElement1) {
            result = objectFactory.createNodedisplayelement2();
        } else if (scheme instanceof SchemeElement2) {
            result = objectFactory.createNodedisplayelement2();
        } else if (scheme instanceof SchemeElement3) {
            result = objectFactory.createNodedisplayelement3();
        } else if (scheme instanceof SchemeElement4) {
            result = objectFactory.createNodedisplayelement4();
        } else if (scheme instanceof SchemeElement5) {
            result = objectFactory.createNodedisplayelement5();
        } else if (scheme instanceof SchemeElement6) {
            result = objectFactory.createNodedisplayelement6();
        } else if (scheme instanceof SchemeElement7) {
            result = objectFactory.createNodedisplayelement7();
        } else if (scheme instanceof SchemeElement8) {
            result = objectFactory.createNodedisplayelement8();
        } else if (scheme instanceof SchemeElement9) {
            result = objectFactory.createNodedisplayelement9();
        } else {
            return null;
        }
        if (scheme.getMin() != null) {
            result.setMin(scheme.getMin());
        }
        if (scheme.getMax() != null) {
            result.setMax(scheme.getMax());
        }
        if (scheme.getList() != null) {
            result.setList(scheme.getList());
        }
        return result;
    }

    private ComponentlayoutType getComponent(String gid) {
        for (ComponentlayoutType object : this.getComponentLayouts()) {
            if (!object.getGid().equals(gid)) continue;
            return object;
        }
        return null;
    }

    private List<InfoboxlayoutType> getInfoboxLayout() {
        LinkedList<InfoboxlayoutType> infoboxLayouts = new LinkedList<InfoboxlayoutType>();
        for (ComponentlayoutType layout : this.getComponentLayouts()) {
            if (!(layout instanceof InfoboxlayoutType)) continue;
            infoboxLayouts.add((InfoboxlayoutType)layout);
        }
        return infoboxLayouts;
    }

    private void setMaxLevelOnLevel(Nodedisplayelement layout, Object scheme, int recLevel, int maxLevel) {
        List<? extends Nodedisplayelement> lowerLayout = LMLCheck.getLowerNodedisplayElements(layout);
        List<? extends SchemeElement> lowerSchemes = LMLCheck.getLowerSchemeElements(scheme);
        if (lowerLayout.size() == 0) {
            for (SchemeElement schemeElement : lowerSchemes) {
                lowerLayout.add(this.createNodedisplayelementFromSchemeElement(schemeElement));
            }
        }
        for (Nodedisplayelement nodedisplayelement : lowerLayout) {
            int[] ids;
            if (recLevel == 1) {
                nodedisplayelement.setMaxlevel(BigInteger.valueOf(maxLevel));
                continue;
            }
            if (nodedisplayelement.getMin() != null) {
                int min;
                int max = min = nodedisplayelement.getMin().intValue();
                if (nodedisplayelement.getMax() != null) {
                    max = nodedisplayelement.getMax().intValue();
                }
                int i = min;
                while (i <= max) {
                    ArrayList<Integer> lowerId = new ArrayList<Integer>();
                    lowerId.add(i);
                    SchemeElement lowerScheme = LMLCheck.getSchemeByLevels(lowerId, scheme);
                    if (lowerScheme != null) {
                        this.setMaxLevelOnLevel(nodedisplayelement, lowerScheme, recLevel - 1, maxLevel);
                    }
                    ++i;
                }
                continue;
            }
            if (nodedisplayelement.getList() == null) continue;
            int[] nArray = ids = LMLCheck.getNumbersFromNumberlist(nodedisplayelement.getList());
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                ArrayList<Integer> lowerId = new ArrayList<Integer>();
                lowerId.add(i);
                SchemeElement lowerScheme = LMLCheck.getSchemeByLevels(lowerId, scheme);
                if (lowerScheme != null) {
                    this.setMaxLevelOnLevel(nodedisplayelement, lowerScheme, recLevel - 1, maxLevel);
                }
                ++n2;
            }
        }
    }
}

