/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.ObservableMap;
import org.eclipse.sapphire.Version;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceContext;

public final class Sapphire {
    private static final String VERSION_QUALIFIER_SUFFIX = ".qualifier";
    private static boolean devmode = Boolean.parseBoolean(System.getProperty("sapphire.dev.mode"));
    private static Version version;
    private static ServiceContext services;
    private static ObservableMap<String, Object> global;

    private Sapphire() {
    }

    public static boolean isDevMode() {
        return devmode;
    }

    public static synchronized Version version() {
        if (version == null) {
            Enumeration<URL> itr = null;
            try {
                itr = Sapphire.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            }
            catch (Exception e) {
                Sapphire.service(LoggingService.class).log(e);
                version = new Version(0L);
            }
            if (itr != null) {
                while (itr.hasMoreElements() && version == null) {
                    Attributes attributes;
                    String bundleSymbolicName;
                    Manifest manifest = null;
                    try {
                        Throwable throwable = null;
                        Object var3_5 = null;
                        try (InputStream stream = itr.nextElement().openStream();){
                            manifest = new Manifest(stream);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException iOException) {}
                    if (manifest == null || (bundleSymbolicName = (attributes = manifest.getMainAttributes()).getValue("Bundle-SymbolicName")) == null || !bundleSymbolicName.equals("org.eclipse.sapphire.modeling")) continue;
                    String bundleVersion = attributes.getValue("Bundle-Version");
                    if (bundleVersion != null) {
                        if ((bundleVersion = bundleVersion.trim()).endsWith(VERSION_QUALIFIER_SUFFIX)) {
                            bundleVersion = bundleVersion.substring(0, bundleVersion.length() - VERSION_QUALIFIER_SUFFIX.length());
                        }
                        try {
                            version = new Version(bundleVersion);
                        }
                        catch (IllegalArgumentException e) {
                            Sapphire.service(LoggingService.class).log(e);
                        }
                    }
                    if (version != null) continue;
                    version = new Version(0L);
                }
            }
        }
        return version;
    }

    public static <S extends Service> S service(Class<S> type) {
        return Sapphire.services().service(type);
    }

    public static <S extends Service> List<S> services(Class<S> type) {
        return Sapphire.services().services(type);
    }

    public static synchronized ServiceContext services() {
        if (services == null) {
            services = new ServiceContext("Sapphire");
        }
        return services;
    }

    public static synchronized ObservableMap<String, Object> global() {
        if (global == null) {
            global = new ObservableMap();
        }
        return global;
    }
}

