/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.text.NumberFormat;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.modeling.ValueKeyword;

public final class LongValueKeyword
extends ValueKeyword {
    public LongValueKeyword(String keyword, String value) {
        super(keyword, value);
    }

    @Override
    protected String createDisplayString(String keyword, String value) {
        String formattedValue = value;
        try {
            long parsedValue = Long.parseLong(value);
            formattedValue = NumberFormat.getInstance().format(parsedValue);
        }
        catch (NumberFormatException e) {
            Sapphire.service(LoggingService.class).log(e);
        }
        StringBuilder buf = new StringBuilder();
        buf.append(keyword);
        buf.append(" (");
        buf.append(formattedValue);
        buf.append(")");
        return buf.toString();
    }
}

