/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.refresh.borderednode;

import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.business.api.query.DNodeQuery;
import org.eclipse.sirius.diagram.description.style.Side;
import org.eclipse.sirius.diagram.ui.business.api.query.NodeQuery;
import org.eclipse.sirius.diagram.ui.business.api.query.ViewQuery;
import org.eclipse.sirius.diagram.ui.edit.internal.part.PortLayoutHelper;
import org.eclipse.sirius.diagram.ui.internal.refresh.GMFHelper;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.IBorderItemOffsets;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

public class CanonicalDBorderItemLocator {
    private static final int NB_SIDES = 4;
    private int preferredSide = 8;
    private Dimension borderItemOffset = new Dimension(1, 1);
    private Rectangle constraint = new Rectangle(0, 0, 0, 0);
    private Node container;
    private boolean borderItemHasMoved;
    private int currentSide = 8;
    private BitSet authorizedSides = new BitSet(29);
    private Rectangle parentBorder;

    public CanonicalDBorderItemLocator(Node containerNode, int preferredSide) {
        this.container = containerNode;
        this.preferredSide = preferredSide;
        this.initAuthorizedSides();
    }

    public void setBorderItemOffset(Dimension borderItemOffset) {
        this.borderItemOffset = borderItemOffset;
    }

    public Dimension getBorderItemOffset() {
        return this.borderItemOffset;
    }

    public void setConstraint(Rectangle constraint) {
        if (!constraint.equals((Object)this.getConstraint())) {
            this.borderItemHasMoved = true;
        }
        this.constraint = constraint;
        if (constraint.getTopLeft().x == 0 || constraint.getTopLeft().y == 0) {
            this.setCurrentSideOfParent(this.getPreferredSideOfParent());
        }
    }

    protected Rectangle getConstraint() {
        return this.constraint;
    }

    public void setCurrentSideOfParent(int side) {
        this.currentSide = side;
    }

    public int getPreferredSideOfParent() {
        return this.preferredSide;
    }

    public static int findClosestSideOfParent(Rectangle proposedLocation, Rectangle parentBorder) {
        return CanonicalDBorderItemLocator.findClosestSideOfParent(proposedLocation, parentBorder, null);
    }

    private static int findClosestSideOfParent(Rectangle proposedLocation, Rectangle parentBorder, BitSet authorizedSides) {
        Point parentCenter = parentBorder.getCenter();
        Point childCenter = proposedLocation.getCenter();
        boolean northAuthorized = true;
        boolean southAuthorized = true;
        boolean eastAuthorized = true;
        boolean westAuthorized = true;
        if (authorizedSides != null && !authorizedSides.isEmpty()) {
            northAuthorized = CanonicalDBorderItemLocator.isAuthorized(authorizedSides, 1);
            southAuthorized = CanonicalDBorderItemLocator.isAuthorized(authorizedSides, 4);
            eastAuthorized = CanonicalDBorderItemLocator.isAuthorized(authorizedSides, 16);
            westAuthorized = CanonicalDBorderItemLocator.isAuthorized(authorizedSides, 8);
        }
        int position = !eastAuthorized || CanonicalDBorderItemLocator.canHandleWestSide(parentCenter, childCenter, northAuthorized, southAuthorized, westAuthorized) ? CanonicalDBorderItemLocator.handleWestSide(parentBorder, parentCenter, childCenter, northAuthorized, southAuthorized, westAuthorized) : CanonicalDBorderItemLocator.handleEastSide(parentBorder, parentCenter, childCenter, northAuthorized, southAuthorized, eastAuthorized);
        return position;
    }

    private static boolean canHandleWestSide(Point parentCenter, Point childCenter, boolean northAuthorized, boolean southAuthorized, boolean westAuthorized) {
        return (westAuthorized || southAuthorized || northAuthorized) && childCenter.x < parentCenter.x;
    }

    private static int handleWestSide(Rectangle parentBorder, Point parentCenter, Point childCenter, boolean northAuthorized, boolean southAuthorized, boolean westAuthorized) {
        int position = !southAuthorized || (westAuthorized || northAuthorized) && childCenter.y < parentCenter.y ? CanonicalDBorderItemLocator.handleNorthWest(parentBorder, childCenter, northAuthorized, westAuthorized) : CanonicalDBorderItemLocator.handleSouthWest(parentBorder, childCenter, southAuthorized, westAuthorized);
        return position;
    }

    private static int handleNorthWest(Rectangle parentBorder, Point childCenter, boolean northAuthorized, boolean westAuthorized) {
        int position;
        if (!northAuthorized || !westAuthorized) {
            position = northAuthorized ? 1 : 8;
        } else {
            Point parentTopLeft = parentBorder.getTopLeft();
            position = childCenter.y < parentTopLeft.y ? 1 : (childCenter.x - parentTopLeft.x <= childCenter.y - parentTopLeft.y ? 8 : 1);
        }
        return position;
    }

    private static int handleSouthWest(Rectangle parentBorder, Point childCenter, boolean southAuthorized, boolean westAuthorized) {
        int position;
        if (!southAuthorized || !westAuthorized) {
            position = southAuthorized ? 4 : 8;
        } else {
            Point parentBottomLeft = parentBorder.getBottomLeft();
            position = childCenter.y > parentBottomLeft.y ? 4 : (childCenter.x - parentBottomLeft.x <= parentBottomLeft.y - childCenter.y ? 8 : 4);
        }
        return position;
    }

    private static int handleEastSide(Rectangle parentBorder, Point parentCenter, Point childCenter, boolean northAuthorized, boolean southAuthorized, boolean eastAuthorized) {
        int position = !southAuthorized || (eastAuthorized || northAuthorized) && childCenter.y < parentCenter.y ? CanonicalDBorderItemLocator.handleNorthEast(parentBorder, childCenter, northAuthorized, eastAuthorized) : CanonicalDBorderItemLocator.handleSouthEast(parentBorder, childCenter, southAuthorized, eastAuthorized);
        return position;
    }

    private static int handleNorthEast(Rectangle parentBorder, Point childCenter, boolean northAuthorized, boolean eastAuthorized) {
        int position;
        if (!eastAuthorized || !northAuthorized) {
            position = eastAuthorized ? 16 : 1;
        } else {
            Point parentTopRight = parentBorder.getTopRight();
            position = childCenter.y < parentTopRight.y ? 1 : (parentTopRight.x - childCenter.x <= childCenter.y - parentTopRight.y ? 16 : 1);
        }
        return position;
    }

    private static int handleSouthEast(Rectangle parentBorder, Point childCenter, boolean southAuthorized, boolean eastAuthorized) {
        int position;
        if (!eastAuthorized || !southAuthorized) {
            position = eastAuthorized ? 16 : 4;
        } else {
            Point parentBottomRight = parentBorder.getBottomRight();
            position = childCenter.y > parentBottomRight.y ? 4 : (parentBottomRight.x - childCenter.x <= parentBottomRight.y - childCenter.y ? 16 : 4);
        }
        return position;
    }

    private void updateAuthorizedSide(DNode borderNode) {
        this.initAuthorizedSides();
        DNodeQuery query = new DNodeQuery(borderNode);
        List forbiddenSides = query.getForbiddenSide();
        if (forbiddenSides.size() != Side.VALUES.size()) {
            for (Side side : forbiddenSides) {
                if (Side.WEST.getName().equals(side.getName())) {
                    this.authorizedSides.clear(8);
                    continue;
                }
                if (Side.EAST.getName().equals(side.getName())) {
                    this.authorizedSides.clear(16);
                    continue;
                }
                if (Side.NORTH.getName().equals(side.getName())) {
                    this.authorizedSides.clear(1);
                    continue;
                }
                if (!Side.SOUTH.getName().equals(side.getName())) continue;
                this.authorizedSides.clear(4);
            }
        }
    }

    private void initAuthorizedSides() {
        this.authorizedSides.clear();
        this.authorizedSides.set(8);
        this.authorizedSides.set(4);
        this.authorizedSides.set(16);
        this.authorizedSides.set(1);
    }

    private static boolean isAuthorized(BitSet authorizedSides, int side) {
        return authorizedSides.get(side);
    }

    public void relocate(Node borderItem) {
        EObject element = borderItem.getElement();
        if (element instanceof DNode) {
            this.updateAuthorizedSide((DNode)element);
        }
        Dimension size = this.getSize(borderItem);
        Rectangle rectSuggested = new Rectangle(this.getPreferredLocation(borderItem), size);
        if (this.borderItemHasMoved) {
            int closestSide = CanonicalDBorderItemLocator.findClosestSideOfParent(rectSuggested, this.getParentBorder(), this.authorizedSides);
            this.setPreferredSideOfParent(closestSide);
            this.setCurrentSideOfParent(closestSide);
            this.borderItemHasMoved = false;
        }
    }

    private Point locateOnBorder(Rectangle suggestedLocation, int suggestedSide, int circuitCount, Node borderItem, Collection<Node> portsNodesToIgnore) {
        Point recommendedLocation = this.locateOnParent(suggestedLocation, suggestedSide, borderItem);
        Dimension nodeSize = suggestedLocation.getSize();
        if (circuitCount < 4 && this.conflicts(recommendedLocation, nodeSize, portsNodesToIgnore).some()) {
            Rectangle newRecommendedLocationBounds = new Rectangle(recommendedLocation, nodeSize);
            recommendedLocation = suggestedSide == 8 ? this.locateOnWestBorder(newRecommendedLocationBounds, circuitCount, borderItem, portsNodesToIgnore) : (suggestedSide == 4 ? this.locateOnSouthBorder(newRecommendedLocationBounds, circuitCount, borderItem, portsNodesToIgnore) : (suggestedSide == 16 ? this.locateOnEastBorder(newRecommendedLocationBounds, circuitCount, borderItem, portsNodesToIgnore) : this.locateOnNorthBorder(newRecommendedLocationBounds, circuitCount, borderItem, portsNodesToIgnore)));
        }
        return recommendedLocation;
    }

    private Option<Rectangle> conflicts(Point recommendedLocation, Dimension nodeSize, Collection<Node> portsNodesToIgnore) {
        Rectangle recommendedRect = new Rectangle(recommendedLocation.x, recommendedLocation.y, nodeSize.width, nodeSize.height);
        EList borderItems = this.container.getPersistedChildren();
        ListIterator iterator = borderItems.listIterator();
        while (iterator.hasNext()) {
            LayoutConstraint borderItemLayoutConstraint;
            Node borderItem = (Node)iterator.next();
            boolean takeIntoAccount = true;
            ViewQuery viewQuery = new ViewQuery((View)borderItem);
            NodeQuery nodeQuery = new NodeQuery(borderItem);
            if (!nodeQuery.isBorderedNode() && !viewQuery.isForNameEditPartOnBorder()) {
                takeIntoAccount = false;
            }
            if (!this.isVisible(borderItem) || !takeIntoAccount || !((borderItemLayoutConstraint = borderItem.getLayoutConstraint()) instanceof Bounds)) continue;
            Dimension extendedDimension = this.getExtendedDimension(borderItem);
            Rectangle borderItemBounds = GMFHelper.getAbsoluteBounds(borderItem);
            if (extendedDimension != null) {
                borderItemBounds = PortLayoutHelper.getUncollapseCandidateLocation(extendedDimension, borderItemBounds, this.getParentBorder());
            }
            if (portsNodesToIgnore.contains(borderItem) || !borderItemBounds.intersects(recommendedRect)) continue;
            return Options.newSome((Object)borderItemBounds);
        }
        return Options.newNone();
    }

    private boolean isVisible(Node node) {
        EObject element = node.getElement();
        if (element instanceof DDiagramElement) {
            return ((DDiagramElement)element).isVisible() && node.isVisible();
        }
        return node.isVisible();
    }

    private Dimension getExtendedDimension(Node node) {
        DDiagramElementQuery diagramElementQuery;
        if (node.getElement() instanceof DDiagramElement && (diagramElementQuery = new DDiagramElementQuery((DDiagramElement)node.getElement())).isCollapsed()) {
            NodeQuery nodeQuery = new NodeQuery(node);
            return nodeQuery.getOriginalDimensionBeforeCollapse();
        }
        return null;
    }

    protected Point locateOnParent(Rectangle suggestedLocation, int suggestedSide, Node borderItem) {
        Rectangle bounds = this.getParentBorder();
        int parentFigureWidth = bounds.width;
        int parentFigureHeight = bounds.height;
        int parentFigureX = bounds.x;
        int parentFigureY = bounds.y;
        Dimension borderItemSize = suggestedLocation.getSize();
        int newX = suggestedLocation.x;
        int newY = suggestedLocation.y;
        int westX = parentFigureX - borderItemSize.width + this.getBorderItemOffset().width;
        int eastX = parentFigureX + parentFigureWidth - this.getBorderItemOffset().width;
        int southY = parentFigureY + parentFigureHeight - this.getBorderItemOffset().height;
        int northY = parentFigureY - borderItemSize.height + this.getBorderItemOffset().height;
        if (suggestedSide == 8) {
            if (suggestedLocation.x != westX) {
                newX = westX;
            }
            if (suggestedLocation.y < parentFigureY) {
                newY = parentFigureY;
            } else if (suggestedLocation.y > bounds.getBottomLeft().y - borderItemSize.height) {
                newY = bounds.getBottomLeft().y - borderItemSize.height;
            }
        } else if (suggestedSide == 16) {
            if (suggestedLocation.x != eastX) {
                newX = eastX;
            }
            if (suggestedLocation.y < parentFigureY) {
                newY = parentFigureY;
            } else if (suggestedLocation.y > bounds.getBottomLeft().y - borderItemSize.height) {
                newY = bounds.getBottomLeft().y - borderItemSize.height;
            }
        } else if (suggestedSide == 4) {
            if (suggestedLocation.y != southY) {
                newY = southY;
            }
            if (borderItemSize.width > bounds.width) {
                newX = parentFigureX - (borderItemSize.width - bounds.width) / 2;
            } else if (suggestedLocation.x < parentFigureX) {
                newX = parentFigureX;
            } else if (suggestedLocation.x > bounds.getBottomRight().x - borderItemSize.width) {
                newX = bounds.getBottomRight().x - borderItemSize.width;
            }
        } else {
            if (suggestedLocation.y != northY) {
                newY = northY;
            }
            if (borderItemSize.width > bounds.width) {
                newX = parentFigureX - (borderItemSize.width - bounds.width) / 2;
            } else if (suggestedLocation.x < parentFigureX) {
                newX = parentFigureX;
            } else if (suggestedLocation.x > bounds.getBottomRight().x - borderItemSize.width) {
                newX = bounds.getBottomRight().x - borderItemSize.width;
            }
        }
        return new Point(newX, newY);
    }

    protected Point locateOnSouthBorder(Rectangle recommendedLocation, int circuitCount, Node borderItem, Collection<Node> portsNodesToIgnore) {
        Dimension borderItemSize = recommendedLocation.getSize();
        Point resultLocation = null;
        Point rightTestPoint = recommendedLocation.getLocation();
        Point leftTestPoint = recommendedLocation.getLocation();
        boolean isStillFreeSpaceToTheRight = true;
        boolean isStillFreeSpaceToTheLeft = true;
        int rightHorizontalGap = 0;
        int leftHorizontalGap = 0;
        int next = this.getNextAuthorizedSide(4);
        Point recommendedLocationForNextSide = recommendedLocation.getLocation();
        Option<Rectangle> lastOptionalConflictingRectangleOnSameSide = Options.newNone();
        while (resultLocation == null && (isStillFreeSpaceToTheRight || isStillFreeSpaceToTheLeft)) {
            Option<Rectangle> optionalConflictingRectangle = Options.newNone();
            if (isStillFreeSpaceToTheRight) {
                rightTestPoint.x += rightHorizontalGap;
                optionalConflictingRectangle = this.conflicts(rightTestPoint, borderItemSize, portsNodesToIgnore);
                if (optionalConflictingRectangle.some()) {
                    if (((Rectangle)optionalConflictingRectangle.get()).y == rightTestPoint.y) {
                        lastOptionalConflictingRectangleOnSameSide = optionalConflictingRectangle;
                    }
                    if (rightTestPoint.x + (rightHorizontalGap = ((Rectangle)optionalConflictingRectangle.get()).x + ((Rectangle)optionalConflictingRectangle.get()).width + 1 - rightTestPoint.x) + borderItemSize.width > this.getParentBorder().getBottomRight().x) {
                        isStillFreeSpaceToTheRight = false;
                    }
                } else {
                    resultLocation = rightTestPoint;
                }
            }
            if (isStillFreeSpaceToTheLeft && resultLocation == null) {
                leftTestPoint.x -= leftHorizontalGap;
                optionalConflictingRectangle = this.conflicts(leftTestPoint, borderItemSize, portsNodesToIgnore);
                if (optionalConflictingRectangle.some()) {
                    if (((Rectangle)optionalConflictingRectangle.get()).y == leftTestPoint.y) {
                        lastOptionalConflictingRectangleOnSameSide = optionalConflictingRectangle;
                    }
                    if (leftTestPoint.x - (leftHorizontalGap = leftTestPoint.x - (((Rectangle)optionalConflictingRectangle.get()).x - borderItemSize.width - 1)) < this.getParentBorder().getTopLeft().x) {
                        isStillFreeSpaceToTheLeft = false;
                    }
                } else {
                    resultLocation = leftTestPoint;
                }
            }
            if (isStillFreeSpaceToTheLeft || isStillFreeSpaceToTheRight) continue;
            if (circuitCount == 3) {
                if (lastOptionalConflictingRectangleOnSameSide.some()) {
                    resultLocation = ((Rectangle)lastOptionalConflictingRectangleOnSameSide.get()).getTopLeft();
                    continue;
                }
                resultLocation = ((Rectangle)optionalConflictingRectangle.get()).getTopLeft();
                continue;
            }
            if (next != 16) continue;
            recommendedLocationForNextSide = new Point(rightTestPoint.x + rightHorizontalGap, ((Rectangle)optionalConflictingRectangle.get()).y - borderItemSize.height - 1);
        }
        if (resultLocation == null) {
            resultLocation = this.locateOnBorder(new Rectangle(recommendedLocationForNextSide, borderItemSize), next, circuitCount + 1, borderItem, portsNodesToIgnore);
        }
        return resultLocation;
    }

    protected Point locateOnNorthBorder(Rectangle recommendedLocation, int circuitCount, Node borderItem, Collection<Node> portsNodesToIgnore) {
        Dimension borderItemSize = recommendedLocation.getSize();
        Point resultLocation = null;
        Point rightTestPoint = recommendedLocation.getLocation();
        Point leftTestPoint = recommendedLocation.getLocation();
        boolean isStillFreeSpaceToTheRight = true;
        boolean isStillFreeSpaceToTheLeft = true;
        int rightHorizontalGap = 0;
        int leftHorizontalGap = 0;
        int next = this.getNextAuthorizedSide(1);
        Point recommendedLocationForNextSide = recommendedLocation.getLocation();
        Option<Rectangle> lastOptionalConflictingRectangleOnSameSide = Options.newNone();
        while (resultLocation == null && (isStillFreeSpaceToTheRight || isStillFreeSpaceToTheLeft)) {
            Option<Rectangle> optionalConflictingRectangle = Options.newNone();
            if (isStillFreeSpaceToTheRight) {
                rightTestPoint.x += rightHorizontalGap;
                optionalConflictingRectangle = this.conflicts(rightTestPoint, borderItemSize, portsNodesToIgnore);
                if (optionalConflictingRectangle.some()) {
                    if (((Rectangle)optionalConflictingRectangle.get()).y == rightTestPoint.y) {
                        lastOptionalConflictingRectangleOnSameSide = optionalConflictingRectangle;
                    }
                    if (rightTestPoint.x + (rightHorizontalGap = ((Rectangle)optionalConflictingRectangle.get()).x + ((Rectangle)optionalConflictingRectangle.get()).width + 1 - rightTestPoint.x) + borderItemSize.width > this.getParentBorder().getBottomRight().x) {
                        isStillFreeSpaceToTheRight = false;
                    }
                } else {
                    resultLocation = rightTestPoint;
                }
            }
            if (isStillFreeSpaceToTheLeft && resultLocation == null) {
                leftTestPoint.x -= leftHorizontalGap;
                optionalConflictingRectangle = this.conflicts(leftTestPoint, borderItemSize, portsNodesToIgnore);
                if (optionalConflictingRectangle.some()) {
                    if (((Rectangle)optionalConflictingRectangle.get()).y == leftTestPoint.y) {
                        lastOptionalConflictingRectangleOnSameSide = optionalConflictingRectangle;
                    }
                    if (leftTestPoint.x - (leftHorizontalGap = leftTestPoint.x - (((Rectangle)optionalConflictingRectangle.get()).x - borderItemSize.width - 1)) < this.getParentBorder().getTopLeft().x) {
                        isStillFreeSpaceToTheLeft = false;
                    }
                } else {
                    resultLocation = leftTestPoint;
                }
            }
            if (isStillFreeSpaceToTheLeft || isStillFreeSpaceToTheRight) continue;
            if (circuitCount == 3) {
                if (lastOptionalConflictingRectangleOnSameSide.some()) {
                    resultLocation = ((Rectangle)lastOptionalConflictingRectangleOnSameSide.get()).getTopLeft();
                    continue;
                }
                resultLocation = ((Rectangle)optionalConflictingRectangle.get()).getTopLeft();
                continue;
            }
            if (next != 8) continue;
            recommendedLocationForNextSide = new Point(leftTestPoint.x - leftHorizontalGap, ((Rectangle)optionalConflictingRectangle.get()).y + ((Rectangle)optionalConflictingRectangle.get()).height + 1);
        }
        if (resultLocation == null) {
            resultLocation = this.locateOnBorder(new Rectangle(recommendedLocationForNextSide, borderItemSize), next, circuitCount + 1, borderItem, portsNodesToIgnore);
        }
        return resultLocation;
    }

    protected Point locateOnWestBorder(Rectangle recommendedLocation, int circuitCount, Node borderItem, Collection<Node> portsNodesToIgnore) {
        Dimension borderItemSize = recommendedLocation.getSize();
        Point resultLocation = null;
        Point belowTestPoint = recommendedLocation.getLocation();
        Point aboveTestPoint = recommendedLocation.getLocation();
        boolean isStillFreeSpaceAbove = true;
        boolean isStillFreeSpaceBelow = true;
        int belowVerticalGap = 0;
        int aboveVerticalGap = 0;
        int next = this.getNextAuthorizedSide(8);
        Point recommendedLocationForNextSide = recommendedLocation.getLocation();
        Option<Rectangle> lastOptionalConflictingRectangleOnSameSide = Options.newNone();
        while (resultLocation == null && (isStillFreeSpaceAbove || isStillFreeSpaceBelow)) {
            Option<Rectangle> optionalConflictingRectangle = Options.newNone();
            if (isStillFreeSpaceBelow) {
                belowTestPoint.y += belowVerticalGap;
                optionalConflictingRectangle = this.conflicts(belowTestPoint, borderItemSize, portsNodesToIgnore);
                if (optionalConflictingRectangle.some()) {
                    if (((Rectangle)optionalConflictingRectangle.get()).x == belowTestPoint.x) {
                        lastOptionalConflictingRectangleOnSameSide = optionalConflictingRectangle;
                    }
                    if (belowTestPoint.y + (belowVerticalGap = ((Rectangle)optionalConflictingRectangle.get()).y + ((Rectangle)optionalConflictingRectangle.get()).height - belowTestPoint.y + 1) + borderItemSize.height > this.getParentBorder().getBottomLeft().y) {
                        isStillFreeSpaceBelow = false;
                    }
                } else {
                    resultLocation = belowTestPoint;
                }
            }
            if (isStillFreeSpaceAbove && resultLocation == null) {
                aboveTestPoint.y -= aboveVerticalGap;
                optionalConflictingRectangle = this.conflicts(aboveTestPoint, borderItemSize, portsNodesToIgnore);
                if (optionalConflictingRectangle.some()) {
                    if (((Rectangle)optionalConflictingRectangle.get()).x == aboveTestPoint.x) {
                        lastOptionalConflictingRectangleOnSameSide = optionalConflictingRectangle;
                    }
                    if (aboveTestPoint.y - (aboveVerticalGap = aboveTestPoint.y - (((Rectangle)optionalConflictingRectangle.get()).y - borderItemSize.height - 1)) < this.getParentBorder().getTopRight().y) {
                        isStillFreeSpaceAbove = false;
                    }
                } else {
                    resultLocation = aboveTestPoint;
                }
            }
            if (isStillFreeSpaceBelow || isStillFreeSpaceAbove) continue;
            if (circuitCount == 3) {
                if (lastOptionalConflictingRectangleOnSameSide.some()) {
                    resultLocation = ((Rectangle)lastOptionalConflictingRectangleOnSameSide.get()).getTopLeft();
                    continue;
                }
                resultLocation = ((Rectangle)optionalConflictingRectangle.get()).getTopLeft();
                continue;
            }
            if (next != 4) continue;
            recommendedLocationForNextSide = new Point(belowTestPoint.x + ((Rectangle)optionalConflictingRectangle.get()).width + 1, belowTestPoint.y + belowVerticalGap);
        }
        if (resultLocation == null) {
            resultLocation = this.locateOnBorder(new Rectangle(recommendedLocationForNextSide, borderItemSize), next, circuitCount + 1, borderItem, portsNodesToIgnore);
        }
        return resultLocation;
    }

    protected Point locateOnEastBorder(Rectangle recommendedLocation, int circuitCount, Node borderItem, Collection<Node> portsNodesToIgnore) {
        Dimension borderItemSize = recommendedLocation.getSize();
        Point resultLocation = null;
        Point belowTestPoint = recommendedLocation.getLocation();
        Point aboveTestPoint = recommendedLocation.getLocation();
        boolean isStillFreeSpaceAbove = true;
        boolean isStillFreeSpaceBelow = true;
        int belowVerticalGap = 0;
        int aboveVerticalGap = 0;
        int next = this.getNextAuthorizedSide(16);
        Point recommendedLocationForNextSide = recommendedLocation.getLocation();
        Option<Rectangle> lastOptionalConflictingRectangleOnSameSide = Options.newNone();
        while (resultLocation == null && (isStillFreeSpaceAbove || isStillFreeSpaceBelow)) {
            Option<Rectangle> optionalConflictingRectangle = Options.newNone();
            if (isStillFreeSpaceBelow) {
                belowTestPoint.y += belowVerticalGap;
                optionalConflictingRectangle = this.conflicts(belowTestPoint, borderItemSize, portsNodesToIgnore);
                if (optionalConflictingRectangle.some()) {
                    if (((Rectangle)optionalConflictingRectangle.get()).x == belowTestPoint.x) {
                        lastOptionalConflictingRectangleOnSameSide = optionalConflictingRectangle;
                    }
                    if (belowTestPoint.y + (belowVerticalGap = ((Rectangle)optionalConflictingRectangle.get()).y + ((Rectangle)optionalConflictingRectangle.get()).height - belowTestPoint.y + 1) + borderItemSize.height > this.getParentBorder().getBottomLeft().y) {
                        isStillFreeSpaceBelow = false;
                    }
                } else {
                    resultLocation = belowTestPoint;
                }
            }
            if (isStillFreeSpaceAbove && resultLocation == null) {
                aboveTestPoint.y -= aboveVerticalGap;
                optionalConflictingRectangle = this.conflicts(aboveTestPoint, borderItemSize, portsNodesToIgnore);
                if (optionalConflictingRectangle.some()) {
                    if (((Rectangle)optionalConflictingRectangle.get()).x == aboveTestPoint.x) {
                        lastOptionalConflictingRectangleOnSameSide = optionalConflictingRectangle;
                    }
                    if (aboveTestPoint.y - (aboveVerticalGap = aboveTestPoint.y - (((Rectangle)optionalConflictingRectangle.get()).y - borderItemSize.height - 1)) < this.getParentBorder().getTopRight().y) {
                        isStillFreeSpaceAbove = false;
                    }
                } else {
                    resultLocation = aboveTestPoint;
                }
            }
            if (isStillFreeSpaceBelow || isStillFreeSpaceAbove) continue;
            if (circuitCount == 3) {
                if (lastOptionalConflictingRectangleOnSameSide.some()) {
                    resultLocation = ((Rectangle)lastOptionalConflictingRectangleOnSameSide.get()).getTopLeft();
                    continue;
                }
                resultLocation = ((Rectangle)optionalConflictingRectangle.get()).getTopLeft();
                continue;
            }
            if (next != 4) continue;
            recommendedLocationForNextSide = new Point(((Rectangle)optionalConflictingRectangle.get()).x - borderItemSize.width - 1, aboveTestPoint.y - aboveVerticalGap);
        }
        if (resultLocation == null) {
            resultLocation = this.locateOnBorder(new Rectangle(recommendedLocationForNextSide, borderItemSize), next, circuitCount + 1, borderItem, portsNodesToIgnore);
        }
        return resultLocation;
    }

    public void setPreferredSideOfParent(int preferredSide) {
        this.preferredSide = preferredSide;
        this.setCurrentSideOfParent(preferredSide);
    }

    private Point getPreferredLocation(Node borderItem) {
        Point constraintLocation = this.getConstraint().getLocation();
        Point ptAbsoluteLocation = this.getAbsoluteToBorder(constraintLocation);
        return ptAbsoluteLocation;
    }

    public int getCurrentSideOfParent() {
        return this.currentSide;
    }

    private Point getAbsoluteToBorder(Point ptRelativeOffset) {
        Point parentOrigin = this.getParentBorder().getTopLeft();
        return parentOrigin.translate(ptRelativeOffset);
    }

    private Rectangle getParentBorder() {
        if (this.parentBorder == null) {
            NodeQuery nodeQuery = new NodeQuery(this.container);
            this.parentBorder = nodeQuery.getHandleBounds();
        }
        return this.parentBorder;
    }

    public void setParentBorderBounds(Rectangle parentBounds) {
        this.parentBorder = parentBounds;
    }

    private Dimension getSize(Node borderItem) {
        return GMFHelper.getBounds(borderItem).getSize();
    }

    public Point getValidLocation(Rectangle proposedBounds, Node borderItem, Collection<Node> portsNodesToIgnore) {
        EObject element = borderItem.getElement();
        if (element instanceof DNode) {
            this.updateAuthorizedSide((DNode)element);
        }
        Rectangle realBounds = new Rectangle(proposedBounds);
        Dimension oldOffset = this.getBorderItemOffset();
        NodeQuery nodeQuery = new NodeQuery(borderItem);
        boolean isCollapsed = nodeQuery.isCollapsed();
        if (isCollapsed) {
            Dimension extendedDimension = nodeQuery.getOriginalDimensionBeforeCollapse();
            this.setBorderItemOffset(IBorderItemOffsets.DEFAULT_OFFSET);
            if (extendedDimension.height != proposedBounds.height || extendedDimension.width != proposedBounds.width) {
                Rectangle extendedBounds = PortLayoutHelper.getUncollapseCandidateLocation(extendedDimension, proposedBounds, this.getParentBorder());
                realBounds.setBounds(extendedBounds);
            }
        }
        int side = CanonicalDBorderItemLocator.findClosestSideOfParent(proposedBounds, this.getParentBorder(), this.authorizedSides);
        Point newTopLeft = this.locateOnBorder(realBounds, side, 4 - this.getNumberOfAuthorizedSides(), borderItem, portsNodesToIgnore);
        if (isCollapsed) {
            this.setBorderItemOffset(oldOffset);
            Rectangle collapsedBounds = PortLayoutHelper.getCollapseCandidateLocation(nodeQuery.getCollapsedSize(), new Rectangle(newTopLeft, nodeQuery.getOriginalDimensionBeforeCollapse()), this.getParentBorder());
            newTopLeft = collapsedBounds.getLocation();
        }
        return newTopLeft;
    }

    private int getNextAuthorizedSide(int currentSide) {
        return this.getNextAuthorizedSide(currentSide, currentSide);
    }

    private int getNextAuthorizedSide(int currentSide, int initialSide) {
        int nextAuthorized = 0;
        int nextSide = this.getNextSide(currentSide);
        if (initialSide != nextSide) {
            nextAuthorized = this.authorizedSides.get(nextSide) ? nextSide : this.getNextAuthorizedSide(nextSide, initialSide);
        }
        return nextAuthorized;
    }

    private int getNextSide(int current) {
        int next = 0;
        switch (current) {
            case 8: {
                next = 4;
                break;
            }
            case 4: {
                next = 16;
                break;
            }
            case 16: {
                next = 1;
                break;
            }
            case 1: {
                next = 8;
                break;
            }
        }
        return next;
    }

    private int getNumberOfAuthorizedSides() {
        return this.authorizedSides.cardinality();
    }
}

