/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.views.providers.outline;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Set;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.transaction.DemultiplexingListener;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.provider.DiagramItemProviderAdapterFactory;
import org.eclipse.sirius.diagram.ui.business.api.provider.DEdgeLabelItemProvider;
import org.eclipse.sirius.diagram.ui.business.api.provider.DNodeLabelItemProvider;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.DiagramOutlinePageListener;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.viewpoint.provider.ViewpointItemProviderAdapterFactory;
import org.eclipse.swt.widgets.Display;

public class OutlineContentResourceSetListener
extends DemultiplexingListener
implements DiagramOutlinePageListener {
    private StructuredViewer viewer;
    private boolean active;
    private Set<DDiagram> toRefresh;
    private Set<Object> toUpdate;
    private boolean deferredRefresh;

    public void setViewer(Viewer viewer) {
        if (viewer instanceof StructuredViewer) {
            this.viewer = (StructuredViewer)viewer;
        }
    }

    public void resourceSetChanged(ResourceSetChangeEvent event) {
        if (this.active) {
            this.toRefresh = Sets.newHashSet();
            this.toUpdate = Sets.newHashSet();
            super.resourceSetChanged(event);
            this.refreshOutline();
            this.toRefresh = null;
            this.toUpdate = null;
        } else {
            this.toRefresh = Sets.newHashSet();
            this.toUpdate = Sets.newHashSet();
            this.deferredRefresh = true;
            super.resourceSetChanged(event);
        }
    }

    private void refreshOutline() {
        if (!this.toRefresh.isEmpty()) {
            this.refreshViewer();
        } else {
            this.updateViewer();
        }
    }

    private void refreshViewer() {
        for (DDiagram diagram : this.toRefresh) {
            this.refreshViewer(diagram);
        }
    }

    private void updateViewer() {
        for (Object object : this.toUpdate) {
            this.updateViewer(object);
        }
    }

    private void refreshViewer(final DDiagram diagram) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (OutlineContentResourceSetListener.this.viewer != null && OutlineContentResourceSetListener.this.viewer.getControl() != null && !OutlineContentResourceSetListener.this.viewer.getControl().isDisposed()) {
                    OutlineContentResourceSetListener.this.viewer.refresh((Object)diagram, true);
                }
            }
        });
    }

    private void updateViewer(final Object object) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (OutlineContentResourceSetListener.this.viewer != null && OutlineContentResourceSetListener.this.viewer.getControl() != null && !OutlineContentResourceSetListener.this.viewer.getControl().isDisposed()) {
                    OutlineContentResourceSetListener.this.viewer.update(object, null);
                }
            }
        });
    }

    private void addToRefresh(DDiagram diagram) {
        this.toRefresh.add(diagram);
    }

    private void addToUpdate(Object object) {
        this.toUpdate.add(object);
    }

    protected void handleNotification(TransactionalEditingDomain domain, Notification notification) {
        Object notifier = notification.getNotifier();
        if (notifier instanceof DDiagramElement) {
            this.caseDDiagramElement(notification, (DDiagramElement)notifier);
            if (notifier instanceof AbstractDNode) {
                this.caseAbstractDNode(notification, (AbstractDNode)notifier);
            }
            if (notifier instanceof DEdge) {
                this.caseDEdge(notification, (DEdge)notifier);
            }
            if (notifier instanceof DNodeContainer) {
                this.caseDNodeContainer(notification, (DNodeContainer)notifier);
            } else if (notifier instanceof DNodeList) {
                this.caseDNodeList(notification, (DNodeList)notifier);
            }
        } else if (notifier instanceof DDiagram) {
            this.caseDDiagram(notification, (DDiagram)notifier);
        }
    }

    private void caseDDiagramElement(Notification n, DDiagramElement diagramElement) {
        int featureID = n.getFeatureID(DDiagramElement.class);
        switch (featureID) {
            case 3: {
                Option parentDiagram = new EObjectQuery((EObject)diagramElement).getParentDiagram();
                if (!parentDiagram.some()) break;
                this.addToRefresh((DDiagram)parentDiagram.get());
                break;
            }
            case 1: {
                this.addToUpdate(diagramElement);
                break;
            }
        }
    }

    private void caseAbstractDNode(Notification n, AbstractDNode node) {
        int featureID = n.getFeatureID(AbstractDNode.class);
        switch (featureID) {
            case 9: 
            case 10: {
                this.addOptionalParentDiagramRefresh((DDiagramElement)node);
                break;
            }
        }
        if (DNodeLabelItemProvider.hasRelevantLabelItem((DDiagramElement)node)) {
            this.addToUpdate((Object)new DNodeLabelItemProvider(this.getAdapterFactoryForNodeLabelItems(), (DNode)node));
        }
    }

    private void caseDEdge(Notification n, DEdge edge) {
        int featureID = n.getFeatureID(AbstractDNode.class);
        switch (featureID) {
            case 9: {
                this.addOptionalParentDiagramRefresh((DDiagramElement)edge);
                break;
            }
        }
        if (DEdgeLabelItemProvider.hasRelevantLabelItem((DDiagramElement)edge)) {
            this.addToUpdate((Object)new DEdgeLabelItemProvider(this.getAdapterFactoryForNodeLabelItems(), edge));
        }
    }

    private AdapterFactory getAdapterFactoryForNodeLabelItems() {
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(new ViewpointItemProviderAdapterFactory());
        factories.add((Object)new DiagramItemProviderAdapterFactory());
        factories.add(new ResourceItemProviderAdapterFactory());
        factories.add(new EcoreItemProviderAdapterFactory());
        factories.add(new ReflectiveItemProviderAdapterFactory());
        return new ComposedAdapterFactory(factories);
    }

    private void caseDNodeContainer(Notification n, DNodeContainer nodeContainer) {
        int featureID = n.getFeatureID(DNodeContainer.class);
        switch (featureID) {
            case 23: {
                this.addOptionalParentDiagramRefresh((DDiagramElement)nodeContainer);
                break;
            }
        }
    }

    private void caseDNodeList(Notification n, DNodeList nodeList) {
        int featureID = n.getFeatureID(DNodeList.class);
        switch (featureID) {
            case 23: {
                this.addOptionalParentDiagramRefresh((DDiagramElement)nodeList);
                break;
            }
        }
    }

    private void caseDDiagram(Notification n, DDiagram diagram) {
        int featureID = n.getFeatureID(DDiagram.class);
        if (featureID == 7) {
            switch (n.getEventType()) {
                case 3: 
                case 4: 
                case 6: {
                    this.addToRefresh(diagram);
                    break;
                }
            }
        } else if (featureID == 15) {
            switch (n.getEventType()) {
                case 3: 
                case 4: 
                case 6: {
                    this.addToRefresh(diagram);
                    break;
                }
            }
        }
    }

    private void addOptionalParentDiagramRefresh(DDiagramElement element) {
        Option parentDiagram = new EObjectQuery((EObject)element).getParentDiagram();
        if (parentDiagram.some()) {
            this.addToRefresh((DDiagram)parentDiagram.get());
        }
    }

    @Override
    public void activate(int page) {
        switch (page) {
            case 0: {
                this.active = true;
                if (!this.deferredRefresh) break;
                this.deferredRefresh = false;
                this.refreshOutline();
                this.toRefresh = null;
                this.toUpdate = null;
                break;
            }
        }
    }

    @Override
    public void deactivate(int page) {
        switch (page) {
            case 0: {
                this.active = false;
                break;
            }
        }
    }
}

