/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.layers;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.sirius.diagram.Messages;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramDescriptionMappingsManager;
import org.eclipse.sirius.diagram.business.internal.componentization.mappings.table.CandidateMappingManager;
import org.eclipse.sirius.diagram.business.internal.layers.MappingTableEntry;
import org.eclipse.sirius.diagram.business.internal.layers.MappingsTable;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.description.NodeMapping;

public class GlobalMappingsTable {
    private final DiagramDescriptionMappingsManager descriptionMappings;
    private MappingsTable<NodeMapping> nodeMappingsTable;
    private MappingsTable<ContainerMapping> containerMappingsTable;
    private MappingsTable<EdgeMapping> edgeMappingsTable;
    private CandidateMappingManager candidateMappingsManager;

    public GlobalMappingsTable(DiagramDescriptionMappingsManager descriptionMappings) {
        this.descriptionMappings = descriptionMappings;
        this.nodeMappingsTable = new MappingsTable();
        this.containerMappingsTable = new MappingsTable();
        this.edgeMappingsTable = new MappingsTable();
        this.candidateMappingsManager = new CandidateMappingManager(descriptionMappings);
    }

    public void build(Collection<Layer> activatedLayers) {
        this.nodeMappingsTable.clear();
        this.containerMappingsTable.clear();
        this.edgeMappingsTable.clear();
        this.candidateMappingsManager.build(activatedLayers);
        this.containerMappingsTable.build(this.candidateMappingsManager.getAvailableCandidateContainerMappings());
        this.nodeMappingsTable.build(this.candidateMappingsManager.getAvailableCandidateNodeMappings());
        this.edgeMappingsTable.build(this.candidateMappingsManager.getAvailableCandidateEdgeMappings());
    }

    public List<NodeMapping> getNodeMappings() {
        return this.nodeMappingsTable.availableSortedMappingsList((NodeMapping)((Object)this.descriptionMappings.getNodeMappings()));
    }

    public List<ContainerMapping> getContainerMappings() {
        return this.containerMappingsTable.availableSortedMappingsList((ContainerMapping)((Object)this.descriptionMappings.getContainerMappings()));
    }

    public List<EdgeMapping> getEdgeMappings() {
        return this.edgeMappingsTable.availableSortedMappingsList((EdgeMapping)((Object)this.descriptionMappings.getEdgeMappings()));
    }

    public List<DiagramElementMapping> getOtherImportersMappings() {
        ArrayList<DiagramElementMapping> otherImporterMappings = new ArrayList<DiagramElementMapping>();
        otherImporterMappings.addAll(this.nodeMappingsTable.otherImportersMappingsList());
        otherImporterMappings.addAll(this.containerMappingsTable.otherImportersMappingsList());
        return otherImporterMappings;
    }

    public List<ContainerMapping> getContainerMappings(List<ContainerMapping> initialContainerMappings) {
        return this.containerMappingsTable.availableSortedMappingsList((ContainerMapping)((Object)initialContainerMappings));
    }

    public List<NodeMapping> getNodeMappings(List<NodeMapping> initialNodeMappings) {
        return this.nodeMappingsTable.availableSortedMappingsList((NodeMapping)((Object)initialNodeMappings));
    }

    public List<NodeMapping> getBorderedNodeMappings(List<NodeMapping> borderNodeMappings) {
        return this.nodeMappingsTable.availableSortedMappingsList((NodeMapping)((Object)borderNodeMappings));
    }

    public Collection<Layer> getIndirectParentLayers(DiagramElementMapping mapping) {
        Collection<Layer> parents = Collections.emptySet();
        MappingTableEntry mappingNode = this.searchMappingEntry(mapping);
        if (mappingNode != null) {
            parents = mappingNode.getIndirectParentLayers();
        }
        return parents;
    }

    private MappingTableEntry searchMappingEntry(DiagramElementMapping mapping) {
        MappingTableEntry entry;
        if (mapping instanceof NodeMapping) {
            entry = this.nodeMappingsTable.searchMappingEntry((NodeMapping)mapping);
        } else if (mapping instanceof ContainerMapping) {
            entry = this.containerMappingsTable.searchMappingEntry((ContainerMapping)mapping);
        } else if (mapping instanceof EdgeMapping) {
            entry = this.edgeMappingsTable.searchMappingEntry((EdgeMapping)mapping);
        } else {
            throw new IllegalArgumentException(MessageFormat.format(Messages.GlobalMappingsTable_mappingErrorMsg, mapping.getClass()));
        }
        return entry;
    }
}

