/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.representation;

import java.util.Optional;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.resource.ResourceDescriptor;
import org.eclipse.sirius.business.internal.representation.DRepresentationURIFragmentStrategy;
import org.eclipse.sirius.common.tools.api.util.EclipseUtil;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;

public class DRepresentationDescriptorToDRepresentationLinkManager {
    private DRepresentationDescriptor repDescriptor;

    public DRepresentationDescriptorToDRepresentationLinkManager(DRepresentationDescriptor repDescriptor) {
        this.repDescriptor = repDescriptor;
    }

    public void setRepresentation(DRepresentation newRepresentation) {
        if (newRepresentation != null) {
            Optional.ofNullable(newRepresentation).ifPresent(rep -> Assert.isNotNull((Object)rep.eResource()));
            Optional<DRepresentationURIFragmentStrategy> fragmentStrategy = EclipseUtil.getExtensionPlugins(DRepresentationURIFragmentStrategy.class, (String)"org.eclipse.sirius.dRepresentationURIFragmentStrategy", (String)"class").stream().filter(strategy -> strategy.providesSetter(newRepresentation)).findFirst();
            if (fragmentStrategy.isPresent()) {
                fragmentStrategy.get().setRepresentation(this.repDescriptor, newRepresentation);
            } else {
                this.setRepresentationPathFromURI(newRepresentation);
            }
        } else {
            this.repDescriptor.setRepPath(null);
        }
    }

    private void setRepresentationPathFromURI(DRepresentation newRepresentation) {
        URI uri = EcoreUtil.getURI((EObject)newRepresentation);
        if (uri != null) {
            this.repDescriptor.setRepPath(new ResourceDescriptor(uri));
        }
    }

    public Optional<DRepresentation> getRepresentation(boolean loadOnDemand) {
        Optional<DRepresentationURIFragmentStrategy> fragmentStrategy = EclipseUtil.getExtensionPlugins(DRepresentationURIFragmentStrategy.class, (String)"org.eclipse.sirius.dRepresentationURIFragmentStrategy", (String)"class").stream().filter(strategy -> strategy.providesGetter(this.repDescriptor)).findFirst();
        if (fragmentStrategy.isPresent()) {
            return fragmentStrategy.get().getRepresentation(this.repDescriptor, loadOnDemand);
        }
        return Optional.ofNullable(this.getRepresentationFromURI(loadOnDemand));
    }

    private DRepresentation getRepresentationFromURI(boolean loadOnDemand) {
        ResourceDescriptor resourceDescriptor = this.repDescriptor.getRepPath();
        Resource resource = this.repDescriptor.eResource();
        if (resourceDescriptor != null) {
            return Optional.ofNullable(resource).map(Resource::getResourceSet).map(rSet -> rSet.getEObject(resourceDescriptor.getResourceURI(), loadOnDemand)).filter(DRepresentation.class::isInstance).map(DRepresentation.class::cast).orElse(null);
        }
        return null;
    }
}

