/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tools.internal.command.builders;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.helper.task.TaskHelper;
import org.eclipse.sirius.business.api.preferences.SiriusPreferencesKeys;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.tools.api.command.DCommand;
import org.eclipse.sirius.tools.api.command.SiriusCommand;
import org.eclipse.sirius.tools.api.command.ui.UICallBack;
import org.eclipse.sirius.tools.internal.command.builders.CommandBuilder;

public abstract class AbstractCommandBuilder
implements CommandBuilder {
    protected IPermissionAuthority permissionAuthority;
    protected ModelAccessor modelAccessor;
    protected TransactionalEditingDomain editingDomain;
    protected UICallBack uiCallback;
    protected TaskHelper taskHelper;
    protected boolean autoRefresh;

    @Override
    public void init(ModelAccessor accessor, TransactionalEditingDomain domain, UICallBack ui) {
        this.modelAccessor = accessor;
        this.editingDomain = domain;
        this.uiCallback = ui;
        this.permissionAuthority = accessor.getPermissionAuthority();
        this.taskHelper = new TaskHelper(this.modelAccessor, this.uiCallback);
        this.autoRefresh = Platform.getPreferencesService().getBoolean("org.eclipse.sirius", SiriusPreferencesKeys.PREF_AUTO_REFRESH.name(), false, null);
    }

    protected boolean evaluatePrecondition(IInterpreter interpreter, EObject semanticContainer, String precondition) {
        boolean evaluation;
        try {
            evaluation = interpreter.evaluateBoolean(semanticContainer, precondition);
        }
        catch (EvaluationException evaluationException) {
            evaluation = false;
        }
        return evaluation;
    }

    protected DCommand createEnclosingCommand() {
        return new SiriusCommand(this.editingDomain, this.getEnclosingCommandLabel());
    }

    protected abstract String getEnclosingCommandLabel();
}

