/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.services.remote;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.tcf.core.Command;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IErrorReport;
import org.eclipse.tcf.protocol.IService;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.services.IDiagnostics;

public class DiagnosticsProxy
implements IDiagnostics {
    private final IChannel channel;

    public DiagnosticsProxy(IChannel channel) {
        this.channel = channel;
    }

    @Override
    public String getName() {
        return "Diagnostics";
    }

    @Override
    public IToken echo(String s, final IDiagnostics.DoneEcho done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"echo", (Object[])new Object[]{s}){

            @Override
            public void done(Exception error, Object[] args) {
                String str = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 1) {
                        throw new AssertionError();
                    }
                    str = (String)args[0];
                }
                done.doneEcho(this.token, error, str);
            }
        }.token;
    }

    @Override
    public IToken echoFP(BigDecimal n, final IDiagnostics.DoneEchoFP done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"echoFP", (Object[])new Object[]{n}){

            @Override
            public void done(Exception error, Object[] args) {
                BigDecimal n = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 1) {
                        throw new AssertionError();
                    }
                    Number x = (Number)args[0];
                    n = x instanceof BigDecimal ? (BigDecimal)x : new BigDecimal(x.toString());
                }
                done.doneEchoFP(this.token, error, n);
            }
        }.token;
    }

    @Override
    public IToken echoINT(int t, BigInteger n, final IDiagnostics.DoneEchoINT done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"echoINT", (Object[])new Object[]{Integer.valueOf((int)t), n}){

            @Override
            public void done(Exception error, Object[] args) {
                BigInteger n = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 1) {
                        throw new AssertionError();
                    }
                    Number x = (Number)args[0];
                    n = x instanceof BigInteger ? (BigInteger)x : new BigInteger(x.toString());
                }
                done.doneEchoINT(this.token, error, n);
            }
        }.token;
    }

    @Override
    public IToken echoERR(Throwable err, final IDiagnostics.DoneEchoERR done) {
        Map<String, Object> map = null;
        if (err instanceof IErrorReport) {
            map = ((IErrorReport)((Object)err)).getAttributes();
        } else {
            map = new HashMap<String, Object>();
            map.put("Time", System.currentTimeMillis());
            map.put("Code", 1);
            map.put("Format", err.getMessage());
        }
        return new Command((IChannel)this.channel, (IService)this, (String)"echoERR", (Object[])new Object[]{map}){

            @Override
            public void done(Exception error, Object[] args) {
                Exception err = null;
                String str = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    err = this.toError(args[0]);
                    str = (String)args[1];
                }
                done.doneEchoERR(this.token, error, err, str);
            }
        }.token;
    }

    @Override
    public IToken getTestList(final IDiagnostics.DoneGetTestList done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"getTestList", null){

            @Override
            public void done(Exception error, Object[] args) {
                String[] arr = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    arr = DiagnosticsProxy.this.toStringArray(args[1]);
                }
                done.doneGetTestList(this.token, error, arr);
            }
        }.token;
    }

    @Override
    public IToken runTest(String s, final IDiagnostics.DoneRunTest done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"runTest", (Object[])new Object[]{s}){

            @Override
            public void done(Exception error, Object[] args) {
                String str = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    str = (String)args[1];
                }
                done.doneRunTest(this.token, error, str);
            }
        }.token;
    }

    @Override
    public IToken cancelTest(String s, final IDiagnostics.DoneCancelTest done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"cancelTest", (Object[])new Object[]{s}){

            @Override
            public void done(Exception error, Object[] args) {
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 1) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                }
                done.doneCancelTest(this.token, error);
            }
        }.token;
    }

    @Override
    public IToken getSymbol(String context_id, String symbol_name, final IDiagnostics.DoneGetSymbol done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"getSymbol", (Object[])new Object[]{context_id, symbol_name}){

            @Override
            public void done(Exception error, Object[] args) {
                IDiagnostics.ISymbol sym = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    sym = DiagnosticsProxy.this.toSymbol(args[1]);
                }
                done.doneGetSymbol(this.token, error, sym);
            }
        }.token;
    }

    @Override
    public IToken createTestStreams(int inp_buf_size, int out_buf_size, final IDiagnostics.DoneCreateTestStreams done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"createTestStreams", (Object[])new Object[]{Integer.valueOf((int)inp_buf_size), Integer.valueOf((int)out_buf_size)}){

            @Override
            public void done(Exception error, Object[] args) {
                String inp_id = null;
                String out_id = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 3) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    inp_id = (String)args[1];
                    out_id = (String)args[2];
                }
                done.doneCreateTestStreams(this.token, error, inp_id, out_id);
            }
        }.token;
    }

    @Override
    public IToken disposeTestStream(String id, final IDiagnostics.DoneDisposeTestStream done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"disposeTestStream", (Object[])new Object[]{id}){

            @Override
            public void done(Exception error, Object[] args) {
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 1) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                }
                done.doneDisposeTestStream(this.token, error);
            }
        }.token;
    }

    @Override
    public IToken not_implemented_command(final IDiagnostics.DoneNotImplementedCommand done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"not implemented command", null){

            @Override
            public void done(Exception error, Object[] args) {
                done.doneNotImplementedCommand(this.token, error);
            }
        }.token;
    }

    private String[] toStringArray(Object o) {
        if (o == null) {
            return null;
        }
        Collection c = (Collection)o;
        return c.toArray(new String[c.size()]);
    }

    private IDiagnostics.ISymbol toSymbol(Object o) {
        if (o == null) {
            return null;
        }
        return new Symbol((Map)o);
    }

    private static class Symbol
    implements IDiagnostics.ISymbol {
        private final Map<String, Object> props;

        Symbol(Map<String, Object> props) {
            this.props = props;
        }

        @Override
        public String getSectionName() {
            return (String)this.props.get("Section");
        }

        @Override
        public Number getValue() {
            return (Number)this.props.get("Value");
        }

        @Override
        public boolean isAbs() {
            Boolean b = (Boolean)this.props.get("Abs");
            return b != null && b != false;
        }

        @Override
        public boolean isCommon() {
            String s = (String)this.props.get("Storage");
            return s != null && s.equals("COMMON");
        }

        @Override
        public boolean isGlobal() {
            String s = (String)this.props.get("Storage");
            return s != null && s.equals("GLOBAL");
        }

        @Override
        public boolean isLocal() {
            String s = (String)this.props.get("Storage");
            return s != null && s.equals("LOCAL");
        }

        @Override
        public boolean isUndef() {
            String s = (String)this.props.get("Storage");
            return s != null && s.equals("UNDEF");
        }
    }
}

