/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.remote;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.connector.SVNProperty;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.UnreportableException;
import org.eclipse.team.svn.core.resource.IRepositoryContainer;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IRepositoryRoot;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class GetRemoteFolderChildrenOperation
extends AbstractActionOperation {
    protected IRepositoryContainer parent;
    protected boolean handleExternals;
    protected IRepositoryResource[] children;
    protected String[] extNames;
    protected boolean caseInsensitive;

    public GetRemoteFolderChildrenOperation(IRepositoryContainer parent, boolean handleExternals) {
        this(parent, handleExternals, false);
    }

    public GetRemoteFolderChildrenOperation(IRepositoryContainer parent, boolean handleExternals, boolean caseInsensitive) {
        super("Operation_GetRemoteChildren", SVNMessages.class);
        this.parent = parent;
        this.handleExternals = handleExternals;
        this.caseInsensitive = caseInsensitive;
    }

    public IRepositoryResource[] getChildren() {
        return this.children;
    }

    public String getExternalsName(int idx) {
        return this.extNames[idx];
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        ArrayList<Object[]> tmpSortableData;
        block11: {
            IRepositoryResource[] tmp = this.parent.getChildren();
            tmpSortableData = new ArrayList<Object[]>(tmp.length);
            int i = 0;
            while (i < tmp.length) {
                Object[] objectArray = new Object[2];
                objectArray[1] = tmp[i];
                tmpSortableData.add(objectArray);
                ++i;
            }
            IRepositoryResource.Information info = this.parent.getInfo();
            if (info != null && info.hasProperties && this.handleExternals) {
                IRepositoryLocation location = this.parent.getRepositoryLocation();
                ISVNConnector proxy = location.acquireSVNProxy();
                try {
                    SVNProperty data = proxy.getProperty(SVNUtility.getEntryRevisionReference(this.parent), "svn:externals", null, new SVNProgressMonitor(this, monitor, null));
                    if (data == null) break block11;
                    try {
                        Map<String, SVNEntryRevisionReference> externals = SVNUtility.parseSVNExternalsProperty(data.value, this.parent);
                        Iterator<Map.Entry<String, SVNEntryRevisionReference>> it = externals.entrySet().iterator();
                        while (it.hasNext()) {
                            try {
                                Map.Entry<String, SVNEntryRevisionReference> entry = it.next();
                                String name = entry.getKey();
                                SVNEntryRevisionReference ref = entry.getValue();
                                IRepositoryResource repositoryResourtce = SVNRemoteStorage.instance().asRepositoryResource(location, ref, new SVNProgressMonitor(this, monitor, null));
                                if (repositoryResourtce == null) continue;
                                repositoryResourtce.setSelectedRevision(ref.revision);
                                repositoryResourtce.setPegRevision(ref.pegRevision);
                                tmpSortableData.add(new Object[]{name, repositoryResourtce});
                            }
                            catch (Exception e) {
                                this.reportStatus((IStatus)new Status(2, "org.eclipse.team.svn.core.svnnature", 0, this.getShortErrorMessage(e), (Throwable)e));
                            }
                        }
                    }
                    catch (UnreportableException ex) {
                        this.reportStatus((IStatus)new Status(2, "org.eclipse.team.svn.core.svnnature", 0, this.getShortErrorMessage(ex), (Throwable)ex));
                    }
                }
                finally {
                    location.releaseSVNProxy(proxy);
                }
            }
        }
        Object[][] sortableData = (Object[][])tmpSortableData.toArray((T[])new Object[tmpSortableData.size()][]);
        Arrays.sort(sortableData, new Comparator<Object[]>(){
            private NaturalComparator comparator;
            {
                this.comparator = new NaturalComparator();
            }

            @Override
            public int compare(Object[] firstArray, Object[] secondArray) {
                IRepositoryResource first = (IRepositoryResource)firstArray[1];
                IRepositoryResource second = (IRepositoryResource)secondArray[1];
                String firstExtName = (String)firstArray[0];
                String secondExtName = (String)secondArray[0];
                boolean firstContainer = first instanceof IRepositoryContainer;
                boolean secondContainer = second instanceof IRepositoryContainer;
                if (firstContainer && secondContainer) {
                    boolean secondRoot;
                    boolean firstExternal = firstExtName != null;
                    boolean secondExternal = secondExtName != null;
                    boolean firstRoot = !firstExternal && first instanceof IRepositoryRoot;
                    boolean bl = secondRoot = !secondExternal && second instanceof IRepositoryRoot;
                    return firstRoot == secondRoot ? (firstRoot ? this.compareRoots(((IRepositoryRoot)first).getKind(), ((IRepositoryRoot)second).getKind()) : this.compareNames(first, firstExtName, second, secondExtName)) : (firstRoot ? -1 : 1);
                }
                return firstContainer == secondContainer ? this.compareNames(first, firstExtName, second, secondExtName) : (firstContainer ? -1 : 1);
            }

            private int compareNames(IRepositoryResource first, String firstExtName, IRepositoryResource second, String secondExtName) {
                String firstName = firstExtName != null ? firstExtName : first.getName();
                String secondName = secondExtName != null ? secondExtName : second.getName();
                return this.comparator.compare(firstName, secondName);
            }

            private int compareRoots(int firstKind, int secondKind) {
                return firstKind < secondKind ? -1 : 1;
            }
        });
        this.children = new IRepositoryResource[sortableData.length];
        this.extNames = new String[sortableData.length];
        int i = 0;
        while (i < sortableData.length) {
            this.children[i] = (IRepositoryResource)sortableData[i][1];
            this.extNames[i] = (String)sortableData[i][0];
            ++i;
        }
    }

    private int compareStrings(String firstName, String secondName) {
        return this.caseInsensitive ? firstName.compareToIgnoreCase(secondName) : firstName.compareTo(secondName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NaturalComparator
    implements Comparator<String> {
        private NaturalComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            if (GetRemoteFolderChildrenOperation.this.compareStrings(o1, o2) == 0) {
                return 0;
            }
            if (o1.length() == 0) {
                return -1;
            }
            if (o2.length() == 0) {
                return 1;
            }
            String o1Part = "";
            int o1i = 0;
            boolean o1IsDigit = Character.isDigit(o1.charAt(o1i++));
            while (o1i < o1.length()) {
                if (Character.isDigit(o1.charAt(o1i)) != o1IsDigit) break;
                ++o1i;
            }
            o1Part = o1.substring(0, o1i);
            String o2Part = "";
            int o2i = 0;
            boolean o2IsDigit = Character.isDigit(o2.charAt(o2i++));
            while (o2i < o2.length()) {
                if (Character.isDigit(o2.charAt(o2i)) != o2IsDigit) break;
                ++o2i;
            }
            o2Part = o2.substring(0, o2i);
            int result = 0;
            if (o1IsDigit && o2IsDigit) {
                if (o1Part.charAt(0) == '0' && o2Part.charAt(0) != '0') {
                    result = -1;
                } else if (o2Part.charAt(0) == '0' && o1Part.charAt(0) != '0') {
                    result = 1;
                } else {
                    try {
                        int n1 = Integer.parseInt(o1Part);
                        int n2 = Integer.parseInt(o2Part);
                        int n = n1 != n2 ? (n1 < n2 ? -1 : 1) : (result = 0);
                        if (result == 0 && o1Part.length() != o2Part.length()) {
                            result = o1Part.length() < o2Part.length() ? 1 : -1;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            } else {
                result = GetRemoteFolderChildrenOperation.this.compareStrings(o1Part, o2Part);
            }
            return result != 0 ? result : this.compare(o1.substring(o1i), o2.substring(o2i));
        }
    }
}

