/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.svnstorage;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.internal.preferences.Base64;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.SVNTeamPlugin;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNCredentialsPrompt;
import org.eclipse.team.svn.core.connector.SVNDepth;
import org.eclipse.team.svn.core.connector.SVNEntryInfo;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.connector.ssl.SSLServerCertificateFailures;
import org.eclipse.team.svn.core.connector.ssl.SSLServerCertificateInfo;
import org.eclipse.team.svn.core.extension.CoreExtensionsManager;
import org.eclipse.team.svn.core.extension.options.IOptionProvider;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.ActivityCancelledException;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.LoggedOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.UnreportableException;
import org.eclipse.team.svn.core.resource.IRepositoryContainer;
import org.eclipse.team.svn.core.resource.IRepositoryFile;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IRepositoryRoot;
import org.eclipse.team.svn.core.resource.IRevisionLink;
import org.eclipse.team.svn.core.resource.SSHSettings;
import org.eclipse.team.svn.core.resource.SSLSettings;
import org.eclipse.team.svn.core.resource.events.IRepositoryLocationStateListener;
import org.eclipse.team.svn.core.resource.events.ISSHSettingsStateListener;
import org.eclipse.team.svn.core.resource.events.ISSLSettingsStateListener;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.svnstorage.SVNRepositoryBase;
import org.eclipse.team.svn.core.svnstorage.SVNRepositoryBranches;
import org.eclipse.team.svn.core.svnstorage.SVNRepositoryFile;
import org.eclipse.team.svn.core.svnstorage.SVNRepositoryFolder;
import org.eclipse.team.svn.core.svnstorage.SVNRepositoryLocationRoot;
import org.eclipse.team.svn.core.svnstorage.SVNRepositoryRoot;
import org.eclipse.team.svn.core.svnstorage.SVNRepositoryTags;
import org.eclipse.team.svn.core.svnstorage.SVNRepositoryTrunk;
import org.eclipse.team.svn.core.utility.ILoggedOperationFactory;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.core.utility.SVNURLStreamHandler;
import org.eclipse.team.svn.core.utility.SVNUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVNRepositoryLocation
extends SVNRepositoryBase
implements IRepositoryLocation,
ISSHSettingsStateListener,
ISSLSettingsStateListener,
Serializable {
    private static final int PROXY_CACHE_SIZE = 5;
    private static final long serialVersionUID = -5820937379741639580L;
    public static final int DEFAULT_CONNECTION = 0;
    public static final int SSH_CONNECTION = 1;
    public static final int SSL_CONNECTION = 2;
    public static final int PROXY_CONNECTION = 3;
    protected String id;
    protected String label;
    protected String trunk;
    protected String branches;
    protected String tags;
    protected boolean trunkEnabled;
    protected String username;
    protected String repositoryRootUrl;
    protected String repositoryUUID;
    protected String password;
    protected boolean passwordSaved;
    private transient String passwordTemporary;
    private List<byte[]> serializedRevisionLinks;
    private SSLSettings sslSettings;
    private SSHSettings sshSettings;
    private transient List<ISVNConnector> proxyCache;
    private transient HashSet<ISVNConnector> usedProxies;
    private transient HashMap<Thread, ProxyHolder> thread2Proxy;
    private transient IRevisionLink[] revisionLinks;
    protected transient boolean trustSiteDefined;
    protected transient ISVNCredentialsPrompt.Answer trustSite;
    protected transient int proxyConfigurationState;
    protected boolean authorNameEnabled;
    protected String authorName;
    private Map<String, IRepositoryLocation> additionalRealms;
    private transient List<String> rawRealms = new ArrayList<String>();
    private transient List<IRepositoryLocationStateListener> changeListeners = new ArrayList<IRepositoryLocationStateListener>();
    private transient Integer lazyInitLock = new Integer(0);
    private transient Integer proxyManagerLock = new Integer(0);
    private transient Integer repositoryRootLock = new Integer(0);
    private transient Integer authInitLock = new Integer(0);
    protected transient boolean isRetrieveAuthInfo;

    public SVNRepositoryLocation() {
        super(null);
    }

    public SVNRepositoryLocation(String id) {
        super(null);
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addStateListener(IRepositoryLocationStateListener listener) {
        List<IRepositoryLocationStateListener> list = this.changeListeners;
        synchronized (list) {
            this.changeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeStateListener(IRepositoryLocationStateListener listener) {
        List<IRepositoryLocationStateListener> list = this.changeListeners;
        synchronized (list) {
            this.changeListeners.remove(listener);
        }
    }

    @Override
    public String asReference(IRepositoryLocation.LocationReferenceTypeEnum locationReferenceType) {
        String reference = this.id;
        reference = String.valueOf(reference) + ";" + this.getUrlAsIs();
        if (locationReferenceType == IRepositoryLocation.LocationReferenceTypeEnum.ONLY_REQUIRED_DATA) {
            return reference;
        }
        reference = String.valueOf(reference) + ";" + this.getLabel();
        reference = String.valueOf(reference) + ";" + this.getBranchesLocation();
        reference = String.valueOf(reference) + ";" + this.getTagsLocation();
        reference = String.valueOf(reference) + ";" + this.getTrunkLocation();
        reference = String.valueOf(reference) + ";" + this.trunkEnabled;
        reference = String.valueOf(reference) + ";" + (this.repositoryUUID == null ? "" : this.repositoryUUID);
        reference = String.valueOf(reference) + ";" + (this.repositoryRootUrl == null ? "" : this.repositoryRootUrl);
        reference = String.valueOf(reference) + ";" + this.getAuthorName();
        reference = String.valueOf(reference) + ";" + this.authorNameEnabled + ";";
        String[] realms = this.getRealms().toArray(new String[0]);
        int i = 0;
        while (i < realms.length) {
            reference = i < realms.length - 1 ? String.valueOf(reference) + realms[i] + "^" : String.valueOf(reference) + realms[i];
            ++i;
        }
        reference = String.valueOf(reference) + ";";
        IRevisionLink[] revisionLinks = this.getRevisionLinks();
        int i2 = 0;
        while (i2 < revisionLinks.length) {
            String base64revLink = new String(Base64.encode((byte[])SVNRemoteStorage.instance().revisionLinkAsBytes(revisionLinks[i2], locationReferenceType != IRepositoryLocation.LocationReferenceTypeEnum.WITHOUT_REVISION_COMMENTS)));
            reference = i2 < revisionLinks.length - 1 ? String.valueOf(reference) + base64revLink + "^" : String.valueOf(reference) + base64revLink;
            ++i2;
        }
        reference = String.valueOf(reference) + ";0";
        return reference;
    }

    @Override
    public void fillLocationFromReference(String[] referenceParts) {
        boolean containRevisionLinks = false;
        switch (referenceParts.length) {
            case 14: {
                int sshPort = Integer.parseInt(referenceParts[13]);
                if (sshPort != 0) {
                    this.getSSHSettings().setPort(sshPort);
                }
            }
            case 13: {
                if (!referenceParts[12].equals("")) {
                    containRevisionLinks = true;
                }
            }
            case 12: {
                if (!referenceParts[11].equals("")) {
                    this.rawRealms.addAll(Arrays.asList(referenceParts[11].split("\\^")));
                }
            }
            case 11: {
                this.setAuthorNameEnabled(referenceParts[10].equals("true"));
            }
            case 10: {
                this.setAuthorName(referenceParts[9].trim());
            }
            case 9: {
                this.repositoryRootUrl = referenceParts[8].trim().equals("") ? null : referenceParts[8].trim();
            }
            case 8: {
                this.repositoryUUID = referenceParts[7].trim().equals("") ? null : referenceParts[7].trim();
            }
            case 7: {
                this.setStructureEnabled(referenceParts[6].equals("true"));
            }
            case 6: {
                this.setTrunkLocation(referenceParts[5].trim());
            }
            case 5: {
                this.setTagsLocation(referenceParts[4].trim());
            }
            case 4: {
                this.setBranchesLocation(referenceParts[3].trim());
            }
            case 3: {
                String label = referenceParts[2].trim();
                if (label.length() > 0) {
                    this.setLabel(label);
                }
            }
            case 2: {
                this.setUrl(referenceParts[1].trim());
            }
        }
        if (this.label == null || this.label.length() == 0) {
            this.label = this.url;
        }
        if (containRevisionLinks) {
            String[] revLinks = referenceParts[12].split("\\^");
            int i = 0;
            while (i < revLinks.length) {
                this.addRevisionLink(SVNRemoteStorage.instance().revisionLinkFromBytes(Base64.decode((byte[])revLinks[i].getBytes()), this));
                ++i;
            }
        }
        this.setRetrieveAuthInfo(true);
    }

    @Override
    public Collection<String> getRealms() {
        return this.getAdditionalRealms().keySet();
    }

    @Override
    public void addRealm(String realm, IRepositoryLocation location) {
        this.getAdditionalRealms(false).put(realm, location);
        this.fireRealmAdded(realm, location);
    }

    @Override
    public void removeRealm(String realm) {
        this.fireRealmRemoved(realm);
        this.getAdditionalRealms().remove(realm);
    }

    @Override
    public Collection<IRepositoryLocation> getRealmLocations() {
        return this.getAdditionalRealms().values();
    }

    @Override
    public IRepositoryLocation getLocationForRealm(String realm) {
        return this.getAdditionalRealms().get(realm);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.getUrl();
    }

    @Override
    public String getUrlAsIs() {
        return super.getUrl();
    }

    @Override
    public String getUrl() {
        return this.getUrlImpl(super.getUrl());
    }

    @Override
    public String getLabel() {
        return this.label == null ? this.getUrl() : this.label;
    }

    @Override
    public String getRepositoryRootUrl() {
        this.fetchRepoInfo();
        return this.repositoryRootUrl == null ? this.getUrl() : this.repositoryRootUrl;
    }

    @Override
    public String getRepositoryUUID() {
        this.fetchRepoInfo();
        return this.repositoryUUID;
    }

    @Override
    public IRepositoryRoot getRepositoryRoot() {
        return new SVNRepositoryRoot(this);
    }

    @Override
    public IRepositoryRoot getRoot() {
        return new SVNRepositoryLocationRoot(this);
    }

    @Override
    public boolean isStructureEnabled() {
        return this.trunkEnabled;
    }

    @Override
    public void setStructureEnabled(boolean structureEnabled) {
        boolean oldValue = this.trunkEnabled;
        this.trunkEnabled = structureEnabled;
        this.fireChanged("structureEnabled", oldValue, this.trunkEnabled);
    }

    @Override
    public String getUserInputTrunk() {
        return this.trunk == null ? "" : this.trunk;
    }

    @Override
    public String getUserInputTags() {
        return this.tags == null ? "" : this.tags;
    }

    @Override
    public String getUserInputBranches() {
        return this.branches == null ? "" : this.branches;
    }

    @Override
    public String getTrunkLocation() {
        return this.trunk == null || !this.isStructureEnabled() ? "" : this.trunk;
    }

    @Override
    public String getBranchesLocation() {
        return this.branches == null || !this.isStructureEnabled() ? "" : this.branches;
    }

    @Override
    public String getTagsLocation() {
        return this.tags == null || !this.isStructureEnabled() ? "" : this.tags;
    }

    @Override
    public boolean isAuthorNameEnabled() {
        return this.authorNameEnabled;
    }

    @Override
    public String getAuthorName() {
        return this.authorName == null ? "" : this.authorName;
    }

    @Override
    public IRepositoryContainer asRepositoryContainer(String url, boolean allowsNull) {
        return SVNRepositoryLocation.asRepositoryContainer(this, url, allowsNull);
    }

    @Override
    public IRepositoryFile asRepositoryFile(String url, boolean allowsNull) {
        return SVNRepositoryLocation.asRepositoryFile(this, url, allowsNull);
    }

    public static IRepositoryContainer asRepositoryContainer(IRepositoryLocation location, String url, boolean allowsNull) {
        IPath locationUrl;
        if (!SVNRepositoryLocation.isArgumentsCorrect(location, url, allowsNull)) {
            return null;
        }
        IPath urlPath = SVNUtility.createPathForSVNUrl(url);
        String name = urlPath.lastSegment();
        if (name != null && location.isStructureEnabled()) {
            boolean regularFolder = false;
            if (name.equals(location.getTrunkLocation()) || name.equals(location.getTagsLocation()) || name.equals(location.getBranchesLocation())) {
                IPath tPath = SVNUtility.createPathForSVNUrl(url);
                String tName = null;
                while ((tPath = tPath.removeLastSegments(1)) != null && !tPath.isEmpty() && (tName = tPath.lastSegment()) != null) {
                    if (!tName.equals(location.getTrunkLocation()) && !tName.equals(location.getBranchesLocation()) && !tName.equals(location.getTagsLocation())) continue;
                    regularFolder = true;
                    break;
                }
            }
            if (!regularFolder) {
                if (name.equals(location.getTrunkLocation())) {
                    return new SVNRepositoryTrunk(location, url, SVNRevision.HEAD);
                }
                if (name.equals(location.getTagsLocation())) {
                    return new SVNRepositoryTags(location, url, SVNRevision.HEAD);
                }
                if (name.equals(location.getBranchesLocation())) {
                    return new SVNRepositoryBranches(location, url, SVNRevision.HEAD);
                }
            }
        }
        if (urlPath.equals((Object)(locationUrl = SVNUtility.createPathForSVNUrl(location.getUrl())))) {
            return location.getRoot();
        }
        if (locationUrl.isPrefixOf(urlPath)) {
            return new SVNRepositoryFolder(location, url, SVNRevision.HEAD);
        }
        if (urlPath.equals((Object)SVNUtility.createPathForSVNUrl(location.getRepositoryRootUrl()))) {
            return location.getRepositoryRoot();
        }
        return new SVNRepositoryFolder(location, url, SVNRevision.HEAD);
    }

    public static IRepositoryFile asRepositoryFile(IRepositoryLocation location, String url, boolean allowsNull) {
        if (!SVNRepositoryLocation.isArgumentsCorrect(location, url, allowsNull)) {
            return null;
        }
        return new SVNRepositoryFile(location, url, SVNRevision.HEAD);
    }

    @Override
    public String getUsername() {
        this.checkAuthInfo();
        return this.username;
    }

    @Override
    public String getPassword() {
        this.checkAuthInfo();
        return this.passwordSaved ? SVNUtility.base64Decode(this.password) : SVNUtility.base64Decode(this.passwordTemporary);
    }

    @Override
    public boolean isPasswordSaved() {
        this.checkAuthInfo();
        return this.passwordSaved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRevisionLink[] getRevisionLinks() {
        Integer n = this.lazyInitLock;
        synchronized (n) {
            if (this.revisionLinks == null) {
                List<byte[]> serialized = this.getSerializedRevisionLinks();
                this.revisionLinks = new IRevisionLink[serialized.size()];
                int i = 0;
                while (i < this.revisionLinks.length) {
                    byte[] data = serialized.get(i);
                    this.revisionLinks[i] = SVNRemoteStorage.instance().revisionLinkFromBytes(data, this);
                    ++i;
                }
            }
            return this.revisionLinks;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRevisionLink(IRevisionLink link) {
        Integer n = this.lazyInitLock;
        synchronized (n) {
            IRevisionLink[] links = this.getRevisionLinks();
            int idx = -1;
            int i = 0;
            while (i < links.length) {
                if (links[i].equals(link) && links[i].getRepositoryResource().getSelectedRevision().equals(link.getRepositoryResource().getSelectedRevision())) {
                    idx = i;
                    break;
                }
                ++i;
            }
            if (idx == -1) {
                List<byte[]> serialized = this.getSerializedRevisionLinks();
                serialized.add(SVNRemoteStorage.instance().revisionLinkAsBytes(link, true));
                this.revisionLinks = null;
            }
        }
        this.fireRevisionLinkAdded(link);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRevisionLink(IRevisionLink link) {
        this.fireRevisionLinkRemoved(link);
        Integer n = this.lazyInitLock;
        synchronized (n) {
            IRevisionLink[] links = this.getRevisionLinks();
            int idx = -1;
            int i = 0;
            while (i < links.length) {
                if (links[i].equals(link) && links[i].getRepositoryResource().getSelectedRevision().equals(link.getRepositoryResource().getSelectedRevision())) {
                    idx = i;
                    break;
                }
                ++i;
            }
            if (idx != -1) {
                List<byte[]> serialized = this.getSerializedRevisionLinks();
                serialized.remove(idx);
                this.revisionLinks = null;
            }
        }
    }

    @Override
    public void setLabel(String label) {
        String oldValue = this.label;
        this.label = label;
        this.fireChanged("label", oldValue, this.label);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUrl(String url) {
        String oldValue = this.url;
        String oldRootUrl = this.getRepositoryRootUrl();
        IRevisionLink[] oldLinks = this.getRevisionLinks();
        List<byte[]> serialized = this.getSerializedRevisionLinks();
        this.url = url;
        if (oldRootUrl != null && !SVNUtility.createPathForSVNUrl(oldRootUrl).isPrefixOf(SVNUtility.createPathForSVNUrl(this.getUrl()))) {
            this.repositoryRootUrl = null;
            this.repositoryUUID = null;
            if (oldLinks.length > 0) {
                String newRootUrl = this.getRepositoryRootUrl();
                Integer n = this.lazyInitLock;
                synchronized (n) {
                    int i = 0;
                    while (i < oldLinks.length) {
                        String linkUrl = oldLinks[i].getRepositoryResource().getUrl();
                        int idx = linkUrl.indexOf(oldRootUrl);
                        if (idx == -1) {
                            serialized.set(i, null);
                        } else {
                            linkUrl = String.valueOf(newRootUrl) + linkUrl.substring(idx + oldRootUrl.length());
                            IRepositoryResource tmpResource = oldLinks[i] instanceof IRepositoryFile ? this.asRepositoryFile(linkUrl, false) : this.asRepositoryContainer(linkUrl, false);
                            IRevisionLink link = SVNUtility.createRevisionLink(tmpResource);
                            link.getRepositoryResource().setPegRevision(oldLinks[i].getRepositoryResource().getPegRevision());
                            link.getRepositoryResource().setSelectedRevision(oldLinks[i].getRepositoryResource().getSelectedRevision());
                            link.setComment(oldLinks[i].getComment());
                            serialized.set(i, SVNRemoteStorage.instance().revisionLinkAsBytes(link, true));
                        }
                        ++i;
                    }
                    Iterator<byte[]> it = serialized.iterator();
                    while (it.hasNext()) {
                        if (it.next() != null) continue;
                        it.remove();
                    }
                    this.revisionLinks = null;
                }
            }
        }
        this.fireChanged("url", oldValue, this.url);
    }

    @Override
    public void setTrunkLocation(String location) {
        String oldValue = this.trunk;
        this.trunk = location;
        this.fireChanged("trunkLocation", oldValue, this.trunk);
    }

    @Override
    public void setBranchesLocation(String location) {
        String oldValue = this.branches;
        this.branches = location;
        this.fireChanged("branchesLocation", oldValue, this.branches);
    }

    @Override
    public void setTagsLocation(String location) {
        String oldValue = this.tags;
        this.tags = location;
        this.fireChanged("tagsLocation", oldValue, this.tags);
    }

    @Override
    public void setUsername(String username) {
        String oldValue = this.username;
        this.username = username;
        this.fireChanged("username", oldValue, this.username);
    }

    @Override
    public void setAuthorNameEnabled(boolean isEnabled) {
        boolean oldValue = this.authorNameEnabled;
        this.authorNameEnabled = isEnabled;
        this.fireChanged("authorNameEnabled", oldValue, this.authorNameEnabled);
    }

    @Override
    public void setAuthorName(String name) {
        String oldValue = this.authorName;
        this.authorName = name;
        this.fireChanged("authorName", oldValue, this.authorName);
    }

    @Override
    public void setPassword(String password) {
        String oldValue = !this.passwordSaved ? this.passwordTemporary : this.password;
        String string = oldValue = oldValue != null ? SVNUtility.base64Decode(oldValue) : oldValue;
        if (!this.passwordSaved) {
            this.passwordTemporary = SVNUtility.base64Encode(password);
        } else {
            this.password = SVNUtility.base64Encode(password);
        }
        this.fireChanged("password", oldValue, password);
    }

    @Override
    public void setPasswordSaved(boolean saved) {
        if (this.passwordSaved == saved) {
            return;
        }
        boolean oldValue = this.passwordSaved;
        this.passwordSaved = saved;
        if (!saved) {
            this.passwordTemporary = this.password;
            this.password = null;
        } else {
            this.password = this.passwordTemporary;
        }
        this.fireChanged("passwordSaved", oldValue, this.passwordSaved);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISVNConnector acquireSVNProxy() {
        ISVNConnector retVal = null;
        boolean isNew = false;
        Integer n = this.proxyManagerLock;
        synchronized (n) {
            try {
                List<ISVNConnector> cache = this.getProxyCache();
                Thread current = Thread.currentThread();
                ProxyHolder holder = this.thread2Proxy.get(current);
                if (holder != null) {
                    ++holder.referenceCounter;
                    return holder.proxy;
                }
                if (this.proxyConfigurationState == 1) {
                    try {
                        this.proxyManagerLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                    if (this.proxyConfigurationState != 2) {
                        throw new ActivityCancelledException(SVNMessages.getErrorString("Error_AuthenticationCancelled"));
                    }
                } else if (this.proxyConfigurationState == 0) {
                    this.proxyConfigurationState = 1;
                }
                if (cache.size() == 0) {
                    retVal = this.newProxyInstance();
                    isNew = true;
                } else {
                    retVal = cache.remove(0);
                }
                this.usedProxies.add(retVal);
                this.thread2Proxy.put(current, new ProxyHolder(retVal));
            }
            catch (RuntimeException e) {
                this.proxyConfigurationState = 0;
                this.proxyManagerLock.notifyAll();
                throw e;
            }
            catch (Throwable e) {
                this.proxyConfigurationState = 0;
                this.proxyManagerLock.notifyAll();
                throw new RuntimeException(e);
            }
        }
        if (isNew) {
            SVNUtility.configureProxy(retVal, this);
        }
        this.fireProxyAcquired(retVal);
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseSVNProxy(ISVNConnector proxy) {
        this.fireProxyDisposed(proxy);
        Integer n = this.proxyManagerLock;
        synchronized (n) {
            List<ISVNConnector> proxies = this.getProxyCache();
            Thread current = Thread.currentThread();
            ProxyHolder holder = this.thread2Proxy.get(current);
            if (--holder.referenceCounter > 0) {
                return;
            }
            this.thread2Proxy.remove(current);
            if (!this.usedProxies.remove(proxy) || proxies.size() >= 5) {
                try {
                    proxy.dispose();
                }
                catch (Throwable throwable) {}
            } else {
                proxies.add(proxy);
            }
            if (this.proxyConfigurationState == 1) {
                this.proxyConfigurationState = 2;
            }
            this.proxyManagerLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reconfigure() {
        Integer n = this.proxyManagerLock;
        synchronized (n) {
            this.proxyConfigurationState = 0;
            this.reconfigureImpl();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Integer n = this.proxyManagerLock;
        synchronized (n) {
            this.reconfigureProxies(new IProxyVisitor(){

                public void visit(ISVNConnector proxy) {
                    try {
                        proxy.dispose();
                    }
                    catch (Throwable throwable) {}
                }
            });
            this.getProxyCache().clear();
        }
    }

    @Override
    public SSLSettings getSSLSettings() {
        return this.getSSLSettings(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLSettings getSSLSettings(boolean isCheckAuthInfo) {
        if (isCheckAuthInfo) {
            this.checkAuthInfo();
        }
        Integer n = this.lazyInitLock;
        synchronized (n) {
            if (this.sslSettings == null) {
                this.sslSettings = new SSLSettings();
            }
            return this.sslSettings;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSHSettings getSSHSettings(boolean isCheckAuthInfo) {
        if (isCheckAuthInfo) {
            this.checkAuthInfo();
        }
        Integer n = this.lazyInitLock;
        synchronized (n) {
            if (this.sshSettings == null) {
                this.sshSettings = new SSHSettings(this);
            }
            return this.sshSettings;
        }
    }

    @Override
    public SSHSettings getSSHSettings() {
        return this.getSSHSettings(true);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null && obj instanceof IRepositoryLocation) {
            IRepositoryLocation other = (IRepositoryLocation)obj;
            return this.getId().equals(other.getId());
        }
        return false;
    }

    protected static boolean isArgumentsCorrect(IRepositoryLocation location, String url, boolean allowsNull) throws IllegalArgumentException {
        IPath rootPath;
        IPath urlPath;
        if (url == null) {
            throw new IllegalArgumentException(SVNMessages.getErrorString("Error_NullURL"));
        }
        IPath repoPath = SVNUtility.createPathForSVNUrl(location.getUrl());
        if (!repoPath.isPrefixOf(urlPath = SVNUtility.createPathForSVNUrl(url)) && !(rootPath = SVNUtility.createPathForSVNUrl(location.getRepositoryRootUrl())).isPrefixOf(urlPath)) {
            if (!allowsNull) {
                if (!urlPath.isPrefixOf(rootPath)) {
                    String message = SVNMessages.formatErrorString("Error_NotRelatedURL", new String[]{url, rootPath.toString()});
                    throw new IllegalArgumentException(message);
                }
                String message = SVNMessages.formatErrorString("Error_ShorterURL", new String[]{url, rootPath.toString()});
                throw new UnreportableException(message);
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fetchRepoInfo() {
        Integer n = this.repositoryRootLock;
        synchronized (n) {
            if (this.repositoryRootUrl == null && this.url != null && SVNUtility.isValidSVNURL(this.getUrl())) {
                String[] values = SVNRepositoryLocation.fetchRepoInfo(this, false);
                this.repositoryRootUrl = values[0];
                this.repositoryUUID = values[1];
                if (this.repositoryUUID != null) {
                    SVNTeamPlugin.instance().setLocationsDirty(true);
                }
            }
        }
    }

    public static String[] fetchRepoInfo(final IRepositoryLocation location, final boolean usePrompt) {
        final String[] retVal = new String[2];
        ProgressMonitorUtility.doTaskExternal(new AbstractActionOperation("Operation_FetchRepositoryRoot", SVNMessages.class){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                ISVNConnector proxy = CoreExtensionsManager.instance().getSVNConnectorFactory().createConnector();
                proxy.setCredentialsCacheEnabled(false);
                SVNUtility.configureProxy(proxy, location);
                if (usePrompt) {
                    IOptionProvider optionProvider = SVNTeamPlugin.instance().getOptionProvider();
                    ISVNCredentialsPrompt externalPrompt = optionProvider.getCredentialsPrompt();
                    if (externalPrompt != null) {
                        proxy.setPrompt(new BaseCredentialsPromptWrapper(externalPrompt, location));
                    }
                } else {
                    proxy.setPrompt(new BaseCredentialsPromptWrapper(null, location));
                }
                SVNEntryInfo[] infos = null;
                String url = location.getUrl();
                try {
                    infos = SVNUtility.info(proxy, new SVNEntryRevisionReference(SVNUtility.encodeURL(url), SVNRevision.HEAD, SVNRevision.HEAD), SVNDepth.EMPTY, new SVNProgressMonitor(this, monitor, null));
                }
                finally {
                    proxy.dispose();
                }
                if (infos != null && infos.length > 0 && infos[0] != null) {
                    retVal[0] = SVNUtility.decodeURL(infos[0].reposRootUrl);
                    if (!SVNUtility.createPathForSVNUrl(retVal[0]).isPrefixOf(SVNUtility.createPathForSVNUrl(url))) {
                        SVNURLStreamHandler userUrl = SVNUtility.getSVNUrlStreamHandler(url);
                        SVNURLStreamHandler returnedURL = SVNUtility.getSVNUrlStreamHandler(retVal[0]);
                        returnedURL.setHost(userUrl.getURL().getHost());
                        retVal[0] = returnedURL.getURL().toExternalForm();
                    }
                    retVal[1] = infos[0].reposUUID;
                }
            }
        }, (IProgressMonitor)new NullProgressMonitor(), new ILoggedOperationFactory(){

            public IActionOperation getLogged(IActionOperation operation) {
                return operation;
            }
        });
        return retVal;
    }

    protected void reconfigureImpl() {
        this.reconfigureProxies(new IProxyVisitor(){

            public void visit(ISVNConnector proxy) {
                SVNUtility.configureProxy(proxy, SVNRepositoryLocation.this);
            }
        });
    }

    protected void reconfigureProxies(IProxyVisitor visitor) {
        this.visitProxies(visitor);
        this.usedProxies.clear();
    }

    protected void visitProxies(IProxyVisitor visitor) {
        for (ISVNConnector proxy : this.getProxyCache()) {
            visitor.visit(proxy);
        }
    }

    protected List<ISVNConnector> getProxyCache() {
        if (this.proxyCache == null) {
            this.proxyCache = new ArrayList<ISVNConnector>();
            this.usedProxies = new HashSet();
            this.thread2Proxy = new HashMap();
        }
        return this.proxyCache;
    }

    protected ISVNConnector newProxyInstance() {
        IOptionProvider optionProvider = SVNTeamPlugin.instance().getOptionProvider();
        ISVNConnector proxy = CoreExtensionsManager.instance().getSVNConnectorFactory().createConnector();
        proxy.setCredentialsCacheEnabled(false);
        proxy.setSSLCertificateCacheEnabled(true);
        proxy.setCommitMissingFiles(true);
        ISVNCredentialsPrompt externalPrompt = optionProvider.getCredentialsPrompt();
        if (externalPrompt != null) {
            proxy.setPrompt(new CredentialsPromptWrapper(externalPrompt));
        }
        return proxy;
    }

    protected List<byte[]> getSerializedRevisionLinks() {
        if (this.serializedRevisionLinks == null) {
            this.serializedRevisionLinks = new ArrayList<byte[]>();
        }
        return this.serializedRevisionLinks;
    }

    protected String getUrlImpl(String url) {
        if (url == null) {
            return null;
        }
        try {
            url = SVNUtility.decodeURL(url);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return SVNUtility.normalizeURL(url);
    }

    protected Map<String, IRepositoryLocation> getAdditionalRealms() {
        return this.getAdditionalRealms(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, IRepositoryLocation> getAdditionalRealms(boolean isCheckAuthInfo) {
        if (isCheckAuthInfo) {
            this.checkAuthInfo();
        }
        SVNRepositoryLocation sVNRepositoryLocation = this;
        synchronized (sVNRepositoryLocation) {
            if (this.additionalRealms == null) {
                this.additionalRealms = new LinkedHashMap<String, IRepositoryLocation>();
            }
        }
        return this.additionalRealms;
    }

    protected void fireChanged(String field, Object oldValue, Object newValue) {
        IRepositoryLocationStateListener[] iRepositoryLocationStateListenerArray = this.getStateListeners();
        int n = iRepositoryLocationStateListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRepositoryLocationStateListener listener = iRepositoryLocationStateListenerArray[n2];
            listener.changed(this, field, oldValue, newValue);
            ++n2;
        }
    }

    @Override
    public void sslChanged(IRepositoryLocation where, String field, Object oldValue, Object newValue) {
        IRepositoryLocationStateListener[] iRepositoryLocationStateListenerArray = this.getStateListeners();
        int n = iRepositoryLocationStateListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRepositoryLocationStateListener listener = iRepositoryLocationStateListenerArray[n2];
            listener.sslChanged(this, field, oldValue, newValue);
            ++n2;
        }
    }

    @Override
    public void sshChanged(IRepositoryLocation where, String field, Object oldValue, Object newValue) {
        IRepositoryLocationStateListener[] iRepositoryLocationStateListenerArray = this.getStateListeners();
        int n = iRepositoryLocationStateListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRepositoryLocationStateListener listener = iRepositoryLocationStateListenerArray[n2];
            listener.sshChanged(this, field, oldValue, newValue);
            ++n2;
        }
    }

    protected void fireRealmAdded(String realm, IRepositoryLocation location) {
        IRepositoryLocationStateListener[] iRepositoryLocationStateListenerArray = this.getStateListeners();
        int n = iRepositoryLocationStateListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRepositoryLocationStateListener listener = iRepositoryLocationStateListenerArray[n2];
            listener.realmAdded(this, realm, location);
            ++n2;
        }
    }

    protected void fireRealmRemoved(String realm) {
        IRepositoryLocationStateListener[] iRepositoryLocationStateListenerArray = this.getStateListeners();
        int n = iRepositoryLocationStateListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRepositoryLocationStateListener listener = iRepositoryLocationStateListenerArray[n2];
            listener.realmRemoved(this, realm);
            ++n2;
        }
    }

    protected void fireRevisionLinkAdded(IRevisionLink link) {
        IRepositoryLocationStateListener[] iRepositoryLocationStateListenerArray = this.getStateListeners();
        int n = iRepositoryLocationStateListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRepositoryLocationStateListener listener = iRepositoryLocationStateListenerArray[n2];
            listener.revisionLinkAdded(this, link);
            ++n2;
        }
    }

    protected void fireRevisionLinkRemoved(IRevisionLink link) {
        IRepositoryLocationStateListener[] iRepositoryLocationStateListenerArray = this.getStateListeners();
        int n = iRepositoryLocationStateListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRepositoryLocationStateListener listener = iRepositoryLocationStateListenerArray[n2];
            listener.revisionLinkRemoved(this, link);
            ++n2;
        }
    }

    protected void fireProxyAcquired(ISVNConnector proxy) {
        IRepositoryLocationStateListener[] iRepositoryLocationStateListenerArray = this.getStateListeners();
        int n = iRepositoryLocationStateListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRepositoryLocationStateListener listener = iRepositoryLocationStateListenerArray[n2];
            listener.proxyAcquired(this, proxy);
            ++n2;
        }
    }

    protected void fireProxyDisposed(ISVNConnector proxy) {
        IRepositoryLocationStateListener[] iRepositoryLocationStateListenerArray = this.getStateListeners();
        int n = iRepositoryLocationStateListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRepositoryLocationStateListener listener = iRepositoryLocationStateListenerArray[n2];
            listener.proxyDisposed(this, proxy);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IRepositoryLocationStateListener[] getStateListeners() {
        List<IRepositoryLocationStateListener> list = this.changeListeners;
        synchronized (list) {
            return this.changeListeners.toArray(new IRepositoryLocationStateListener[this.changeListeners.size()]);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.lazyInitLock = new Integer(0);
        this.proxyManagerLock = new Integer(0);
        this.repositoryRootLock = new Integer(0);
    }

    @Override
    public boolean isPasswordSavedForRealm(String realm) {
        IRepositoryLocation locationForRealm = this.getAdditionalRealms().get(realm);
        return locationForRealm != null && locationForRealm.isPasswordSaved();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRetrieveAuthInfo(boolean isRetrieveAuthInfo) {
        Integer n = this.authInitLock;
        synchronized (n) {
            this.isRetrieveAuthInfo = isRetrieveAuthInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAuthInfo() {
        Integer n = this.authInitLock;
        synchronized (n) {
            block10: {
                if (this.isRetrieveAuthInfo) {
                    try {
                        try {
                            SVNRemoteStorage.instance().loadAuthInfo(this, "");
                            for (String realm : this.rawRealms) {
                                SVNRemoteStorage.instance().loadAuthInfo(this, realm);
                            }
                        }
                        catch (Exception ex) {
                            LoggedOperation.reportError("fillLocationFromReference", ex);
                            this.isRetrieveAuthInfo = false;
                            break block10;
                        }
                    }
                    catch (Throwable throwable) {
                        this.isRetrieveAuthInfo = false;
                        throw throwable;
                    }
                    this.isRetrieveAuthInfo = false;
                }
            }
        }
    }

    public static class BaseCredentialsPromptWrapper
    implements ISVNCredentialsPrompt {
        protected ISVNCredentialsPrompt prompt;
        protected String tryRealm;
        protected String threadName;
        protected IRepositoryLocation realmLocation;
        protected IRepositoryLocation location;

        public BaseCredentialsPromptWrapper(ISVNCredentialsPrompt prompt, IRepositoryLocation location) {
            this.prompt = prompt == null ? ISVNCredentialsPrompt.DEFAULT_PROMPT : prompt;
            this.location = location;
        }

        public ISVNCredentialsPrompt.Answer askTrustSSLServer(Object context, SSLServerCertificateFailures failures, SSLServerCertificateInfo info, boolean allowPermanently) {
            return this.prompt.askTrustSSLServer(this.location, failures, info, allowPermanently);
        }

        public String getRealmToSave() {
            return this.prompt.getRealmToSave();
        }

        public String getProxyHost() {
            return this.prompt.getProxyHost();
        }

        public String getProxyPassword() {
            return this.prompt.getProxyPassword();
        }

        public int getProxyPort() {
            return this.prompt.getProxyPort();
        }

        public String getProxyUserName() {
            return this.prompt.getProxyUserName();
        }

        public int getSSHPort() {
            return this.realmLocation != null ? this.realmLocation.getSSHSettings().getPort() : this.prompt.getSSHPort();
        }

        public String getSSHPrivateKeyPassphrase() {
            return this.realmLocation != null ? this.realmLocation.getSSHSettings().getPassPhrase() : this.prompt.getSSHPrivateKeyPassphrase();
        }

        public String getSSHPrivateKeyPath() {
            return this.realmLocation != null ? this.realmLocation.getSSHSettings().getPrivateKeyPath() : this.prompt.getSSHPrivateKeyPath();
        }

        public String getSSLClientCertPassword() {
            return this.realmLocation != null ? this.realmLocation.getSSLSettings().getPassPhrase() : this.prompt.getSSLClientCertPassword();
        }

        public String getSSLClientCertPath() {
            return this.realmLocation != null ? this.realmLocation.getSSLSettings().getCertificatePath() : this.prompt.getSSLClientCertPath();
        }

        public String getUsername() {
            return this.realmLocation != null ? this.realmLocation.getUsername() : this.prompt.getUsername();
        }

        public String getPassword() {
            return this.realmLocation != null ? this.realmLocation.getPassword() : this.prompt.getPassword();
        }

        public boolean isProxyAuthenticationEnabled() {
            return this.prompt.isProxyAuthenticationEnabled();
        }

        public boolean isProxyEnabled() {
            return this.prompt.isProxyEnabled();
        }

        public boolean isSSHPrivateKeyPassphraseSaved() {
            return this.prompt.isSSHPrivateKeyPassphraseSaved();
        }

        public boolean isSSHPublicKeySelected() {
            return this.prompt.isSSHPublicKeySelected();
        }

        public boolean isSSLAuthenticationEnabled() {
            return this.prompt.isSSLAuthenticationEnabled();
        }

        public boolean isSSLSavePassphrase() {
            return this.prompt.isSSLSavePassphrase();
        }

        public boolean isSaveCredentialsEnabled() {
            return this.prompt.isSaveCredentialsEnabled();
        }

        public boolean isSaveProxyPassword() {
            return this.prompt.isSaveProxyPassword();
        }

        public boolean promptProxy(Object context) {
            boolean retVal = this.prompt.promptProxy(this.location);
            this.checkForSave(retVal, 3);
            return retVal;
        }

        public boolean prompt(Object context, String realm) {
            if (this.tryCachedRealm(realm)) {
                return true;
            }
            boolean retVal = this.prompt.prompt(this.location, realm);
            this.checkForSave(retVal, 0);
            return retVal;
        }

        public boolean promptSSH(Object context, String realm) {
            if (this.tryCachedRealm(realm)) {
                return true;
            }
            boolean retVal = this.prompt.promptSSH(this.location, realm);
            this.checkForSave(retVal, 1);
            return retVal;
        }

        public boolean promptSSL(Object context, String realm) {
            if (this.tryCachedRealm(realm)) {
                return true;
            }
            boolean retVal = this.prompt.promptSSL(this.location, realm);
            this.checkForSave(retVal, 2);
            return retVal;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected boolean tryCachedRealm(String realm) {
            String threadName = Thread.currentThread().getName();
            if (this.tryRealm == null || !this.tryRealm.equals(realm) || !threadName.equals(this.threadName)) {
                this.realmLocation = this.location.getLocationForRealm(realm);
                if (this.realmLocation != null && this.realmLocation.getUsername() != null && !this.realmLocation.getUsername().equals("")) {
                    this.tryRealm = realm;
                    this.threadName = threadName;
                    return true;
                }
                if (this.realmLocation != null || CoreExtensionsManager.instance().getSVNConnectorFactory().getId().indexOf("svnkit") == -1) return false;
                String protocol = "file";
                try {
                    URL url = SVNUtility.getSVNUrl(this.location.getUrl());
                    protocol = url.getProtocol();
                    if (!protocol.equals("file")) return false;
                    this.realmLocation = this.location;
                    this.tryRealm = realm;
                    this.threadName = threadName;
                    return true;
                }
                catch (MalformedURLException malformedURLException) {
                    return false;
                }
            } else {
                this.tryRealm = null;
                this.realmLocation = null;
                this.threadName = null;
            }
            return false;
        }

        protected void checkForSave(boolean retVal, int connectionType) {
            if (retVal) {
                IRepositoryLocation location = this.location;
                String realmToSave = this.getRealmToSave();
                if (!"<Repository Location>".equals(realmToSave) && (location = this.location.getLocationForRealm(realmToSave)) == null) {
                    location = SVNRemoteStorage.instance().newRepositoryLocation();
                    SVNRemoteStorage.instance().copyRepositoryLocation(location, this.location);
                    this.location.addRealm(realmToSave, location);
                }
                this.checkForSaveImpl(location, retVal, connectionType);
            }
        }

        protected void checkForSaveImpl(IRepositoryLocation location, boolean retVal, int connectionType) {
            Serializable settings;
            location.setUsername(this.prompt.getUsername());
            location.setPassword(this.prompt.getPassword());
            location.setPasswordSaved(this.prompt.isSaveCredentialsEnabled());
            SVNTeamPlugin.instance().setLocationsDirty(true);
            if (connectionType == 1) {
                settings = location.getSSHSettings();
                ((SSHSettings)settings).setPort(this.prompt.getSSHPort());
                ((SSHSettings)settings).setUseKeyFile(this.prompt.isSSHPublicKeySelected());
                if (((SSHSettings)settings).isUseKeyFile()) {
                    ((SSHSettings)settings).setPrivateKeyPath(this.prompt.getSSHPrivateKeyPath());
                    ((SSHSettings)settings).setPassPhraseSaved(this.prompt.isSSHPrivateKeyPassphraseSaved());
                    ((SSHSettings)settings).setPassPhrase(this.prompt.getSSHPrivateKeyPassphrase());
                }
            }
            if (connectionType == 2) {
                settings = location.getSSLSettings();
                ((SSLSettings)settings).setAuthenticationEnabled(this.prompt.isSSLAuthenticationEnabled());
                if (((SSLSettings)settings).isAuthenticationEnabled()) {
                    ((SSLSettings)settings).setCertificatePath(this.prompt.getSSLClientCertPath());
                    ((SSLSettings)settings).setPassPhrase(this.prompt.getSSLClientCertPassword());
                    ((SSLSettings)settings).setPassPhraseSaved(this.prompt.isSSLSavePassphrase());
                }
            }
        }
    }

    protected class CredentialsPromptWrapper
    extends BaseCredentialsPromptWrapper {
        public CredentialsPromptWrapper(ISVNCredentialsPrompt prompt) {
            super(prompt, SVNRepositoryLocation.this);
        }

        public ISVNCredentialsPrompt.Answer askTrustSSLServer(Object context, SSLServerCertificateFailures failures, SSLServerCertificateInfo info, boolean allowPermanently) {
            if (!SVNRepositoryLocation.this.trustSiteDefined) {
                SVNRepositoryLocation.this.trustSite = super.askTrustSSLServer(SVNRepositoryLocation.this, failures, info, allowPermanently);
                if (SVNRepositoryLocation.this.trustSite != ISVNCredentialsPrompt.Answer.REJECT) {
                    SVNRepositoryLocation.this.trustSiteDefined = true;
                } else {
                    SVNRepositoryLocation.this.proxyConfigurationState = 0;
                }
                return SVNRepositoryLocation.this.trustSite;
            }
            return SVNRepositoryLocation.this.trustSite;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void checkForSave(boolean retVal, int connectionType) {
            Integer n = SVNRepositoryLocation.this.proxyManagerLock;
            synchronized (n) {
                if (retVal) {
                    super.checkForSave(retVal, connectionType);
                } else {
                    SVNRepositoryLocation.this.proxyConfigurationState = 0;
                }
                SVNRepositoryLocation.this.reconfigureImpl();
            }
        }
    }

    protected static interface IProxyVisitor {
        public void visit(ISVNConnector var1);
    }

    protected static class ProxyHolder {
        public final ISVNConnector proxy;
        public int referenceCounter;

        public ProxyHolder(ISVNConnector proxy) {
            this.proxy = proxy;
            this.referenceCounter = 1;
        }
    }
}

